'\" t
.\" Copyright (c) 1999, Oracle and/or its affiliates.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbResizeKeyType __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbResizeKeyType \- Change the number of levels in a key type
.SH SYNOPSIS
.HP
.B Status XkbResizeKeyType
.BI "(\^XkbDescPtr " "xkb" "\^,"
.BI "int " "type_ndx" "\^,"
.BI "int " "map_count" "\^,"
.BI "Bool " "want_preserve" "\^,"
.BI "int " "new_num_lvls" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I xkb
keyboard description containing client map to update
.TP
.I type_ndx
index in xkb->map->types of type to change
.TP
.I map_count
total # of map entries needed for the type
.TP
.I want_preserve
True => list of preserved modifiers is necessary
.TP
.I new_num_lvls
new max # of levels for type
.SH DESCRIPTION
.LP
.I XkbResizeKeyType 
changes the type specified by 
.I xkb->map->types[type_ndx], 
and reallocates the symbols and actions bound to all keys that use the type, if 
necessary. 
.I XkbResizeKeyType 
updates only the local copy of the types in 
.I xkb; 
to update the server's copy for the physical device, use 
.I XkbSetMap 
or 
.I XkbChangeMap 
after calling 
.I XkbResizeKeyType.

The 
.I map_count 
parameter specifies the total number of map entries needed for the type, and can 
be zero or greater. If 
.I map_count 
is zero, 
.I XkbResizeKeyType 
frees the existing 
.I map 
and 
.I preserve 
entries for the type if they exist and sets them to NULL.

The 
.I want_preserve 
parameter specifies whether a 
.I preserve 
list for the key should be created. If 
.I want_preserve 
is True, the 
.I preserve 
list with 
.I map_count 
entries is allocated or reallocated if it already exists. Otherwise, if
.I want_preserve 
is False, the 
.I preserve 
field is freed if necessary and set to NULL.

The 
.I new_num_lvls 
parameter specifies the new maximum number of shift levels for the type and is 
used to calculate and resize the symbols and actions bound to all keys that use 
the type.

If 
.I type_ndx 
does not specify a legal type, 
.I new_num_lvls 
is less than 1, or the 
.I map_count 
is less than zero, 
.I XkbResizeKeyType 
returns BadValue. If 
.I XkbResizeKeyType 
encounters any problems with allocation, it returns BadAlloc. Otherwise, it 
returns Success.
.SH "RETURN VALUES"
.TP 15
Success
The 
.I XkbResizeKeyType 
function returns Success if 
.I type_ndx 
specifies a legal type,   
.I new_num_lvls 
is greater than zero and 
.I map_count 
is positive.
.SH DIAGNOSTICS
.TP 15
.B BadAlloc
Unable to allocate storage
.TP 15
.B BadValue
An argument is out of range
.SH "SEE ALSO"
.BR XkbChangeMap (__libmansuffix__),
.BR XkbSetMap (__libmansuffix__)
