untrusted comment: signature from openbsd 5.5 base secret key
RWRGy8gxk9N935ES6bkdbp5OZJQRQKmaEcdzBYShaOP4N2xigy16QMQ0IFMbNZ7tmjMbK+nMnuZgzQKwLT5V0OLrv9G6npu7ZQI=

OpenBSD 5.5 errata 19, December 9, 2014:

One year after Ilja van Sprundel, discovered and reported a large number
of issues in the way the X server code base handles requests from X clients,
they have been fixed.

Apply patch using:

    signify -Vep /etc/signify/openbsd-55-base.pub -x 019_xserver.patch.sig \
        -m - | (cd /usr/xenocara && patch -p0)

Then build and install a new xserver:

    cd /usr/xenocara/xserver
    make -f Makefile.bsd-wrapper obj
    make -f Makefile.bsd-wrapper build

Index: xserver/Xext/xcmisc.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/Xext/xcmisc.c,v
retrieving revision 1.9
diff -u -p -u -r1.9 xcmisc.c
--- xserver/Xext/xcmisc.c	7 Jun 2013 17:28:46 -0000	1.9
+++ xserver/Xext/xcmisc.c	7 Dec 2014 12:31:36 -0000
@@ -167,6 +167,7 @@ static int
 SProcXCMiscGetXIDList(ClientPtr client)
 {
     REQUEST(xXCMiscGetXIDListReq);
+    REQUEST_SIZE_MATCH(xXCMiscGetXIDListReq);
 
     swaps(&stuff->length);
     swapl(&stuff->count);
Index: xserver/Xext/xvdisp.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/Xext/xvdisp.c,v
retrieving revision 1.9
diff -u -p -u -r1.9 xvdisp.c
--- xserver/Xext/xvdisp.c	7 Jun 2013 17:28:46 -0000	1.9
+++ xserver/Xext/xvdisp.c	7 Dec 2014 12:31:36 -0000
@@ -1218,6 +1218,7 @@ static int
 SProcXvQueryExtension(ClientPtr client)
 {
     REQUEST(xvQueryExtensionReq);
+    REQUEST_SIZE_MATCH(xvQueryExtensionReq);
     swaps(&stuff->length);
     return XvProcVector[xv_QueryExtension] (client);
 }
@@ -1226,6 +1227,7 @@ static int
 SProcXvQueryAdaptors(ClientPtr client)
 {
     REQUEST(xvQueryAdaptorsReq);
+    REQUEST_SIZE_MATCH(xvQueryAdaptorsReq);
     swaps(&stuff->length);
     swapl(&stuff->window);
     return XvProcVector[xv_QueryAdaptors] (client);
@@ -1235,6 +1237,7 @@ static int
 SProcXvQueryEncodings(ClientPtr client)
 {
     REQUEST(xvQueryEncodingsReq);
+    REQUEST_SIZE_MATCH(xvQueryEncodingsReq);
     swaps(&stuff->length);
     swapl(&stuff->port);
     return XvProcVector[xv_QueryEncodings] (client);
@@ -1244,6 +1247,7 @@ static int
 SProcXvGrabPort(ClientPtr client)
 {
     REQUEST(xvGrabPortReq);
+    REQUEST_SIZE_MATCH(xvGrabPortReq);
     swaps(&stuff->length);
     swapl(&stuff->port);
     swapl(&stuff->time);
@@ -1254,6 +1258,7 @@ static int
 SProcXvUngrabPort(ClientPtr client)
 {
     REQUEST(xvUngrabPortReq);
+    REQUEST_SIZE_MATCH(xvUngrabPortReq);
     swaps(&stuff->length);
     swapl(&stuff->port);
     swapl(&stuff->time);
@@ -1264,6 +1269,7 @@ static int
 SProcXvPutVideo(ClientPtr client)
 {
     REQUEST(xvPutVideoReq);
+    REQUEST_SIZE_MATCH(xvPutVideoReq);
     swaps(&stuff->length);
     swapl(&stuff->port);
     swapl(&stuff->drawable);
@@ -1283,6 +1289,7 @@ static int
 SProcXvPutStill(ClientPtr client)
 {
     REQUEST(xvPutStillReq);
+    REQUEST_SIZE_MATCH(xvPutStillReq);
     swaps(&stuff->length);
     swapl(&stuff->port);
     swapl(&stuff->drawable);
@@ -1302,6 +1309,7 @@ static int
 SProcXvGetVideo(ClientPtr client)
 {
     REQUEST(xvGetVideoReq);
+    REQUEST_SIZE_MATCH(xvGetVideoReq);
     swaps(&stuff->length);
     swapl(&stuff->port);
     swapl(&stuff->drawable);
@@ -1321,6 +1329,7 @@ static int
 SProcXvGetStill(ClientPtr client)
 {
     REQUEST(xvGetStillReq);
+    REQUEST_SIZE_MATCH(xvGetStillReq);
     swaps(&stuff->length);
     swapl(&stuff->port);
     swapl(&stuff->drawable);
@@ -1340,6 +1349,7 @@ static int
 SProcXvPutImage(ClientPtr client)
 {
     REQUEST(xvPutImageReq);
+    REQUEST_AT_LEAST_SIZE(xvPutImageReq);
     swaps(&stuff->length);
     swapl(&stuff->port);
     swapl(&stuff->drawable);
@@ -1363,6 +1373,7 @@ static int
 SProcXvShmPutImage(ClientPtr client)
 {
     REQUEST(xvShmPutImageReq);
+    REQUEST_SIZE_MATCH(xvShmPutImageReq);
     swaps(&stuff->length);
     swapl(&stuff->port);
     swapl(&stuff->drawable);
@@ -1390,6 +1401,7 @@ static int
 SProcXvSelectVideoNotify(ClientPtr client)
 {
     REQUEST(xvSelectVideoNotifyReq);
+    REQUEST_SIZE_MATCH(xvSelectVideoNotifyReq);
     swaps(&stuff->length);
     swapl(&stuff->drawable);
     return XvProcVector[xv_SelectVideoNotify] (client);
@@ -1399,6 +1411,7 @@ static int
 SProcXvSelectPortNotify(ClientPtr client)
 {
     REQUEST(xvSelectPortNotifyReq);
+    REQUEST_SIZE_MATCH(xvSelectPortNotifyReq);
     swaps(&stuff->length);
     swapl(&stuff->port);
     return XvProcVector[xv_SelectPortNotify] (client);
@@ -1408,6 +1421,7 @@ static int
 SProcXvStopVideo(ClientPtr client)
 {
     REQUEST(xvStopVideoReq);
+    REQUEST_SIZE_MATCH(xvStopVideoReq);
     swaps(&stuff->length);
     swapl(&stuff->port);
     swapl(&stuff->drawable);
@@ -1418,6 +1432,7 @@ static int
 SProcXvSetPortAttribute(ClientPtr client)
 {
     REQUEST(xvSetPortAttributeReq);
+    REQUEST_SIZE_MATCH(xvSetPortAttributeReq);
     swaps(&stuff->length);
     swapl(&stuff->port);
     swapl(&stuff->attribute);
@@ -1429,6 +1444,7 @@ static int
 SProcXvGetPortAttribute(ClientPtr client)
 {
     REQUEST(xvGetPortAttributeReq);
+    REQUEST_SIZE_MATCH(xvGetPortAttributeReq);
     swaps(&stuff->length);
     swapl(&stuff->port);
     swapl(&stuff->attribute);
@@ -1439,6 +1455,7 @@ static int
 SProcXvQueryBestSize(ClientPtr client)
 {
     REQUEST(xvQueryBestSizeReq);
+    REQUEST_SIZE_MATCH(xvQueryBestSizeReq);
     swaps(&stuff->length);
     swapl(&stuff->port);
     swaps(&stuff->vid_w);
@@ -1452,6 +1469,7 @@ static int
 SProcXvQueryPortAttributes(ClientPtr client)
 {
     REQUEST(xvQueryPortAttributesReq);
+    REQUEST_SIZE_MATCH(xvQueryPortAttributesReq);
     swaps(&stuff->length);
     swapl(&stuff->port);
     return XvProcVector[xv_QueryPortAttributes] (client);
@@ -1461,6 +1479,7 @@ static int
 SProcXvQueryImageAttributes(ClientPtr client)
 {
     REQUEST(xvQueryImageAttributesReq);
+    REQUEST_SIZE_MATCH(xvQueryImageAttributesReq);
     swaps(&stuff->length);
     swapl(&stuff->port);
     swapl(&stuff->id);
@@ -1473,6 +1492,7 @@ static int
 SProcXvListImageFormats(ClientPtr client)
 {
     REQUEST(xvListImageFormatsReq);
+    REQUEST_SIZE_MATCH(xvListImageFormatsReq);
     swaps(&stuff->length);
     swapl(&stuff->port);
     return XvProcVector[xv_ListImageFormats] (client);
Index: xserver/Xi/chgdctl.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/Xi/chgdctl.c,v
retrieving revision 1.7
diff -u -p -u -r1.7 chgdctl.c
--- xserver/Xi/chgdctl.c	7 Jun 2013 17:28:46 -0000	1.7
+++ xserver/Xi/chgdctl.c	7 Dec 2014 12:31:36 -0000
@@ -78,7 +78,7 @@ SProcXChangeDeviceControl(ClientPtr clie
 
     REQUEST(xChangeDeviceControlReq);
     swaps(&stuff->length);
-    REQUEST_AT_LEAST_SIZE(xChangeDeviceControlReq);
+    REQUEST_AT_LEAST_EXTRA_SIZE(xChangeDeviceControlReq, sizeof(xDeviceCtl));
     swaps(&stuff->control);
     ctl = (xDeviceCtl *) &stuff[1];
     swaps(&ctl->control);
@@ -115,7 +115,7 @@ ProcXChangeDeviceControl(ClientPtr clien
     xDeviceEnableCtl *e;
 
     REQUEST(xChangeDeviceControlReq);
-    REQUEST_AT_LEAST_SIZE(xChangeDeviceControlReq);
+    REQUEST_AT_LEAST_EXTRA_SIZE(xChangeDeviceControlReq, sizeof(xDeviceCtl));
 
     len = stuff->length - bytes_to_int32(sizeof(xChangeDeviceControlReq));
     ret = dixLookupDevice(&dev, stuff->deviceid, client, DixManageAccess);
@@ -186,6 +186,10 @@ ProcXChangeDeviceControl(ClientPtr clien
         break;
     case DEVICE_ENABLE:
         e = (xDeviceEnableCtl *) &stuff[1];
+        if ((len != bytes_to_int32(sizeof(xDeviceEnableCtl)))) {
+            ret = BadLength;
+            goto out;
+        }
 
         if (IsXTestDevice(dev, NULL))
             status = !Success;
Index: xserver/Xi/chgfctl.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/Xi/chgfctl.c,v
retrieving revision 1.5
diff -u -p -u -r1.5 chgfctl.c
--- xserver/Xi/chgfctl.c	10 Jun 2012 13:21:20 -0000	1.5
+++ xserver/Xi/chgfctl.c	7 Dec 2014 12:31:36 -0000
@@ -467,6 +467,8 @@ ProcXChangeFeedbackControl(ClientPtr cli
         xStringFeedbackCtl *f = ((xStringFeedbackCtl *) &stuff[1]);
 
         if (client->swapped) {
+            if (len < bytes_to_int32(sizeof(xStringFeedbackCtl)))
+                return BadLength;
             swaps(&f->num_keysyms);
         }
         if (len !=
Index: xserver/Xi/sendexev.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/Xi/sendexev.c,v
retrieving revision 1.7
diff -u -p -u -r1.7 sendexev.c
--- xserver/Xi/sendexev.c	10 Jun 2012 13:21:20 -0000	1.7
+++ xserver/Xi/sendexev.c	7 Dec 2014 12:31:36 -0000
@@ -135,6 +135,9 @@ ProcXSendExtensionEvent(ClientPtr client
     if (ret != Success)
         return ret;
 
+    if (stuff->num_events == 0)
+        return ret;
+
     /* The client's event type must be one defined by an extension. */
 
     first = ((xEvent *) &stuff[1]);
Index: xserver/Xi/xiallowev.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/Xi/xiallowev.c,v
retrieving revision 1.3
diff -u -p -u -r1.3 xiallowev.c
--- xserver/Xi/xiallowev.c	8 Dec 2013 10:53:01 -0000	1.3
+++ xserver/Xi/xiallowev.c	7 Dec 2014 12:31:36 -0000
@@ -48,6 +48,7 @@ int
 SProcXIAllowEvents(ClientPtr client)
 {
     REQUEST(xXIAllowEventsReq);
+    REQUEST_AT_LEAST_SIZE(xXIAllowEventsReq);
 
     swaps(&stuff->length);
     swaps(&stuff->deviceid);
@@ -55,6 +56,7 @@ SProcXIAllowEvents(ClientPtr client)
     if (stuff->length > 3) {
         xXI2_2AllowEventsReq *req_xi22 = (xXI2_2AllowEventsReq *) stuff;
 
+        REQUEST_AT_LEAST_SIZE(xXI2_2AllowEventsReq);
         swapl(&req_xi22->touchid);
         swapl(&req_xi22->grab_window);
     }
Index: xserver/Xi/xichangecursor.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/Xi/xichangecursor.c,v
retrieving revision 1.3
diff -u -p -u -r1.3 xichangecursor.c
--- xserver/Xi/xichangecursor.c	10 Jun 2012 13:21:20 -0000	1.3
+++ xserver/Xi/xichangecursor.c	7 Dec 2014 12:31:36 -0000
@@ -57,11 +57,11 @@ int
 SProcXIChangeCursor(ClientPtr client)
 {
     REQUEST(xXIChangeCursorReq);
+    REQUEST_SIZE_MATCH(xXIChangeCursorReq);
     swaps(&stuff->length);
     swapl(&stuff->win);
     swapl(&stuff->cursor);
     swaps(&stuff->deviceid);
-    REQUEST_SIZE_MATCH(xXIChangeCursorReq);
     return (ProcXIChangeCursor(client));
 }
 
Index: xserver/Xi/xichangehierarchy.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/Xi/xichangehierarchy.c,v
retrieving revision 1.6
diff -u -p -u -r1.6 xichangehierarchy.c
--- xserver/Xi/xichangehierarchy.c	7 Jun 2013 17:28:46 -0000	1.6
+++ xserver/Xi/xichangehierarchy.c	7 Dec 2014 12:31:36 -0000
@@ -407,7 +407,7 @@ int
 ProcXIChangeHierarchy(ClientPtr client)
 {
     xXIAnyHierarchyChangeInfo *any;
-    int required_len = sizeof(xXIChangeHierarchyReq);
+    size_t len;			/* length of data remaining in request */
     int rc = Success;
     int flags[MAXDEVICES] = { 0 };
 
@@ -417,21 +417,46 @@ ProcXIChangeHierarchy(ClientPtr client)
     if (!stuff->num_changes)
         return rc;
 
+    if (stuff->length > (INT_MAX >> 2))
+        return BadAlloc;
+    len = (stuff->length << 2) - sizeof(xXIAnyHierarchyChangeInfo);
+
     any = (xXIAnyHierarchyChangeInfo *) &stuff[1];
     while (stuff->num_changes--) {
+        if (len < sizeof(xXIAnyHierarchyChangeInfo)) {
+            rc = BadLength;
+            goto unwind;
+        }
+
         SWAPIF(swaps(&any->type));
         SWAPIF(swaps(&any->length));
 
-        required_len += any->length;
-        if ((stuff->length * 4) < required_len)
+        if ((any->length > (INT_MAX >> 2)) || (len < (any->length << 2)))
             return BadLength;
 
+#define CHANGE_SIZE_MATCH(type) \
+    do { \
+        if ((len < sizeof(type)) || (any->length != (sizeof(type) >> 2))) { \
+            rc = BadLength; \
+            goto unwind; \
+        } \
+    } while(0)
+
         switch (any->type) {
         case XIAddMaster:
         {
             xXIAddMasterInfo *c = (xXIAddMasterInfo *) any;
 
+            /* Variable length, due to appended name string */
+            if (len < sizeof(xXIAddMasterInfo)) {
+                rc = BadLength;
+                goto unwind;
+            }
             SWAPIF(swaps(&c->name_len));
+            if (c->name_len > (len - sizeof(xXIAddMasterInfo))) {
+                rc = BadLength;
+                goto unwind;
+            }
 
             rc = add_master(client, c, flags);
             if (rc != Success)
@@ -442,6 +467,7 @@ ProcXIChangeHierarchy(ClientPtr client)
         {
             xXIRemoveMasterInfo *r = (xXIRemoveMasterInfo *) any;
 
+            CHANGE_SIZE_MATCH(xXIRemoveMasterInfo);
             rc = remove_master(client, r, flags);
             if (rc != Success)
                 goto unwind;
@@ -451,6 +477,7 @@ ProcXIChangeHierarchy(ClientPtr client)
         {
             xXIDetachSlaveInfo *c = (xXIDetachSlaveInfo *) any;
 
+            CHANGE_SIZE_MATCH(xXIDetachSlaveInfo);
             rc = detach_slave(client, c, flags);
             if (rc != Success)
                 goto unwind;
@@ -460,6 +487,7 @@ ProcXIChangeHierarchy(ClientPtr client)
         {
             xXIAttachSlaveInfo *c = (xXIAttachSlaveInfo *) any;
 
+            CHANGE_SIZE_MATCH(xXIAttachSlaveInfo);
             rc = attach_slave(client, c, flags);
             if (rc != Success)
                 goto unwind;
@@ -467,6 +495,7 @@ ProcXIChangeHierarchy(ClientPtr client)
             break;
         }
 
+        len -= any->length * 4;
         any = (xXIAnyHierarchyChangeInfo *) ((char *) any + any->length * 4);
     }
 
Index: xserver/Xi/xigetclientpointer.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/Xi/xigetclientpointer.c,v
retrieving revision 1.3
diff -u -p -u -r1.3 xigetclientpointer.c
--- xserver/Xi/xigetclientpointer.c	7 Jun 2013 17:28:46 -0000	1.3
+++ xserver/Xi/xigetclientpointer.c	7 Dec 2014 12:31:36 -0000
@@ -50,6 +50,7 @@ int
 SProcXIGetClientPointer(ClientPtr client)
 {
     REQUEST(xXIGetClientPointerReq);
+    REQUEST_SIZE_MATCH(xXIGetClientPointerReq);
 
     swaps(&stuff->length);
     swapl(&stuff->win);
Index: xserver/Xi/xigrabdev.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/Xi/xigrabdev.c,v
retrieving revision 1.5
diff -u -p -u -r1.5 xigrabdev.c
--- xserver/Xi/xigrabdev.c	24 Aug 2013 19:44:29 -0000	1.5
+++ xserver/Xi/xigrabdev.c	7 Dec 2014 12:31:36 -0000
@@ -47,6 +47,11 @@ int
 SProcXIGrabDevice(ClientPtr client)
 {
     REQUEST(xXIGrabDeviceReq);
+    /*
+     * Check here for at least the length of the struct we swap, then
+     * let ProcXIGrabDevice check the full size after we swap mask_len.
+     */
+    REQUEST_AT_LEAST_SIZE(xXIGrabDeviceReq);
 
     swaps(&stuff->length);
     swaps(&stuff->deviceid);
@@ -71,7 +76,7 @@ ProcXIGrabDevice(ClientPtr client)
     unsigned int pointer_mode;
 
     REQUEST(xXIGrabDeviceReq);
-    REQUEST_AT_LEAST_SIZE(xXIGrabDeviceReq);
+    REQUEST_FIXED_SIZE(xXIGrabDeviceReq, ((size_t) stuff->mask_len) * 4);
 
     ret = dixLookupDevice(&dev, stuff->deviceid, client, DixGrabAccess);
     if (ret != Success)
@@ -131,6 +136,7 @@ int
 SProcXIUngrabDevice(ClientPtr client)
 {
     REQUEST(xXIUngrabDeviceReq);
+    REQUEST_SIZE_MATCH(xXIUngrabDeviceReq);
 
     swaps(&stuff->length);
     swaps(&stuff->deviceid);
@@ -148,6 +154,7 @@ ProcXIUngrabDevice(ClientPtr client)
     TimeStamp time;
 
     REQUEST(xXIUngrabDeviceReq);
+    REQUEST_SIZE_MATCH(xXIUngrabDeviceReq);
 
     ret = dixLookupDevice(&dev, stuff->deviceid, client, DixGetAttrAccess);
     if (ret != Success)
Index: xserver/Xi/xipassivegrab.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/Xi/xipassivegrab.c,v
retrieving revision 1.7
diff -u -p -u -r1.7 xipassivegrab.c
--- xserver/Xi/xipassivegrab.c	28 Sep 2013 15:36:33 -0000	1.7
+++ xserver/Xi/xipassivegrab.c	7 Dec 2014 14:29:28 -0000
@@ -53,6 +53,7 @@ SProcXIPassiveGrabDevice(ClientPtr clien
     uint32_t *mods;
 
     REQUEST(xXIPassiveGrabDeviceReq);
+    REQUEST_AT_LEAST_SIZE(xXIPassiveGrabDeviceReq);
 
     swaps(&stuff->length);
     swaps(&stuff->deviceid);
@@ -63,6 +64,8 @@ SProcXIPassiveGrabDevice(ClientPtr clien
     swaps(&stuff->mask_len);
     swaps(&stuff->num_modifiers);
 
+    REQUEST_FIXED_SIZE(xXIPassiveGrabDeviceReq,
+        ((uint32_t) stuff->mask_len + stuff->num_modifiers) *4);
     mods = (uint32_t *) &stuff[1];
 
     for (i = 0; i < stuff->num_modifiers; i++, mods++) {
@@ -92,7 +95,8 @@ ProcXIPassiveGrabDevice(ClientPtr client
     int mask_len;
 
     REQUEST(xXIPassiveGrabDeviceReq);
-    REQUEST_AT_LEAST_SIZE(xXIPassiveGrabDeviceReq);
+    REQUEST_FIXED_SIZE(xXIPassiveGrabDeviceReq,
+        ((uint32_t) stuff->mask_len + stuff->num_modifiers) * 4);
 
     if (stuff->deviceid == XIAllDevices)
         dev = inputInfo.all_devices;
@@ -248,6 +252,7 @@ SProcXIPassiveUngrabDevice(ClientPtr cli
     uint32_t *modifiers;
 
     REQUEST(xXIPassiveUngrabDeviceReq);
+    REQUEST_AT_LEAST_SIZE(xXIPassiveUngrabDeviceReq);
 
     swaps(&stuff->length);
     swapl(&stuff->grab_window);
@@ -255,6 +260,8 @@ SProcXIPassiveUngrabDevice(ClientPtr cli
     swapl(&stuff->detail);
     swaps(&stuff->num_modifiers);
 
+    REQUEST_FIXED_SIZE(xXIPassiveUngrabDeviceReq,
+                       ((uint32_t) stuff->num_modifiers) << 2);
     modifiers = (uint32_t *) &stuff[1];
 
     for (i = 0; i < stuff->num_modifiers; i++, modifiers++)
@@ -273,7 +280,8 @@ ProcXIPassiveUngrabDevice(ClientPtr clie
     int i, rc;
 
     REQUEST(xXIPassiveUngrabDeviceReq);
-    REQUEST_AT_LEAST_SIZE(xXIPassiveUngrabDeviceReq);
+    REQUEST_FIXED_SIZE(xXIPassiveUngrabDeviceReq,
+                       ((uint32_t) stuff->num_modifiers) << 2);
 
     if (stuff->deviceid == XIAllDevices)
         dev = inputInfo.all_devices;
Index: xserver/Xi/xiproperty.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/Xi/xiproperty.c,v
retrieving revision 1.6
diff -u -p -u -r1.6 xiproperty.c
--- xserver/Xi/xiproperty.c	7 Jun 2013 17:28:46 -0000	1.6
+++ xserver/Xi/xiproperty.c	7 Dec 2014 12:31:36 -0000
@@ -1013,10 +1013,9 @@ int
 SProcXListDeviceProperties(ClientPtr client)
 {
     REQUEST(xListDevicePropertiesReq);
+    REQUEST_SIZE_MATCH(xListDevicePropertiesReq);
 
     swaps(&stuff->length);
-
-    REQUEST_SIZE_MATCH(xListDevicePropertiesReq);
     return (ProcXListDeviceProperties(client));
 }
 
@@ -1037,10 +1036,10 @@ int
 SProcXDeleteDeviceProperty(ClientPtr client)
 {
     REQUEST(xDeleteDevicePropertyReq);
+    REQUEST_SIZE_MATCH(xDeleteDevicePropertyReq);
 
     swaps(&stuff->length);
     swapl(&stuff->property);
-    REQUEST_SIZE_MATCH(xDeleteDevicePropertyReq);
     return (ProcXDeleteDeviceProperty(client));
 }
 
@@ -1048,13 +1047,13 @@ int
 SProcXGetDeviceProperty(ClientPtr client)
 {
     REQUEST(xGetDevicePropertyReq);
+    REQUEST_SIZE_MATCH(xGetDevicePropertyReq);
 
     swaps(&stuff->length);
     swapl(&stuff->property);
     swapl(&stuff->type);
     swapl(&stuff->longOffset);
     swapl(&stuff->longLength);
-    REQUEST_SIZE_MATCH(xGetDevicePropertyReq);
     return (ProcXGetDeviceProperty(client));
 }
 
@@ -1253,11 +1252,10 @@ int
 SProcXIListProperties(ClientPtr client)
 {
     REQUEST(xXIListPropertiesReq);
+    REQUEST_SIZE_MATCH(xXIListPropertiesReq);
 
     swaps(&stuff->length);
     swaps(&stuff->deviceid);
-
-    REQUEST_SIZE_MATCH(xXIListPropertiesReq);
     return (ProcXIListProperties(client));
 }
 
@@ -1279,11 +1277,11 @@ int
 SProcXIDeleteProperty(ClientPtr client)
 {
     REQUEST(xXIDeletePropertyReq);
+    REQUEST_SIZE_MATCH(xXIDeletePropertyReq);
 
     swaps(&stuff->length);
     swaps(&stuff->deviceid);
     swapl(&stuff->property);
-    REQUEST_SIZE_MATCH(xXIDeletePropertyReq);
     return (ProcXIDeleteProperty(client));
 }
 
@@ -1291,6 +1289,7 @@ int
 SProcXIGetProperty(ClientPtr client)
 {
     REQUEST(xXIGetPropertyReq);
+    REQUEST_SIZE_MATCH(xXIGetPropertyReq);
 
     swaps(&stuff->length);
     swaps(&stuff->deviceid);
@@ -1298,7 +1297,6 @@ SProcXIGetProperty(ClientPtr client)
     swapl(&stuff->type);
     swapl(&stuff->offset);
     swapl(&stuff->len);
-    REQUEST_SIZE_MATCH(xXIGetPropertyReq);
     return (ProcXIGetProperty(client));
 }
 
Index: xserver/Xi/xiquerydevice.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/Xi/xiquerydevice.c,v
retrieving revision 1.7
diff -u -p -u -r1.7 xiquerydevice.c
--- xserver/Xi/xiquerydevice.c	7 Jun 2013 17:28:46 -0000	1.7
+++ xserver/Xi/xiquerydevice.c	7 Dec 2014 12:31:36 -0000
@@ -54,6 +54,7 @@ int
 SProcXIQueryDevice(ClientPtr client)
 {
     REQUEST(xXIQueryDeviceReq);
+    REQUEST_SIZE_MATCH(xXIQueryDeviceReq);
 
     swaps(&stuff->length);
     swaps(&stuff->deviceid);
Index: xserver/Xi/xiquerypointer.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/Xi/xiquerypointer.c,v
retrieving revision 1.5
diff -u -p -u -r1.5 xiquerypointer.c
--- xserver/Xi/xiquerypointer.c	7 Jun 2013 17:28:46 -0000	1.5
+++ xserver/Xi/xiquerypointer.c	7 Dec 2014 12:31:36 -0000
@@ -63,6 +63,8 @@ int
 SProcXIQueryPointer(ClientPtr client)
 {
     REQUEST(xXIQueryPointerReq);
+    REQUEST_SIZE_MATCH(xXIQueryPointerReq);
+
     swaps(&stuff->length);
     swaps(&stuff->deviceid);
     swapl(&stuff->win);
Index: xserver/Xi/xiselectev.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/Xi/xiselectev.c,v
retrieving revision 1.6
diff -u -p -u -r1.6 xiselectev.c
--- xserver/Xi/xiselectev.c	7 Jun 2013 17:28:46 -0000	1.6
+++ xserver/Xi/xiselectev.c	7 Dec 2014 12:31:36 -0000
@@ -114,6 +114,7 @@ int
 SProcXISelectEvents(ClientPtr client)
 {
     int i;
+    int len;
     xXIEventMask *evmask;
 
     REQUEST(xXISelectEventsReq);
@@ -122,10 +123,17 @@ SProcXISelectEvents(ClientPtr client)
     swapl(&stuff->win);
     swaps(&stuff->num_masks);
 
+    len = stuff->length - bytes_to_int32(sizeof(xXISelectEventsReq));
     evmask = (xXIEventMask *) &stuff[1];
     for (i = 0; i < stuff->num_masks; i++) {
+        if (len < bytes_to_int32(sizeof(xXIEventMask)))
+            return BadLength;
+        len -= bytes_to_int32(sizeof(xXIEventMask));
         swaps(&evmask->deviceid);
         swaps(&evmask->mask_len);
+        if (len < evmask->mask_len)
+            return BadLength;
+        len -= evmask->mask_len;
         evmask =
             (xXIEventMask *) (((char *) &evmask[1]) + evmask->mask_len * 4);
     }
Index: xserver/Xi/xisetclientpointer.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/Xi/xisetclientpointer.c,v
retrieving revision 1.2
diff -u -p -u -r1.2 xisetclientpointer.c
--- xserver/Xi/xisetclientpointer.c	10 Jun 2012 13:21:20 -0000	1.2
+++ xserver/Xi/xisetclientpointer.c	7 Dec 2014 12:31:36 -0000
@@ -51,10 +51,11 @@ int
 SProcXISetClientPointer(ClientPtr client)
 {
     REQUEST(xXISetClientPointerReq);
+    REQUEST_SIZE_MATCH(xXISetClientPointerReq);
+
     swaps(&stuff->length);
     swapl(&stuff->win);
     swaps(&stuff->deviceid);
-    REQUEST_SIZE_MATCH(xXISetClientPointerReq);
     return (ProcXISetClientPointer(client));
 }
 
Index: xserver/Xi/xisetdevfocus.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/Xi/xisetdevfocus.c,v
retrieving revision 1.3
diff -u -p -u -r1.3 xisetdevfocus.c
--- xserver/Xi/xisetdevfocus.c	7 Jun 2013 17:28:46 -0000	1.3
+++ xserver/Xi/xisetdevfocus.c	7 Dec 2014 12:31:36 -0000
@@ -44,6 +44,8 @@ int
 SProcXISetFocus(ClientPtr client)
 {
     REQUEST(xXISetFocusReq);
+    REQUEST_AT_LEAST_SIZE(xXISetFocusReq);
+
     swaps(&stuff->length);
     swaps(&stuff->deviceid);
     swapl(&stuff->focus);
@@ -56,6 +58,8 @@ int
 SProcXIGetFocus(ClientPtr client)
 {
     REQUEST(xXIGetFocusReq);
+    REQUEST_AT_LEAST_SIZE(xXIGetFocusReq);
+
     swaps(&stuff->length);
     swaps(&stuff->deviceid);
 
Index: xserver/Xi/xiwarppointer.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/Xi/xiwarppointer.c,v
retrieving revision 1.3
diff -u -p -u -r1.3 xiwarppointer.c
--- xserver/Xi/xiwarppointer.c	10 Jun 2012 13:21:20 -0000	1.3
+++ xserver/Xi/xiwarppointer.c	7 Dec 2014 12:31:36 -0000
@@ -56,6 +56,8 @@ int
 SProcXIWarpPointer(ClientPtr client)
 {
     REQUEST(xXIWarpPointerReq);
+    REQUEST_SIZE_MATCH(xXIWarpPointerReq);
+
     swaps(&stuff->length);
     swapl(&stuff->src_win);
     swapl(&stuff->dst_win);
Index: xserver/dbe/dbe.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/dbe/dbe.c,v
retrieving revision 1.12
diff -u -p -u -r1.12 dbe.c
--- xserver/dbe/dbe.c	7 Jun 2013 17:28:47 -0000	1.12
+++ xserver/dbe/dbe.c	7 Dec 2014 12:31:36 -0000
@@ -454,18 +454,20 @@ ProcDbeSwapBuffers(ClientPtr client)
     DbeSwapInfoPtr swapInfo;
     xDbeSwapInfo *dbeSwapInfo;
     int error;
-    register int i, j;
-    int nStuff;
+    unsigned int i, j;
+    unsigned int nStuff;
 
     REQUEST_AT_LEAST_SIZE(xDbeSwapBuffersReq);
     nStuff = stuff->n;          /* use local variable for performance. */
 
     if (nStuff == 0) {
+        REQUEST_SIZE_MATCH(xDbeSwapBuffersReq);
         return Success;
     }
 
     if (nStuff > UINT32_MAX / sizeof(DbeSwapInfoRec))
         return BadAlloc;
+    REQUEST_FIXED_SIZE(xDbeSwapBuffersReq, nStuff * sizeof(xDbeSwapInfo));
 
     /* Get to the swap info appended to the end of the request. */
     dbeSwapInfo = (xDbeSwapInfo *) &stuff[1];
@@ -956,13 +958,16 @@ static int
 SProcDbeSwapBuffers(ClientPtr client)
 {
     REQUEST(xDbeSwapBuffersReq);
-    register int i;
+    unsigned int i;
     xDbeSwapInfo *pSwapInfo;
 
     swaps(&stuff->length);
     REQUEST_AT_LEAST_SIZE(xDbeSwapBuffersReq);
 
     swapl(&stuff->n);
+    if (stuff->n > UINT32_MAX / sizeof(DbeSwapInfoRec))
+        return BadAlloc;
+    REQUEST_FIXED_SIZE(xDbeSwapBuffersReq, stuff->n * sizeof(xDbeSwapInfo));
 
     if (stuff->n != 0) {
         pSwapInfo = (xDbeSwapInfo *) stuff + 1;
Index: xserver/dix/dispatch.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/dix/dispatch.c,v
retrieving revision 1.10
diff -u -p -u -r1.10 dispatch.c
--- xserver/dix/dispatch.c	28 Sep 2013 15:36:33 -0000	1.10
+++ xserver/dix/dispatch.c	7 Dec 2014 12:31:36 -0000
@@ -1955,6 +1955,9 @@ ProcPutImage(ClientPtr client)
     tmpImage = (char *) &stuff[1];
     lengthProto = length;
 
+    if (lengthProto >= (INT32_MAX / stuff->height))
+        return BadLength;
+
     if ((bytes_to_int32(lengthProto * stuff->height) +
          bytes_to_int32(sizeof(xPutImageReq))) != client->req_len)
         return BadLength;
Index: xserver/dix/region.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/dix/region.c,v
retrieving revision 1.3
diff -u -p -u -r1.3 region.c
--- xserver/dix/region.c	10 Jun 2012 13:21:21 -0000	1.3
+++ xserver/dix/region.c	7 Dec 2014 12:31:36 -0000
@@ -169,7 +169,6 @@ Equipment Corporation.
         ((r1)->y1 <= (r2)->y1) && \
         ((r1)->y2 >= (r2)->y2) )
 
-#define xallocData(n) malloc(RegionSizeof(n))
 #define xfreeData(reg) if ((reg)->data && (reg)->data->size) free((reg)->data)
 
 #define RECTALLOC_BAIL(pReg,n,bail) \
@@ -205,8 +204,9 @@ if (!(pReg)->data || (((pReg)->data->num
 #define DOWNSIZE(reg,numRects)						 \
 if (((numRects) < ((reg)->data->size >> 1)) && ((reg)->data->size > 50)) \
 {									 \
-    RegDataPtr NewData;							 \
-    NewData = (RegDataPtr)realloc((reg)->data, RegionSizeof(numRects));	 \
+    size_t NewSize = RegionSizeof(numRects);				 \
+    RegDataPtr NewData =						 \
+        (NewSize > 0) ? realloc((reg)->data, NewSize) : NULL ;		 \
     if (NewData)							 \
     {									 \
 	NewData->size = (numRects);					 \
@@ -330,17 +330,20 @@ Bool
 RegionRectAlloc(RegionPtr pRgn, int n)
 {
     RegDataPtr data;
+    size_t rgnSize;
 
     if (!pRgn->data) {
         n++;
-        pRgn->data = xallocData(n);
+        rgnSize = RegionSizeof(n);
+        pRgn->data = (rgnSize > 0) ? malloc(rgnSize) : NULL;
         if (!pRgn->data)
             return RegionBreak(pRgn);
         pRgn->data->numRects = 1;
         *RegionBoxptr(pRgn) = pRgn->extents;
     }
     else if (!pRgn->data->size) {
-        pRgn->data = xallocData(n);
+        rgnSize = RegionSizeof(n);
+        pRgn->data = (rgnSize > 0) ? malloc(rgnSize) : NULL;
         if (!pRgn->data)
             return RegionBreak(pRgn);
         pRgn->data->numRects = 0;
@@ -352,7 +355,8 @@ RegionRectAlloc(RegionPtr pRgn, int n)
                 n = 250;
         }
         n += pRgn->data->numRects;
-        data = (RegDataPtr) realloc(pRgn->data, RegionSizeof(n));
+        rgnSize = RegionSizeof(n);
+        data = (rgnSize > 0) ? realloc(pRgn->data, rgnSize) : NULL;
         if (!data)
             return RegionBreak(pRgn);
         pRgn->data = data;
@@ -1297,6 +1301,7 @@ RegionFromRects(int nrects, xRectangle *
 {
 
     RegionPtr pRgn;
+    size_t rgnSize;
     RegDataPtr pData;
     BoxPtr pBox;
     int i;
@@ -1323,7 +1328,8 @@ RegionFromRects(int nrects, xRectangle *
         }
         return pRgn;
     }
-    pData = xallocData(nrects);
+    rgnSize = RegionSizeof(nrects);
+    pData = (rgnSize > 0) ? malloc(rgnSize) : NULL;
     if (!pData) {
         RegionBreak(pRgn);
         return pRgn;
Index: xserver/glx/clientinfo.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/glx/clientinfo.c,v
retrieving revision 1.2
diff -u -p -u -r1.2 clientinfo.c
--- xserver/glx/clientinfo.c	7 Jun 2013 17:28:47 -0000	1.2
+++ xserver/glx/clientinfo.c	7 Dec 2014 12:31:42 -0000
@@ -33,18 +33,21 @@ static int
 set_client_info(__GLXclientState * cl, xGLXSetClientInfoARBReq * req,
                 unsigned bytes_per_version)
 {
+    ClientPtr client = cl->client;
     char *gl_extensions;
     char *glx_extensions;
 
+    REQUEST_AT_LEAST_SIZE(xGLXSetClientInfoARBReq);
+
     /* Verify that the size of the packet matches the size inferred from the
      * sizes specified for the various fields.
      */
-    const unsigned expected_size = sz_xGLXSetClientInfoARBReq
-        + (req->numVersions * bytes_per_version)
-        + __GLX_PAD(req->numGLExtensionBytes)
-        + __GLX_PAD(req->numGLXExtensionBytes);
+    int size = sz_xGLXSetClientInfoARBReq;
+    size = safe_add(size, safe_mul(req->numVersions, bytes_per_version));
+    size = safe_add(size, safe_pad(req->numGLExtensionBytes));
+    size = safe_add(size, safe_pad(req->numGLXExtensionBytes));
 
-    if (req->length != (expected_size / 4))
+    if (size < 0 || req->length != (size / 4))
         return BadLength;
 
     /* Verify that the actual length of the GL extension string matches what's
@@ -80,8 +83,11 @@ __glXDisp_SetClientInfoARB(__GLXclientSt
 int
 __glXDispSwap_SetClientInfoARB(__GLXclientState * cl, GLbyte * pc)
 {
+    ClientPtr client = cl->client;
     xGLXSetClientInfoARBReq *req = (xGLXSetClientInfoARBReq *) pc;
 
+    REQUEST_AT_LEAST_SIZE(xGLXSetClientInfoARBReq);
+
     req->length = bswap_16(req->length);
     req->numVersions = bswap_32(req->numVersions);
     req->numGLExtensionBytes = bswap_32(req->numGLExtensionBytes);
@@ -99,7 +105,10 @@ __glXDisp_SetClientInfo2ARB(__GLXclientS
 int
 __glXDispSwap_SetClientInfo2ARB(__GLXclientState * cl, GLbyte * pc)
 {
+    ClientPtr client = cl->client;
     xGLXSetClientInfoARBReq *req = (xGLXSetClientInfoARBReq *) pc;
+
+    REQUEST_AT_LEAST_SIZE(xGLXSetClientInfoARBReq);
 
     req->length = bswap_16(req->length);
     req->numVersions = bswap_32(req->numVersions);
Index: xserver/glx/glxcmds.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/glx/glxcmds.c,v
retrieving revision 1.8
diff -u -p -u -r1.8 glxcmds.c
--- xserver/glx/glxcmds.c	7 Jun 2013 17:28:47 -0000	1.8
+++ xserver/glx/glxcmds.c	7 Dec 2014 12:31:42 -0000
@@ -1971,7 +1971,7 @@ __glXDisp_Render(__GLXclientState * cl, 
     left = (req->length << 2) - sz_xGLXRenderReq;
     while (left > 0) {
         __GLXrenderSizeData entry;
-        int extra;
+        int extra = 0;
         __GLXdispatchRenderProcPtr proc;
         int err;
 
@@ -1990,6 +1990,9 @@ __glXDisp_Render(__GLXclientState * cl, 
         cmdlen = hdr->length;
         opcode = hdr->opcode;
 
+        if (left < cmdlen)
+            return BadLength;
+
         /*
          ** Check for core opcodes and grab entry data.
          */
@@ -2003,24 +2006,21 @@ __glXDisp_Render(__GLXclientState * cl, 
             return __glXError(GLXBadRenderRequest);
         }
 
+        if (cmdlen < entry.bytes) {
+            return BadLength;
+        }
+
         if (entry.varsize) {
             /* variable size command */
             extra = (*entry.varsize) (pc + __GLX_RENDER_HDR_SIZE,
-                                      client->swapped);
+                                      client->swapped,
+                                      left - __GLX_RENDER_HDR_SIZE);
             if (extra < 0) {
-                extra = 0;
-            }
-            if (cmdlen != __GLX_PAD(entry.bytes + extra)) {
-                return BadLength;
-            }
-        }
-        else {
-            /* constant size command */
-            if (cmdlen != __GLX_PAD(entry.bytes)) {
                 return BadLength;
             }
         }
-        if (left < cmdlen) {
+
+        if (cmdlen != safe_pad(safe_add(entry.bytes, extra))) {
             return BadLength;
         }
 
@@ -2056,6 +2056,8 @@ __glXDisp_RenderLarge(__GLXclientState *
 
     __GLX_DECLARE_SWAP_VARIABLES;
 
+    REQUEST_AT_LEAST_SIZE(xGLXRenderLargeReq);
+
     req = (xGLXRenderLargeReq *) pc;
     if (client->swapped) {
         __GLX_SWAP_SHORT(&req->length);
@@ -2071,12 +2073,14 @@ __glXDisp_RenderLarge(__GLXclientState *
         __glXResetLargeCommandStatus(cl);
         return error;
     }
+    if (safe_pad(req->dataBytes) < 0)
+        return BadLength;
     dataBytes = req->dataBytes;
 
     /*
      ** Check the request length.
      */
-    if ((req->length << 2) != __GLX_PAD(dataBytes) + sz_xGLXRenderLargeReq) {
+    if ((req->length << 2) != safe_pad(dataBytes) + sz_xGLXRenderLargeReq) {
         client->errorValue = req->length;
         /* Reset in case this isn't 1st request. */
         __glXResetLargeCommandStatus(cl);
@@ -2086,7 +2090,8 @@ __glXDisp_RenderLarge(__GLXclientState *
 
     if (cl->largeCmdRequestsSoFar == 0) {
         __GLXrenderSizeData entry;
-        int extra;
+        int extra = 0;
+        int left = (req->length << 2) - sz_xGLXRenderLargeReq;
         size_t cmdlen;
         int err;
 
@@ -2099,13 +2104,17 @@ __glXDisp_RenderLarge(__GLXclientState *
             return __glXError(GLXBadLargeRequest);
         }
 
+        if (dataBytes < __GLX_RENDER_LARGE_HDR_SIZE)
+            return BadLength;
+
         hdr = (__GLXrenderLargeHeader *) pc;
         if (client->swapped) {
             __GLX_SWAP_INT(&hdr->length);
             __GLX_SWAP_INT(&hdr->opcode);
         }
-        cmdlen = hdr->length;
         opcode = hdr->opcode;
+        if ((cmdlen = safe_pad(hdr->length)) < 0)
+            return BadLength;
 
         /*
          ** Check for core opcodes and grab entry data.
@@ -2123,21 +2132,18 @@ __glXDisp_RenderLarge(__GLXclientState *
              ** will be in the 1st request, so it's okay to do this.
              */
             extra = (*entry.varsize) (pc + __GLX_RENDER_LARGE_HDR_SIZE,
-                                      client->swapped);
+                                      client->swapped,
+                                      left - __GLX_RENDER_LARGE_HDR_SIZE);
             if (extra < 0) {
-                extra = 0;
-            }
-            /* large command's header is 4 bytes longer, so add 4 */
-            if (cmdlen != __GLX_PAD(entry.bytes + 4 + extra)) {
                 return BadLength;
             }
         }
-        else {
-            /* constant size command */
-            if (cmdlen != __GLX_PAD(entry.bytes + 4)) {
-                return BadLength;
-            }
+
+        /* the +4 is safe because we know entry.bytes is small */
+        if (cmdlen != safe_pad(safe_add(entry.bytes + 4, extra))) {
+            return BadLength;
         }
+
         /*
          ** Make enough space in the buffer, then copy the entire request.
          */
@@ -2167,6 +2173,7 @@ __glXDisp_RenderLarge(__GLXclientState *
          ** We are receiving subsequent (i.e. not the first) requests of a
          ** multi request command.
          */
+        int bytesSoFar; /* including this packet */
 
         /*
          ** Check the request number and the total request count.
@@ -2185,11 +2192,18 @@ __glXDisp_RenderLarge(__GLXclientState *
         /*
          ** Check that we didn't get too much data.
          */
-        if ((cl->largeCmdBytesSoFar + dataBytes) > cl->largeCmdBytesTotal) {
+        if ((bytesSoFar = safe_add(cl->largeCmdBytesSoFar, dataBytes)) < 0) {
             client->errorValue = dataBytes;
             __glXResetLargeCommandStatus(cl);
             return __glXError(GLXBadLargeRequest);
         }
+
+        if (bytesSoFar > cl->largeCmdBytesTotal) {
+            client->errorValue = dataBytes;
+            __glXResetLargeCommandStatus(cl);
+            return __glXError(GLXBadLargeRequest);
+        }
+
         memcpy(cl->largeCmdBuf + cl->largeCmdBytesSoFar, pc, dataBytes);
         cl->largeCmdBytesSoFar += dataBytes;
         cl->largeCmdRequestsSoFar++;
@@ -2201,17 +2215,16 @@ __glXDisp_RenderLarge(__GLXclientState *
              ** This is the last request; it must have enough bytes to complete
              ** the command.
              */
-            /* NOTE: the two pad macros have been added below; they are needed
-             ** because the client library pads the total byte count, but not
-             ** the per-request byte counts.  The Protocol Encoding says the
-             ** total byte count should not be padded, so a proposal will be 
-             ** made to the ARB to relax the padding constraint on the total 
-             ** byte count, thus preserving backward compatibility.  Meanwhile, 
-             ** the padding done below fixes a bug that did not allow
-             ** large commands of odd sizes to be accepted by the server.
+            /* NOTE: the pad macro below is needed because the client library
+             ** pads the total byte count, but not the per-request byte counts.
+             ** The Protocol Encoding says the total byte count should not be
+             ** padded, so a proposal will be made to the ARB to relax the
+             ** padding constraint on the total byte count, thus preserving
+             ** backward compatibility.  Meanwhile, the padding done below
+             ** fixes a bug that did not allow large commands of odd sizes to
+             ** be accepted by the server.
              */
-            if (__GLX_PAD(cl->largeCmdBytesSoFar) !=
-                __GLX_PAD(cl->largeCmdBytesTotal)) {
+            if (safe_pad(cl->largeCmdBytesSoFar) != cl->largeCmdBytesTotal) {
                 client->errorValue = dataBytes;
                 __glXResetLargeCommandStatus(cl);
                 return __glXError(GLXBadLargeRequest);
Index: xserver/glx/glxcmdsswap.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/glx/glxcmdsswap.c,v
retrieving revision 1.6
diff -u -p -u -r1.6 glxcmdsswap.c
--- xserver/glx/glxcmdsswap.c	7 Jun 2013 17:28:47 -0000	1.6
+++ xserver/glx/glxcmdsswap.c	7 Dec 2014 12:31:42 -0000
@@ -962,11 +962,13 @@ __glXDispSwap_RenderLarge(__GLXclientSta
 int
 __glXDispSwap_VendorPrivate(__GLXclientState * cl, GLbyte * pc)
 {
+    ClientPtr client = cl->client;
     xGLXVendorPrivateReq *req;
     GLint vendorcode;
     __GLXdispatchVendorPrivProcPtr proc;
 
     __GLX_DECLARE_SWAP_VARIABLES;
+    REQUEST_AT_LEAST_SIZE(xGLXVendorPrivateReq);
 
     req = (xGLXVendorPrivateReq *) pc;
     __GLX_SWAP_SHORT(&req->length);
@@ -989,11 +991,13 @@ __glXDispSwap_VendorPrivate(__GLXclientS
 int
 __glXDispSwap_VendorPrivateWithReply(__GLXclientState * cl, GLbyte * pc)
 {
+    ClientPtr client = cl->client;
     xGLXVendorPrivateWithReplyReq *req;
     GLint vendorcode;
     __GLXdispatchVendorPrivProcPtr proc;
 
     __GLX_DECLARE_SWAP_VARIABLES;
+    REQUEST_AT_LEAST_SIZE(xGLXVendorPrivateWithReplyReq);
 
     req = (xGLXVendorPrivateWithReplyReq *) pc;
     __GLX_SWAP_SHORT(&req->length);
Index: xserver/glx/glxserver.h
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/glx/glxserver.h,v
retrieving revision 1.6
diff -u -p -u -r1.6 glxserver.h
--- xserver/glx/glxserver.h	7 Jun 2013 17:28:47 -0000	1.6
+++ xserver/glx/glxserver.h	7 Dec 2014 12:31:42 -0000
@@ -163,7 +163,7 @@ typedef int (*__GLXprocPtr) (__GLXclient
 /*
  * Tables for computing the size of each rendering command.
  */
-typedef int (*gl_proto_size_func) (const GLbyte *, Bool);
+typedef int (*gl_proto_size_func) (const GLbyte *, Bool, int);
 
 typedef struct {
     int bytes;
@@ -213,6 +213,47 @@ extern void glxSwapQueryServerStringRepl
 /*
  * Routines for computing the size of variably-sized rendering commands.
  */
+
+static _X_INLINE int
+safe_add(int a, int b)
+{
+    if (a < 0 || b < 0)
+        return -1;
+
+    if (INT_MAX - a < b)
+        return -1;
+
+    return a + b;
+}
+
+static _X_INLINE int
+safe_mul(int a, int b)
+{
+    if (a < 0 || b < 0)
+        return -1;
+
+    if (a == 0 || b == 0)
+        return 0;
+
+    if (a > INT_MAX / b)
+        return -1;
+
+    return a * b;
+}
+
+static _X_INLINE int
+safe_pad(int a)
+{
+    int ret;
+
+    if (a < 0)
+        return -1;
+
+    if ((ret = safe_add(a, 3)) < 0)
+        return -1;
+
+    return ret & (GLuint)~3;
+}
 
 extern int __glXTypeSize(GLenum enm);
 extern int __glXImageSize(GLenum format, GLenum type,
Index: xserver/glx/indirect_dispatch.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/glx/indirect_dispatch.c,v
retrieving revision 1.4
diff -u -p -u -r1.4 indirect_dispatch.c
--- xserver/glx/indirect_dispatch.c	10 Jun 2012 13:21:22 -0000	1.4
+++ xserver/glx/indirect_dispatch.c	7 Dec 2014 18:35:48 -0000
@@ -2705,6 +2705,9 @@ __glXDisp_AreTexturesResident(__GLXclien
         GLboolean answerBuffer[200];
         GLboolean *residences =
             __glXGetAnswerBuffer(cl, n, answerBuffer, sizeof(answerBuffer), 1);
+
+        if (residences == NULL)
+            return BadAlloc;
         retval =
             CALL_AreTexturesResident(GET_DISPATCH(),
                                      (n, (const GLuint *) (pc + 4),
@@ -2731,6 +2734,9 @@ __glXDisp_AreTexturesResidentEXT(__GLXcl
         GLboolean answerBuffer[200];
         GLboolean *residences =
             __glXGetAnswerBuffer(cl, n, answerBuffer, sizeof(answerBuffer), 1);
+
+        if (residences == NULL)
+            return BadAlloc;
         retval =
             CALL_AreTexturesResident(GET_DISPATCH(),
                                      (n, (const GLuint *) (pc + 4),
@@ -2848,6 +2854,8 @@ __glXDisp_GenTextures(__GLXclientState *
         GLuint *textures =
             __glXGetAnswerBuffer(cl, n * 4, answerBuffer, sizeof(answerBuffer),
                                  4);
+        if (textures == NULL)
+            return BadAlloc;
         CALL_GenTextures(GET_DISPATCH(), (n, textures));
         __glXSendReply(cl->client, textures, n, 4, GL_TRUE, 0);
         error = Success;
@@ -2871,6 +2879,8 @@ __glXDisp_GenTexturesEXT(__GLXclientStat
         GLuint *textures =
             __glXGetAnswerBuffer(cl, n * 4, answerBuffer, sizeof(answerBuffer),
                                  4);
+        if (textures == NULL)
+            return BadAlloc;
         CALL_GenTextures(GET_DISPATCH(), (n, textures));
         __glXSendReply(cl->client, textures, n, 4, GL_TRUE, 0);
         error = Success;
@@ -4598,6 +4608,8 @@ __glXDisp_GenQueriesARB(__GLXclientState
         GLuint *ids =
             __glXGetAnswerBuffer(cl, n * 4, answerBuffer, sizeof(answerBuffer),
                                  4);
+        if (ids == NULL)
+            return BadAlloc;
         CALL_GenQueriesARB(GET_DISPATCH(), (n, ids));
         __glXSendReply(cl->client, ids, n, 4, GL_TRUE, 0);
         error = Success;
@@ -4956,6 +4968,8 @@ __glXDisp_GenProgramsNV(__GLXclientState
         GLuint *programs =
             __glXGetAnswerBuffer(cl, n * 4, answerBuffer, sizeof(answerBuffer),
                                  4);
+        if (programs == NULL)
+            return BadAlloc;
         CALL_GenProgramsNV(GET_DISPATCH(), (n, programs));
         __glXSendReply(cl->client, programs, n, 4, GL_TRUE, 0);
         error = Success;
@@ -5765,6 +5779,8 @@ __glXDisp_GenFramebuffersEXT(__GLXclient
         GLuint *framebuffers =
             __glXGetAnswerBuffer(cl, n * 4, answerBuffer, sizeof(answerBuffer),
                                  4);
+        if (framebuffers == NULL)
+            return BadAlloc;
         CALL_GenFramebuffersEXT(GET_DISPATCH(), (n, framebuffers));
         __glXSendReply(cl->client, framebuffers, n, 4, GL_TRUE, 0);
         error = Success;
@@ -5788,6 +5804,8 @@ __glXDisp_GenRenderbuffersEXT(__GLXclien
         GLuint *renderbuffers =
             __glXGetAnswerBuffer(cl, n * 4, answerBuffer, sizeof(answerBuffer),
                                  4);
+        if (renderbuffers == NULL)
+            return BadAlloc;
         CALL_GenRenderbuffersEXT(GET_DISPATCH(), (n, renderbuffers));
         __glXSendReply(cl->client, renderbuffers, n, 4, GL_TRUE, 0);
         error = Success;
Index: xserver/glx/indirect_dispatch_swap.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/glx/indirect_dispatch_swap.c,v
retrieving revision 1.4
diff -u -p -u -r1.4 indirect_dispatch_swap.c
--- xserver/glx/indirect_dispatch_swap.c	10 Jun 2012 13:21:22 -0000	1.4
+++ xserver/glx/indirect_dispatch_swap.c	7 Dec 2014 18:35:12 -0000
@@ -3076,6 +3076,9 @@ __glXDispSwap_AreTexturesResident(__GLXc
         GLboolean answerBuffer[200];
         GLboolean *residences =
             __glXGetAnswerBuffer(cl, n, answerBuffer, sizeof(answerBuffer), 1);
+
+        if (residences == NULL)
+            return BadAlloc;
         retval =
             CALL_AreTexturesResident(GET_DISPATCH(),
                                      (n,
@@ -3105,6 +3108,9 @@ __glXDispSwap_AreTexturesResidentEXT(__G
         GLboolean answerBuffer[200];
         GLboolean *residences =
             __glXGetAnswerBuffer(cl, n, answerBuffer, sizeof(answerBuffer), 1);
+
+        if (residences == NULL)
+            return BadAlloc;
         retval =
             CALL_AreTexturesResident(GET_DISPATCH(),
                                      (n,
@@ -3233,6 +3239,8 @@ __glXDispSwap_GenTextures(__GLXclientSta
         GLuint *textures =
             __glXGetAnswerBuffer(cl, n * 4, answerBuffer, sizeof(answerBuffer),
                                  4);
+        if (textures == NULL)
+            return BadAlloc;
         CALL_GenTextures(GET_DISPATCH(), (n, textures));
         (void) bswap_32_array((uint32_t *) textures, n);
         __glXSendReplySwap(cl->client, textures, n, 4, GL_TRUE, 0);
@@ -3258,6 +3266,8 @@ __glXDispSwap_GenTexturesEXT(__GLXclient
         GLuint *textures =
             __glXGetAnswerBuffer(cl, n * 4, answerBuffer, sizeof(answerBuffer),
                                  4);
+        if (textures == NULL)
+            return BadAlloc;
         CALL_GenTextures(GET_DISPATCH(), (n, textures));
         (void) bswap_32_array((uint32_t *) textures, n);
         __glXSendReplySwap(cl->client, textures, n, 4, GL_TRUE, 0);
@@ -5259,6 +5269,8 @@ __glXDispSwap_GenQueriesARB(__GLXclientS
         GLuint *ids =
             __glXGetAnswerBuffer(cl, n * 4, answerBuffer, sizeof(answerBuffer),
                                  4);
+        if (ids == NULL)
+            return BadAlloc;
         CALL_GenQueriesARB(GET_DISPATCH(), (n, ids));
         (void) bswap_32_array((uint32_t *) ids, n);
         __glXSendReplySwap(cl->client, ids, n, 4, GL_TRUE, 0);
@@ -5672,6 +5684,8 @@ __glXDispSwap_GenProgramsNV(__GLXclientS
         GLuint *programs =
             __glXGetAnswerBuffer(cl, n * 4, answerBuffer, sizeof(answerBuffer),
                                  4);
+        if (programs == NULL)
+            return BadAlloc;
         CALL_GenProgramsNV(GET_DISPATCH(), (n, programs));
         (void) bswap_32_array((uint32_t *) programs, n);
         __glXSendReplySwap(cl->client, programs, n, 4, GL_TRUE, 0);
@@ -6610,6 +6624,8 @@ __glXDispSwap_GenFramebuffersEXT(__GLXcl
         GLuint *framebuffers =
             __glXGetAnswerBuffer(cl, n * 4, answerBuffer, sizeof(answerBuffer),
                                  4);
+        if (framebuffers == NULL)
+            return BadAlloc;
         CALL_GenFramebuffersEXT(GET_DISPATCH(), (n, framebuffers));
         (void) bswap_32_array((uint32_t *) framebuffers, n);
         __glXSendReplySwap(cl->client, framebuffers, n, 4, GL_TRUE, 0);
@@ -6635,6 +6651,8 @@ __glXDispSwap_GenRenderbuffersEXT(__GLXc
         GLuint *renderbuffers =
             __glXGetAnswerBuffer(cl, n * 4, answerBuffer, sizeof(answerBuffer),
                                  4);
+        if (renderbuffers == NULL)
+            return BadAlloc;
         CALL_GenRenderbuffersEXT(GET_DISPATCH(), (n, renderbuffers));
         (void) bswap_32_array((uint32_t *) renderbuffers, n);
         __glXSendReplySwap(cl->client, renderbuffers, n, 4, GL_TRUE, 0);
Index: xserver/glx/indirect_program.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/glx/indirect_program.c,v
retrieving revision 1.4
diff -u -p -u -r1.4 indirect_program.c
--- xserver/glx/indirect_program.c	7 Jun 2013 17:28:47 -0000	1.4
+++ xserver/glx/indirect_program.c	7 Dec 2014 12:31:42 -0000
@@ -69,6 +69,8 @@ DoGetProgramString(struct __GLXclientSta
     __GLXcontext *const cx = __glXForceCurrent(cl, req->contextTag, &error);
     ClientPtr client = cl->client;
 
+    REQUEST_FIXED_SIZE(xGLXVendorPrivateWithReplyReq, 8);
+
     pc += __GLX_VENDPRIV_HDR_SIZE;
     if (cx != NULL) {
         GLenum target;
Index: xserver/glx/indirect_reqsize.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/glx/indirect_reqsize.c,v
retrieving revision 1.4
diff -u -p -u -r1.4 indirect_reqsize.c
--- xserver/glx/indirect_reqsize.c	10 Jun 2012 13:21:22 -0000	1.4
+++ xserver/glx/indirect_reqsize.c	7 Dec 2014 14:50:36 -0000
@@ -31,24 +31,22 @@
 #include "indirect_size.h"
 #include "indirect_reqsize.h"
 
-#define __GLX_PAD(x)  (((x) + 3) & ~3)
-
 #if defined(__CYGWIN__) || defined(__MINGW32__)
 #undef HAVE_ALIAS
 #endif
 #ifdef HAVE_ALIAS
 #define ALIAS2(from,to) \
-    GLint __glX ## from ## ReqSize( const GLbyte * pc, Bool swap ) \
+    GLint __glX ## from ## ReqSize( const GLbyte * pc, Bool swap, int reqlen ) \
         __attribute__ ((alias( # to )));
 #define ALIAS(from,to) ALIAS2( from, __glX ## to ## ReqSize )
 #else
 #define ALIAS(from,to) \
-    GLint __glX ## from ## ReqSize( const GLbyte * pc, Bool swap ) \
-    { return __glX ## to ## ReqSize( pc, swap ); }
+    GLint __glX ## from ## ReqSize( const GLbyte * pc, Bool swap, int reqlen ) \
+    { return __glX ## to ## ReqSize( pc, swap, reqlen ); }
 #endif
 
 int
-__glXCallListsReqSize(const GLbyte * pc, Bool swap)
+__glXCallListsReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLsizei n = *(GLsizei *) (pc + 0);
     GLenum type = *(GLenum *) (pc + 4);
@@ -60,11 +58,11 @@ __glXCallListsReqSize(const GLbyte * pc,
     }
 
     compsize = __glCallLists_size(type);
-    return __GLX_PAD((compsize * n));
+    return safe_pad(safe_mul(compsize, n));
 }
 
 int
-__glXBitmapReqSize(const GLbyte * pc, Bool swap)
+__glXBitmapReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLint row_length = *(GLint *) (pc + 4);
     GLint image_height = 0;
@@ -88,7 +86,7 @@ __glXBitmapReqSize(const GLbyte * pc, Bo
 }
 
 int
-__glXFogfvReqSize(const GLbyte * pc, Bool swap)
+__glXFogfvReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLenum pname = *(GLenum *) (pc + 0);
     GLsizei compsize;
@@ -98,11 +96,11 @@ __glXFogfvReqSize(const GLbyte * pc, Boo
     }
 
     compsize = __glFogfv_size(pname);
-    return __GLX_PAD((compsize * 4));
+    return safe_pad(safe_mul(compsize, 4));
 }
 
 int
-__glXLightfvReqSize(const GLbyte * pc, Bool swap)
+__glXLightfvReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLenum pname = *(GLenum *) (pc + 4);
     GLsizei compsize;
@@ -112,11 +110,11 @@ __glXLightfvReqSize(const GLbyte * pc, B
     }
 
     compsize = __glLightfv_size(pname);
-    return __GLX_PAD((compsize * 4));
+    return safe_pad(safe_mul(compsize, 4));
 }
 
 int
-__glXLightModelfvReqSize(const GLbyte * pc, Bool swap)
+__glXLightModelfvReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLenum pname = *(GLenum *) (pc + 0);
     GLsizei compsize;
@@ -126,11 +124,11 @@ __glXLightModelfvReqSize(const GLbyte * 
     }
 
     compsize = __glLightModelfv_size(pname);
-    return __GLX_PAD((compsize * 4));
+    return safe_pad(safe_mul(compsize, 4));
 }
 
 int
-__glXMaterialfvReqSize(const GLbyte * pc, Bool swap)
+__glXMaterialfvReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLenum pname = *(GLenum *) (pc + 4);
     GLsizei compsize;
@@ -140,11 +138,11 @@ __glXMaterialfvReqSize(const GLbyte * pc
     }
 
     compsize = __glMaterialfv_size(pname);
-    return __GLX_PAD((compsize * 4));
+    return safe_pad(safe_mul(compsize, 4));
 }
 
 int
-__glXPolygonStippleReqSize(const GLbyte * pc, Bool swap)
+__glXPolygonStippleReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLint row_length = *(GLint *) (pc + 4);
     GLint image_height = 0;
@@ -164,7 +162,7 @@ __glXPolygonStippleReqSize(const GLbyte 
 }
 
 int
-__glXTexParameterfvReqSize(const GLbyte * pc, Bool swap)
+__glXTexParameterfvReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLenum pname = *(GLenum *) (pc + 4);
     GLsizei compsize;
@@ -174,11 +172,11 @@ __glXTexParameterfvReqSize(const GLbyte 
     }
 
     compsize = __glTexParameterfv_size(pname);
-    return __GLX_PAD((compsize * 4));
+    return safe_pad(safe_mul(compsize, 4));
 }
 
 int
-__glXTexImage1DReqSize(const GLbyte * pc, Bool swap)
+__glXTexImage1DReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLint row_length = *(GLint *) (pc + 4);
     GLint image_height = 0;
@@ -206,7 +204,7 @@ __glXTexImage1DReqSize(const GLbyte * pc
 }
 
 int
-__glXTexImage2DReqSize(const GLbyte * pc, Bool swap)
+__glXTexImage2DReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLint row_length = *(GLint *) (pc + 4);
     GLint image_height = 0;
@@ -236,7 +234,7 @@ __glXTexImage2DReqSize(const GLbyte * pc
 }
 
 int
-__glXTexEnvfvReqSize(const GLbyte * pc, Bool swap)
+__glXTexEnvfvReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLenum pname = *(GLenum *) (pc + 4);
     GLsizei compsize;
@@ -246,11 +244,11 @@ __glXTexEnvfvReqSize(const GLbyte * pc, 
     }
 
     compsize = __glTexEnvfv_size(pname);
-    return __GLX_PAD((compsize * 4));
+    return safe_pad(safe_mul(compsize, 4));
 }
 
 int
-__glXTexGendvReqSize(const GLbyte * pc, Bool swap)
+__glXTexGendvReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLenum pname = *(GLenum *) (pc + 4);
     GLsizei compsize;
@@ -260,11 +258,11 @@ __glXTexGendvReqSize(const GLbyte * pc, 
     }
 
     compsize = __glTexGendv_size(pname);
-    return __GLX_PAD((compsize * 8));
+    return safe_pad(safe_mul(compsize, 8));
 }
 
 int
-__glXTexGenfvReqSize(const GLbyte * pc, Bool swap)
+__glXTexGenfvReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLenum pname = *(GLenum *) (pc + 4);
     GLsizei compsize;
@@ -274,11 +272,11 @@ __glXTexGenfvReqSize(const GLbyte * pc, 
     }
 
     compsize = __glTexGenfv_size(pname);
-    return __GLX_PAD((compsize * 4));
+    return safe_pad(safe_mul(compsize, 4));
 }
 
 int
-__glXPixelMapfvReqSize(const GLbyte * pc, Bool swap)
+__glXPixelMapfvReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLsizei mapsize = *(GLsizei *) (pc + 4);
 
@@ -286,11 +284,11 @@ __glXPixelMapfvReqSize(const GLbyte * pc
         mapsize = bswap_32(mapsize);
     }
 
-    return __GLX_PAD((mapsize * 4));
+    return safe_pad(safe_mul(mapsize, 4));
 }
 
 int
-__glXPixelMapusvReqSize(const GLbyte * pc, Bool swap)
+__glXPixelMapusvReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLsizei mapsize = *(GLsizei *) (pc + 4);
 
@@ -298,11 +296,11 @@ __glXPixelMapusvReqSize(const GLbyte * p
         mapsize = bswap_32(mapsize);
     }
 
-    return __GLX_PAD((mapsize * 2));
+    return safe_pad(safe_mul(mapsize, 2));
 }
 
 int
-__glXDrawPixelsReqSize(const GLbyte * pc, Bool swap)
+__glXDrawPixelsReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLint row_length = *(GLint *) (pc + 4);
     GLint image_height = 0;
@@ -330,7 +328,7 @@ __glXDrawPixelsReqSize(const GLbyte * pc
 }
 
 int
-__glXPrioritizeTexturesReqSize(const GLbyte * pc, Bool swap)
+__glXPrioritizeTexturesReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLsizei n = *(GLsizei *) (pc + 0);
 
@@ -338,11 +336,11 @@ __glXPrioritizeTexturesReqSize(const GLb
         n = bswap_32(n);
     }
 
-    return __GLX_PAD((n * 4) + (n * 4));
+    return safe_pad(safe_add(safe_mul(n, 4), safe_mul(n, 4)));
 }
 
 int
-__glXTexSubImage1DReqSize(const GLbyte * pc, Bool swap)
+__glXTexSubImage1DReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLint row_length = *(GLint *) (pc + 4);
     GLint image_height = 0;
@@ -370,7 +368,7 @@ __glXTexSubImage1DReqSize(const GLbyte *
 }
 
 int
-__glXTexSubImage2DReqSize(const GLbyte * pc, Bool swap)
+__glXTexSubImage2DReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLint row_length = *(GLint *) (pc + 4);
     GLint image_height = 0;
@@ -400,7 +398,7 @@ __glXTexSubImage2DReqSize(const GLbyte *
 }
 
 int
-__glXColorTableReqSize(const GLbyte * pc, Bool swap)
+__glXColorTableReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLint row_length = *(GLint *) (pc + 4);
     GLint image_height = 0;
@@ -428,7 +426,7 @@ __glXColorTableReqSize(const GLbyte * pc
 }
 
 int
-__glXColorTableParameterfvReqSize(const GLbyte * pc, Bool swap)
+__glXColorTableParameterfvReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLenum pname = *(GLenum *) (pc + 4);
     GLsizei compsize;
@@ -438,11 +436,11 @@ __glXColorTableParameterfvReqSize(const 
     }
 
     compsize = __glColorTableParameterfv_size(pname);
-    return __GLX_PAD((compsize * 4));
+    return safe_pad(safe_mul(compsize, 4));
 }
 
 int
-__glXColorSubTableReqSize(const GLbyte * pc, Bool swap)
+__glXColorSubTableReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLint row_length = *(GLint *) (pc + 4);
     GLint image_height = 0;
@@ -470,7 +468,7 @@ __glXColorSubTableReqSize(const GLbyte *
 }
 
 int
-__glXConvolutionFilter1DReqSize(const GLbyte * pc, Bool swap)
+__glXConvolutionFilter1DReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLint row_length = *(GLint *) (pc + 4);
     GLint image_height = 0;
@@ -498,7 +496,7 @@ __glXConvolutionFilter1DReqSize(const GL
 }
 
 int
-__glXConvolutionFilter2DReqSize(const GLbyte * pc, Bool swap)
+__glXConvolutionFilter2DReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLint row_length = *(GLint *) (pc + 4);
     GLint image_height = 0;
@@ -528,7 +526,7 @@ __glXConvolutionFilter2DReqSize(const GL
 }
 
 int
-__glXConvolutionParameterfvReqSize(const GLbyte * pc, Bool swap)
+__glXConvolutionParameterfvReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLenum pname = *(GLenum *) (pc + 4);
     GLsizei compsize;
@@ -538,11 +536,11 @@ __glXConvolutionParameterfvReqSize(const
     }
 
     compsize = __glConvolutionParameterfv_size(pname);
-    return __GLX_PAD((compsize * 4));
+    return safe_pad(safe_mul(compsize, 4));
 }
 
 int
-__glXTexImage3DReqSize(const GLbyte * pc, Bool swap)
+__glXTexImage3DReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLint row_length = *(GLint *) (pc + 4);
     GLint image_height = *(GLint *) (pc + 8);
@@ -579,7 +577,7 @@ __glXTexImage3DReqSize(const GLbyte * pc
 }
 
 int
-__glXTexSubImage3DReqSize(const GLbyte * pc, Bool swap)
+__glXTexSubImage3DReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLint row_length = *(GLint *) (pc + 4);
     GLint image_height = *(GLint *) (pc + 8);
@@ -613,7 +611,7 @@ __glXTexSubImage3DReqSize(const GLbyte *
 }
 
 int
-__glXCompressedTexImage1DARBReqSize(const GLbyte * pc, Bool swap)
+__glXCompressedTexImage1DARBReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLsizei imageSize = *(GLsizei *) (pc + 20);
 
@@ -621,11 +619,11 @@ __glXCompressedTexImage1DARBReqSize(cons
         imageSize = bswap_32(imageSize);
     }
 
-    return __GLX_PAD(imageSize);
+    return safe_pad(imageSize);
 }
 
 int
-__glXCompressedTexImage2DARBReqSize(const GLbyte * pc, Bool swap)
+__glXCompressedTexImage2DARBReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLsizei imageSize = *(GLsizei *) (pc + 24);
 
@@ -633,11 +631,11 @@ __glXCompressedTexImage2DARBReqSize(cons
         imageSize = bswap_32(imageSize);
     }
 
-    return __GLX_PAD(imageSize);
+    return safe_pad(imageSize);
 }
 
 int
-__glXCompressedTexImage3DARBReqSize(const GLbyte * pc, Bool swap)
+__glXCompressedTexImage3DARBReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLsizei imageSize = *(GLsizei *) (pc + 28);
 
@@ -645,11 +643,11 @@ __glXCompressedTexImage3DARBReqSize(cons
         imageSize = bswap_32(imageSize);
     }
 
-    return __GLX_PAD(imageSize);
+    return safe_pad(imageSize);
 }
 
 int
-__glXCompressedTexSubImage3DARBReqSize(const GLbyte * pc, Bool swap)
+__glXCompressedTexSubImage3DARBReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLsizei imageSize = *(GLsizei *) (pc + 36);
 
@@ -657,11 +655,11 @@ __glXCompressedTexSubImage3DARBReqSize(c
         imageSize = bswap_32(imageSize);
     }
 
-    return __GLX_PAD(imageSize);
+    return safe_pad(imageSize);
 }
 
 int
-__glXProgramStringARBReqSize(const GLbyte * pc, Bool swap)
+__glXProgramStringARBReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLsizei len = *(GLsizei *) (pc + 8);
 
@@ -669,11 +667,11 @@ __glXProgramStringARBReqSize(const GLbyt
         len = bswap_32(len);
     }
 
-    return __GLX_PAD(len);
+    return safe_pad(len);
 }
 
 int
-__glXDrawBuffersARBReqSize(const GLbyte * pc, Bool swap)
+__glXDrawBuffersARBReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLsizei n = *(GLsizei *) (pc + 0);
 
@@ -681,11 +679,11 @@ __glXDrawBuffersARBReqSize(const GLbyte 
         n = bswap_32(n);
     }
 
-    return __GLX_PAD((n * 4));
+    return safe_pad(safe_mul(n, 4));
 }
 
 int
-__glXPointParameterfvEXTReqSize(const GLbyte * pc, Bool swap)
+__glXPointParameterfvEXTReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLenum pname = *(GLenum *) (pc + 0);
     GLsizei compsize;
@@ -695,11 +693,11 @@ __glXPointParameterfvEXTReqSize(const GL
     }
 
     compsize = __glPointParameterfvEXT_size(pname);
-    return __GLX_PAD((compsize * 4));
+    return safe_pad(safe_mul(compsize, 4));
 }
 
 int
-__glXProgramParameters4dvNVReqSize(const GLbyte * pc, Bool swap)
+__glXProgramParameters4dvNVReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLsizei num = *(GLsizei *) (pc + 8);
 
@@ -707,11 +705,11 @@ __glXProgramParameters4dvNVReqSize(const
         num = bswap_32(num);
     }
 
-    return __GLX_PAD((num * 32));
+    return safe_pad(safe_mul(num, 32));
 }
 
 int
-__glXProgramParameters4fvNVReqSize(const GLbyte * pc, Bool swap)
+__glXProgramParameters4fvNVReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLsizei num = *(GLsizei *) (pc + 8);
 
@@ -719,11 +717,11 @@ __glXProgramParameters4fvNVReqSize(const
         num = bswap_32(num);
     }
 
-    return __GLX_PAD((num * 16));
+    return safe_pad(safe_mul(num, 16));
 }
 
 int
-__glXVertexAttribs1dvNVReqSize(const GLbyte * pc, Bool swap)
+__glXVertexAttribs1dvNVReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLsizei n = *(GLsizei *) (pc + 4);
 
@@ -731,11 +729,11 @@ __glXVertexAttribs1dvNVReqSize(const GLb
         n = bswap_32(n);
     }
 
-    return __GLX_PAD((n * 8));
+    return safe_pad(safe_mul(n, 8));
 }
 
 int
-__glXVertexAttribs2dvNVReqSize(const GLbyte * pc, Bool swap)
+__glXVertexAttribs2dvNVReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLsizei n = *(GLsizei *) (pc + 4);
 
@@ -743,11 +741,11 @@ __glXVertexAttribs2dvNVReqSize(const GLb
         n = bswap_32(n);
     }
 
-    return __GLX_PAD((n * 16));
+    return safe_pad(safe_mul(n, 16));
 }
 
 int
-__glXVertexAttribs3dvNVReqSize(const GLbyte * pc, Bool swap)
+__glXVertexAttribs3dvNVReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLsizei n = *(GLsizei *) (pc + 4);
 
@@ -755,11 +753,11 @@ __glXVertexAttribs3dvNVReqSize(const GLb
         n = bswap_32(n);
     }
 
-    return __GLX_PAD((n * 24));
+    return safe_pad(safe_mul(n, 24));
 }
 
 int
-__glXVertexAttribs3fvNVReqSize(const GLbyte * pc, Bool swap)
+__glXVertexAttribs3fvNVReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLsizei n = *(GLsizei *) (pc + 4);
 
@@ -767,11 +765,11 @@ __glXVertexAttribs3fvNVReqSize(const GLb
         n = bswap_32(n);
     }
 
-    return __GLX_PAD((n * 12));
+    return safe_pad(safe_mul(n, 12));
 }
 
 int
-__glXVertexAttribs3svNVReqSize(const GLbyte * pc, Bool swap)
+__glXVertexAttribs3svNVReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLsizei n = *(GLsizei *) (pc + 4);
 
@@ -779,11 +777,11 @@ __glXVertexAttribs3svNVReqSize(const GLb
         n = bswap_32(n);
     }
 
-    return __GLX_PAD((n * 6));
+    return safe_pad(safe_mul(n, 6));
 }
 
 int
-__glXVertexAttribs4dvNVReqSize(const GLbyte * pc, Bool swap)
+__glXVertexAttribs4dvNVReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLsizei n = *(GLsizei *) (pc + 4);
 
@@ -791,11 +789,11 @@ __glXVertexAttribs4dvNVReqSize(const GLb
         n = bswap_32(n);
     }
 
-    return __GLX_PAD((n * 32));
+    return safe_pad(safe_mul(n, 32));
 }
 
 int
-__glXProgramNamedParameter4fvNVReqSize(const GLbyte * pc, Bool swap)
+__glXProgramNamedParameter4fvNVReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLsizei len = *(GLsizei *) (pc + 4);
 
@@ -803,7 +801,7 @@ __glXProgramNamedParameter4fvNVReqSize(c
         len = bswap_32(len);
     }
 
-    return __GLX_PAD(len);
+    return safe_pad(len);
 }
 
 ALIAS(Fogiv, Fogfv)
Index: xserver/glx/indirect_reqsize.h
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/glx/indirect_reqsize.h,v
retrieving revision 1.3
diff -u -p -u -r1.3 indirect_reqsize.h
--- xserver/glx/indirect_reqsize.h	10 Jun 2012 13:21:22 -0000	1.3
+++ xserver/glx/indirect_reqsize.h	7 Dec 2014 14:04:42 -0000
@@ -36,128 +36,175 @@
 #define PURE
 #endif
 
-extern PURE _X_HIDDEN int __glXCallListsReqSize(const GLbyte * pc, Bool swap);
-extern PURE _X_HIDDEN int __glXBitmapReqSize(const GLbyte * pc, Bool swap);
-extern PURE _X_HIDDEN int __glXFogfvReqSize(const GLbyte * pc, Bool swap);
-extern PURE _X_HIDDEN int __glXFogivReqSize(const GLbyte * pc, Bool swap);
-extern PURE _X_HIDDEN int __glXLightfvReqSize(const GLbyte * pc, Bool swap);
-extern PURE _X_HIDDEN int __glXLightivReqSize(const GLbyte * pc, Bool swap);
+extern PURE _X_HIDDEN int __glXCallListsReqSize(const GLbyte * pc, Bool swap,
+                                                int reqlen);
+extern PURE _X_HIDDEN int __glXBitmapReqSize(const GLbyte * pc, Bool swap,
+                                             int reqlen);
+extern PURE _X_HIDDEN int __glXFogfvReqSize(const GLbyte * pc, Bool swap,
+                                            int reqlen);
+extern PURE _X_HIDDEN int __glXFogivReqSize(const GLbyte * pc, Bool swap,
+                                            int reqlen);
+extern PURE _X_HIDDEN int __glXLightfvReqSize(const GLbyte * pc, Bool swap,
+                                              int reqlen);
+extern PURE _X_HIDDEN int __glXLightivReqSize(const GLbyte * pc, Bool swap,
+                                              int reqlen);
 extern PURE _X_HIDDEN int __glXLightModelfvReqSize(const GLbyte * pc,
-                                                   Bool swap);
+                                                   Bool swap, int reqlen);
 extern PURE _X_HIDDEN int __glXLightModelivReqSize(const GLbyte * pc,
-                                                   Bool swap);
-extern PURE _X_HIDDEN int __glXMaterialfvReqSize(const GLbyte * pc, Bool swap);
-extern PURE _X_HIDDEN int __glXMaterialivReqSize(const GLbyte * pc, Bool swap);
+                                                   Bool swap, int reqlen);
+extern PURE _X_HIDDEN int __glXMaterialfvReqSize(const GLbyte * pc, Bool swap,
+                                                 int reqlen);
+extern PURE _X_HIDDEN int __glXMaterialivReqSize(const GLbyte * pc, Bool swap,
+                                                 int reqlen);
 extern PURE _X_HIDDEN int __glXPolygonStippleReqSize(const GLbyte * pc,
-                                                     Bool swap);
+                                                     Bool swap, int reqlen);
 extern PURE _X_HIDDEN int __glXTexParameterfvReqSize(const GLbyte * pc,
-                                                     Bool swap);
+                                                     Bool swap, int reqlen);
 extern PURE _X_HIDDEN int __glXTexParameterivReqSize(const GLbyte * pc,
-                                                     Bool swap);
-extern PURE _X_HIDDEN int __glXTexImage1DReqSize(const GLbyte * pc, Bool swap);
-extern PURE _X_HIDDEN int __glXTexImage2DReqSize(const GLbyte * pc, Bool swap);
-extern PURE _X_HIDDEN int __glXTexEnvfvReqSize(const GLbyte * pc, Bool swap);
-extern PURE _X_HIDDEN int __glXTexEnvivReqSize(const GLbyte * pc, Bool swap);
-extern PURE _X_HIDDEN int __glXTexGendvReqSize(const GLbyte * pc, Bool swap);
-extern PURE _X_HIDDEN int __glXTexGenfvReqSize(const GLbyte * pc, Bool swap);
-extern PURE _X_HIDDEN int __glXTexGenivReqSize(const GLbyte * pc, Bool swap);
-extern PURE _X_HIDDEN int __glXMap1dReqSize(const GLbyte * pc, Bool swap);
-extern PURE _X_HIDDEN int __glXMap1fReqSize(const GLbyte * pc, Bool swap);
-extern PURE _X_HIDDEN int __glXMap2dReqSize(const GLbyte * pc, Bool swap);
-extern PURE _X_HIDDEN int __glXMap2fReqSize(const GLbyte * pc, Bool swap);
-extern PURE _X_HIDDEN int __glXPixelMapfvReqSize(const GLbyte * pc, Bool swap);
-extern PURE _X_HIDDEN int __glXPixelMapuivReqSize(const GLbyte * pc, Bool swap);
-extern PURE _X_HIDDEN int __glXPixelMapusvReqSize(const GLbyte * pc, Bool swap);
-extern PURE _X_HIDDEN int __glXDrawPixelsReqSize(const GLbyte * pc, Bool swap);
-extern PURE _X_HIDDEN int __glXDrawArraysReqSize(const GLbyte * pc, Bool swap);
+                                                     Bool swap, int reqlen);
+extern PURE _X_HIDDEN int __glXTexImage1DReqSize(const GLbyte * pc, Bool swap,
+                                                 int reqlen);
+extern PURE _X_HIDDEN int __glXTexImage2DReqSize(const GLbyte * pc, Bool swap,
+                                                 int reqlen);
+extern PURE _X_HIDDEN int __glXTexEnvfvReqSize(const GLbyte * pc, Bool swap,
+                                               int reqlen);
+extern PURE _X_HIDDEN int __glXTexEnvivReqSize(const GLbyte * pc, Bool swap,
+                                               int reqlen);
+extern PURE _X_HIDDEN int __glXTexGendvReqSize(const GLbyte * pc, Bool swap,
+                                               int reqlen);
+extern PURE _X_HIDDEN int __glXTexGenfvReqSize(const GLbyte * pc, Bool swap,
+                                               int reqlen);
+extern PURE _X_HIDDEN int __glXTexGenivReqSize(const GLbyte * pc, Bool swap,
+                                               int reqlen);
+extern PURE _X_HIDDEN int __glXMap1dReqSize(const GLbyte * pc, Bool swap,
+                                            int reqlen);
+extern PURE _X_HIDDEN int __glXMap1fReqSize(const GLbyte * pc, Bool swap,
+                                            int reqlen);
+extern PURE _X_HIDDEN int __glXMap2dReqSize(const GLbyte * pc, Bool swap,
+                                            int reqlen);
+extern PURE _X_HIDDEN int __glXMap2fReqSize(const GLbyte * pc, Bool swap,
+                                            int reqlen);
+extern PURE _X_HIDDEN int __glXPixelMapfvReqSize(const GLbyte * pc, Bool swap,
+                                                 int reqlen);
+extern PURE _X_HIDDEN int __glXPixelMapuivReqSize(const GLbyte * pc, Bool swap,
+                                                  int reqlen);
+extern PURE _X_HIDDEN int __glXPixelMapusvReqSize(const GLbyte * pc, Bool swap,
+                                                  int reqlen);
+extern PURE _X_HIDDEN int __glXDrawPixelsReqSize(const GLbyte * pc, Bool swap,
+                                                 int reqlen);
+extern PURE _X_HIDDEN int __glXDrawArraysReqSize(const GLbyte * pc, Bool swap,
+                                                 int reqlen);
 extern PURE _X_HIDDEN int __glXPrioritizeTexturesReqSize(const GLbyte * pc,
-                                                         Bool swap);
+                                                         Bool swap, int reqlen);
 extern PURE _X_HIDDEN int __glXTexSubImage1DReqSize(const GLbyte * pc,
-                                                    Bool swap);
+                                                    Bool swap, int reqlen);
 extern PURE _X_HIDDEN int __glXTexSubImage2DReqSize(const GLbyte * pc,
-                                                    Bool swap);
-extern PURE _X_HIDDEN int __glXColorTableReqSize(const GLbyte * pc, Bool swap);
+                                                    Bool swap, int reqlen);
+extern PURE _X_HIDDEN int __glXColorTableReqSize(const GLbyte * pc, Bool swap,
+                                                 int reqlen);
 extern PURE _X_HIDDEN int __glXColorTableParameterfvReqSize(const GLbyte * pc,
-                                                            Bool swap);
+                                                            Bool swap,
+                                                            int reqlen);
 extern PURE _X_HIDDEN int __glXColorTableParameterivReqSize(const GLbyte * pc,
-                                                            Bool swap);
+                                                            Bool swap,
+                                                            int reqlen);
 extern PURE _X_HIDDEN int __glXColorSubTableReqSize(const GLbyte * pc,
-                                                    Bool swap);
+                                                    Bool swap, int reqlen);
 extern PURE _X_HIDDEN int __glXConvolutionFilter1DReqSize(const GLbyte * pc,
-                                                          Bool swap);
+                                                          Bool swap,
+                                                          int reqlen);
 extern PURE _X_HIDDEN int __glXConvolutionFilter2DReqSize(const GLbyte * pc,
-                                                          Bool swap);
+                                                          Bool swap,
+                                                          int reqlen);
 extern PURE _X_HIDDEN int __glXConvolutionParameterfvReqSize(const GLbyte * pc,
-                                                             Bool swap);
+                                                             Bool swap,
+                                                             int reqlen);
 extern PURE _X_HIDDEN int __glXConvolutionParameterivReqSize(const GLbyte * pc,
-                                                             Bool swap);
+                                                             Bool swap,
+                                                             int reqlen);
 extern PURE _X_HIDDEN int __glXSeparableFilter2DReqSize(const GLbyte * pc,
-                                                        Bool swap);
-extern PURE _X_HIDDEN int __glXTexImage3DReqSize(const GLbyte * pc, Bool swap);
+                                                        Bool swap, int reqlen);
+extern PURE _X_HIDDEN int __glXTexImage3DReqSize(const GLbyte * pc, Bool swap,
+                                                 int reqlen);
 extern PURE _X_HIDDEN int __glXTexSubImage3DReqSize(const GLbyte * pc,
-                                                    Bool swap);
+                                                    Bool swap, int reqlen);
 extern PURE _X_HIDDEN int __glXCompressedTexImage1DARBReqSize(const GLbyte * pc,
-                                                              Bool swap);
+                                                              Bool swap,
+                                                              int reqlen);
 extern PURE _X_HIDDEN int __glXCompressedTexImage2DARBReqSize(const GLbyte * pc,
-                                                              Bool swap);
+                                                              Bool swap,
+                                                              int reqlen);
 extern PURE _X_HIDDEN int __glXCompressedTexImage3DARBReqSize(const GLbyte * pc,
-                                                              Bool swap);
+                                                              Bool swap,
+                                                              int reqlen);
 extern PURE _X_HIDDEN int __glXCompressedTexSubImage1DARBReqSize(const GLbyte *
-                                                                 pc, Bool swap);
+                                                                 pc, Bool swap,
+                                                                 int reqlen);
 extern PURE _X_HIDDEN int __glXCompressedTexSubImage2DARBReqSize(const GLbyte *
-                                                                 pc, Bool swap);
+                                                                 pc, Bool swap,
+                                                                 int reqlen);
 extern PURE _X_HIDDEN int __glXCompressedTexSubImage3DARBReqSize(const GLbyte *
-                                                                 pc, Bool swap);
+                                                                 pc, Bool swap,
+                                                                 int reqlen);
 extern PURE _X_HIDDEN int __glXProgramStringARBReqSize(const GLbyte * pc,
-                                                       Bool swap);
+                                                       Bool swap, int reqlen);
 extern PURE _X_HIDDEN int __glXDrawBuffersARBReqSize(const GLbyte * pc,
-                                                     Bool swap);
+                                                     Bool swap, int reqlen);
 extern PURE _X_HIDDEN int __glXPointParameterfvEXTReqSize(const GLbyte * pc,
-                                                          Bool swap);
+                                                          Bool swap,
+                                                          int reqlen);
 extern PURE _X_HIDDEN int __glXLoadProgramNVReqSize(const GLbyte * pc,
-                                                    Bool swap);
+                                                    Bool swap, int reqlen);
 extern PURE _X_HIDDEN int __glXProgramParameters4dvNVReqSize(const GLbyte * pc,
-                                                             Bool swap);
+                                                             Bool swap,
+                                                             int reqlen);
 extern PURE _X_HIDDEN int __glXProgramParameters4fvNVReqSize(const GLbyte * pc,
-                                                             Bool swap);
+                                                             Bool swap,
+                                                             int reqlen);
 extern PURE _X_HIDDEN int __glXRequestResidentProgramsNVReqSize(const GLbyte *
-                                                                pc, Bool swap);
+                                                                pc, Bool swap,
+                                                                int reqlen);
 extern PURE _X_HIDDEN int __glXVertexAttribs1dvNVReqSize(const GLbyte * pc,
-                                                         Bool swap);
+                                                         Bool swap, int reqlen);
 extern PURE _X_HIDDEN int __glXVertexAttribs1fvNVReqSize(const GLbyte * pc,
-                                                         Bool swap);
+                                                         Bool swap, int reqlen);
 extern PURE _X_HIDDEN int __glXVertexAttribs1svNVReqSize(const GLbyte * pc,
-                                                         Bool swap);
+                                                         Bool swap, int reqlen);
 extern PURE _X_HIDDEN int __glXVertexAttribs2dvNVReqSize(const GLbyte * pc,
-                                                         Bool swap);
+                                                         Bool swap, int reqlen);
 extern PURE _X_HIDDEN int __glXVertexAttribs2fvNVReqSize(const GLbyte * pc,
-                                                         Bool swap);
+                                                         Bool swap, int reqlen);
 extern PURE _X_HIDDEN int __glXVertexAttribs2svNVReqSize(const GLbyte * pc,
-                                                         Bool swap);
+                                                         Bool swap, int reqlen);
 extern PURE _X_HIDDEN int __glXVertexAttribs3dvNVReqSize(const GLbyte * pc,
-                                                         Bool swap);
+                                                         Bool swap, int reqlen);
 extern PURE _X_HIDDEN int __glXVertexAttribs3fvNVReqSize(const GLbyte * pc,
-                                                         Bool swap);
+                                                         Bool swap, int reqlen);
 extern PURE _X_HIDDEN int __glXVertexAttribs3svNVReqSize(const GLbyte * pc,
-                                                         Bool swap);
+                                                         Bool swap, int reqlen);
 extern PURE _X_HIDDEN int __glXVertexAttribs4dvNVReqSize(const GLbyte * pc,
-                                                         Bool swap);
+                                                         Bool swap, int reqlen);
 extern PURE _X_HIDDEN int __glXVertexAttribs4fvNVReqSize(const GLbyte * pc,
-                                                         Bool swap);
+                                                         Bool swap, int reqlen);
 extern PURE _X_HIDDEN int __glXVertexAttribs4svNVReqSize(const GLbyte * pc,
-                                                         Bool swap);
+                                                         Bool swap, int reqlen);
 extern PURE _X_HIDDEN int __glXVertexAttribs4ubvNVReqSize(const GLbyte * pc,
-                                                          Bool swap);
+                                                          Bool swap,
+                                                          int reqlen);
 extern PURE _X_HIDDEN int __glXPointParameterivNVReqSize(const GLbyte * pc,
-                                                         Bool swap);
+                                                         Bool swap, int reqlen);
 extern PURE _X_HIDDEN int __glXProgramNamedParameter4dvNVReqSize(const GLbyte *
-                                                                 pc, Bool swap);
+                                                                 pc, Bool swap,
+                                                                 int reqlen);
 extern PURE _X_HIDDEN int __glXProgramNamedParameter4fvNVReqSize(const GLbyte *
-                                                                 pc, Bool swap);
+                                                                 pc, Bool swap,
+                                                                 int reqlen);
 extern PURE _X_HIDDEN int __glXDeleteFramebuffersEXTReqSize(const GLbyte * pc,
-                                                            Bool swap);
+                                                            Bool swap,
+                                                            int reqlen);
 extern PURE _X_HIDDEN int __glXDeleteRenderbuffersEXTReqSize(const GLbyte * pc,
-                                                             Bool swap);
+                                                             Bool swap,
+                                                             int reqlen);
 
 #undef PURE
 
Index: xserver/glx/indirect_texture_compression.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/glx/indirect_texture_compression.c,v
retrieving revision 1.4
diff -u -p -u -r1.4 indirect_texture_compression.c
--- xserver/glx/indirect_texture_compression.c	7 Jun 2013 17:28:47 -0000	1.4
+++ xserver/glx/indirect_texture_compression.c	7 Dec 2014 12:31:42 -0000
@@ -47,6 +47,8 @@ __glXDisp_GetCompressedTexImageARB(struc
     __GLXcontext *const cx = __glXForceCurrent(cl, req->contextTag, &error);
     ClientPtr client = cl->client;
 
+    REQUEST_FIXED_SIZE(xGLXSingleReq, 8);
+
     pc += __GLX_SINGLE_HDR_SIZE;
     if (cx != NULL) {
         const GLenum target = *(GLenum *) (pc + 0);
@@ -92,6 +94,8 @@ __glXDispSwap_GetCompressedTexImageARB(s
     __GLXcontext *const cx =
         __glXForceCurrent(cl, bswap_32(req->contextTag), &error);
     ClientPtr client = cl->client;
+
+    REQUEST_FIXED_SIZE(xGLXSingleReq, 8);
 
     pc += __GLX_SINGLE_HDR_SIZE;
     if (cx != NULL) {
Index: xserver/glx/indirect_util.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/glx/indirect_util.c,v
retrieving revision 1.5
diff -u -p -u -r1.5 indirect_util.c
--- xserver/glx/indirect_util.c	7 Jun 2013 17:28:47 -0000	1.5
+++ xserver/glx/indirect_util.c	7 Dec 2014 12:31:42 -0000
@@ -78,11 +78,16 @@ __glXGetAnswerBuffer(__GLXclientState * 
                      void *local_buffer, size_t local_size, unsigned alignment)
 {
     void *buffer = local_buffer;
-    const unsigned mask = alignment - 1;
+    const intptr_t mask = alignment - 1;
 
     if (local_size < required_size) {
-        const size_t worst_case_size = required_size + alignment;
+        size_t worst_case_size;
         intptr_t temp_buf;
+
+        if (required_size < SIZE_MAX - alignment)
+            worst_case_size = required_size + alignment;
+        else
+            return NULL;
 
         if (cl->returnBufSize < worst_case_size) {
             void *temp = realloc(cl->returnBuf, worst_case_size);
Index: xserver/glx/rensize.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/glx/rensize.c,v
retrieving revision 1.4
diff -u -p -u -r1.4 rensize.c
--- xserver/glx/rensize.c	10 Jun 2012 13:21:22 -0000	1.4
+++ xserver/glx/rensize.c	7 Dec 2014 12:31:42 -0000
@@ -43,19 +43,11 @@
   (((a & 0xff000000U)>>24) | ((a & 0xff0000U)>>8) | \
    ((a & 0xff00U)<<8) | ((a & 0xffU)<<24))
 
-static int
-Map1Size(GLint k, GLint order)
-{
-    if (order <= 0 || k < 0)
-        return -1;
-    return k * order;
-}
-
 int
-__glXMap1dReqSize(const GLbyte * pc, Bool swap)
+__glXMap1dReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLenum target;
-    GLint order, k;
+    GLint order;
 
     target = *(GLenum *) (pc + 16);
     order = *(GLint *) (pc + 20);
@@ -63,15 +55,16 @@ __glXMap1dReqSize(const GLbyte * pc, Boo
         target = SWAPL(target);
         order = SWAPL(order);
     }
-    k = __glMap1d_size(target);
-    return 8 * Map1Size(k, order);
+    if (order < 1)
+        return -1;
+    return safe_mul(8, safe_mul(__glMap1d_size(target), order));
 }
 
 int
-__glXMap1fReqSize(const GLbyte * pc, Bool swap)
+__glXMap1fReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLenum target;
-    GLint order, k;
+    GLint order;
 
     target = *(GLenum *) (pc + 0);
     order = *(GLint *) (pc + 12);
@@ -79,23 +72,24 @@ __glXMap1fReqSize(const GLbyte * pc, Boo
         target = SWAPL(target);
         order = SWAPL(order);
     }
-    k = __glMap1f_size(target);
-    return 4 * Map1Size(k, order);
+    if (order < 1)
+        return -1;
+    return safe_mul(4, safe_mul(__glMap1f_size(target), order));
 }
 
 static int
 Map2Size(int k, int majorOrder, int minorOrder)
 {
-    if (majorOrder <= 0 || minorOrder <= 0 || k < 0)
+    if (majorOrder < 1 || minorOrder < 1)
         return -1;
-    return k * majorOrder * minorOrder;
+    return safe_mul(k, safe_mul(majorOrder, minorOrder));
 }
 
 int
-__glXMap2dReqSize(const GLbyte * pc, Bool swap)
+__glXMap2dReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLenum target;
-    GLint uorder, vorder, k;
+    GLint uorder, vorder;
 
     target = *(GLenum *) (pc + 32);
     uorder = *(GLint *) (pc + 36);
@@ -105,15 +99,14 @@ __glXMap2dReqSize(const GLbyte * pc, Boo
         uorder = SWAPL(uorder);
         vorder = SWAPL(vorder);
     }
-    k = __glMap2d_size(target);
-    return 8 * Map2Size(k, uorder, vorder);
+    return safe_mul(8, Map2Size(__glMap2d_size(target), uorder, vorder));
 }
 
 int
-__glXMap2fReqSize(const GLbyte * pc, Bool swap)
+__glXMap2fReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     GLenum target;
-    GLint uorder, vorder, k;
+    GLint uorder, vorder;
 
     target = *(GLenum *) (pc + 0);
     uorder = *(GLint *) (pc + 12);
@@ -123,8 +116,7 @@ __glXMap2fReqSize(const GLbyte * pc, Boo
         uorder = SWAPL(uorder);
         vorder = SWAPL(vorder);
     }
-    k = __glMap2f_size(target);
-    return 4 * Map2Size(k, uorder, vorder);
+    return safe_mul(4, Map2Size(__glMap2f_size(target), uorder, vorder));
 }
 
 /**
@@ -175,14 +167,16 @@ __glXImageSize(GLenum format, GLenum typ
     GLint bytesPerElement, elementsPerGroup, groupsPerRow;
     GLint groupSize, rowSize, padding, imageSize;
 
+    if (w == 0 || h == 0 || d == 0)
+        return 0;
+
     if (w < 0 || h < 0 || d < 0 ||
         (type == GL_BITMAP &&
          (format != GL_COLOR_INDEX && format != GL_STENCIL_INDEX))) {
         return -1;
     }
-    if (w == 0 || h == 0 || d == 0)
-        return 0;
 
+    /* proxy targets have no data */
     switch (target) {
     case GL_PROXY_TEXTURE_1D:
     case GL_PROXY_TEXTURE_2D:
@@ -199,6 +193,12 @@ __glXImageSize(GLenum format, GLenum typ
         return 0;
     }
 
+    /* real data has to have real sizes */
+    if (imageHeight < 0 || rowLength < 0 || skipImages < 0 || skipRows < 0)
+        return -1;
+    if (alignment != 1 && alignment != 2 && alignment != 4 && alignment != 8)
+        return -1;
+
     if (type == GL_BITMAP) {
         if (rowLength > 0) {
             groupsPerRow = rowLength;
@@ -207,11 +207,14 @@ __glXImageSize(GLenum format, GLenum typ
             groupsPerRow = w;
         }
         rowSize = bits_to_bytes(groupsPerRow);
+        if (rowSize < 0)
+            return -1;
         padding = (rowSize % alignment);
         if (padding) {
             rowSize += alignment - padding;
         }
-        return ((h + skipRows) * rowSize);
+
+        return safe_mul(safe_add(h, skipRows), rowSize);
     }
     else {
         switch (format) {
@@ -224,6 +227,11 @@ __glXImageSize(GLenum format, GLenum typ
         case GL_ALPHA:
         case GL_LUMINANCE:
         case GL_INTENSITY:
+        case GL_RED_INTEGER_EXT:
+        case GL_GREEN_INTEGER_EXT:
+        case GL_BLUE_INTEGER_EXT:
+        case GL_ALPHA_INTEGER_EXT:
+        case GL_LUMINANCE_INTEGER_EXT:
             elementsPerGroup = 1;
             break;
         case GL_422_EXT:
@@ -234,14 +242,19 @@ __glXImageSize(GLenum format, GLenum typ
         case GL_DEPTH_STENCIL_MESA:
         case GL_YCBCR_MESA:
         case GL_LUMINANCE_ALPHA:
+        case GL_LUMINANCE_ALPHA_INTEGER_EXT:
             elementsPerGroup = 2;
             break;
         case GL_RGB:
         case GL_BGR:
+        case GL_RGB_INTEGER_EXT:
+        case GL_BGR_INTEGER_EXT:
             elementsPerGroup = 3;
             break;
         case GL_RGBA:
         case GL_BGRA:
+        case GL_RGBA_INTEGER_EXT:
+        case GL_BGRA_INTEGER_EXT:
         case GL_ABGR_EXT:
             elementsPerGroup = 4;
             break;
@@ -293,6 +306,7 @@ __glXImageSize(GLenum format, GLenum typ
         default:
             return -1;
         }
+        /* known safe by the switches above, not checked */
         groupSize = bytesPerElement * elementsPerGroup;
         if (rowLength > 0) {
             groupsPerRow = rowLength;
@@ -300,18 +314,21 @@ __glXImageSize(GLenum format, GLenum typ
         else {
             groupsPerRow = w;
         }
-        rowSize = groupsPerRow * groupSize;
+
+        if ((rowSize = safe_mul(groupsPerRow, groupSize)) < 0)
+            return -1;
         padding = (rowSize % alignment);
         if (padding) {
             rowSize += alignment - padding;
         }
-        if (imageHeight > 0) {
-            imageSize = (imageHeight + skipRows) * rowSize;
-        }
-        else {
-            imageSize = (h + skipRows) * rowSize;
-        }
-        return ((d + skipImages) * imageSize);
+
+        if (imageHeight > 0)
+            h = imageHeight;
+        h = safe_add(h, skipRows);
+
+        imageSize = safe_mul(h, rowSize);
+
+        return safe_mul(safe_add(d, skipImages), imageSize);
     }
 }
 
@@ -342,13 +359,14 @@ __glXTypeSize(GLenum enm)
 }
 
 int
-__glXDrawArraysReqSize(const GLbyte * pc, Bool swap)
+__glXDrawArraysReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     __GLXdispatchDrawArraysHeader *hdr = (__GLXdispatchDrawArraysHeader *) pc;
     __GLXdispatchDrawArraysComponentHeader *compHeader;
     GLint numVertexes = hdr->numVertexes;
     GLint numComponents = hdr->numComponents;
     GLint arrayElementSize = 0;
+    GLint x, size;
     int i;
 
     if (swap) {
@@ -357,6 +375,13 @@ __glXDrawArraysReqSize(const GLbyte * pc
     }
 
     pc += sizeof(__GLXdispatchDrawArraysHeader);
+    reqlen -= sizeof(__GLXdispatchDrawArraysHeader);
+
+    size = safe_mul(sizeof(__GLXdispatchDrawArraysComponentHeader),
+                    numComponents);
+    if (size < 0 || reqlen < 0 || reqlen < size)
+        return -1;
+
     compHeader = (__GLXdispatchDrawArraysComponentHeader *) pc;
 
     for (i = 0; i < numComponents; i++) {
@@ -400,17 +425,18 @@ __glXDrawArraysReqSize(const GLbyte * pc
             return -1;
         }
 
-        arrayElementSize += __GLX_PAD(numVals * __glXTypeSize(datatype));
+        x = safe_pad(safe_mul(numVals, __glXTypeSize(datatype)));
+        if ((arrayElementSize = safe_add(arrayElementSize, x)) < 0)
+            return -1;
 
         pc += sizeof(__GLXdispatchDrawArraysComponentHeader);
     }
 
-    return ((numComponents * sizeof(__GLXdispatchDrawArraysComponentHeader)) +
-            (numVertexes * arrayElementSize));
+    return safe_add(size, safe_mul(numVertexes, arrayElementSize));
 }
 
 int
-__glXSeparableFilter2DReqSize(const GLbyte * pc, Bool swap)
+__glXSeparableFilter2DReqSize(const GLbyte * pc, Bool swap, int reqlen)
 {
     __GLXdispatchConvolutionFilterHeader *hdr =
         (__GLXdispatchConvolutionFilterHeader *) pc;
@@ -435,9 +461,7 @@ __glXSeparableFilter2DReqSize(const GLby
     /* XXX Should rowLength be used for either or both image? */
     image1size = __glXImageSize(format, type, 0, w, 1, 1,
                                 0, rowLength, 0, 0, alignment);
-    image1size = __GLX_PAD(image1size);
     image2size = __glXImageSize(format, type, 0, h, 1, 1,
                                 0, rowLength, 0, 0, alignment);
-    return image1size + image2size;
-
+    return safe_add(safe_pad(image1size), image2size);
 }
Index: xserver/glx/single2.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/glx/single2.c,v
retrieving revision 1.7
diff -u -p -u -r1.7 single2.c
--- xserver/glx/single2.c	7 Jun 2013 17:28:47 -0000	1.7
+++ xserver/glx/single2.c	7 Dec 2014 14:28:31 -0000
@@ -49,11 +49,14 @@
 int
 __glXDisp_FeedbackBuffer(__GLXclientState * cl, GLbyte * pc)
 {
+    ClientPtr client = cl->client;
     GLsizei size;
     GLenum type;
     __GLXcontext *cx;
     int error;
 
+    REQUEST_FIXED_SIZE(xGLXSingleReq, 8);
+
     cx = __glXForceCurrent(cl, __GLX_GET_SINGLE_CONTEXT_TAG(pc), &error);
     if (!cx) {
         return error;
@@ -80,10 +83,13 @@ __glXDisp_FeedbackBuffer(__GLXclientStat
 int
 __glXDisp_SelectBuffer(__GLXclientState * cl, GLbyte * pc)
 {
+    ClientPtr client = cl->client;
     __GLXcontext *cx;
     GLsizei size;
     int error;
 
+    REQUEST_FIXED_SIZE(xGLXSingleReq, 4);
+
     cx = __glXForceCurrent(cl, __GLX_GET_SINGLE_CONTEXT_TAG(pc), &error);
     if (!cx) {
         return error;
@@ -108,7 +114,7 @@ __glXDisp_SelectBuffer(__GLXclientState 
 int
 __glXDisp_RenderMode(__GLXclientState * cl, GLbyte * pc)
 {
-    ClientPtr client;
+    ClientPtr client = cl->client;
     xGLXRenderModeReply reply;
     __GLXcontext *cx;
     GLint nitems = 0, retBytes = 0, retval, newModeCheck;
@@ -116,6 +122,8 @@ __glXDisp_RenderMode(__GLXclientState * 
     GLenum newMode;
     int error;
 
+    REQUEST_FIXED_SIZE(xGLXSingleReq, 4);
+
     cx = __glXForceCurrent(cl, __GLX_GET_SINGLE_CONTEXT_TAG(pc), &error);
     if (!cx) {
         return error;
@@ -192,7 +200,6 @@ __glXDisp_RenderMode(__GLXclientState * 
      ** selection array, as per the API for glRenderMode itself.
      */
  noChangeAllowed:;
-    client = cl->client;
     reply = (xGLXRenderModeReply) {
         .type = X_Reply,
         .sequenceNumber = client->sequence,
@@ -211,9 +218,12 @@ __glXDisp_RenderMode(__GLXclientState * 
 int
 __glXDisp_Flush(__GLXclientState * cl, GLbyte * pc)
 {
+    ClientPtr client = cl->client;
     __GLXcontext *cx;
     int error;
 
+    REQUEST_SIZE_MATCH(xGLXSingleReq);
+
     cx = __glXForceCurrent(cl, __GLX_GET_SINGLE_CONTEXT_TAG(pc), &error);
     if (!cx) {
         return error;
@@ -227,10 +237,12 @@ __glXDisp_Flush(__GLXclientState * cl, G
 int
 __glXDisp_Finish(__GLXclientState * cl, GLbyte * pc)
 {
+    ClientPtr client = cl->client;
     __GLXcontext *cx;
-    ClientPtr client;
     int error;
 
+    REQUEST_SIZE_MATCH(xGLXSingleReq);
+
     cx = __glXForceCurrent(cl, __GLX_GET_SINGLE_CONTEXT_TAG(pc), &error);
     if (!cx) {
         return error;
@@ -321,7 +333,7 @@ __glXcombine_strings(const char *cext_st
 int
 DoGetString(__GLXclientState * cl, GLbyte * pc, GLboolean need_swap)
 {
-    ClientPtr client;
+    ClientPtr client = cl->client;
     __GLXcontext *cx;
     GLenum name;
     const char *string;
@@ -331,6 +343,8 @@ DoGetString(__GLXclientState * cl, GLbyt
     char *buf = NULL, *buf1 = NULL;
     GLint length = 0;
 
+    REQUEST_FIXED_SIZE(xGLXSingleReq, 4);
+
     /* If the client has the opposite byte order, swap the contextTag and
      * the name.
      */
@@ -347,7 +361,6 @@ DoGetString(__GLXclientState * cl, GLbyt
     pc += __GLX_SINGLE_HDR_SIZE;
     name = *(GLenum *) (pc + 0);
     string = (const char *) CALL_GetString(GET_DISPATCH(), (name));
-    client = cl->client;
 
     if (string == NULL)
         string = "";
Index: xserver/glx/single2swap.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/glx/single2swap.c,v
retrieving revision 1.7
diff -u -p -u -r1.7 single2swap.c
--- xserver/glx/single2swap.c	7 Jun 2013 17:28:48 -0000	1.7
+++ xserver/glx/single2swap.c	7 Dec 2014 12:31:42 -0000
@@ -45,6 +45,7 @@
 int
 __glXDispSwap_FeedbackBuffer(__GLXclientState * cl, GLbyte * pc)
 {
+    ClientPtr client = cl->client;
     GLsizei size;
     GLenum type;
 
@@ -52,6 +53,8 @@ __glXDispSwap_FeedbackBuffer(__GLXclient
     __GLXcontext *cx;
     int error;
 
+    REQUEST_FIXED_SIZE(xGLXSingleReq, 8);
+
     __GLX_SWAP_INT(&((xGLXSingleReq *) pc)->contextTag);
     cx = __glXForceCurrent(cl, __GLX_GET_SINGLE_CONTEXT_TAG(pc), &error);
     if (!cx) {
@@ -81,12 +84,15 @@ __glXDispSwap_FeedbackBuffer(__GLXclient
 int
 __glXDispSwap_SelectBuffer(__GLXclientState * cl, GLbyte * pc)
 {
+    ClientPtr client = cl->client;
     __GLXcontext *cx;
     GLsizei size;
 
     __GLX_DECLARE_SWAP_VARIABLES;
     int error;
 
+    REQUEST_FIXED_SIZE(xGLXSingleReq, 4);
+
     __GLX_SWAP_INT(&((xGLXSingleReq *) pc)->contextTag);
     cx = __glXForceCurrent(cl, __GLX_GET_SINGLE_CONTEXT_TAG(pc), &error);
     if (!cx) {
@@ -113,7 +119,7 @@ __glXDispSwap_SelectBuffer(__GLXclientSt
 int
 __glXDispSwap_RenderMode(__GLXclientState * cl, GLbyte * pc)
 {
-    ClientPtr client;
+    ClientPtr client = cl->client;
     __GLXcontext *cx;
     xGLXRenderModeReply reply;
     GLint nitems = 0, retBytes = 0, retval, newModeCheck;
@@ -124,6 +130,8 @@ __glXDispSwap_RenderMode(__GLXclientStat
     __GLX_DECLARE_SWAP_ARRAY_VARIABLES;
     int error;
 
+    REQUEST_FIXED_SIZE(xGLXSingleReq, 4);
+
     __GLX_SWAP_INT(&((xGLXSingleReq *) pc)->contextTag);
     cx = __glXForceCurrent(cl, __GLX_GET_SINGLE_CONTEXT_TAG(pc), &error);
     if (!cx) {
@@ -204,7 +212,6 @@ __glXDispSwap_RenderMode(__GLXclientStat
      ** selection array, as per the API for glRenderMode itself.
      */
  noChangeAllowed:;
-    client = cl->client;
     reply = (xGLXRenderModeReply) {
         .type = X_Reply,
         .sequenceNumber = client->sequence,
@@ -228,11 +235,14 @@ __glXDispSwap_RenderMode(__GLXclientStat
 int
 __glXDispSwap_Flush(__GLXclientState * cl, GLbyte * pc)
 {
+    ClientPtr client = cl->client;
     __GLXcontext *cx;
     int error;
 
     __GLX_DECLARE_SWAP_VARIABLES;
 
+    REQUEST_SIZE_MATCH(xGLXSingleReq);
+
     __GLX_SWAP_INT(&((xGLXSingleReq *) pc)->contextTag);
     cx = __glXForceCurrent(cl, __GLX_GET_SINGLE_CONTEXT_TAG(pc), &error);
     if (!cx) {
@@ -247,12 +257,14 @@ __glXDispSwap_Flush(__GLXclientState * c
 int
 __glXDispSwap_Finish(__GLXclientState * cl, GLbyte * pc)
 {
+    ClientPtr client = cl->client;
     __GLXcontext *cx;
-    ClientPtr client;
     int error;
 
     __GLX_DECLARE_SWAP_VARIABLES;
 
+    REQUEST_SIZE_MATCH(xGLXSingleReq);
+
     __GLX_SWAP_INT(&((xGLXSingleReq *) pc)->contextTag);
     cx = __glXForceCurrent(cl, __GLX_GET_SINGLE_CONTEXT_TAG(pc), &error);
     if (!cx) {
@@ -264,7 +276,6 @@ __glXDispSwap_Finish(__GLXclientState * 
     cx->hasUnflushedCommands = GL_FALSE;
 
     /* Send empty reply packet to indicate finish is finished */
-    client = cl->client;
     __GLX_BEGIN_REPLY(0);
     __GLX_PUT_RETVAL(0);
     __GLX_SWAP_REPLY_HEADER();
Index: xserver/glx/singlepix.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/glx/singlepix.c,v
retrieving revision 1.6
diff -u -p -u -r1.6 singlepix.c
--- xserver/glx/singlepix.c	7 Jun 2013 17:28:48 -0000	1.6
+++ xserver/glx/singlepix.c	7 Dec 2014 14:51:51 -0000
@@ -55,6 +55,8 @@ __glXDisp_ReadPixels(__GLXclientState * 
     int error;
     char *answer, answerBuffer[200];
 
+    REQUEST_FIXED_SIZE(xGLXSingleReq, 28);
+
     cx = __glXForceCurrent(cl, __GLX_GET_SINGLE_CONTEXT_TAG(pc), &error);
     if (!cx) {
         return error;
@@ -107,6 +109,8 @@ __glXDisp_GetTexImage(__GLXclientState *
     char *answer, answerBuffer[200];
     GLint width = 0, height = 0, depth = 1;
 
+    REQUEST_FIXED_SIZE(xGLXSingleReq, 20);
+
     cx = __glXForceCurrent(cl, __GLX_GET_SINGLE_CONTEXT_TAG(pc), &error);
     if (!cx) {
         return error;
@@ -169,6 +173,8 @@ __glXDisp_GetPolygonStipple(__GLXclientS
     GLubyte answerBuffer[200];
     char *answer;
 
+    REQUEST_FIXED_SIZE(xGLXSingleReq, 4);
+
     cx = __glXForceCurrent(cl, __GLX_GET_SINGLE_CONTEXT_TAG(pc), &error);
     if (!cx) {
         return error;
@@ -231,15 +237,13 @@ GetSeparableFilter(__GLXclientState * cl
     compsize = __glGetTexImage_size(target, 1, format, type, width, 1, 1);
     compsize2 = __glGetTexImage_size(target, 1, format, type, height, 1, 1);
 
-    if (compsize < 0)
+    if ((compsize = safe_pad(compsize)) < 0)
         compsize = 0;
-    if (compsize2 < 0)
+    if ((compsize2 = safe_pad(compsize2)) < 0)
         compsize2 = 0;
-    compsize = __GLX_PAD(compsize);
-    compsize2 = __GLX_PAD(compsize2);
 
     CALL_PixelStorei(GET_DISPATCH(), (GL_PACK_SWAP_BYTES, swapBytes));
-    __GLX_GET_ANSWER_BUFFER(answer, cl, compsize + compsize2, 1);
+    __GLX_GET_ANSWER_BUFFER(answer, cl, safe_add(compsize, compsize2), 1);
     __glXClearErrorOccured();
     CALL_GetSeparableFilter(GET_DISPATCH(), (*(GLenum *) (pc + 0),
                                              *(GLenum *) (pc + 4),
@@ -265,7 +269,8 @@ int
 __glXDisp_GetSeparableFilter(__GLXclientState * cl, GLbyte * pc)
 {
     const GLXContextTag tag = __GLX_GET_SINGLE_CONTEXT_TAG(pc);
-
+    ClientPtr client = cl->client;
+    REQUEST_FIXED_SIZE(xGLXSingleReq, 16);
     return GetSeparableFilter(cl, pc + __GLX_SINGLE_HDR_SIZE, tag);
 }
 
@@ -273,7 +278,8 @@ int
 __glXDisp_GetSeparableFilterEXT(__GLXclientState * cl, GLbyte * pc)
 {
     const GLXContextTag tag = __GLX_GET_VENDPRIV_CONTEXT_TAG(pc);
-
+    ClientPtr client = cl->client;
+    REQUEST_FIXED_SIZE(xGLXVendorPrivateReq, 16);
     return GetSeparableFilter(cl, pc + __GLX_VENDPRIV_HDR_SIZE, tag);
 }
 
@@ -343,7 +349,8 @@ int
 __glXDisp_GetConvolutionFilter(__GLXclientState * cl, GLbyte * pc)
 {
     const GLXContextTag tag = __GLX_GET_SINGLE_CONTEXT_TAG(pc);
-
+    ClientPtr client = cl->client;
+    REQUEST_FIXED_SIZE(xGLXSingleReq, 16);
     return GetConvolutionFilter(cl, pc + __GLX_SINGLE_HDR_SIZE, tag);
 }
 
@@ -351,7 +358,8 @@ int
 __glXDisp_GetConvolutionFilterEXT(__GLXclientState * cl, GLbyte * pc)
 {
     const GLXContextTag tag = __GLX_GET_VENDPRIV_CONTEXT_TAG(pc);
-
+    ClientPtr client = cl->client;
+    REQUEST_FIXED_SIZE(xGLXVendorPrivateReq, 16);
     return GetConvolutionFilter(cl, pc + __GLX_VENDPRIV_HDR_SIZE, tag);
 }
 
@@ -411,7 +419,8 @@ int
 __glXDisp_GetHistogram(__GLXclientState * cl, GLbyte * pc)
 {
     const GLXContextTag tag = __GLX_GET_SINGLE_CONTEXT_TAG(pc);
-
+    ClientPtr client = cl->client;
+    REQUEST_FIXED_SIZE(xGLXSingleReq, 16);
     return GetHistogram(cl, pc + __GLX_SINGLE_HDR_SIZE, tag);
 }
 
@@ -419,7 +428,8 @@ int
 __glXDisp_GetHistogramEXT(__GLXclientState * cl, GLbyte * pc)
 {
     const GLXContextTag tag = __GLX_GET_VENDPRIV_CONTEXT_TAG(pc);
-
+    ClientPtr client = cl->client;
+    REQUEST_FIXED_SIZE(xGLXVendorPrivateReq, 16);
     return GetHistogram(cl, pc + __GLX_VENDPRIV_HDR_SIZE, tag);
 }
 
@@ -471,7 +481,8 @@ int
 __glXDisp_GetMinmax(__GLXclientState * cl, GLbyte * pc)
 {
     const GLXContextTag tag = __GLX_GET_SINGLE_CONTEXT_TAG(pc);
-
+    ClientPtr client = cl->client;
+    REQUEST_FIXED_SIZE(xGLXSingleReq, 16);
     return GetMinmax(cl, pc + __GLX_SINGLE_HDR_SIZE, tag);
 }
 
@@ -479,7 +490,8 @@ int
 __glXDisp_GetMinmaxEXT(__GLXclientState * cl, GLbyte * pc)
 {
     const GLXContextTag tag = __GLX_GET_VENDPRIV_CONTEXT_TAG(pc);
-
+    ClientPtr client = cl->client;
+    REQUEST_FIXED_SIZE(xGLXVendorPrivateReq, 16);
     return GetMinmax(cl, pc + __GLX_VENDPRIV_HDR_SIZE, tag);
 }
 
@@ -540,7 +552,8 @@ int
 __glXDisp_GetColorTable(__GLXclientState * cl, GLbyte * pc)
 {
     const GLXContextTag tag = __GLX_GET_SINGLE_CONTEXT_TAG(pc);
-
+    ClientPtr client = cl->client;
+    REQUEST_FIXED_SIZE(xGLXSingleReq, 16);
     return GetColorTable(cl, pc + __GLX_SINGLE_HDR_SIZE, tag);
 }
 
@@ -548,6 +561,7 @@ int
 __glXDisp_GetColorTableSGI(__GLXclientState * cl, GLbyte * pc)
 {
     const GLXContextTag tag = __GLX_GET_VENDPRIV_CONTEXT_TAG(pc);
-
+    ClientPtr client = cl->client;
+    REQUEST_FIXED_SIZE(xGLXVendorPrivateReq, 16);
     return GetColorTable(cl, pc + __GLX_VENDPRIV_HDR_SIZE, tag);
 }
Index: xserver/glx/singlepixswap.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/glx/singlepixswap.c,v
retrieving revision 1.6
diff -u -p -u -r1.6 singlepixswap.c
--- xserver/glx/singlepixswap.c	7 Jun 2013 17:28:48 -0000	1.6
+++ xserver/glx/singlepixswap.c	7 Dec 2014 14:25:40 -0000
@@ -57,6 +57,8 @@ __glXDispSwap_ReadPixels(__GLXclientStat
     int error;
     char *answer, answerBuffer[200];
 
+    REQUEST_FIXED_SIZE(xGLXSingleReq, 28);
+
     __GLX_SWAP_INT(&((xGLXSingleReq *) pc)->contextTag);
     cx = __glXForceCurrent(cl, __GLX_GET_SINGLE_CONTEXT_TAG(pc), &error);
     if (!cx) {
@@ -122,6 +124,8 @@ __glXDispSwap_GetTexImage(__GLXclientSta
     char *answer, answerBuffer[200];
     GLint width = 0, height = 0, depth = 1;
 
+    REQUEST_FIXED_SIZE(xGLXSingleReq, 20);
+
     __GLX_SWAP_INT(&((xGLXSingleReq *) pc)->contextTag);
     cx = __glXForceCurrent(cl, __GLX_GET_SINGLE_CONTEXT_TAG(pc), &error);
     if (!cx) {
@@ -197,6 +201,8 @@ __glXDispSwap_GetPolygonStipple(__GLXcli
 
     __GLX_DECLARE_SWAP_VARIABLES;
 
+    REQUEST_FIXED_SIZE(xGLXSingleReq, 4);
+
     __GLX_SWAP_INT(&((xGLXSingleReq *) pc)->contextTag);
     cx = __glXForceCurrent(cl, __GLX_GET_SINGLE_CONTEXT_TAG(pc), &error);
     if (!cx) {
@@ -266,15 +272,13 @@ GetSeparableFilter(__GLXclientState * cl
     compsize = __glGetTexImage_size(target, 1, format, type, width, 1, 1);
     compsize2 = __glGetTexImage_size(target, 1, format, type, height, 1, 1);
 
-    if (compsize < 0)
+    if ((compsize = safe_pad(compsize)) < 0)
         compsize = 0;
-    if (compsize2 < 0)
+    if ((compsize2 = safe_pad(compsize2)) < 0)
         compsize2 = 0;
-    compsize = __GLX_PAD(compsize);
-    compsize2 = __GLX_PAD(compsize2);
 
     CALL_PixelStorei(GET_DISPATCH(), (GL_PACK_SWAP_BYTES, !swapBytes));
-    __GLX_GET_ANSWER_BUFFER(answer, cl, compsize + compsize2, 1);
+    __GLX_GET_ANSWER_BUFFER(answer, cl, safe_add(compsize, compsize2), 1);
     __glXClearErrorOccured();
     CALL_GetSeparableFilter(GET_DISPATCH(), (*(GLenum *) (pc + 0),
                                              *(GLenum *) (pc + 4),
@@ -302,7 +306,9 @@ int
 __glXDispSwap_GetSeparableFilter(__GLXclientState * cl, GLbyte * pc)
 {
     const GLXContextTag tag = __GLX_GET_SINGLE_CONTEXT_TAG(pc);
+    ClientPtr client = cl->client;
 
+    REQUEST_FIXED_SIZE(xGLXSingleReq, 16);
     return GetSeparableFilter(cl, pc + __GLX_SINGLE_HDR_SIZE, tag);
 }
 
@@ -310,7 +316,9 @@ int
 __glXDispSwap_GetSeparableFilterEXT(__GLXclientState * cl, GLbyte * pc)
 {
     const GLXContextTag tag = __GLX_GET_VENDPRIV_CONTEXT_TAG(pc);
+    ClientPtr client = cl->client;
 
+    REQUEST_FIXED_SIZE(xGLXVendorPrivateReq, 16);
     return GetSeparableFilter(cl, pc + __GLX_VENDPRIV_HDR_SIZE, tag);
 }
 
@@ -388,7 +396,9 @@ int
 __glXDispSwap_GetConvolutionFilter(__GLXclientState * cl, GLbyte * pc)
 {
     const GLXContextTag tag = __GLX_GET_SINGLE_CONTEXT_TAG(pc);
+    ClientPtr client = cl->client;
 
+    REQUEST_FIXED_SIZE(xGLXSingleReq, 16);
     return GetConvolutionFilter(cl, pc + __GLX_SINGLE_HDR_SIZE, tag);
 }
 
@@ -396,7 +406,9 @@ int
 __glXDispSwap_GetConvolutionFilterEXT(__GLXclientState * cl, GLbyte * pc)
 {
     const GLXContextTag tag = __GLX_GET_VENDPRIV_CONTEXT_TAG(pc);
+    ClientPtr client = cl->client;
 
+    REQUEST_FIXED_SIZE(xGLXVendorPrivateReq, 16);
     return GetConvolutionFilter(cl, pc + __GLX_VENDPRIV_HDR_SIZE, tag);
 }
 
@@ -463,7 +475,9 @@ int
 __glXDispSwap_GetHistogram(__GLXclientState * cl, GLbyte * pc)
 {
     const GLXContextTag tag = __GLX_GET_SINGLE_CONTEXT_TAG(pc);
+    ClientPtr client = cl->client;
 
+    REQUEST_FIXED_SIZE(xGLXSingleReq, 16);
     return GetHistogram(cl, pc + __GLX_SINGLE_HDR_SIZE, tag);
 }
 
@@ -471,7 +485,9 @@ int
 __glXDispSwap_GetHistogramEXT(__GLXclientState * cl, GLbyte * pc)
 {
     const GLXContextTag tag = __GLX_GET_VENDPRIV_CONTEXT_TAG(pc);
+    ClientPtr client = cl->client;
 
+    REQUEST_FIXED_SIZE(xGLXVendorPrivateReq, 16);
     return GetHistogram(cl, pc + __GLX_VENDPRIV_HDR_SIZE, tag);
 }
 
@@ -529,7 +545,9 @@ int
 __glXDispSwap_GetMinmax(__GLXclientState * cl, GLbyte * pc)
 {
     const GLXContextTag tag = __GLX_GET_SINGLE_CONTEXT_TAG(pc);
+    ClientPtr client = cl->client;
 
+    REQUEST_FIXED_SIZE(xGLXSingleReq, 16);
     return GetMinmax(cl, pc + __GLX_SINGLE_HDR_SIZE, tag);
 }
 
@@ -537,7 +555,9 @@ int
 __glXDispSwap_GetMinmaxEXT(__GLXclientState * cl, GLbyte * pc)
 {
     const GLXContextTag tag = __GLX_GET_VENDPRIV_CONTEXT_TAG(pc);
+    ClientPtr client = cl->client;
 
+    REQUEST_FIXED_SIZE(xGLXVendorPrivateReq, 16);
     return GetMinmax(cl, pc + __GLX_VENDPRIV_HDR_SIZE, tag);
 }
 
@@ -605,7 +625,9 @@ int
 __glXDispSwap_GetColorTable(__GLXclientState * cl, GLbyte * pc)
 {
     const GLXContextTag tag = __GLX_GET_SINGLE_CONTEXT_TAG(pc);
+    ClientPtr client = cl->client;
 
+    REQUEST_FIXED_SIZE(xGLXSingleReq, 16);
     return GetColorTable(cl, pc + __GLX_SINGLE_HDR_SIZE, tag);
 }
 
@@ -613,6 +635,8 @@ int
 __glXDispSwap_GetColorTableSGI(__GLXclientState * cl, GLbyte * pc)
 {
     const GLXContextTag tag = __GLX_GET_VENDPRIV_CONTEXT_TAG(pc);
+    ClientPtr client = cl->client;
 
+    REQUEST_FIXED_SIZE(xGLXVendorPrivateReq, 16);
     return GetColorTable(cl, pc + __GLX_VENDPRIV_HDR_SIZE, tag);
 }
Index: xserver/glx/swap_interval.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/glx/swap_interval.c,v
retrieving revision 1.3
diff -u -p -u -r1.3 swap_interval.c
--- xserver/glx/swap_interval.c	10 Jun 2012 13:21:22 -0000	1.3
+++ xserver/glx/swap_interval.c	7 Dec 2014 12:31:42 -0000
@@ -50,6 +50,8 @@ DoSwapInterval(__GLXclientState * cl, GL
     __GLXcontext *cx;
     GLint interval;
 
+    REQUEST_FIXED_SIZE(xGLXVendorPrivateReq, 4);
+
     cx = __glXLookupContextByTag(cl, tag);
 
     if ((cx == NULL) || (cx->pGlxScreen == NULL)) {
Index: xserver/glx/unpack.h
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/glx/unpack.h,v
retrieving revision 1.7
diff -u -p -u -r1.7 unpack.h
--- xserver/glx/unpack.h	7 Jun 2013 17:28:48 -0000	1.7
+++ xserver/glx/unpack.h	7 Dec 2014 12:31:42 -0000
@@ -83,7 +83,8 @@ extern xGLXSingleReply __glXReply;
 ** pointer.
 */
 #define __GLX_GET_ANSWER_BUFFER(res,cl,size,align)			 \
-    if ((size) > sizeof(answerBuffer)) {				 \
+    if (size < 0) return BadLength;                                      \
+    else if ((size) > sizeof(answerBuffer)) {				 \
 	int bump;							 \
 	if ((cl)->returnBufSize < (size)+(align)) {			 \
 	    (cl)->returnBuf = (GLbyte*)realloc((cl)->returnBuf,	 	 \
Index: xserver/hw/xfree86/dri2/dri2ext.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/hw/xfree86/dri2/dri2ext.c,v
retrieving revision 1.8
diff -u -p -u -r1.8 dri2ext.c
--- xserver/hw/xfree86/dri2/dri2ext.c	7 Jun 2013 17:28:51 -0000	1.8
+++ xserver/hw/xfree86/dri2/dri2ext.c	7 Dec 2014 12:31:42 -0000
@@ -270,6 +270,9 @@ ProcDRI2GetBuffers(ClientPtr client)
     unsigned int *attachments;
 
     REQUEST_FIXED_SIZE(xDRI2GetBuffersReq, stuff->count * 4);
+    if (stuff->count > (INT_MAX / 4))
+        return BadLength;
+
     if (!validDrawable(client, stuff->drawable, DixReadAccess | DixWriteAccess,
                        &pDrawable, &status))
         return status;
Index: xserver/include/dix.h
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/include/dix.h,v
retrieving revision 1.9
diff -u -p -u -r1.9 dix.h
--- xserver/include/dix.h	8 Dec 2013 10:53:01 -0000	1.9
+++ xserver/include/dix.h	7 Dec 2014 12:31:42 -0000
@@ -74,9 +74,14 @@ SOFTWARE.
     if ((sizeof(req) >> 2) > client->req_len )\
          return(BadLength)
 
+#define REQUEST_AT_LEAST_EXTRA_SIZE(req, extra)  \
+    if (((sizeof(req) + ((uint64_t) extra)) >> 2) > client->req_len ) \
+         return(BadLength)
+
 #define REQUEST_FIXED_SIZE(req, n)\
     if (((sizeof(req) >> 2) > client->req_len) || \
-        (((sizeof(req) + (n) + 3) >> 2) != client->req_len)) \
+        ((n >> 2) >= client->req_len) || \
+        ((((uint64_t) sizeof(req) + (n) + 3) >> 2) != (uint64_t) client->req_len))  \
          return(BadLength)
 
 #define LEGAL_NEW_RESOURCE(id,client)\
Index: xserver/include/regionstr.h
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/include/regionstr.h,v
retrieving revision 1.6
diff -u -p -u -r1.6 regionstr.h
--- xserver/include/regionstr.h	10 Jun 2012 13:21:30 -0000	1.6
+++ xserver/include/regionstr.h	7 Dec 2014 12:31:42 -0000
@@ -125,9 +125,12 @@ RegionEnd(RegionPtr reg)
 }
 
 static inline size_t
-RegionSizeof(int n)
+RegionSizeof(unsigned int n)
 {
-    return (sizeof(RegDataRec) + ((n) * sizeof(BoxRec)));
+    if (n < ((INT_MAX - sizeof(RegDataRec)) / sizeof(BoxRec)))
+        return (sizeof(RegDataRec) + ((n) * sizeof(BoxRec)));
+    else
+        return 0;
 }
 
 static inline void
@@ -138,9 +141,10 @@ RegionInit(RegionPtr _pReg, BoxPtr _rect
         (_pReg)->data = (RegDataPtr) NULL;
     }
     else {
+        size_t rgnSize;
         (_pReg)->extents = RegionEmptyBox;
-        if (((_size) > 1) && ((_pReg)->data =
-                              (RegDataPtr) malloc(RegionSizeof(_size)))) {
+        if (((_size) > 1) && ((rgnSize = RegionSizeof(_size)) > 0) &&
+            (((_pReg)->data = malloc(rgnSize)) != NULL)) {
             (_pReg)->data->size = (_size);
             (_pReg)->data->numRects = 0;
         }
Index: xserver/os/access.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/os/access.c,v
retrieving revision 1.11
diff -u -p -u -r1.11 access.c
--- xserver/os/access.c	7 Jun 2013 17:28:55 -0000	1.11
+++ xserver/os/access.c	7 Dec 2014 12:31:42 -0000
@@ -1323,6 +1323,10 @@ GetHosts(pointer *data, int *pnHosts, in
     for (host = validhosts; host; host = host->next) {
         nHosts++;
         n += pad_to_int32(host->len) + sizeof(xHostEntry);
+        /* Could check for INT_MAX, but in reality having more than 1mb of
+           hostnames in the access list is ridiculous */
+        if (n >= 1048576)
+            break;
     }
     if (n) {
         *data = ptr = malloc(n);
@@ -1331,6 +1335,8 @@ GetHosts(pointer *data, int *pnHosts, in
         }
         for (host = validhosts; host; host = host->next) {
             len = host->len;
+            if ((ptr + sizeof(xHostEntry) + len) > (data + n))
+                break;
             ((xHostEntry *) ptr)->family = host->family;
             ((xHostEntry *) ptr)->length = len;
             ptr += sizeof(xHostEntry);
Index: xserver/os/rpcauth.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/os/rpcauth.c,v
retrieving revision 1.7
diff -u -p -u -r1.7 rpcauth.c
--- xserver/os/rpcauth.c	10 Jun 2012 13:21:31 -0000	1.7
+++ xserver/os/rpcauth.c	7 Dec 2014 12:31:42 -0000
@@ -66,6 +66,10 @@ authdes_ezdecode(const char *inmsg, int 
     SVCXPRT xprt;
 
     temp_inmsg = malloc(len);
+    if (temp_inmsg == NULL) {
+        why = AUTH_FAILED; /* generic error, since there is no AUTH_BADALLOC */
+        return NULL;
+    }
     memmove(temp_inmsg, inmsg, len);
 
     memset((char *) &msg, 0, sizeof(msg));
Index: xserver/randr/rrsdispatch.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/randr/rrsdispatch.c,v
retrieving revision 1.5
diff -u -p -u -r1.5 rrsdispatch.c
--- xserver/randr/rrsdispatch.c	10 Jun 2012 13:21:31 -0000	1.5
+++ xserver/randr/rrsdispatch.c	7 Dec 2014 12:31:49 -0000
@@ -27,6 +27,7 @@ SProcRRQueryVersion(ClientPtr client)
 {
     REQUEST(xRRQueryVersionReq);
 
+    REQUEST_SIZE_MATCH(xRRQueryVersionReq);
     swaps(&stuff->length);
     swapl(&stuff->majorVersion);
     swapl(&stuff->minorVersion);
@@ -38,6 +39,7 @@ SProcRRGetScreenInfo(ClientPtr client)
 {
     REQUEST(xRRGetScreenInfoReq);
 
+    REQUEST_SIZE_MATCH(xRRGetScreenInfoReq);
     swaps(&stuff->length);
     swapl(&stuff->window);
     return (*ProcRandrVector[stuff->randrReqType]) (client);
@@ -69,6 +71,7 @@ SProcRRSelectInput(ClientPtr client)
 {
     REQUEST(xRRSelectInputReq);
 
+    REQUEST_SIZE_MATCH(xRRSelectInputReq);
     swaps(&stuff->length);
     swapl(&stuff->window);
     swaps(&stuff->enable);
@@ -152,6 +155,7 @@ SProcRRConfigureOutputProperty(ClientPtr
 {
     REQUEST(xRRConfigureOutputPropertyReq);
 
+    REQUEST_AT_LEAST_SIZE(xRRConfigureOutputPropertyReq);
     swaps(&stuff->length);
     swapl(&stuff->output);
     swapl(&stuff->property);
Index: xserver/render/render.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/render/render.c,v
retrieving revision 1.15
diff -u -p -u -r1.15 render.c
--- xserver/render/render.c	7 Jun 2013 17:28:55 -0000	1.15
+++ xserver/render/render.c	7 Dec 2014 12:31:49 -0000
@@ -276,11 +276,11 @@ ProcRenderQueryVersion(ClientPtr client)
 
     REQUEST(xRenderQueryVersionReq);
 
+    REQUEST_SIZE_MATCH(xRenderQueryVersionReq);
+
     pRenderClient->major_version = stuff->majorVersion;
     pRenderClient->minor_version = stuff->minorVersion;
 
-    REQUEST_SIZE_MATCH(xRenderQueryVersionReq);
-
     if ((stuff->majorVersion * 1000 + stuff->minorVersion) <
         (SERVER_RENDER_MAJOR_VERSION * 1000 + SERVER_RENDER_MINOR_VERSION)) {
         rep.majorVersion = stuff->majorVersion;
@@ -1995,7 +1995,7 @@ static int
 SProcRenderQueryVersion(ClientPtr client)
 {
     REQUEST(xRenderQueryVersionReq);
-
+    REQUEST_SIZE_MATCH(xRenderQueryVersionReq);
     swaps(&stuff->length);
     swapl(&stuff->majorVersion);
     swapl(&stuff->minorVersion);
@@ -2006,6 +2006,7 @@ static int
 SProcRenderQueryPictFormats(ClientPtr client)
 {
     REQUEST(xRenderQueryPictFormatsReq);
+    REQUEST_SIZE_MATCH(xRenderQueryPictFormatsReq);
     swaps(&stuff->length);
     return (*ProcRenderVector[stuff->renderReqType]) (client);
 }
@@ -2014,6 +2015,7 @@ static int
 SProcRenderQueryPictIndexValues(ClientPtr client)
 {
     REQUEST(xRenderQueryPictIndexValuesReq);
+    REQUEST_AT_LEAST_SIZE(xRenderQueryPictIndexValuesReq);
     swaps(&stuff->length);
     swapl(&stuff->format);
     return (*ProcRenderVector[stuff->renderReqType]) (client);
@@ -2029,6 +2031,7 @@ static int
 SProcRenderCreatePicture(ClientPtr client)
 {
     REQUEST(xRenderCreatePictureReq);
+    REQUEST_AT_LEAST_SIZE(xRenderCreatePictureReq);
     swaps(&stuff->length);
     swapl(&stuff->pid);
     swapl(&stuff->drawable);
@@ -2042,6 +2045,7 @@ static int
 SProcRenderChangePicture(ClientPtr client)
 {
     REQUEST(xRenderChangePictureReq);
+    REQUEST_AT_LEAST_SIZE(xRenderChangePictureReq);
     swaps(&stuff->length);
     swapl(&stuff->picture);
     swapl(&stuff->mask);
@@ -2053,6 +2057,7 @@ static int
 SProcRenderSetPictureClipRectangles(ClientPtr client)
 {
     REQUEST(xRenderSetPictureClipRectanglesReq);
+    REQUEST_AT_LEAST_SIZE(xRenderSetPictureClipRectanglesReq);
     swaps(&stuff->length);
     swapl(&stuff->picture);
     swaps(&stuff->xOrigin);
@@ -2065,6 +2070,7 @@ static int
 SProcRenderFreePicture(ClientPtr client)
 {
     REQUEST(xRenderFreePictureReq);
+    REQUEST_SIZE_MATCH(xRenderFreePictureReq);
     swaps(&stuff->length);
     swapl(&stuff->picture);
     return (*ProcRenderVector[stuff->renderReqType]) (client);
@@ -2074,6 +2080,7 @@ static int
 SProcRenderComposite(ClientPtr client)
 {
     REQUEST(xRenderCompositeReq);
+    REQUEST_SIZE_MATCH(xRenderCompositeReq);
     swaps(&stuff->length);
     swapl(&stuff->src);
     swapl(&stuff->mask);
@@ -2093,6 +2100,7 @@ static int
 SProcRenderScale(ClientPtr client)
 {
     REQUEST(xRenderScaleReq);
+    REQUEST_SIZE_MATCH(xRenderScaleReq);
     swaps(&stuff->length);
     swapl(&stuff->src);
     swapl(&stuff->dst);
@@ -2193,6 +2201,7 @@ static int
 SProcRenderCreateGlyphSet(ClientPtr client)
 {
     REQUEST(xRenderCreateGlyphSetReq);
+    REQUEST_SIZE_MATCH(xRenderCreateGlyphSetReq);
     swaps(&stuff->length);
     swapl(&stuff->gsid);
     swapl(&stuff->format);
@@ -2203,6 +2212,7 @@ static int
 SProcRenderReferenceGlyphSet(ClientPtr client)
 {
     REQUEST(xRenderReferenceGlyphSetReq);
+    REQUEST_SIZE_MATCH(xRenderReferenceGlyphSetReq);
     swaps(&stuff->length);
     swapl(&stuff->gsid);
     swapl(&stuff->existing);
@@ -2213,6 +2223,7 @@ static int
 SProcRenderFreeGlyphSet(ClientPtr client)
 {
     REQUEST(xRenderFreeGlyphSetReq);
+    REQUEST_SIZE_MATCH(xRenderFreeGlyphSetReq);
     swaps(&stuff->length);
     swapl(&stuff->glyphset);
     return (*ProcRenderVector[stuff->renderReqType]) (client);
@@ -2227,6 +2238,7 @@ SProcRenderAddGlyphs(ClientPtr client)
     xGlyphInfo *gi;
 
     REQUEST(xRenderAddGlyphsReq);
+    REQUEST_AT_LEAST_SIZE(xRenderAddGlyphsReq);
     swaps(&stuff->length);
     swapl(&stuff->glyphset);
     swapl(&stuff->nglyphs);
@@ -2261,6 +2273,7 @@ static int
 SProcRenderFreeGlyphs(ClientPtr client)
 {
     REQUEST(xRenderFreeGlyphsReq);
+    REQUEST_AT_LEAST_SIZE(xRenderFreeGlyphsReq);
     swaps(&stuff->length);
     swapl(&stuff->glyphset);
     SwapRestL(stuff);
@@ -2278,6 +2291,7 @@ SProcRenderCompositeGlyphs(ClientPtr cli
     int size;
 
     REQUEST(xRenderCompositeGlyphsReq);
+    REQUEST_AT_LEAST_SIZE(xRenderCompositeGlyphsReq);
 
     switch (stuff->renderReqType) {
     default:
Index: xserver/test/misc.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/test/misc.c,v
retrieving revision 1.2
diff -u -p -u -r1.2 misc.c
--- xserver/test/misc.c	10 Jun 2012 13:21:31 -0000	1.2
+++ xserver/test/misc.c	7 Dec 2014 12:31:49 -0000
@@ -28,6 +28,8 @@
 #include <stdint.h>
 #include "misc.h"
 #include "scrnintstr.h"
+#include "dix.h"
+#include "dixstruct.h"
 
 ScreenInfo screenInfo;
 
@@ -155,11 +157,46 @@ dix_update_desktop_dimensions(void)
     assert_dimensions(-w2, -h2, w2, h2);
 }
 
+static int
+dix_request_fixed_size_overflow(ClientRec *client)
+{
+    xReq req = { 0 };
+
+    client->req_len = req.length = 1;
+    REQUEST_FIXED_SIZE(req, SIZE_MAX);
+    return Success;
+}
+
+static int
+dix_request_fixed_size_match(ClientRec *client)
+{
+    xReq req = { 0 };
+
+    client->req_len = req.length = 9;
+    REQUEST_FIXED_SIZE(req, 30);
+    return Success;
+}
+
+static void
+dix_request_size_checks(void)
+{
+    ClientRec client = { 0 };
+    int rc;
+
+    rc = dix_request_fixed_size_overflow(&client);
+    assert(rc == BadLength);
+
+    rc = dix_request_fixed_size_match(&client);
+    assert(rc == Success);
+}
+
+
 int
 main(int argc, char **argv)
 {
     dix_version_compare();
     dix_update_desktop_dimensions();
+    dix_request_size_checks();
 
     return 0;
 }
Index: xserver/test/xi2/protocol-xigetclientpointer.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/test/xi2/protocol-xigetclientpointer.c,v
retrieving revision 1.3
diff -u -p -u -r1.3 protocol-xigetclientpointer.c
--- xserver/test/xi2/protocol-xigetclientpointer.c	10 Jun 2012 13:21:31 -0000	1.3
+++ xserver/test/xi2/protocol-xigetclientpointer.c	7 Dec 2014 12:31:49 -0000
@@ -124,6 +124,11 @@ test_XIGetClientPointer(void)
     request.win = INVALID_WINDOW_ID;
     request_XIGetClientPointer(&client_request, &request, BadWindow);
 
+    printf("Testing invalid length\n");
+    client_request.req_len -= 4;
+    request_XIGetClientPointer(&client_request, &request, BadLength);
+    client_request.req_len += 4;
+
     test_data.cp_is_set = FALSE;
 
     printf("Testing window None, unset ClientPointer.\n");
Index: xserver/test/xi2/protocol-xipassivegrabdevice.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/test/xi2/protocol-xipassivegrabdevice.c,v
retrieving revision 1.3
diff -u -p -u -r1.3 protocol-xipassivegrabdevice.c
--- xserver/test/xi2/protocol-xipassivegrabdevice.c	7 Jun 2013 17:28:56 -0000	1.3
+++ xserver/test/xi2/protocol-xipassivegrabdevice.c	7 Dec 2014 12:31:49 -0000
@@ -138,6 +138,7 @@ request_XIPassiveGrabDevice(ClientPtr cl
     int rc;
     int modifiers;
 
+    client_request.req_len = req->length;
     rc = ProcXIPassiveGrabDevice(&client_request);
     assert(rc == error);
 
@@ -188,6 +189,13 @@ test_XIPassiveGrabDevice(void)
     request_XIPassiveGrabDevice(&client_request, request, BadDevice,
                                 request->deviceid);
 
+    printf("Testing invalid length\n");
+    request->length -= 2;
+    request_XIPassiveGrabDevice(&client_request, request, BadLength,
+                                client_request.errorValue);
+    /* re-init request since swapped length test leaves some values swapped */
+    request_init(request, XIPassiveGrabDevice);
+    request->grab_window = CLIENT_WINDOW_ID;
     request->deviceid = XIAllMasterDevices;
 
     printf("Testing invalid grab types\n");
Index: xserver/test/xi2/protocol-xiquerypointer.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/test/xi2/protocol-xiquerypointer.c,v
retrieving revision 1.4
diff -u -p -u -r1.4 protocol-xiquerypointer.c
--- xserver/test/xi2/protocol-xiquerypointer.c	7 Jun 2013 17:28:56 -0000	1.4
+++ xserver/test/xi2/protocol-xiquerypointer.c	7 Dec 2014 12:31:49 -0000
@@ -201,6 +201,10 @@ test_XIQueryPointer(void)
     test_data.dev = devices.mouse;
     request.deviceid = devices.mouse->id;
     request_XIQueryPointer(&client_request, &request, Success);
+
+    /* test REQUEST_SIZE_MATCH */
+    client_request.req_len -= 4;
+    request_XIQueryPointer(&client_request, &request, BadLength);
 }
 
 int
Index: xserver/test/xi2/protocol-xiwarppointer.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/test/xi2/protocol-xiwarppointer.c,v
retrieving revision 1.4
diff -u -p -u -r1.4 protocol-xiwarppointer.c
--- xserver/test/xi2/protocol-xiwarppointer.c	7 Jun 2013 17:28:56 -0000	1.4
+++ xserver/test/xi2/protocol-xiwarppointer.c	7 Dec 2014 12:31:49 -0000
@@ -198,6 +198,9 @@ test_XIWarpPointer(void)
     request_XIWarpPointer(&client_request, &request, Success);
 
     /* FIXME: src_x/y checks */
+
+    client_request.req_len -= 2; /* invalid length */
+    request_XIWarpPointer(&client_request, &request, BadLength);
 }
 
 int
Index: xserver/xfixes/select.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/xserver/xfixes/select.c,v
retrieving revision 1.6
diff -u -p -u -r1.6 select.c
--- xserver/xfixes/select.c	7 Jun 2013 17:28:56 -0000	1.6
+++ xserver/xfixes/select.c	7 Dec 2014 12:31:49 -0000
@@ -201,6 +201,7 @@ SProcXFixesSelectSelectionInput(ClientPt
 {
     REQUEST(xXFixesSelectSelectionInputReq);
 
+    REQUEST_SIZE_MATCH(xXFixesSelectSelectionInputReq);
     swaps(&stuff->length);
     swapl(&stuff->window);
     swapl(&stuff->selection);
