dnl Copyright (C) 1999-2005 Open Source Telecom Corporation.
dnl  
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl 
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl 
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software 
dnl Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
dnl 
dnl As a special exception to the GNU General Public License, if you 
dnl distribute this file as part of a program that contains a configuration 
dnl script generated by Autoconf, you may include it under the same 
dnl distribution terms that you use for the rest of that program.

AC_DEFUN([OST_CC_THREADING],[
  ost_cv_thread_flags=""
  ost_cv_thread_library="c"
  AC_CHECK_HEADER(pthread.h,[
	AC_DEFINE(HAVE_PTHREAD_H, [1], [posix threading header])
	ost_cv_thread_flags=""

	for flags in in -kthread -pthread -mthreads -pthreads -Kthread --threadsafe -mt ; do
                AC_MSG_CHECKING(whether ${CC-cc} accepts $flags)
                echo 'void f(){}' >conftest.c
                if test -z "`${CC-cc} $flags -c conftest.c 2>&1`"; then
                        ost_cv_thread_flags=$flags
                        AC_MSG_RESULT(yes)
                else
                        AC_MSG_RESULT(no)
                fi
                rm -f conftest*
                if test ! -z "$ost_cv_thread_flags" ; then break ; fi
	done

        ost_cv_thread_library=none
        AC_CHECK_LIB(pthread, pthread_self,
                ost_cv_thread_library=pthread,
                AC_CHECK_LIB(c_r, pthread_self,
                        ost_cv_thread_library=c_r,
                        AC_CHECK_LIB(pthread, pthread_kill,
                                ost_cv_thread_library=pthread,
                                AC_CHECK_LIB(pthreads, pthread_self,
                                        ost_cv_thread_library=pthreads,
                                        AC_CHECK_LIB(thread, pthread_self,
                                        	ost_cv_thread_library=thread)))))       

       if test $ost_cv_thread_library = none ; then
                AC_CHECK_LIB(gthreads, pthread_self,[
                        AC_CHECK_LIB(malloc, malloc)
                        ost_cv_thread_library=gthreads])
        fi
        if test $ost_cv_thread_library = none ; then
                AC_CHECK_LIB(cma, pthread_self,
                        ost_cv_thread_library=cma)
        fi


        if test $ost_cv_thread_library = none ; then
                AC_CHECK_LIB(c, pthread_self,
                        ost_cv_thread_library=c)
        fi

        if test $ost_cv_thread_library = none ; then
                AC_MSG_ERROR(no library for posix threads found!)
        fi

  ])
  if test ! -z "$ost_cv_thread_flags" ; then
	  CXXFLAGS="$CXXFLAGS $ost_cv_thread_flags" ; fi

  if test "$ost_cv_thread_library" != "c" ; then 
	LIBS="$LIBS -l$ost_cv_thread_library" ; fi
])

