/* Encoder8859_5.java -- Encoder for ISO-Latin-5 Character set
   Copyright (C) 1998 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.
 
GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


package gnu.java.io.encode;

import java.io.OutputStream;

/**
  * This class decodes bytes in ISO-8859-3 (Latin-3) format to Unicode.
  *
  * @version 0.0
  *
  * @author Aaron M. Renn (arenn@urbanophile.com)
  */
public class Encoder8859_5 extends EncoderEightBitLookup
{

/*************************************************************************/

/**
  * This is the lookup table for this encoding
  */

protected static char[] lookup_table_8859_5 = { 
// Begin range undefined in spec document I used
0x0000,
0x0001,
0x0002,
0x0003,
0x0004,
0x0005,
0x0006,
0x0007,
0x0008,
0x0009,
0x000A,
0x000B,
0x000C,
0x000D,
0x000E,
0x000F,
0x0010,
0x0011,
0x0012,
0x0013,
0x0014,
0x0015,
0x0016,
0x0017,
0x0018,
0x0019,
0x001A,
0x001B,
0x001C,
0x001D,
0x001E,
0x001F,
// End range undefined in spec document I used
0x0020,
0x0021,
0x0022,
0x0023,
0x0024,
0x0025,
0x0026,
0x0027,
0x0028,
0x0029,
0x002A,
0x002B,
0x002C,
0x002D,
0x002E,
0x002F,
0x0030,
0x0031,
0x0032,
0x0033,
0x0034,
0x0035,
0x0036,
0x0037,
0x0038,
0x0039,
0x003A,
0x003B,
0x003C,
0x003D,
0x003E,
0x003F,
0x0040,
0x0041,
0x0042,
0x0043,
0x0044,
0x0045,
0x0046,
0x0047,
0x0048,
0x0049,
0x004A,
0x004B,
0x004C,
0x004D,
0x004E,
0x004F,
0x0050,
0x0051,
0x0052,
0x0053,
0x0054,
0x0055,
0x0056,
0x0057,
0x0058,
0x0059,
0x005A,
0x005B,
0x005C,
0x005D,
0x005E,
0x005F,
0x0060,
0x0061,
0x0062,
0x0063,
0x0064,
0x0065,
0x0066,
0x0067,
0x0068,
0x0069,
0x006A,
0x006B,
0x006C,
0x006D,
0x006E,
0x006F,
0x0070,
0x0071,
0x0072,
0x0073,
0x0074,
0x0075,
0x0076,
0x0077,
0x0078,
0x0079,
0x007A,
0x007B,
0x007C,
0x007D,
0x007E,
// Begin range undefined in spec document I used
0x007F,
0x0080,
0x0081,
0x0082,
0x0083,
0x0084,
0x0085,
0x0086,
0x0087,
0x0088,
0x0089,
0x008A,
0x008B,
0x008C,
0x008D,
0x008E,
0x008F,
0x0090,
0x0091,
0x0092,
0x0093,
0x0094,
0x0095,
0x0096,
0x0097,
0x0098,
0x0099,
0x009A,
0x009B,
0x009C,
0x009D,
0x009E,
0x009F,
// End range undefined in spec document I used
0x00A0,
0x0401,
0x0402,
0x0403,
0x0404,
0x0405,
0x0406,
0x0407,
0x0408,
0x0409,
0x040A,
0x040B,
0x040C,
0x00AD,
0x040E,
0x040F,
0x0410,
0x0411,
0x0412,
0x0413,
0x0414,
0x0415,
0x0416,
0x0417,
0x0418,
0x0419,
0x041A,
0x041B,
0x041C,
0x041D,
0x041E,
0x041F,
0x0420,
0x0421,
0x0422,
0x0423,
0x0424,
0x0425,
0x0426,
0x0427,
0x0428,
0x0429,
0x042A,
0x042B,
0x042C,
0x042D,
0x042E,
0x042F,
0x0430,
0x0431,
0x0432,
0x0433,
0x0434,
0x0435,
0x0436,
0x0437,
0x0438,
0x0439,
0x043A,
0x043B,
0x043C,
0x043D,
0x043E,
0x043F,
0x0440,
0x0441,
0x0442,
0x0443,
0x0444,
0x0445,
0x0446,
0x0447,
0x0448,
0x0449,
0x044A,
0x044B,
0x044C,
0x044D,
0x044E,
0x044F,
0x2116,
0x0451,
0x0452,
0x0453,
0x0454,
0x0455,
0x0456,
0x0457,
0x0458,
0x0459,
0x045A,
0x045B,
0x045C,
0x00A7,
0x045E,
0x045F
};

static
{
  scheme_name = "8859_5";
  scheme_description = "ISO-8859-5 (Latin-5 character set)";
  lookup_table = lookup_table_8859_5;
}

/*************************************************************************/

/*
 * Constructors
 */
public
Encoder8859_5(OutputStream out)
{
  super(out);
}

} // class Encoder8859_5

