/* -*- tab-width: 4 -*-
 *
 * Electric(tm) VLSI Design System
 *
 * File: Active.java
 *
 * Copyright (c) 2008 Sun Microsystems and Static Free Software
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 */
package com.sun.electric.tool.user.tecEditWizard;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.user.Resources;

import java.awt.*;

/**
 * Class to handle the "Active" tab of the Numeric Technology Editor dialog.
 */
public class Active extends TechEditWizardPanel
{
	/** Creates new form Active */
	public Active(TechEditWizard parent, boolean modal)
	{
		super(parent, modal);
		initComponents();
		image.setIcon(Resources.getResource(getClass(), "Active.png"));
		pack();
	}

	/** return the panel to use for this Numeric Technology Editor tab. */
	public Component getComponent() { return active; }

	/** return the name of this Numeric Technology Editor tab. */
	public String getName() { return "Active"; }

	/**
	 * Method called at the start of the dialog.
	 * Caches current values and displays them in the Active tab.
	 */
	public void init()
	{
		TechEditWizardData data = wizard.getTechEditData();
		width.setText(TextUtils.formatDouble(data.getDiffWidth().value));
		widthRule.setText(data.getDiffWidth().rule);
		polyOverhang.setText(TextUtils.formatDouble(data.getDiffPolyOverhang().value));
		polyOverhangRule.setText(data.getDiffPolyOverhang().rule);
		contactOverhang.setText(TextUtils.formatDouble(data.getDiffContactOverhang().value));
		contactOverhangRule.setText(data.getDiffContactOverhang().rule);
		spacing.setText(TextUtils.formatDouble(data.getDiffSpacing().value));
		spacingRule.setText(data.getDiffSpacing().rule);
	}

	/**
	 * Method called when the "OK" panel is hit.
	 * Updates any changed fields in the Active tab.
	 */
	public void term()
	{
		TechEditWizardData data = wizard.getTechEditData();
		data.setDiffWidth(new WizardField(TextUtils.atof(width.getText()), widthRule.getText()));
		data.setDiffPolyOverhang(new WizardField(TextUtils.atof(polyOverhang.getText()), polyOverhangRule.getText()));
		data.setDiffContactOverhang(new WizardField(TextUtils.atof(contactOverhang.getText()), contactOverhangRule.getText()));
		data.setDiffSpacing(new WizardField(TextUtils.atof(spacing.getText()), spacingRule.getText()));
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        active = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        width = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        polyOverhang = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        contactOverhang = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        spacing = new javax.swing.JTextField();
        image = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        widthRule = new javax.swing.JTextField();
        polyOverhangRule = new javax.swing.JTextField();
        contactOverhangRule = new javax.swing.JTextField();
        spacingRule = new javax.swing.JTextField();
        jLabel7 = new javax.swing.JLabel();
        jLabel8 = new javax.swing.JLabel();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setTitle("Active");
        setName("");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        active.setLayout(new java.awt.GridBagLayout());

        jLabel1.setText("Width (A):");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 4, 1, 0);
        active.add(jLabel1, gridBagConstraints);

        width.setColumns(8);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(1, 0, 1, 2);
        active.add(width, gridBagConstraints);

        jLabel2.setText("Poly overhang (B):");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 4, 1, 0);
        active.add(jLabel2, gridBagConstraints);

        polyOverhang.setColumns(8);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(1, 0, 1, 2);
        active.add(polyOverhang, gridBagConstraints);

        jLabel3.setText("Contact overhang (C):");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 4, 1, 0);
        active.add(jLabel3, gridBagConstraints);

        contactOverhang.setColumns(8);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new java.awt.Insets(1, 0, 1, 2);
        active.add(contactOverhang, gridBagConstraints);

        jLabel4.setText("Spacing (D):");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 4, 1, 0);
        active.add(jLabel4, gridBagConstraints);

        spacing.setColumns(8);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new java.awt.Insets(1, 0, 1, 2);
        active.add(spacing, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        active.add(image, gridBagConstraints);

        jLabel5.setText("Distances are in nanometers");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 1, 0);
        active.add(jLabel5, gridBagConstraints);

        jLabel6.setText("Active Parameters");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 0);
        active.add(jLabel6, gridBagConstraints);

        widthRule.setColumns(8);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(1, 2, 1, 2);
        active.add(widthRule, gridBagConstraints);

        polyOverhangRule.setColumns(8);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(1, 2, 1, 2);
        active.add(polyOverhangRule, gridBagConstraints);

        contactOverhangRule.setColumns(8);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new java.awt.Insets(1, 2, 1, 2);
        active.add(contactOverhangRule, gridBagConstraints);

        spacingRule.setColumns(8);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new java.awt.Insets(1, 2, 1, 2);
        active.add(spacingRule, gridBagConstraints);

        jLabel7.setText("Rule Name");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        active.add(jLabel7, gridBagConstraints);

        jLabel8.setText("Distance");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        active.add(jLabel8, gridBagConstraints);

        getContentPane().add(active, new java.awt.GridBagConstraints());

        pack();
    }// </editor-fold>//GEN-END:initComponents

	/** Closes the dialog */
	private void closeDialog(java.awt.event.WindowEvent evt)//GEN-FIRST:event_closeDialog
	{
		setVisible(false);
		dispose();
	}//GEN-LAST:event_closeDialog

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel active;
    private javax.swing.JTextField contactOverhang;
    private javax.swing.JTextField contactOverhangRule;
    private javax.swing.JLabel image;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JTextField polyOverhang;
    private javax.swing.JTextField polyOverhangRule;
    private javax.swing.JTextField spacing;
    private javax.swing.JTextField spacingRule;
    private javax.swing.JTextField width;
    private javax.swing.JTextField widthRule;
    // End of variables declaration//GEN-END:variables

}
