/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.DrcRings;
import com.sun.electric.tool.generator.layout.Gallery;
import com.sun.electric.tool.generator.layout.GenerateLayoutForGatesInSchematic;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.EditWindow;

public class GateLayoutGenerator
extends Job {
    private static final DrcRings.Filter FILTER = new DrcRings.Filter(){

        public boolean skip(NodeInst ni) {
            return ni.getProto().getName().indexOf("mosWellTie_") != -1;
        }
    };

    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    private Cell findCell(Library lib, String cellName) {
        Cell c = lib.findNodeProto(cellName);
        LayoutLib.error(c == null, "can't find: " + lib.getName() + ":" + cellName);
        return c;
    }

    private Library generateLayout(Library outLib, Cell cell) {
        StdCellParams stdCell = GateLayoutGenerator.locoParams(outLib);
        StdCellParams stdCellPwr = GateLayoutGenerator.locoParams(outLib);
        stdCellPwr.setVddExportName("power");
        stdCellPwr.setVddExportRole(PortProto.Characteristic.IN);
        GenerateLayoutForGatesInSchematic visitor = new GenerateLayoutForGatesInSchematic(stdCell, stdCellPwr);
        HierarchyEnumerator.enumerateCell(cell, null, null, visitor);
        return outLib;
    }

    private static StdCellParams locoParams(Library outLib) {
        StdCellParams stdCell = new StdCellParams(outLib);
        stdCell.setSizeQuantizationError(0.0);
        stdCell.setMaxMosWidth(1000.0);
        stdCell.setVddY(21.0);
        stdCell.setGndY(-21.0);
        stdCell.setNmosWellHeight(42.0);
        stdCell.setPmosWellHeight(42.0);
        stdCell.setSimpleName(true);
        return stdCell;
    }

    public boolean doIt() {
        String outLibNm = "autoGenLib";
        String outLibDir = "";
        Library outLib = LayoutLib.openLibForWrite(outLibNm, outLibDir + outLibNm);
        EditWindow wnd = EditWindow.getCurrent();
        Cell cell = wnd.getCell();
        if (cell == null) {
            System.out.println("Please open the schematic for which you want to generate gate layouts.");
            return false;
        }
        View view = cell.getView();
        if (view != View.SCHEMATIC) {
            System.out.println("The current cell isn't a schematic. This command only works on schematics.");
            return false;
        }
        System.out.println("Generating layouts for gates in the schematic: " + cell.getName() + " and its descendents");
        System.out.println("Output goes to library: autoGenLib");
        this.generateLayout(outLib, cell);
        Cell gallery = Gallery.makeGallery(outLib);
        DrcRings.addDrcRings(gallery, FILTER);
        System.out.println("done.");
        return true;
    }

    public GateLayoutGenerator() {
        super("Generate gate layouts", User.tool, Job.Type.CHANGE, null, null, Job.Priority.ANALYSIS);
        this.startJob();
    }
}

