/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.misc;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyQTree;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LayerCoverageJob
extends Job {
    private Cell curCell;
    private boolean testCase;
    private PolyQTree tree;
    public static final int AREA = 0;
    public static final int MERGE = 1;
    public static final int IMPLANT = 2;
    public static final int NETWORK = 3;
    private final int function;
    private List deleteList;
    private HashMap originalPolygons = new HashMap();
    private Highlighter highlighter;
    private GeometryOnNetwork geoms;

    public static GeometryOnNetwork listGeometryOnNetworks(Cell cell, HashSet nets, boolean printable) {
        if (cell == null || nets == null || nets.isEmpty()) {
            return null;
        }
        double lambda = 1.0;
        GeometryOnNetwork geoms = new GeometryOnNetwork(cell, nets, lambda, printable);
        LayerCoverageJob job = new LayerCoverageJob(Job.Type.EXAMINE, cell, 3, false, null, geoms);
        job.startJob();
        return geoms;
    }

    public static GeometryOnNetwork listGeometryOnNetworksNoJob(Cell cell, HashSet nets, boolean printable) {
        if (cell == null || nets == null || nets.isEmpty()) {
            return null;
        }
        double lambda = 1.0;
        GeometryOnNetwork geoms = new GeometryOnNetwork(cell, nets, lambda, printable);
        LayerCoverageJob job = new LayerCoverageJob(Job.Type.EXAMINE, cell, 3, false, null, geoms);
        ((Job)job).doIt();
        return geoms;
    }

    public LayerCoverageJob(Job.Type jobType, Cell cell, int func, boolean test, Highlighter highlighter, GeometryOnNetwork geoms) {
        super("Layer Coverage", User.tool, jobType, null, null, Job.Priority.USER);
        this.curCell = cell;
        this.testCase = test;
        this.tree = new PolyQTree(this.curCell.getBounds());
        this.function = func;
        this.deleteList = new ArrayList();
        this.highlighter = highlighter;
        this.geoms = geoms;
        this.setReportExecutionFlag(true);
    }

    public boolean doIt() {
        LayerVisitor visitor = new LayerVisitor(this.testCase, this.tree, this.deleteList, this.function, this.originalPolygons, this.geoms.nets);
        HierarchyEnumerator.enumerateCell(this.curCell, VarContext.globalContext, null, visitor);
        switch (this.function) {
            case 0: {
                double lambdaSqr = 1.0;
                Rectangle2D bbox = this.curCell.getBounds();
                double totalArea = bbox.getHeight() * bbox.getWidth() / lambdaSqr;
                Iterator it = this.tree.getKeyIterator();
                while (it.hasNext()) {
                    Layer layer = (Layer)it.next();
                    Collection set = this.tree.getObjects(layer, false, true);
                    double layerArea = 0.0;
                    Iterator i = set.iterator();
                    while (i.hasNext()) {
                        PolyQTree.PolyNode area = (PolyQTree.PolyNode)i.next();
                        layerArea += area.getArea();
                    }
                    System.out.println("Layer " + layer.getName() + " covers " + TextUtils.formatDouble(layerArea) + " square lambda (" + TextUtils.formatDouble(layerArea / totalArea * 100.0, 0) + "%)");
                }
                System.out.println("Cell is " + TextUtils.formatDouble(totalArea, 2) + " square lambda (took " + TextUtils.getElapsedTime(this.endTime - this.startTime) + ")");
                break;
            }
            case 1: 
            case 2: {
                if (this.highlighter != null) {
                    this.highlighter.clear();
                }
                boolean noNewNodes = true;
                boolean isMerge = this.function == 1;
                Iterator it = this.tree.getKeyIterator();
                while (it.hasNext()) {
                    Layer layer = (Layer)it.next();
                    Collection set = this.tree.getObjects(layer, !isMerge, true);
                    Iterator i = set.iterator();
                    while (i.hasNext()) {
                        Map map;
                        PolyQTree.PolyNode qNode = (PolyQTree.PolyNode)i.next();
                        if (this.function == 2 && (map = (Map)this.originalPolygons.get(layer)).containsValue(qNode)) continue;
                        Rectangle2D rect = qNode.getBounds2D();
                        Point2D.Double center = new Point2D.Double(rect.getCenterX(), rect.getCenterY());
                        PrimitiveNode priNode = layer.getPureLayerNode();
                        NodeInst node = NodeInst.makeInstance(priNode, center, rect.getWidth(), rect.getHeight(), this.curCell);
                        if (this.highlighter != null) {
                            this.highlighter.addElectricObject(node, this.curCell);
                        }
                        if (isMerge) {
                            Point2D[] points = qNode.getPoints();
                            node.newVar(NodeInst.TRACE, (Object)points);
                        } else {
                            node.setHardSelect();
                        }
                        noNewNodes = false;
                    }
                }
                if (this.highlighter != null) {
                    this.highlighter.finished();
                }
                it = this.deleteList.iterator();
                while (it.hasNext()) {
                    NodeInst node = (NodeInst)it.next();
                    node.kill();
                }
                if (!noNewNodes) break;
                System.out.println("No new areas added");
                break;
            }
            case 3: {
                double totalWire = 0.0;
                double lambda = 1.0;
                ArrayList list = new ArrayList(this.tree.getKeySet());
                Collections.sort(list, new Layer.LayerSort());
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    Layer layer = (Layer)it.next();
                    Collection set = this.tree.getObjects(layer, false, true);
                    double layerArea = 0.0;
                    double perimeter = 0.0;
                    Iterator i = set.iterator();
                    while (i.hasNext()) {
                        PolyQTree.PolyNode area = (PolyQTree.PolyNode)i.next();
                        layerArea += area.getArea();
                        perimeter += area.getPerimeter();
                    }
                    this.geoms.addLayer(layer, layerArea /= lambda, perimeter /= 2.0);
                }
                this.geoms.print();
                break;
            }
            default: {
                System.out.println("Error in LayerCoverageJob: function not implemented");
            }
        }
        return true;
    }

    public static class GeometryOnNetwork {
        public final Cell cell;
        protected Set nets;
        private double lambda;
        private boolean printable;
        private ArrayList layers;
        private ArrayList areas;
        private ArrayList halfPerimeters;
        private double totalWire;

        private GeometryOnNetwork(Cell cell, Set nets, double lambda, boolean printable) {
            this.cell = cell;
            this.nets = nets;
            this.lambda = lambda;
            this.layers = new ArrayList();
            this.areas = new ArrayList();
            this.halfPerimeters = new ArrayList();
            this.printable = printable;
            this.totalWire = 0.0;
        }

        public double getTotalWireLength() {
            return this.totalWire;
        }

        private void addLayer(Layer layer, double area, double halfperimeter) {
            this.layers.add(layer);
            this.areas.add(new Double(area));
            this.halfPerimeters.add(new Double(halfperimeter));
            Layer.Function func = layer.getFunction();
            if (func.isPoly() && !func.isGatePoly() || func.isMetal()) {
                this.totalWire += halfperimeter;
            }
        }

        public void print() {
            if (!this.printable) {
                return;
            }
            Iterator it = this.nets.iterator();
            while (it.hasNext()) {
                Network net = (Network)it.next();
                System.out.println("For network '" + net.describe() + "' in cell '" + this.cell.describe() + "':");
            }
            for (int i = 0; i < this.layers.size(); ++i) {
                Layer layer = (Layer)this.layers.get(i);
                Double area = (Double)this.areas.get(i);
                Double halfperim = (Double)this.halfPerimeters.get(i);
                System.out.println("\tLayer " + layer.getName() + ":\t area " + TextUtils.formatDouble(area) + "\t half-perimeter " + TextUtils.formatDouble(halfperim) + "\t ratio " + TextUtils.formatDouble(area / halfperim));
            }
            if (this.totalWire > 0.0) {
                System.out.println("Total wire length = " + TextUtils.formatDouble(this.totalWire / this.lambda));
            }
        }
    }

    public static class LayerVisitor
    extends HierarchyEnumerator.Visitor {
        private boolean testCase;
        private PolyQTree tree;
        private List deleteList;
        private final int function;
        private HashMap originalPolygons;
        private Set netSet;

        private static boolean IsValidFunction(Layer.Function func, int function, boolean testCase) {
            if (testCase) {
                return true;
            }
            switch (function) {
                case 3: {
                    return true;
                }
                case 2: {
                    return func.isSubstrate();
                }
                case 0: {
                    return func.isPoly() || func.isMetal();
                }
            }
            return false;
        }

        public LayerVisitor(boolean test, PolyQTree t, List delList, int func, HashMap original, Set netSet) {
            this.testCase = test;
            this.tree = t;
            this.deleteList = delList;
            this.function = func;
            this.originalPolygons = original;
            this.netSet = netSet;
        }

        public void exitCell(HierarchyEnumerator.CellInfo info) {
        }

        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            Cell curCell = info.getCell();
            Netlist netlist = info.getNetlist();
            boolean found = this.netSet == null;
            Iterator it = netlist.getNetworks();
            while (!found && it.hasNext()) {
                Network aNet;
                Network parentNet = aNet = (Network)it.next();
                HierarchyEnumerator.CellInfo cinfo = info;
                boolean netFound = false;
                while (!(netFound = this.netSet.contains(parentNet)) && cinfo.getParentInst() != null) {
                    parentNet = cinfo.getNetworkInParent(parentNet);
                    cinfo = cinfo.getParentInfo();
                }
                found = netFound;
            }
            if (!found) {
                return false;
            }
            it = curCell.getArcs();
            while (it.hasNext()) {
                ArcInst arc = (ArcInst)it.next();
                int width = netlist.getBusWidth(arc);
                found = this.netSet == null;
                for (int i = 0; !found && i < width; ++i) {
                    Network parentNet = netlist.getNetwork(arc, i);
                    HierarchyEnumerator.CellInfo cinfo = info;
                    boolean netFound = false;
                    while (!(netFound = this.netSet.contains(parentNet)) && cinfo.getParentInst() != null) {
                        parentNet = cinfo.getNetworkInParent(parentNet);
                        cinfo = cinfo.getParentInfo();
                    }
                    found = netFound;
                }
                if (!found) continue;
                ArcProto arcType = arc.getProto();
                Technology tech = arcType.getTechnology();
                Poly[] polyList = tech.getShapeOfArc(arc);
                for (int i = 0; i < polyList.length; ++i) {
                    Poly poly = polyList[i];
                    Layer layer = poly.getLayer();
                    Layer.Function func = layer.getFunction();
                    boolean value = LayerVisitor.IsValidFunction(func, this.function, this.testCase);
                    if (!value) continue;
                    poly.transform(info.getTransformToRoot());
                    PolyQTree.PolyNode pnode = new PolyQTree.PolyNode(poly);
                    if (this.function == 2) {
                        HashMap<PolyQTree.PolyNode, Object> map = (HashMap<PolyQTree.PolyNode, Object>)this.originalPolygons.get(layer);
                        if (map == null) {
                            map = new HashMap<PolyQTree.PolyNode, Object>();
                            this.originalPolygons.put(layer, map);
                        }
                        map.put(pnode, pnode.clone());
                    }
                    this.tree.add(layer, pnode, this.function == 3);
                }
            }
            return true;
        }

        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            NodeInst node = no.getNodeInst();
            boolean found = this.netSet == null;
            NodeProto np = node.getProto();
            if (NodeInst.isSpecialNode(node)) {
                return false;
            }
            if (np instanceof Cell) {
                return true;
            }
            Iterator pIt = node.getPortInsts();
            while (!found && pIt.hasNext()) {
                Network oNet;
                PortInst pi = (PortInst)pIt.next();
                PortProto subPP = pi.getPortProto();
                Network parentNet = oNet = info.getNetlist().getNetwork(node, subPP, 0);
                HierarchyEnumerator.CellInfo cinfo = info;
                boolean netFound = false;
                while (!(netFound = this.netSet.contains(parentNet)) && cinfo.getParentInst() != null) {
                    parentNet = cinfo.getNetworkInParent(parentNet);
                    cinfo = cinfo.getParentInfo();
                }
                found = netFound;
            }
            if (!found) {
                return false;
            }
            if (!this.testCase && node.isPrimtiveSubstrateNode()) {
                this.deleteList.add(node);
                return false;
            }
            Technology tech = np.getTechnology();
            Poly[] polyList = tech.getShapeOfNode(node);
            AffineTransform transform = node.rotateOut();
            for (int i = 0; i < polyList.length; ++i) {
                Poly poly = polyList[i];
                Layer layer = poly.getLayer();
                Layer.Function func = layer.getFunction();
                boolean value = LayerVisitor.IsValidFunction(func, this.function, this.testCase);
                if (!value || poly.getPoints().length < 3) continue;
                poly.transform(transform);
                poly.transform(info.getTransformToRoot());
                PolyQTree.PolyNode pnode = new PolyQTree.PolyNode(poly);
                if (this.function == 2) {
                    HashMap<PolyQTree.PolyNode, Object> map = (HashMap<PolyQTree.PolyNode, Object>)this.originalPolygons.get(layer);
                    if (map == null) {
                        map = new HashMap<PolyQTree.PolyNode, Object>();
                        this.originalPolygons.put(layer, map);
                    }
                    map.put(pnode, pnode.clone());
                }
                this.tree.add(layer, pnode, this.function == 3);
            }
            return true;
        }
    }
}

