/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.jemNets;

import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.basic.NccCellAnnotations;
import com.sun.electric.tool.ncc.jemNets.ExportGlobal;
import com.sun.electric.tool.ncc.jemNets.ExportGlobalConflict;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

class NccCellInfo
extends HierarchyEnumerator.CellInfo {
    private NccGlobals globals;
    private boolean gotAnnotations = false;
    private NccCellAnnotations annotations;

    public NccCellInfo(NccGlobals globals) {
        this.globals = globals;
    }

    public NccCellAnnotations getAnnotations() {
        if (!this.gotAnnotations) {
            this.annotations = NccCellAnnotations.getAnnotations(this.getCell());
        }
        this.gotAnnotations = true;
        return this.annotations;
    }

    public Iterator getExportsAndGlobals() {
        String nm;
        HashMap<String, ExportGlobal> nameToExport = new HashMap<String, ExportGlobal>();
        Iterator it = this.getCell().getPorts();
        while (it.hasNext()) {
            Export e = (Export)it.next();
            int[] expNetIDs = this.getExportNetIDs(e);
            for (int i = 0; i < expNetIDs.length; ++i) {
                nm = e.getNameKey().subname(i).toString();
                ExportGlobal eg = new ExportGlobal(nm, expNetIDs[i], e.getCharacteristic());
                nameToExport.put(nm, eg);
            }
        }
        ArrayList<Object> expGlob = new ArrayList<Object>();
        expGlob.addAll(nameToExport.values());
        Global.Set globNets = this.getNetlist().getGlobals();
        for (int i = 0; i < globNets.size(); ++i) {
            Global g = globNets.get(i);
            nm = g.getName();
            int netID = this.getNetID(this.getNetlist().getNetwork(g));
            PortCharacteristic type = globNets.getCharacteristic(g);
            ExportGlobal eg = (ExportGlobal)nameToExport.get(nm);
            if (eg != null) {
                if (eg.netID == netID && eg.type == type) continue;
                System.out.println("  Error! Cell: " + this.getCell().libDescribe() + " has both an Export and a global signal " + "named: " + nm + " but their networks or " + "Characteristics differ");
                throw new ExportGlobalConflict();
            }
            eg = new ExportGlobal(nm, netID, type);
            expGlob.add(eg);
        }
        return expGlob.iterator();
    }
}

