/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.strategy;

import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.jemNets.NetObject;
import com.sun.electric.tool.ncc.jemNets.Part;
import com.sun.electric.tool.ncc.jemNets.Port;
import com.sun.electric.tool.ncc.jemNets.Wire;
import com.sun.electric.tool.ncc.lists.LeafList;
import com.sun.electric.tool.ncc.strategy.Strategy;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.Iterator;
import java.util.TreeMap;

public class StratCount
extends Strategy {
    private static final int INDENT_WIDTH = 4;
    private static final int LABEL_WIDTH = 30;
    private static final int FIELD_WIDTH = 15;
    private int maxDepth;
    private int numInternalRecs;
    private NetObjStats numMismatchedNetObjs = new NetObjStats(0);
    private NetObjStats numMatchedNetObjs = new NetObjStats(0);
    private NetObjStats numActiveNetObjs = new NetObjStats(0);
    private NetObjStats numMismatchedLeafRecs = new NetObjStats(0);
    private NetObjStats numMatchedLeafRecs = new NetObjStats(0);
    private NetObjStats numActiveLeafRecs = new NetObjStats(0);
    private int numCircuits;
    private int totalEqGrpSize;
    private int numberOfWireConnections;
    private long numberOfWireConnectionsSquared;
    private int numberOfPartConnections;
    private String workingOnString;
    private NetObject.Type netObjType;
    private SizeHistogram sizeHistogram = new SizeHistogram();

    private StratCount(NccGlobals globals) {
        super(globals);
    }

    private static String spaces(int num) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < num; ++i) {
            b.append(" ");
        }
        return b.toString();
    }

    private static String rightJustifyInField(String s, int fieldWidth) {
        return StratCount.spaces(fieldWidth - s.length()) + s;
    }

    private static String leftJustifyInField(String s, int fieldWidth) {
        return s + StratCount.spaces(fieldWidth - s.length());
    }

    private void printLine(String label, NetObjStats stats) {
        this.globals.status2(StratCount.spaces(4) + StratCount.leftJustifyInField(label, 30) + stats.toString());
    }

    private void printLine(String label, int data) {
        this.globals.status2(StratCount.spaces(4) + StratCount.leftJustifyInField(label, 30) + StratCount.rightJustifyInField(String.valueOf(data), 15));
    }

    private void printLine(String label, double data) {
        data = Math.rint(data * 10.0) / 10.0;
        this.globals.status2(StratCount.spaces(4) + StratCount.leftJustifyInField(label, 30) + StratCount.rightJustifyInField(String.valueOf(data), 15));
    }

    private void preamble(EquivRecord j) {
        this.startTime("StratCount", "statistics for entire equivalence class tree");
    }

    private Counts summary() {
        this.globals.status2(StratCount.spaces(34) + StratCount.rightJustifyInField("Parts", 15) + StratCount.rightJustifyInField("Wires", 15) + StratCount.rightJustifyInField("Ports", 15));
        this.printLine("# mismatched equiv classes", this.numMismatchedLeafRecs);
        this.printLine("# matched equiv classes", this.numMatchedLeafRecs);
        this.printLine("# active equiv classes", this.numActiveLeafRecs);
        this.printLine("# mismatched net objects", this.numMismatchedNetObjs);
        this.printLine("# matched net objects", this.numMatchedNetObjs);
        this.printLine("# active net objects", this.numActiveNetObjs);
        int numEquivRecs = this.numMismatchedLeafRecs.getSumForAllTypes() + this.numMatchedLeafRecs.getSumForAllTypes() + this.numActiveLeafRecs.getSumForAllTypes();
        this.globals.status2("");
        this.sizeHistogram.print();
        this.globals.status2("");
        this.printLine("max tree depth", this.maxDepth);
        if (this.maxDepth > 1000) {
            System.out.println("Tell Russell that max tree depth = " + this.maxDepth);
        }
        this.elapsedTime();
        return new Counts(this.numMatchedLeafRecs.get(NetObject.Type.PART), this.numMatchedLeafRecs.get(NetObject.Type.WIRE), this.numMismatchedLeafRecs.get(NetObject.Type.PART), this.numMismatchedLeafRecs.get(NetObject.Type.WIRE));
    }

    public LeafList doFor(EquivRecord j) {
        if (j.isLeaf()) {
            this.doEquivRec(j);
        } else {
            ++this.numInternalRecs;
        }
        return super.doFor(j);
    }

    private void doEquivRec(EquivRecord er) {
        int erSize = er.maxSize();
        this.totalEqGrpSize += erSize;
        this.netObjType = er.getNetObjType();
        int numNetObjs = er.numNetObjs();
        if (er.isMismatched()) {
            this.numMismatchedLeafRecs.incr(this.netObjType, 1);
            this.numMismatchedNetObjs.incr(this.netObjType, numNetObjs);
            this.sizeHistogram.incr(this.netObjType, erSize);
        } else if (er.isMatched()) {
            this.numMatchedLeafRecs.incr(this.netObjType, 1);
            this.numMatchedNetObjs.incr(this.netObjType, numNetObjs);
            this.sizeHistogram.incr(this.netObjType, erSize);
        } else {
            this.numActiveLeafRecs.incr(this.netObjType, 1);
            this.numActiveNetObjs.incr(this.netObjType, numNetObjs);
            this.sizeHistogram.incr(this.netObjType, erSize);
        }
        this.numCircuits += er.numCircuits();
    }

    public Integer doFor(NetObject n) {
        this.error(n.getNetObjType() != this.netObjType, "mixed type leaf record");
        this.maxDepth = Math.max(this.maxDepth, this.getDepth());
        if (n instanceof Wire) {
            this.doFor((Wire)n);
        } else if (n instanceof Part) {
            this.doFor((Part)n);
        } else {
            this.error(!(n instanceof Port), "expecting Port");
        }
        return CODE_NO_CHANGE;
    }

    private void doFor(Wire w) {
        int n = w.numParts();
        this.numberOfWireConnections += n;
        float nf = n;
        this.numberOfWireConnectionsSquared = (long)((float)this.numberOfWireConnectionsSquared + nf * nf);
    }

    private void doFor(Part p) {
        this.numberOfPartConnections += p.getNumWiresConnected();
    }

    public static Counts doYourJob(NccGlobals globals) {
        EquivRecord root = globals.getRoot();
        StratCount jsc = new StratCount(globals);
        jsc.preamble(root);
        jsc.doFor(root);
        return jsc.summary();
    }

    public static class Counts {
        public final int numMatchedPartEquivRecs;
        public final int numMatchedWireEquivRecs;
        public final int numMismatchedPartEquivRecs;
        public final int numMismatchedWireEquivRecs;

        public Counts(int matchPartER, int matchWireER, int mismatchPartER, int mismatchWireER) {
            this.numMatchedPartEquivRecs = matchPartER;
            this.numMatchedWireEquivRecs = matchWireER;
            this.numMismatchedPartEquivRecs = mismatchPartER;
            this.numMismatchedWireEquivRecs = mismatchWireER;
        }
    }

    private class SizeHistogram {
        TreeMap sizeToStats = new TreeMap();

        private SizeHistogram() {
        }

        void incr(NetObject.Type type, int size) {
            Integer sz = new Integer(size);
            NetObjStats stats = (NetObjStats)this.sizeToStats.get(sz);
            if (stats == null) {
                stats = new NetObjStats(0);
                this.sizeToStats.put(sz, stats);
            }
            stats.incr(type, 1);
        }

        void print() {
            StratCount.this.globals.status2(StratCount.spaces(4) + StratCount.leftJustifyInField("LeafRec size", 30) + StratCount.rightJustifyInField("#Part_Recs", 15) + StratCount.rightJustifyInField("#Wire_Recs", 15) + StratCount.rightJustifyInField("#Port_Recs", 15));
            Iterator it = this.sizeToStats.keySet().iterator();
            while (it.hasNext()) {
                Integer key = (Integer)it.next();
                NetObjStats stats = (NetObjStats)this.sizeToStats.get(key);
                StratCount.this.printLine(StratCount.rightJustifyInField(key.toString(), 7), stats);
            }
        }
    }

    private static class NetObjStats {
        private static final int NUM_TYPES = 3;
        private int[] data = new int[3];

        NetObjStats(int initialVal) {
            for (int i = 0; i < 3; ++i) {
                this.data[i] = initialVal;
            }
        }

        public void incr(NetObject.Type type, int delta) {
            int n = type.ordinal();
            this.data[n] = this.data[n] + delta;
        }

        public int get(NetObject.Type type) {
            return this.data[type.ordinal()];
        }

        public int getSumForAllTypes() {
            int sum = 0;
            for (int i = 0; i < 3; ++i) {
                sum += this.data[i];
            }
            return sum;
        }

        public String toString() {
            String out = "";
            for (int i = 0; i < 3; ++i) {
                String v = String.valueOf(this.data[i]);
                out = out + StratCount.rightJustifyInField(v, 15);
            }
            return out;
        }
    }
}

