/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.logicaleffort;

import com.sun.electric.tool.logicaleffort.Instance;
import com.sun.electric.tool.logicaleffort.Pin;
import java.util.ArrayList;
import java.util.Iterator;

public class Net {
    private String name;
    private ArrayList pins;

    protected Net(String name) {
        this.name = name;
        this.pins = new ArrayList();
    }

    protected boolean isDrivenBySizeableGate() {
        Iterator it = this.pins.iterator();
        while (it.hasNext()) {
            Pin pin = (Pin)it.next();
            Instance inst = pin.getInstance();
            if (pin.getDir() != Pin.Dir.OUTPUT || inst.getType() != Instance.Type.LEGATE) continue;
            return true;
        }
        return false;
    }

    protected boolean isDrivenByStaticGate() {
        Iterator it = this.pins.iterator();
        while (it.hasNext()) {
            Pin pin = (Pin)it.next();
            Instance inst = pin.getInstance();
            if (pin.getDir() != Pin.Dir.OUTPUT || inst.getType() != Instance.Type.STATICGATE) continue;
            return true;
        }
        return false;
    }

    protected boolean isDrivenByGate() {
        Iterator it = this.pins.iterator();
        while (it.hasNext()) {
            Pin pin = (Pin)it.next();
            Instance inst = pin.getInstance();
            if (pin.getDir() != Pin.Dir.OUTPUT || inst.getType() != Instance.Type.LEGATE && inst.getType() != Instance.Type.STATICGATE) continue;
            return true;
        }
        return false;
    }

    protected boolean drivesSizableGate() {
        Iterator it = this.pins.iterator();
        while (it.hasNext()) {
            Pin pin = (Pin)it.next();
            Instance inst = pin.getInstance();
            if (pin.getDir() != Pin.Dir.INPUT || inst.getType() != Instance.Type.LEGATE) continue;
            return true;
        }
        return false;
    }

    protected boolean drivesStaticGate() {
        Iterator it = this.pins.iterator();
        while (it.hasNext()) {
            Pin pin = (Pin)it.next();
            Instance inst = pin.getInstance();
            if (pin.getDir() != Pin.Dir.INPUT || inst.getType() != Instance.Type.STATICGATE) continue;
            return true;
        }
        return false;
    }

    protected boolean drivesLoad() {
        Iterator it = this.pins.iterator();
        while (it.hasNext()) {
            Pin pin = (Pin)it.next();
            Instance inst = pin.getInstance();
            if (pin.getDir() != Pin.Dir.INPUT || inst.getType() != Instance.Type.LOAD && inst.getType() != Instance.Type.WIRE) continue;
            return true;
        }
        return false;
    }

    protected void addPin(Pin pin) {
        this.pins.add(pin);
        pin.setNet(this);
    }

    protected ArrayList getAllPins() {
        return this.pins;
    }

    protected ArrayList getOutputPins() {
        return Pin.getOutputPins(this.pins);
    }

    protected ArrayList getInputPins() {
        return Pin.getInputPins(this.pins);
    }

    protected ArrayList getInoutPins() {
        return Pin.getInoutPins(this.pins);
    }

    protected String getName() {
        return this.name;
    }
}

