/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.IdMapper;
import com.sun.electric.database.LibId;
import com.sun.electric.database.LibraryBackup;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.constraint.Constraints;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.Listener;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.cvspm.CVS;
import com.sun.electric.tool.cvspm.CVSLibrary;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.output.ArchSim;
import com.sun.electric.tool.io.output.CIF;
import com.sun.electric.tool.io.output.DELIB;
import com.sun.electric.tool.io.output.DXF;
import com.sun.electric.tool.io.output.ECAD;
import com.sun.electric.tool.io.output.EDIF;
import com.sun.electric.tool.io.output.ELIB;
import com.sun.electric.tool.io.output.Eagle;
import com.sun.electric.tool.io.output.FastHenry;
import com.sun.electric.tool.io.output.GDS;
import com.sun.electric.tool.io.output.HPGL;
import com.sun.electric.tool.io.output.IRSIM;
import com.sun.electric.tool.io.output.JELIB;
import com.sun.electric.tool.io.output.L;
import com.sun.electric.tool.io.output.LEF;
import com.sun.electric.tool.io.output.MOSSIM;
import com.sun.electric.tool.io.output.Maxwell;
import com.sun.electric.tool.io.output.PAL;
import com.sun.electric.tool.io.output.Pads;
import com.sun.electric.tool.io.output.PostScript;
import com.sun.electric.tool.io.output.ReadableDump;
import com.sun.electric.tool.io.output.Silos;
import com.sun.electric.tool.io.output.Sim;
import com.sun.electric.tool.io.output.Spice;
import com.sun.electric.tool.io.output.Tegas;
import com.sun.electric.tool.io.output.Verilog;
import com.sun.electric.tool.user.User;
import java.awt.geom.Rectangle2D;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Output {
    static final Comparator<Export> EXPORTS_ORDER = new OrderedExports();
    protected String filePath;
    protected PrintWriter printWriter;
    protected DataOutputStream dataOutputStream;
    HashMap<Object, Integer> objInfo;
    int[] faceMap;
    TreeMap<String, Short> nameSpace;
    protected boolean quiet;
    private int lineCharCount = 0;
    private int maxWidth = 80;
    private boolean strictWidthLimit = false;
    private char commentChar = '\u0000';
    private String continuationString = "";

    public static void exportCellCommand(Cell cell, VarContext context, String filePath, FileType type, List<PolyBase> override) {
        new OutputCellInfo(cell, context, filePath, type, override);
    }

    protected boolean writeCell(Cell cell, VarContext context) {
        return true;
    }

    public static boolean writePanicSnapshot(Snapshot panicSnapshot, File panicDir, boolean oldRevision) {
        FileType type = FileType.JELIB;
        HashMap<LibId, URL> libFiles = new HashMap<LibId, URL>();
        TreeMap<String, LibId> sortedLibs = new TreeMap<String, LibId>(TextUtils.STRING_NUMBER_ORDER);
        for (LibraryBackup libBackup : panicSnapshot.libBackups) {
            if (libBackup == null || (libBackup.d.flags & 0x80) != 0) continue;
            LibId libId = libBackup.d.libId;
            String libName = libBackup.d.libId.libName;
            URL libURL = libBackup.d.libFile;
            File newLibFile = null;
            if (libURL == null || libURL.getPath() == null) {
                newLibFile = new File(panicDir.getAbsolutePath(), libName + "." + type.getExtensions()[0]);
            } else {
                File libFile = new File(libURL.getPath());
                String fileName = libFile.getName();
                if (fileName == null) {
                    fileName = libName + "." + type.getExtensions()[0];
                }
                newLibFile = new File(panicDir.getAbsolutePath(), fileName);
            }
            URL newLibURL = TextUtils.makeURLToFile(newLibFile.getAbsolutePath());
            libFiles.put(libId, newLibURL);
            sortedLibs.put(libName, libId);
        }
        boolean error = false;
        for (LibId libId : sortedLibs.values()) {
            System.out.print(".");
            System.out.flush();
            JELIB jelib = new JELIB();
            URL libURL = (URL)libFiles.get(libId);
            String properOutputName = TextUtils.getFilePath(libURL) + TextUtils.getFileNameWithoutExtension(libURL) + ".jelib";
            if (!jelib.openTextOutputStream(properOutputName) && !jelib.writeLib(panicSnapshot, libId, libFiles, oldRevision) && !jelib.closeTextOutputStream()) continue;
            System.out.println("Error saving " + panicSnapshot.getLib((LibId)libId).d.libId.libName);
            error = true;
        }
        System.out.println(" Libraries saved");
        return error;
    }

    public static boolean saveJelib(String newName, Library lib) {
        HashMap<LibId, URL> libFiles = new HashMap<LibId, URL>();
        URL libURL = lib.getLibFile();
        if (newName != null) {
            libURL = TextUtils.makeURLToFile(newName);
            libFiles.put(lib.getId(), libURL);
        }
        boolean error = false;
        JELIB jelib = new JELIB();
        String properOutputName = TextUtils.getFilePath(libURL) + TextUtils.getFileNameWithoutExtension(libURL) + ".jelib";
        if (jelib.openTextOutputStream(properOutputName) || jelib.writeLib(lib.getDatabase().backup(), lib.getId(), libFiles, false) || jelib.closeTextOutputStream()) {
            System.out.println("Error saving " + lib.getName());
            error = true;
        }
        return error;
    }

    public static boolean writeLibrary(Library lib, FileType type, boolean compatibleWith6, boolean quiet, boolean delibHeaderOnly) {
        String properOutputName;
        block40: {
            block37: {
                block39: {
                    File newFile;
                    int backupScheme;
                    String properOutputNameWithoutExtension;
                    block38: {
                        Technology tech;
                        Constraints.getCurrent().writeLibrary(lib);
                        Iterator<Listener> it = Tool.getListeners();
                        while (it.hasNext()) {
                            Listener listener = it.next();
                            listener.writeLibrary(lib);
                        }
                        double largestScale = 0.0;
                        Iterator<Technology> it2 = Technology.getTechnologies();
                        while (it2.hasNext()) {
                            tech = it2.next();
                            if (tech.isScaleRelevant() || tech == Generic.tech || !(tech.getScale() > largestScale)) continue;
                            largestScale = tech.getScale();
                        }
                        it2 = Technology.getTechnologies();
                        while (it2.hasNext()) {
                            tech = it2.next();
                            if (tech.isScaleRelevant() || tech == Generic.tech) continue;
                            tech.setScale(largestScale);
                        }
                        URL libFile = lib.getLibFile();
                        if (libFile == null) {
                            libFile = TextUtils.makeURLToFile(lib.getName());
                        }
                        properOutputName = properOutputNameWithoutExtension = TextUtils.getFilePath(libFile) + TextUtils.getFileNameWithoutExtension(libFile);
                        if (type == FileType.ELIB) {
                            properOutputName = properOutputName + ".elib";
                        }
                        if (type == FileType.JELIB) {
                            properOutputName = properOutputName + ".jelib";
                        }
                        if (type == FileType.DELIB) {
                            properOutputName = properOutputName + ".delib";
                        }
                        if (type == FileType.READABLEDUMP) {
                            properOutputName = properOutputName + ".txt";
                        }
                        if (type != FileType.ELIB && type != FileType.JELIB) break block37;
                        backupScheme = IOTool.getBackupRedundancy();
                        if (backupScheme != 1) break block38;
                        newFile = new File(properOutputName);
                        if (!newFile.exists()) break block39;
                        String backupFileName = properOutputName + "~";
                        File oldFile = new File(backupFileName);
                        boolean canRename = true;
                        if (oldFile.exists() && !oldFile.delete()) {
                            System.out.println("Unable to delete former library file " + oldFile);
                            canRename = false;
                        }
                        if (canRename && !newFile.renameTo(oldFile)) {
                            System.out.println("Unable to rename " + newFile + " to " + oldFile);
                        }
                        break block39;
                    }
                    if (backupScheme == 2 && (newFile = new File(properOutputName)).exists()) {
                        long modified = newFile.lastModified();
                        Date modifiedDate = new Date(modified);
                        SimpleDateFormat sdf = new SimpleDateFormat("-yyyy-MM-dd");
                        for (int i = 0; i < 1000; ++i) {
                            File oldFile;
                            String backupFileName = properOutputNameWithoutExtension + sdf.format(modifiedDate);
                            if (i != 0) {
                                backupFileName = backupFileName + "--" + i;
                            }
                            if ((oldFile = new File(backupFileName = backupFileName + "." + type.getExtensions()[0])).exists()) continue;
                            if (newFile.renameTo(oldFile)) break;
                            System.out.println("Unable to rename " + newFile + " to " + oldFile);
                            break;
                        }
                    }
                }
                if (type == FileType.ELIB) {
                    ELIB elib = new ELIB();
                    elib.quiet = quiet;
                    if (compatibleWith6) {
                        elib.write6Compatible();
                    }
                    if (elib.openBinaryOutputStream(properOutputName)) {
                        return true;
                    }
                    if (CVS.isEnabled()) {
                        CVSLibrary.savingLibrary(lib);
                    }
                    if (elib.writeLib(lib)) {
                        return true;
                    }
                    if (elib.closeBinaryOutputStream()) {
                        return true;
                    }
                } else {
                    JELIB jelib = new JELIB();
                    jelib.quiet = quiet;
                    if (jelib.openTextOutputStream(properOutputName)) {
                        return true;
                    }
                    if (CVS.isEnabled()) {
                        CVSLibrary.savingLibrary(lib);
                    }
                    if (jelib.writeLib(lib.getDatabase().backup(), lib.getId(), null, false)) {
                        return true;
                    }
                    if (jelib.closeTextOutputStream()) {
                        return true;
                    }
                }
                break block40;
            }
            if (type == FileType.READABLEDUMP) {
                ReadableDump readableDump = new ReadableDump();
                readableDump.quiet = quiet;
                if (readableDump.openTextOutputStream(properOutputName)) {
                    return true;
                }
                if (readableDump.writeLib(lib)) {
                    return true;
                }
                if (readableDump.closeTextOutputStream()) {
                    return true;
                }
            } else if (type == FileType.DELIB) {
                DELIB delib = new DELIB(delibHeaderOnly);
                delib.quiet = quiet;
                if (delib.openTextOutputStream(properOutputName)) {
                    return true;
                }
                if (CVS.isEnabled() && !delibHeaderOnly) {
                    CVSLibrary.savingLibrary(lib);
                }
                if (delib.writeLib(lib.getDatabase().backup(), lib.getId(), lib.getDelibCellFiles())) {
                    return true;
                }
                if (delib.closeTextOutputStream()) {
                    return true;
                }
                if (CVS.isEnabled() && !delibHeaderOnly) {
                    CVSLibrary.savedLibrary(lib, delib.getDeletedCellFiles(), delib.getWrittenCellFiles());
                }
            } else {
                System.out.println("Unknown export type: " + type);
                return true;
            }
        }
        lib.setFromDisk();
        if (!quiet) {
            System.out.println(properOutputName + " written");
        }
        lib.setVersion(Version.getVersion());
        return false;
    }

    public static void writeCell(Cell cell, VarContext context, String filePath, FileType type, List<PolyBase> override) {
        if (type == FileType.ARCHSIM) {
            ArchSim.writeArchSimFile(cell, filePath);
        } else if (type == FileType.CDL) {
            Spice.writeSpiceFile(cell, context, filePath, true);
        } else if (type == FileType.CIF) {
            CIF.writeCIFFile(cell, context, filePath);
        } else if (type == FileType.COSMOS) {
            Sim.writeSimFile(cell, context, filePath, type);
        } else if (type == FileType.DXF) {
            DXF.writeDXFFile(cell, filePath);
        } else if (type == FileType.EAGLE) {
            Eagle.writeEagleFile(cell, context, filePath);
        } else if (type == FileType.ECAD) {
            ECAD.writeECADFile(cell, context, filePath);
        } else if (type == FileType.EDIF) {
            EDIF.writeEDIFFile(cell, context, filePath);
        } else if (type == FileType.ESIM || type == FileType.RSIM) {
            Sim.writeSimFile(cell, context, filePath, type);
        } else if (type == FileType.FASTHENRY) {
            FastHenry.writeFastHenryFile(cell, context, filePath);
        } else if (type == FileType.HPGL) {
            HPGL.writeHPGLFile(cell, context, filePath);
        } else if (type == FileType.GDS) {
            GDS.writeGDSFile(cell, context, filePath);
        } else if (type == FileType.IRSIM) {
            IRSIM.writeIRSIMFile(cell, context, filePath);
        } else if (type == FileType.L) {
            L.writeLFile(cell, filePath);
        } else if (type == FileType.LEF) {
            LEF.writeLEFFile(cell, context, filePath);
        } else if (type == FileType.MAXWELL) {
            Maxwell.writeMaxwellFile(cell, context, filePath);
        } else if (type == FileType.MOSSIM) {
            MOSSIM.writeMOSSIMFile(cell, context, filePath);
        } else if (type == FileType.PADS) {
            Pads.writePadsFile(cell, context, filePath);
        } else if (type == FileType.PAL) {
            PAL.writePALFile(cell, context, filePath);
        } else if (type == FileType.POSTSCRIPT || type == FileType.EPS) {
            PostScript.writePostScriptFile(cell, filePath, override);
        } else if (type == FileType.SILOS) {
            Silos.writeSilosFile(cell, context, filePath);
        } else if (type == FileType.SKILL) {
            IOTool.writeSkill(cell, filePath, false);
        } else if (type == FileType.SKILLEXPORTSONLY) {
            IOTool.writeSkill(cell, filePath, true);
        } else if (type == FileType.SPICE) {
            Spice.writeSpiceFile(cell, context, filePath, false);
        } else if (type == FileType.TEGAS) {
            Tegas.writeTegasFile(cell, context, filePath);
        } else if (type == FileType.VERILOG) {
            Verilog.writeVerilogFile(cell, context, filePath);
        }
    }

    void gatherReferencedObjects(Library lib) {
        this.objInfo = new HashMap();
        this.nameSpace = new TreeMap(TextUtils.STRING_NUMBER_ORDER);
        Iterator<Cell> cIt = lib.getCells();
        while (cIt.hasNext()) {
            Cell cell = cIt.next();
            this.gatherCell(cell);
            Iterator<ElectricObject> it = cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                if (ni.getName() == null) {
                    System.out.println("ERROR: " + cell + " has " + ni + " with no name");
                }
                NodeProto np = ni.getProto();
                if (ni.isCellInstance()) {
                    this.gatherCell((Cell)np);
                } else {
                    this.gatherObj(np);
                    this.gatherObj(((PrimitiveNode)np).getTechnology());
                }
                Iterator<PortInst> pIt = ni.getPortInsts();
                while (pIt.hasNext()) {
                    PortInst pi = pIt.next();
                    this.gatherVariables(pi);
                }
                this.gatherVariables(ni);
                this.gatherFont(ni.getTextDescriptor(NodeInst.NODE_NAME));
                this.gatherFont(ni.getTextDescriptor(NodeInst.NODE_PROTO));
            }
            it = cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = (ArcInst)it.next();
                ArcProto ap = ai.getProto();
                this.gatherObj(ap);
                this.gatherObj(ap.getTechnology());
                this.gatherVariables(ai);
                this.gatherFont(ai.getTextDescriptor(ArcInst.ARC_NAME));
            }
            it = cell.getExports();
            while (it.hasNext()) {
                Export e = (Export)it.next();
                this.gatherVariables(e);
                this.gatherFont(e.getTextDescriptor(Export.EXPORT_NAME));
            }
            this.gatherVariables(cell);
        }
        this.gatherVariables(lib);
        Iterator<Comparable> it = Tool.getTools();
        while (it.hasNext()) {
            this.gatherMeaningPrefs(it.next());
        }
        it = Technology.getTechnologies();
        while (it.hasNext()) {
            this.gatherMeaningPrefs(it.next());
        }
        this.putNameSpace(Library.FONT_ASSOCIATIONS.getName());
        this.putNameSpace(NodeInst.NODE_NAME.getName());
        this.putNameSpace(ArcInst.ARC_NAME.getName());
        short varIndex = 0;
        for (Map.Entry<String, Short> e : this.nameSpace.entrySet()) {
            short s = varIndex;
            varIndex = (short)(varIndex + 1);
            e.setValue(new Short(s));
        }
    }

    private void gatherVariables(ElectricObject eObj) {
        Iterator<Variable> it = eObj.getVariables();
        while (it.hasNext()) {
            Variable var = it.next();
            Object value = var.getObjectInDatabase(EDatabase.serverDatabase());
            if (this.nameSpace != null) {
                this.putNameSpace(this.diskName(eObj, var));
            }
            this.gatherFont(var.getTextDescriptor());
            int length = value instanceof Object[] ? ((Object[])value).length : 1;
            for (int i = 0; i < length; ++i) {
                Object v;
                Object object = v = value instanceof Object[] ? ((Object[])value)[i] : value;
                if (v == null) continue;
                if (v instanceof Technology || v instanceof Tool) {
                    this.gatherObj(v);
                    continue;
                }
                if (v instanceof PrimitiveNode) {
                    this.gatherObj(v);
                    this.gatherObj(((PrimitiveNode)v).getTechnology());
                    continue;
                }
                if (v instanceof PrimitivePort) {
                    PrimitiveNode pn = ((PrimitivePort)v).getParent();
                    this.gatherObj(pn);
                    this.gatherObj(pn.getTechnology());
                    continue;
                }
                if (v instanceof ArcProto) {
                    this.gatherObj(v);
                    this.gatherObj(((ArcProto)v).getTechnology());
                    continue;
                }
                if (!(v instanceof ElectricObject)) continue;
                this.gatherObj(v);
                Cell cell = ((ElectricObject)v).whichCell();
                if (cell == null) continue;
                this.gatherCell(cell);
            }
        }
    }

    private void gatherMeaningPrefs(Object obj) {
        for (Pref pref : Pref.getMeaningVariables(obj)) {
            this.gatherObj(obj);
            String name = pref.getPrefName();
            if (this.nameSpace == null) continue;
            this.putNameSpace(name);
        }
    }

    private void gatherCell(Cell cell) {
        this.gatherObj(cell);
        this.gatherObj(cell.getLibrary());
        this.gatherObj(cell.getView());
    }

    private void gatherFont(TextDescriptor td) {
        int face = td.getFace();
        if (face != 0) {
            this.gatherObj(AbstractTextDescriptor.ActiveFont.findActiveFont(face));
        }
    }

    private void gatherObj(Object obj) {
        this.objInfo.put(obj, null);
    }

    void putObjIndex(Object obj, int index) {
        this.objInfo.put(obj, new Integer(index));
    }

    void putNameSpace(String name) {
        this.nameSpace.put(name, null);
    }

    String diskName(ElectricObject owner, Variable var) {
        String portName = null;
        if (owner instanceof PortInst) {
            PortInst pi = (PortInst)owner;
            portName = pi.getPortProto().getName();
        }
        return this.diskName(portName, var);
    }

    String diskName(String portName, Variable var) {
        if (portName == null) {
            return var.getKey().getName();
        }
        StringBuffer sb = new StringBuffer("ATTRP_");
        for (int i = 0; i < portName.length(); ++i) {
            char ch = portName.charAt(i);
            if (ch == '\\' || ch == '_') {
                sb.append('\\');
            }
            sb.append(ch);
        }
        sb.append('_');
        sb.append(var.getKey().getName());
        return sb.toString();
    }

    String[] createFontAssociation() {
        int maxIndices = AbstractTextDescriptor.ActiveFont.getMaxIndex();
        this.faceMap = new int[maxIndices + 1];
        TreeMap<String, AbstractTextDescriptor.ActiveFont> sortedFonts = new TreeMap<String, AbstractTextDescriptor.ActiveFont>();
        for (int i = 1; i <= maxIndices; ++i) {
            AbstractTextDescriptor.ActiveFont af = AbstractTextDescriptor.ActiveFont.findActiveFont(i);
            if (!this.objInfo.containsKey(af)) continue;
            sortedFonts.put(af.getName(), af);
        }
        if (sortedFonts.size() == 0) {
            return null;
        }
        String[] fontAssociation = new String[sortedFonts.size()];
        int face = 0;
        for (AbstractTextDescriptor.ActiveFont af : sortedFonts.values()) {
            this.faceMap[af.getIndex()] = ++face;
            fontAssociation[face - 1] = face + "/" + af.getName();
        }
        return fontAssociation;
    }

    protected boolean openBinaryOutputStream(String filePath) {
        FileOutputStream fileOutputStream;
        this.filePath = filePath;
        try {
            fileOutputStream = new FileOutputStream(filePath);
        }
        catch (FileNotFoundException e) {
            System.out.println("Could not write file " + filePath);
            System.out.println("Reason: " + e.getMessage());
            return true;
        }
        BufferedOutputStream bufStrm = new BufferedOutputStream(fileOutputStream);
        this.dataOutputStream = new DataOutputStream(bufStrm);
        return false;
    }

    protected boolean closeBinaryOutputStream() {
        try {
            this.dataOutputStream.close();
        }
        catch (IOException e) {
            System.out.println("Error closing " + this.filePath);
            return true;
        }
        return false;
    }

    protected boolean openTextOutputStream(String filePath) {
        this.filePath = filePath;
        try {
            this.printWriter = new PrintWriter(new BufferedWriter(new FileWriter(filePath)));
        }
        catch (IOException e) {
            System.out.println("Error opening " + filePath + ": " + e.getMessage());
            return true;
        }
        return false;
    }

    protected boolean closeTextOutputStream() {
        this.printWriter.close();
        return false;
    }

    protected void emitCopyright(String prefix, String postfix) {
        if (!IOTool.isUseCopyrightMessage()) {
            return;
        }
        String str = IOTool.getCopyrightMessage();
        int start = 0;
        while (start < str.length()) {
            int endPos = str.indexOf(10, start);
            if (endPos < 0) {
                endPos = str.length();
            }
            String oneLine = str.substring(start, endPos);
            this.printWriter.println(prefix + oneLine + postfix);
            start = endPos + 1;
        }
    }

    protected void setOutputWidth(int width, boolean strict) {
        this.maxWidth = width;
        this.strictWidthLimit = strict;
    }

    protected void setCommentChar(char ch) {
        this.commentChar = ch;
    }

    protected void setContinuationString(String str) {
        this.continuationString = str;
    }

    private void writeChunk(String str) {
        int len = str.length();
        if (len <= 0) {
            return;
        }
        this.printWriter.print(str);
        this.lineCharCount += len;
        if (str.charAt(len - 1) == '\n') {
            this.lineCharCount = 0;
        }
    }

    protected void writeWidthLimited(String str) {
        int len;
        while ((len = str.length()) > 0) {
            int i = str.indexOf(10);
            i = i < 0 ? len : ++i;
            if (this.lineCharCount + i < this.maxWidth) {
                String chunk = str;
                if (i < len) {
                    chunk = str.substring(0, i);
                }
                this.writeChunk(chunk);
                if ((str = str.substring(i)).length() != 0) continue;
                break;
            }
            int left = this.maxWidth - this.lineCharCount;
            String exact = str.substring(0, left);
            int splitPos = exact.lastIndexOf(32);
            if (splitPos < 0 && (splitPos = exact.lastIndexOf(44)) < 0 && (splitPos = exact.lastIndexOf(40)) < 0) {
                splitPos = exact.lastIndexOf(41);
            }
            if (splitPos > 0) {
                exact = exact.substring(0, splitPos + 1);
            } else if (!this.strictWidthLimit) {
                splitPos = str.indexOf(32, left);
                if (splitPos < 0 && (splitPos = str.indexOf(44, left)) < 0 && (splitPos = str.indexOf(40, left)) < 0) {
                    splitPos = str.indexOf(41, left);
                }
                if (splitPos > 0) {
                    exact = str.substring(0, splitPos + 1);
                }
            }
            this.writeChunk(exact);
            this.writeChunk("\n");
            if (this.continuationString.length() > 0) {
                this.writeChunk(this.continuationString);
            }
            str = str.substring(exact.length());
        }
    }

    public Rectangle2D getAreaToPrint(Cell cell, boolean reduce, EditWindow_ wnd) {
        Rectangle2D bounds = cell.getBounds();
        if (wnd != null) {
            bounds = wnd.getBoundsInWindow();
        }
        if (reduce) {
            double wid = bounds.getWidth() * 0.75;
            double hei = bounds.getHeight() * 0.75;
            bounds.setRect(bounds.getCenterX(), bounds.getCenterY(), wid, hei);
        }
        if (IOTool.getPlotArea() != 0) {
            if (wnd == null) {
                System.out.println("No current window: printing entire cell");
            } else if (IOTool.getPlotArea() == 2) {
                bounds = wnd.getDisplayedBounds();
            } else {
                Rectangle2D hBounds = wnd.getHighlightedArea();
                if (hBounds == null || hBounds.getWidth() == 0.0 || hBounds.getHeight() == 0.0) {
                    System.out.println("Warning: no highlighted area; printing entire cell");
                } else {
                    bounds = hBounds;
                }
            }
        }
        return bounds;
    }

    public static class WriteJELIB
    extends Job {
        private Library lib;
        private String newName;
        private IdMapper idMapper;

        public WriteJELIB(Library lib, String newName) {
            super("Write " + lib, User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.lib = lib;
            this.newName = newName;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            boolean error = false;
            try {
                if (this.newName != null) {
                    URL libURL = TextUtils.makeURLToFile(this.newName);
                    this.lib.setLibFile(libURL);
                    this.idMapper = this.lib.setName(TextUtils.getFileNameWithoutExtension(libURL));
                    if (this.idMapper != null) {
                        this.lib = EDatabase.serverDatabase().getLib(this.idMapper.get(this.lib.getId()));
                    }
                }
                this.fieldVariableChanged("idMapper");
                error = Output.writeLibrary(this.lib, FileType.JELIB, false, false, false);
            }
            catch (Exception e) {
                throw new JobException("Exception caught when saving library: " + e.getMessage());
            }
            return !error;
        }

        public void terminateOK() {
            User.fixStaleCellReferences(this.idMapper);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OutputCellInfo
    extends Job {
        private Cell cell;
        private VarContext context;
        private String filePath;
        private FileType type;
        private List<PolyBase> override;

        public OutputCellInfo(Cell cell, VarContext context, String filePath, FileType type, List<PolyBase> override) {
            super("Export " + cell + " (" + type + ")", IOTool.getIOTool(), Job.Type.EXAMINE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.context = context;
            this.filePath = filePath;
            this.type = type;
            this.override = override;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            Output.writeCell(this.cell, this.context, this.filePath, this.type, this.override);
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OrderedExports
    implements Comparator<Export> {
        OrderedExports() {
        }

        @Override
        public int compare(Export e1, Export e2) {
            int i2;
            int i1 = e1.getOriginalPort().getPortProto().getPortIndex();
            int cmp = i1 - (i2 = e2.getOriginalPort().getPortProto().getPortIndex());
            if (cmp != 0) {
                return cmp;
            }
            return e1.getPortIndex() - e2.getPortIndex();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NetNamesSort
    implements Comparator<NetNames> {
        NetNamesSort() {
        }

        @Override
        public int compare(NetNames nn1, NetNames nn2) {
            String name1 = nn1.netName;
            String name2 = nn2.netName;
            return name1.compareToIgnoreCase(name2);
        }
    }

    static class NetNames {
        String nodeName;
        String netName;
        String portName;

        NetNames() {
        }
    }
}

