/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.DisplayedText;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.MutableTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class ChangeText
extends EDialog {
    private static boolean lastNodesSelected = false;
    private static boolean lastArcsSelected = false;
    private static boolean lastExportsSelected = false;
    private static boolean lastAnnotationsSelected = false;
    private static boolean lastInstancesSelected = false;
    private static boolean lastCellsSelected = false;
    private ChangeParameters cp;
    private Cell cell;
    private EditWindow wnd;
    private JCheckBox bold;
    private JButton cancel;
    private JRadioButton changeAllInCell;
    private JRadioButton changeAllInLibrary;
    private JCheckBox changeAnnotationText;
    private JCheckBox changeArcText;
    private JCheckBox changeCellText;
    private JRadioButton changeCellsWithView;
    private JCheckBox changeExportText;
    private JCheckBox changeInstanceText;
    private JCheckBox changeNodeText;
    private JRadioButton changeSelectedObjects;
    private JComboBox font;
    private JCheckBox italic;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JButton ok;
    private JTextField pointSize;
    private JLabel selectedText;
    private ButtonGroup sizeGroup;
    private JCheckBox underline;
    private JTextField unitSize;
    private JRadioButton usePoints;
    private JRadioButton useUnits;
    private JComboBox viewList;
    private ButtonGroup whereGroup;

    private void gatherTextChoices() {
        lastNodesSelected = this.cp.nodesSelected = this.changeNodeText.isSelected();
        lastArcsSelected = this.cp.arcsSelected = this.changeArcText.isSelected();
        lastExportsSelected = this.cp.exportsSelected = this.changeExportText.isSelected();
        lastAnnotationsSelected = this.cp.annotationsSelected = this.changeAnnotationText.isSelected();
        lastInstancesSelected = this.cp.instancesSelected = this.changeInstanceText.isSelected();
        lastCellsSelected = this.cp.cellsSelected = this.changeCellText.isSelected();
        this.cp.changeSelectedObjects = this.changeSelectedObjects.isSelected();
        this.cp.changeAllInCell = this.changeAllInCell.isSelected();
        this.cp.changeCellsWithView = this.changeCellsWithView.isSelected();
        this.cp.changeAllInLibrary = this.changeAllInLibrary.isSelected();
        this.cp.usePoints = this.usePoints.isSelected();
        this.cp.pointSize = this.pointSize.getText();
        this.cp.unitSize = this.unitSize.getText();
        this.cp.selectedFontIndex = this.font.getSelectedIndex();
        this.cp.selectedFontName = (String)this.font.getSelectedItem();
        this.cp.isBold = this.bold.isSelected();
        this.cp.isItalic = this.italic.isSelected();
        this.cp.isUnderline = this.underline.isSelected();
        this.cp.viewListSelection = (String)this.viewList.getSelectedItem();
    }

    public static void changeTextDialog() {
        ChangeText dialog = new ChangeText((Frame)TopLevel.getCurrentJFrame(), true);
        dialog.setVisible(true);
    }

    private ChangeText(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.ok);
        this.useUnits.setSelected(true);
        this.changeNodeText.setSelected(lastNodesSelected);
        this.changeArcText.setSelected(lastArcsSelected);
        this.changeExportText.setSelected(lastExportsSelected);
        this.changeAnnotationText.setSelected(lastAnnotationsSelected);
        this.changeInstanceText.setSelected(lastInstancesSelected);
        this.changeCellText.setSelected(lastCellsSelected);
        this.cell = WindowFrame.getCurrentCell();
        this.wnd = EditWindow.getCurrent();
        for (View view : View.getOrderedViews()) {
            this.viewList.addItem(view.getFullName());
        }
        this.font.addItem("DEFAULT FONT");
        Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        for (int i = 0; i < fonts.length; ++i) {
            this.font.addItem(fonts[i].getFontName());
        }
        if (this.wnd == null || this.wnd.getHighlighter().getNumHighlights() == 0) {
            this.changeSelectedObjects.setEnabled(false);
            this.changeAllInCell.setSelected(true);
        } else {
            this.changeSelectedObjects.setSelected(true);
        }
        this.cp = new ChangeParameters();
        this.gatherTextChoices();
        this.findSelectedText();
        this.changeSelectedObjects.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChangeText.this.gatherTextChoices();
                ChangeText.this.findSelectedText();
            }
        });
        this.changeAllInCell.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChangeText.this.gatherTextChoices();
                ChangeText.this.findSelectedText();
            }
        });
        this.changeCellsWithView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChangeText.this.gatherTextChoices();
                ChangeText.this.findSelectedText();
            }
        });
        this.viewList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChangeText.this.gatherTextChoices();
                ChangeText.this.findSelectedText();
            }
        });
        this.changeAllInLibrary.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChangeText.this.gatherTextChoices();
                ChangeText.this.findSelectedText();
            }
        });
        this.changeNodeText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChangeText.this.findSelectedText();
            }
        });
        this.changeArcText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChangeText.this.findSelectedText();
            }
        });
        this.changeExportText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChangeText.this.findSelectedText();
            }
        });
        this.changeAnnotationText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChangeText.this.findSelectedText();
            }
        });
        this.changeInstanceText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChangeText.this.findSelectedText();
            }
        });
        this.changeCellText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChangeText.this.findSelectedText();
            }
        });
        this.finishInitialization();
    }

    protected void escapePressed() {
        this.cancelActionPerformed(null);
    }

    private void findSelectedText() {
        this.gatherTextChoices();
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        this.cp.numToChange = 0;
        this.cp.lowPointSize = -1;
        this.cp.lowUnitSize = -1.0;
        if (this.cp.changeSelectedObjects) {
            EditWindow wnd = EditWindow.getCurrent();
            if (wnd != null) {
                for (DisplayedText dt : wnd.getHighlighter().getHighlightedText(false)) {
                    ChangeText.accumulateTextFound(this.cp, dt.getElectricObject(), dt.getVariableKey(), false);
                }
            }
        } else if (this.cp.changeAllInCell) {
            ChangeText.findAllInCell(this.cp, cell, false);
        } else if (this.cp.changeCellsWithView) {
            View v = View.findView(this.cp.viewListSelection);
            if (v != null) {
                Iterator<Cell> it = Library.getCurrent().getCells();
                while (it.hasNext()) {
                    Cell c = it.next();
                    if (c.getView() != v) continue;
                    ChangeText.findAllInCell(this.cp, c, false);
                }
            }
        } else if (this.cp.changeAllInLibrary) {
            Iterator<Cell> it = Library.getCurrent().getCells();
            while (it.hasNext()) {
                Cell c = it.next();
                ChangeText.findAllInCell(this.cp, c, false);
            }
        }
        if (this.cp.numToChange == 0) {
            this.selectedText.setText("No text to change");
        } else {
            String what = "Text runs from ";
            if (this.cp.lowPointSize >= 0) {
                what = what + this.cp.lowPointSize + " to " + this.cp.highPointSize + " points";
            }
            if (this.cp.lowUnitSize >= 0.0) {
                if (this.cp.lowPointSize >= 0) {
                    what = what + "; ";
                }
                what = what + this.cp.lowUnitSize + " to " + this.cp.highUnitSize + " units";
            }
            this.selectedText.setText(what);
            if (this.cp.lowUnitSize >= 0.0) {
                this.useUnits.setSelected(true);
                this.unitSize.setText(TextUtils.formatDouble(this.cp.highUnitSize));
            } else {
                this.usePoints.setSelected(true);
                this.pointSize.setText(Integer.toString(this.cp.highPointSize));
            }
        }
    }

    private static void changeSelectedText(Cell cell, ChangeParameters cp) {
        block6: {
            block8: {
                block7: {
                    block5: {
                        if (!cp.changeSelectedObjects) break block5;
                        if (CircuitChangeJobs.cantEdit(cell, null, true) != 0) {
                            return;
                        }
                        EditWindow wnd = EditWindow.getCurrent();
                        if (wnd == null) break block6;
                        for (DisplayedText dt : wnd.getHighlighter().getHighlightedText(false)) {
                            ChangeText.accumulateTextFound(cp, dt.getElectricObject(), dt.getVariableKey(), true);
                        }
                        break block6;
                    }
                    if (!cp.changeAllInCell) break block7;
                    ChangeText.findAllInCell(cp, cell, true);
                    break block6;
                }
                if (!cp.changeCellsWithView) break block8;
                View v = View.findView(cp.viewListSelection);
                if (v == null) break block6;
                Iterator<Cell> it = Library.getCurrent().getCells();
                while (it.hasNext()) {
                    Cell c = it.next();
                    if (c.getView() != v) continue;
                    ChangeText.findAllInCell(cp, c, true);
                }
                break block6;
            }
            if (cp.changeAllInLibrary) {
                Iterator<Cell> it = Library.getCurrent().getCells();
                while (it.hasNext()) {
                    Cell c = it.next();
                    ChangeText.findAllInCell(cp, c, true);
                }
            }
        }
    }

    private static void findAllInCell(ChangeParameters cp, Cell cell, boolean change) {
        Variable var;
        Iterator<Variable> vIt;
        if (change && CircuitChangeJobs.cantEdit(cell, null, true) != 0) {
            return;
        }
        Iterator<Object> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            if (ni.isCellInstance() && !ni.isExpanded()) {
                ChangeText.accumulateTextFound(cp, ni, NodeInst.NODE_PROTO, change);
            }
            if (!ni.getNameKey().isTempname()) {
                ChangeText.accumulateTextFound(cp, ni, NodeInst.NODE_NAME, change);
            }
            vIt = ni.getVariables();
            while (vIt.hasNext()) {
                var = vIt.next();
                if (!var.isDisplay()) continue;
                ChangeText.accumulateTextFound(cp, ni, var.getKey(), change);
            }
        }
        it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            if (!ai.getNameKey().isTempname()) {
                ChangeText.accumulateTextFound(cp, ai, ArcInst.ARC_NAME, change);
            }
            vIt = ai.getVariables();
            while (vIt.hasNext()) {
                var = vIt.next();
                if (!var.isDisplay()) continue;
                ChangeText.accumulateTextFound(cp, ai, var.getKey(), change);
            }
        }
        it = cell.getPorts();
        while (it.hasNext()) {
            Export pp = (Export)it.next();
            ChangeText.accumulateTextFound(cp, pp, Export.EXPORT_NAME, change);
            vIt = pp.getVariables();
            while (vIt.hasNext()) {
                var = vIt.next();
                if (!var.isDisplay()) continue;
                ChangeText.accumulateTextFound(cp, pp, var.getKey(), change);
            }
        }
        Iterator<Variable> vIt2 = cell.getVariables();
        while (vIt2.hasNext()) {
            Variable var2 = vIt2.next();
            if (!var2.isDisplay()) continue;
            ChangeText.accumulateTextFound(cp, cell, var2.getKey(), change);
        }
    }

    private static void accumulateTextFound(ChangeParameters cp, ElectricObject eObj, Variable.Key varKey, boolean change) {
        if (eObj instanceof NodeInst) {
            NodeInst ni = (NodeInst)eObj;
            if (ni.getProto() == Generic.tech.invisiblePinNode) {
                if (cp.annotationsSelected && ChangeText.processText(cp, eObj, varKey, change)) {
                    cp.numAnnotationsChanged++;
                }
            } else if (varKey == NodeInst.NODE_PROTO) {
                if (cp.instancesSelected && ChangeText.processText(cp, eObj, varKey, change)) {
                    cp.numInstancesChanged++;
                }
            } else if (cp.nodesSelected && ChangeText.processText(cp, eObj, varKey, change)) {
                cp.numNodesChanged++;
            }
        } else if (eObj instanceof ArcInst) {
            if (cp.arcsSelected && ChangeText.processText(cp, eObj, varKey, change)) {
                cp.numArcsChanged++;
            }
        } else if (eObj instanceof Cell) {
            if (cp.cellsSelected && ChangeText.processText(cp, eObj, varKey, change)) {
                cp.numCellsChanged++;
            }
        } else if (eObj instanceof Export && cp.exportsSelected && ChangeText.processText(cp, eObj, varKey, change)) {
            cp.numExportsChanged++;
        }
    }

    private static boolean processText(ChangeParameters cp, ElectricObject owner, Variable.Key varKey, boolean change) {
        AbstractTextDescriptor.Size s = owner.getTextDescriptor(varKey).getSize();
        if (change) {
            AbstractTextDescriptor.ActiveFont newFont;
            boolean changed = false;
            MutableTextDescriptor td = owner.getMutableTextDescriptor(varKey);
            if (cp.usePoints) {
                int size = TextUtils.atoi(cp.pointSize);
                if (!s.isAbsolute() || s.getSize() != (double)size) {
                    td.setAbsSize(size);
                    changed = true;
                }
            } else {
                double size = TextUtils.atof(cp.unitSize);
                if (s.isAbsolute() || s.getSize() != size) {
                    td.setRelSize(size);
                    changed = true;
                }
            }
            int fontIndex = 0;
            if (cp.selectedFontIndex != 0 && (newFont = AbstractTextDescriptor.ActiveFont.findActiveFont(cp.selectedFontName)) != null) {
                fontIndex = newFont.getIndex();
            }
            if (fontIndex != td.getFace()) {
                td.setFace(fontIndex);
                changed = true;
            }
            if (cp.isBold != td.isBold()) {
                td.setBold(!td.isBold());
                changed = true;
            }
            if (cp.isItalic != td.isItalic()) {
                td.setItalic(!td.isItalic());
                changed = true;
            }
            if (cp.isUnderline != td.isUnderline()) {
                td.setUnderline(!td.isUnderline());
                changed = true;
            }
            if (changed) {
                owner.setTextDescriptor(varKey, TextDescriptor.newTextDescriptor(td));
            }
            return changed;
        }
        double size = s.getSize();
        if (cp.numToChange == 0) {
            if (s.isAbsolute()) {
                cp.lowPointSize = (cp.highPointSize = (int)size);
            } else {
                cp.lowUnitSize = (cp.highUnitSize = size);
            }
        } else if (s.isAbsolute()) {
            if ((int)size < cp.lowPointSize) {
                cp.lowPointSize = (int)size;
            }
            if ((int)size > cp.highPointSize) {
                cp.highPointSize = (int)size;
            }
        } else {
            if (size < cp.lowUnitSize) {
                cp.lowUnitSize = size;
            }
            if (size > cp.highUnitSize) {
                cp.highUnitSize = size;
            }
        }
        cp.numToChange++;
        return false;
    }

    private void initComponents() {
        this.sizeGroup = new ButtonGroup();
        this.whereGroup = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.changeNodeText = new JCheckBox();
        this.changeArcText = new JCheckBox();
        this.changeExportText = new JCheckBox();
        this.changeAnnotationText = new JCheckBox();
        this.changeInstanceText = new JCheckBox();
        this.changeCellText = new JCheckBox();
        this.selectedText = new JLabel();
        this.changeSelectedObjects = new JRadioButton();
        this.changeAllInCell = new JRadioButton();
        this.changeCellsWithView = new JRadioButton();
        this.viewList = new JComboBox();
        this.changeAllInLibrary = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.pointSize = new JTextField();
        this.unitSize = new JTextField();
        this.jLabel2 = new JLabel();
        this.usePoints = new JRadioButton();
        this.useUnits = new JRadioButton();
        this.jLabel3 = new JLabel();
        this.font = new JComboBox();
        this.bold = new JCheckBox();
        this.italic = new JCheckBox();
        this.underline = new JCheckBox();
        this.cancel = new JButton();
        this.ok = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Change Text Size");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ChangeText.this.closeDialog(evt);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(new TitledBorder("What to Change"));
        this.changeNodeText.setText("Change size of node text");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel1.add((Component)this.changeNodeText, gridBagConstraints);
        this.changeArcText.setText("Change size of arc text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel1.add((Component)this.changeArcText, gridBagConstraints);
        this.changeExportText.setText("Change size of export text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel1.add((Component)this.changeExportText, gridBagConstraints);
        this.changeAnnotationText.setText("Change size of annotation text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel1.add((Component)this.changeAnnotationText, gridBagConstraints);
        this.changeInstanceText.setText("Change size of instance name text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel1.add((Component)this.changeInstanceText, gridBagConstraints);
        this.changeCellText.setText("Change size of cell text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.jPanel1.add((Component)this.changeCellText, gridBagConstraints);
        this.selectedText.setText("No text to change");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.selectedText, gridBagConstraints);
        this.whereGroup.add(this.changeSelectedObjects);
        this.changeSelectedObjects.setText("Change only selected objects");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel1.add((Component)this.changeSelectedObjects, gridBagConstraints);
        this.whereGroup.add(this.changeAllInCell);
        this.changeAllInCell.setText("Change all in this cell");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel1.add((Component)this.changeAllInCell, gridBagConstraints);
        this.whereGroup.add(this.changeCellsWithView);
        this.changeCellsWithView.setText("Change all cells with view:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel1.add((Component)this.changeCellsWithView, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 20, 2, 4);
        this.jPanel1.add((Component)this.viewList, gridBagConstraints);
        this.whereGroup.add(this.changeAllInLibrary);
        this.changeAllInLibrary.setText("Change all in this library");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel1.add((Component)this.changeAllInLibrary, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(new TitledBorder("How to Change it"));
        this.pointSize.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.pointSize, gridBagConstraints);
        this.unitSize.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.jPanel2.add((Component)this.unitSize, gridBagConstraints);
        this.jLabel2.setText("Size:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints);
        this.sizeGroup.add(this.usePoints);
        this.usePoints.setText("Points (max 63)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.usePoints, gridBagConstraints);
        this.sizeGroup.add(this.useUnits);
        this.useUnits.setText("Units (max 127.75)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.useUnits, gridBagConstraints);
        this.jLabel3.setText("Font:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.jPanel2.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.font, gridBagConstraints);
        this.bold.setText("Bold");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.jPanel2.add((Component)this.bold, gridBagConstraints);
        this.italic.setText("Italic");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.jPanel2.add((Component)this.italic, gridBagConstraints);
        this.underline.setText("Underline");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        this.jPanel2.add((Component)this.underline, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChangeText.this.cancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cancel, gridBagConstraints);
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChangeText.this.okActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.pack();
    }

    private void okActionPerformed(ActionEvent evt) {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        this.gatherTextChoices();
        ChangeTextSizes job = new ChangeTextSizes(cell, this.cp);
        this.closeDialog(null);
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class ChangeTextSizes
    extends Job {
        private Cell cell;
        private ChangeParameters cp;

        private ChangeTextSizes(Cell cell, ChangeParameters cp) {
            super("Change Text Size", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.cp = cp;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            this.cp.numNodesChanged = (this.cp.numArcsChanged = (this.cp.numExportsChanged = 0));
            this.cp.numAnnotationsChanged = (this.cp.numInstancesChanged = (this.cp.numCellsChanged = 0));
            ChangeText.changeSelectedText(this.cell, this.cp);
            if (this.cp.numNodesChanged != 0 || this.cp.numArcsChanged != 0 || this.cp.numExportsChanged != 0 || this.cp.numAnnotationsChanged != 0 || this.cp.numInstancesChanged != 0 || this.cp.numCellsChanged != 0) {
                String what = "Changed text on";
                boolean others = false;
                if (this.cp.numNodesChanged != 0) {
                    what = what + " " + this.cp.numNodesChanged + " nodes";
                    others = true;
                }
                if (this.cp.numArcsChanged != 0) {
                    if (others) {
                        what = what + ", ";
                    }
                    what = what + " " + this.cp.numArcsChanged + " arcs";
                    others = true;
                }
                if (this.cp.numExportsChanged != 0) {
                    if (others) {
                        what = what + ", ";
                    }
                    what = what + " " + this.cp.numExportsChanged + " exports";
                    others = true;
                }
                if (this.cp.numAnnotationsChanged != 0) {
                    if (others) {
                        what = what + ", ";
                    }
                    what = what + " " + this.cp.numAnnotationsChanged + " annotations";
                    others = true;
                }
                if (this.cp.numInstancesChanged != 0) {
                    if (others) {
                        what = what + ", ";
                    }
                    what = what + " " + this.cp.numInstancesChanged + " instances";
                    others = true;
                }
                if (this.cp.numCellsChanged != 0) {
                    if (others) {
                        what = what + ", ";
                    }
                    what = what + " " + this.cp.numCellsChanged + " cells";
                    others = true;
                }
                System.out.println(what);
            }
            return true;
        }
    }

    private static class ChangeParameters
    implements Serializable {
        private boolean nodesSelected;
        private boolean arcsSelected;
        private boolean exportsSelected;
        private boolean annotationsSelected;
        private boolean instancesSelected;
        private boolean cellsSelected;
        private boolean changeSelectedObjects;
        private boolean changeAllInCell;
        private boolean changeCellsWithView;
        private boolean changeAllInLibrary;
        private boolean usePoints;
        private String pointSize;
        private String unitSize;
        private int selectedFontIndex;
        private String selectedFontName;
        private boolean isBold;
        private boolean isItalic;
        private boolean isUnderline;
        private String viewListSelection;
        private int numToChange;
        private int lowPointSize;
        private int highPointSize;
        private double lowUnitSize;
        private double highUnitSize;
        private int numNodesChanged;
        private int numArcsChanged;
        private int numExportsChanged;
        private int numAnnotationsChanged;
        private int numInstancesChanged;
        private int numCellsChanged;

        private ChangeParameters() {
        }
    }
}

