/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.projsettings;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.user.dialogs.ProjectSettingsFrame;
import com.sun.electric.tool.user.dialogs.projsettings.ProjSettingsPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ScaleTab
extends ProjSettingsPanel {
    private JList unitsTechnologyList;
    private DefaultListModel unitsTechnologyModel;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JPanel scale;
    private JLabel unitsAlternateScale;
    private JScrollPane unitsList;
    private JTextField unitsScaleValue;

    public ScaleTab(ProjectSettingsFrame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.scale;
    }

    public String getName() {
        return "Scale";
    }

    public void init() {
        this.unitsTechnologyModel = new DefaultListModel();
        this.unitsTechnologyList = new JList(this.unitsTechnologyModel);
        this.unitsTechnologyList.setSelectionMode(0);
        this.unitsList.setViewportView(this.unitsTechnologyList);
        this.unitsTechnologyList.clearSelection();
        this.unitsTechnologyList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ScaleTab.this.unitsClickTechnology();
            }
        });
        this.unitsTechnologyModel.clear();
        int wantIndex = 0;
        int index = 0;
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            if (!tech.isScaleRelevant()) continue;
            double shownScale = this.getDouble(tech.getScaleSetting());
            this.unitsTechnologyModel.addElement(tech.getTechName() + " (scale=" + shownScale + " nanometers)");
            if (tech == Technology.getCurrent()) {
                wantIndex = index;
            }
            ++index;
        }
        this.unitsTechnologyList.setSelectedIndex(wantIndex);
        this.unitsClickTechnology();
        this.unitsScaleValue.getDocument().addDocumentListener(new UnitsDocumentListener(this));
    }

    private void unitsNumbersChanged() {
        Technology tech;
        String str = (String)this.unitsTechnologyList.getSelectedValue();
        int spacePos = str.indexOf(" ");
        if (spacePos >= 0) {
            str = str.substring(0, spacePos);
        }
        if ((tech = Technology.findTechnology(str)) == null) {
            return;
        }
        double shownScale = TextUtils.atof(this.unitsScaleValue.getText());
        if (shownScale <= 0.0) {
            return;
        }
        this.setDouble(tech.getScaleSetting(), shownScale);
        String newLine = tech.getTechName() + " (scale=" + shownScale + " nanometers)";
        int index = this.unitsTechnologyList.getSelectedIndex();
        this.unitsTechnologyModel.set(index, newLine);
        this.unitsAlternateScale.setText("nanometers (" + shownScale / 1000.0 + " microns)");
    }

    private void unitsClickTechnology() {
        Technology tech;
        String str = (String)this.unitsTechnologyList.getSelectedValue();
        int spacePos = str.indexOf(" ");
        if (spacePos >= 0) {
            str = str.substring(0, spacePos);
        }
        if ((tech = Technology.findTechnology(str)) == null) {
            return;
        }
        double shownValue = this.getDouble(tech.getScaleSetting());
        this.unitsScaleValue.setText(TextUtils.formatDouble(shownValue));
        this.unitsAlternateScale.setText("nanometers (" + shownValue / 1000.0 + " microns)");
    }

    private void initComponents() {
        this.scale = new JPanel();
        this.unitsList = new JScrollPane();
        this.jLabel10 = new JLabel();
        this.unitsScaleValue = new JTextField();
        this.jLabel11 = new JLabel();
        this.unitsAlternateScale = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("IO Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ScaleTab.this.closeDialog(evt);
            }
        });
        this.scale.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.scale.add((Component)this.unitsList, gridBagConstraints);
        this.jLabel10.setText("The technology scale converts grid units to real spacing on the chip:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.scale.add((Component)this.jLabel10, gridBagConstraints);
        this.unitsScaleValue.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.scale.add((Component)this.unitsScaleValue, gridBagConstraints);
        this.jLabel11.setText("Technology scale:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.scale.add((Component)this.jLabel11, gridBagConstraints);
        this.unitsAlternateScale.setText("nanometers");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.scale.add((Component)this.unitsAlternateScale, gridBagConstraints);
        this.getContentPane().add((Component)this.scale, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class UnitsDocumentListener
    implements DocumentListener {
        ScaleTab dialog;

        UnitsDocumentListener(ScaleTab dialog) {
            this.dialog = dialog;
        }

        public void changedUpdate(DocumentEvent e) {
            this.dialog.unitsNumbersChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            this.dialog.unitsNumbersChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            this.dialog.unitsNumbersChanged();
        }
    }
}

