/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input.spicenetlist;

import com.sun.electric.tool.io.input.spicenetlist.SpiceInstance;
import com.sun.electric.tool.io.input.spicenetlist.SpiceNetlistReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpiceSubckt {
    private String name;
    private List<String> ports;
    private HashMap<String, String> params;
    private List<SpiceInstance> instances;
    private HashMap<String, PortType> porttypes;

    public SpiceSubckt(String name) {
        this.name = name;
        this.ports = new ArrayList<String>();
        this.params = new LinkedHashMap<String, String>();
        this.instances = new ArrayList<SpiceInstance>();
        this.porttypes = new HashMap();
    }

    public String getName() {
        return this.name;
    }

    public void addPort(String port) {
        this.ports.add(port);
    }

    public boolean hasPort(String portname) {
        return this.ports.contains(portname);
    }

    public boolean hasPortCaseInsensitive(String portname) {
        for (String port : this.ports) {
            if (!portname.equalsIgnoreCase(port)) continue;
            return true;
        }
        return false;
    }

    public List<String> getPorts() {
        return this.ports;
    }

    public String getParamValue(String name) {
        return this.params.get(name);
    }

    public HashMap<String, String> getParams() {
        return this.params;
    }

    void addInstance(SpiceInstance inst) {
        this.instances.add(inst);
    }

    public List<SpiceInstance> getInstances() {
        return this.instances;
    }

    public void setPortType(String port, PortType type) {
        if (this.ports.contains(port) && type != null) {
            this.porttypes.put(port, type);
        }
    }

    public PortType getPortType(String port) {
        return this.porttypes.get(port);
    }

    public void write(PrintStream out) {
        StringBuffer buf = new StringBuffer(".subckt ");
        buf.append(this.name);
        buf.append(" ");
        for (String port : this.ports) {
            buf.append(port);
            buf.append(" ");
        }
        for (String key : this.params.keySet()) {
            buf.append(key);
            buf.append("=");
            buf.append(this.params.get(key));
            buf.append(" ");
        }
        buf.append("\n");
        SpiceNetlistReader.multiLinePrint(out, false, buf.toString());
        for (SpiceInstance inst : this.instances) {
            inst.write(out);
        }
        out.println(".ends " + this.name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PortType {
        IN,
        OUT,
        BIDIR;

    }
}

