/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.CurrentReadable;
import com.sun.electric.tool.simulation.test.Infrastructure;
import com.sun.electric.tool.simulation.test.Logger;
import com.sun.electric.tool.simulation.test.VoltageReadable;

public abstract class PowerChannel
extends Logger
implements CurrentReadable,
VoltageReadable {
    public long maxSettleMsec = 4000L;
    public float settleResolution = 0.1f;
    public static final float DEFAULT_VOLTAGE_RESOLUTION = 0.01f;
    protected String name;

    public String toString() {
        Infrastructure.nonfatal("Please change toString() reference to getState()");
        return this.getName();
    }

    public String getState() {
        return this.getName() + ": " + this.readVoltage() + " V, " + this.readCurrent() + " A";
    }

    public String getName() {
        return this.name;
    }

    public abstract float readVoltage();

    public abstract float getVoltageSetpoint();

    public float getVoltageResolution() {
        return 0.01f;
    }

    public abstract void setVoltageNoWait(float var1);

    public void setVoltageWait(float volts) {
        this.setVoltageNoWait(volts);
        this.waitForVoltage(volts);
    }

    public void waitForVoltage(float setVolts) {
        float gotV;
        long endTime;
        long startTime = System.currentTimeMillis();
        float voltsErr = 1.001f * this.getVoltageResolution();
        do {
            boolean checkedSetpoint = false;
            try {
                Thread.sleep((int)(1000.0f * this.settleResolution));
            }
            catch (InterruptedException _) {
                // empty catch block
            }
            gotV = this.readVoltage();
            if (Math.abs(gotV - setVolts) <= voltsErr) {
                this.logOther("  " + this.getName() + ".waitForVoltage(): achieved " + gotV + " V");
                return;
            }
            if (!checkedSetpoint) {
                checkedSetpoint = true;
                float setpoint = this.getVoltageSetpoint();
                if ((double)Math.abs(setpoint - setVolts) > 1.0001 * (double)this.getVoltageResolution()) {
                    Infrastructure.fatal(this.getName() + ".waitForVoltage: requested setpoint is " + setVolts + " V, but actual setpoint is " + setpoint + ".  Voltage is " + gotV + " V and current is " + this.readCurrent() + " A.");
                }
            }
            try {
                Thread.sleep((int)(1000.0f * this.settleResolution));
            }
            catch (InterruptedException _) {
                // empty catch block
            }
        } while ((endTime = System.currentTimeMillis()) - startTime <= this.maxSettleMsec);
        Infrastructure.fatal(this.getName() + ".waitForVoltage: requested setpoint is " + setVolts + " V, but voltage is " + gotV + " V after " + (endTime - startTime) + " msec.  Actual setpoint is " + this.getVoltageSetpoint() + " V.  Current is " + this.readCurrent() + " A, setpoint is " + this.getCurrentSetpoint() + " A.");
    }

    public abstract void setCurrent(float var1);

    public abstract float getCurrentSetpoint();

    public float readCurrent(float ampsExpected, float ampsResolution) {
        System.err.println("WARNING: " + this.getName() + " does not support manual range and resolution setting");
        return this.readCurrent();
    }

    public abstract float readCurrent();
}

