/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.BitVector;
import com.sun.electric.tool.simulation.test.BypassJtagTester;
import com.sun.electric.tool.simulation.test.ChainNode;
import com.sun.electric.tool.simulation.test.ChipNode;
import com.sun.electric.tool.simulation.test.MyTreeNode;
import com.sun.electric.tool.simulation.test.NanosimModel;
import com.sun.electric.tool.simulation.test.NetscanGeneric;
import com.sun.electric.tool.simulation.test.SimulationModel;
import java.util.Random;

public class JtagTesterModel
extends BypassJtagTester {
    private final String tck;
    private final String tms;
    private final String trstb;
    private final String tdi;
    private final String tdob;
    private static final String SHIFT_IR = "1100";
    private static final String SHIFT_DR = "100";
    private static final String CAPTURE_DR = "10";
    private static final String IDLE = "110";
    private static final boolean DEBUG = true;

    JtagTesterModel(SimulationModel nm, String tck, String tms, String trstb, String tdi, String tdob) {
        super(nm);
        this.tck = tck;
        this.tms = tms;
        this.trstb = trstb;
        this.tdi = tdi;
        this.tdob = tdob;
        this.configure((float)nm.getVdd(), 100000L);
    }

    @Override
    public void reset() {
        if (this.model.isBypassScanning()) {
            this.model.setNodeState(this.trstb, 0);
            this.model.setNodeState(this.tck, 0);
            this.model.setNodeState(this.tms, 1);
            this.model.setNodeState(this.tdi, 0);
            this.model.waitNS(this.delay);
        } else {
            this.model.setNodeState(this.trstb, 0);
            this.model.setNodeState(this.tck, 0);
            this.model.setNodeState(this.tms, 1);
            this.model.setNodeState(this.tdi, 0);
            this.model.waitNS(this.delay);
            this.model.setNodeState(this.trstb, 1);
            this.model.setNodeState(this.tms, 0);
            this.cycle_tck(1);
        }
        System.out.println("Finished resetting JtagTester");
    }

    @Override
    public void tms_reset() {
        this.reset();
    }

    @Override
    void shift(ChainNode chain2, boolean readEnable, boolean writeEnable, int irBadSeverity) {
        if (this.isBypassScanning()) {
            this.doBypassScanning(chain2, readEnable, writeEnable);
            return;
        }
        String instruction = NetscanGeneric.getInstructionRegister(chain2, readEnable, writeEnable);
        this.task_load_instruction(instruction);
        MyTreeNode root2 = chain2.getParentChip().getParent();
        int numPrebits = 0;
        int numPostbits = 0;
        boolean foundChain = false;
        for (int i = 0; i < root2.getChildCount(); ++i) {
            MyTreeNode child = root2.getChildAt(i);
            if (!(child instanceof ChipNode)) continue;
            ChipNode chip = (ChipNode)child;
            if (chip == chain2.getParentChip()) {
                foundChain = true;
                continue;
            }
            if (foundChain) {
                ++numPostbits;
                continue;
            }
            ++numPrebits;
        }
        BitVector scanInBits = NetscanGeneric.padBitVector(chain2.getInBits(), numPrebits, numPostbits);
        String inbits = scanInBits.getState();
        String outbits = this.task_scan_data(inbits);
        BitVector scanOutBits = new BitVector(outbits.substring(numPrebits, outbits.length() - numPostbits), "outbits");
        if (this.isScanOutInverted()) {
            scanOutBits.flip(0, scanOutBits.getNumBits());
        }
        chain2.getOutBits().put(0, scanOutBits);
        if (writeEnable) {
            BitVector bitsToCheck = new BitVector(chain2.getInBits().getNumBits(), "bitsToCheck");
            bitsToCheck.set(0, chain2.getInBits().getNumBits(), true);
            this.checkDataNets(chain2, 0, bitsToCheck);
            this.checkDataNets(chain2, 1, bitsToCheck);
        }
    }

    private void cycle_tck(int times2) {
        for (int i = 0; i < times2; ++i) {
            this.model.waitNS(this.delay);
            this.model.setNodeState(this.tck, 1);
            this.model.waitNS(this.delay);
            this.model.setNodeState(this.tck, 0);
        }
    }

    private void task_goto(String IR) {
        int[] arr = JtagTesterModel.stringToIntArray(IR);
        for (int i = 0; i < arr.length; ++i) {
            this.model.setNodeState(this.tms, arr[i]);
            this.model.waitNS(1.0);
            this.cycle_tck(1);
        }
    }

    private int task_goto_send_tdo(String IR) {
        int[] arr = JtagTesterModel.stringToIntArray(IR);
        boolean sendLastBit = true;
        int out = -1;
        for (int i = 0; i < arr.length; ++i) {
            this.model.setNodeState(this.tms, arr[i]);
            if (sendLastBit) {
                sendLastBit = false;
                this.model.waitNS(this.delay + 1.0);
                this.model.setNodeState(this.tck, 1);
                out = this.model.getNodeState(this.tdob);
                this.model.waitNS(this.delay);
                this.model.setNodeState(this.tck, 0);
                continue;
            }
            this.model.waitNS(1.0);
            this.cycle_tck(1);
        }
        return out;
    }

    private void task_go_idle() {
        this.model.setNodeState(this.tms, 1);
        this.cycle_tck(5);
        this.model.setNodeState(this.tms, 0);
        this.cycle_tck(1);
    }

    void task_load_instruction(String opcode) {
        int[] arr = JtagTesterModel.stringToIntArray(JtagTesterModel.reverse(opcode));
        System.out.print("  Loading instruction " + opcode + ".");
        System.out.flush();
        this.task_goto(SHIFT_IR);
        this.model.setNodeState(this.tdi, arr[0]);
        System.out.print(".");
        System.out.flush();
        for (int i = 1; i < arr.length; ++i) {
            this.cycle_tck(1);
            this.model.setNodeState(this.tdi, arr[i]);
            System.out.print(".");
            System.out.flush();
        }
        this.task_goto(IDLE);
        System.out.println("...done.");
    }

    String task_scan_data(String data2) {
        String s;
        this.task_goto(SHIFT_DR);
        data2 = JtagTesterModel.reverse(data2);
        int[] arr = JtagTesterModel.stringToIntArray(data2);
        StringBuffer buf = new StringBuffer();
        System.out.println("  Scanning in  (reversed): " + data2);
        System.out.print("  Scanning out (reversed): ");
        for (int i = 0; i < arr.length - 1; ++i) {
            this.model.setNodeState(this.tdi, arr[i]);
            this.model.waitNS(0.5 * this.delay);
            this.model.setNodeState(this.tck, 1);
            this.model.waitNS(0.5 * this.delay);
            int n = this.model.getNodeState(this.tdob);
            s = String.valueOf(n);
            if (n < 0) {
                s = "X";
            }
            buf.append(s);
            System.out.print(s);
            System.out.flush();
            this.model.waitNS(0.5 * this.delay);
            this.model.setNodeState(this.tck, 0);
            this.model.waitNS(0.5 * this.delay);
        }
        this.model.setNodeState(this.tdi, arr[arr.length - 1]);
        this.model.waitNS(this.delay);
        int ret = this.task_goto_send_tdo(IDLE);
        s = String.valueOf(ret);
        if (ret < 0) {
            s = "X";
        }
        buf.append(s);
        System.out.println(s + "...done");
        System.out.flush();
        String outbits = JtagTesterModel.reverse(buf.toString());
        outbits = outbits.replace('X', '0');
        return outbits;
    }

    private static String reverse(String str) {
        StringBuffer buf = new StringBuffer();
        for (int i = str.length() - 1; i >= 0; --i) {
            buf.append(str.charAt(i));
        }
        return buf.toString();
    }

    private static int[] stringToIntArray(String str) {
        int[] arr = new int[str.length()];
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '1') {
                arr[i] = 1;
                continue;
            }
            if (str.charAt(i) == '0') {
                arr[i] = 0;
                continue;
            }
            System.out.println("Warning: Unknown char in string, setting to 0: " + str.charAt(i));
            arr[i] = 0;
        }
        return arr;
    }

    public static void main(String[] args) {
        NanosimModel nm = new NanosimModel();
        JtagTesterModel tester = (JtagTesterModel)nm.createJtagTester("TCK", "TMS", "TRSTb", "TDI", "TDOb");
        nm.start("nanosim", "loco_core.hsp", 0);
        tester.task_load_instruction("11000101");
        tester.task_scan_data("1000100010001111");
        tester.task_load_instruction("11001100");
        tester.task_scan_data("100010001000111101011100011");
        tester.task_scan_data("100010001000111101011100011");
        tester.task_scan_data("100010001000111101011100011");
        tester.task_scan_data("100010001000111101011100011");
        ChipNode cn = new ChipNode("test", 8, "none");
        ChainNode testNode = new ChainNode("testNode", "1001", 156, "node for unit test");
        cn.addChild(testNode);
        Random rand = new Random(309402934L);
        for (int i = 0; i < testNode.getInBits().getNumBits(); ++i) {
            testNode.getInBits().set(i, rand.nextBoolean());
        }
        System.out.println("Note that data shifted out is inverted sense of data shifted in,");
        System.out.println("  unless it goes through one of our inverting output pads first.");
        System.out.println("Unit Test: Shifting in: " + testNode.getInBits().getState());
        tester.shift(testNode, true, true, 0);
        System.out.println("Unit Test: Shifted out: " + testNode.getOutBits().getState());
        boolean match = true;
        for (int i = 0; i < testNode.getInBits().getNumBits(); ++i) {
            if (testNode.getInBits().get(i) == !testNode.getOutBits().get(i)) continue;
            match = false;
            break;
        }
        if (!match) {
            System.out.println("Unit Test Error: scan data in should match scan data out when chain is looped back.");
        } else {
            System.out.println("Unit Test OK.");
        }
        tester.model.finish();
    }
}

