/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool;

import com.sun.electric.Main;
import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.LibId;
import com.sun.electric.database.id.TechId;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.AbstractUserInterface;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.EJob;
import com.sun.electric.tool.EThread;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.StreamClient;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.MessagesStream;
import com.sun.electric.tool.user.User;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class ServerJobManager {
    private static final String CLASS_NAME = Job.class.getName();
    private static final int defaultNumThreads = Math.max(2, Runtime.getRuntime().availableProcessors());
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition databaseChangesMutex = this.lock.newCondition();
    private final ArrayList<EJob> startedJobs = new ArrayList();
    private final ArrayList<EJob> waitingJobs = new ArrayList();
    private final ServerSocket serverSocket;
    final ArrayList<Client> serverConnections = new ArrayList();
    private int passiveConnections;
    private int numThreads;
    private final int maxNumThreads;
    private boolean runningChangeJob;
    private boolean signalledEThread;
    private static int maxNumberOfThreads;

    void lock() {
        this.lock.lock();
    }

    void unlock() {
        this.lock.unlock();
    }

    ServerJobManager(int recommendedNumThreads, String loggingFilePath, boolean pipe, int socketPort) {
        maxNumberOfThreads = this.maxNumThreads = this.initThreads(recommendedNumThreads);
        if (Job.currentUI != null) {
            this.initCurrentUI(Job.currentUI);
        }
        if (loggingFilePath != null) {
            this.initSnapshotLogging(new File(loggingFilePath));
        }
        if (pipe) {
            this.initPipe();
        }
        ServerSocket serverSocket = null;
        if (socketPort > 0) {
            try {
                serverSocket = new ServerSocket(socketPort);
                System.out.println("ServerSocket waits for port " + socketPort);
            }
            catch (IOException e) {
                System.out.println("ServerSocket mode failure: " + e.getMessage());
            }
        }
        this.serverSocket = serverSocket;
    }

    ServerJobManager() {
        this(0, null, false, 0);
        this.serverConnections.add(new Client(0){});
    }

    private int initThreads(int recommendedNumThreads) {
        int maxNumThreads = defaultNumThreads;
        if (recommendedNumThreads > 0) {
            maxNumThreads = recommendedNumThreads;
        }
        Job.logger.trace("ServerJobManager.initThreads maxNumThreads=", maxNumThreads);
        return maxNumThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initCurrentUI(AbstractUserInterface currentUI) {
        this.lock();
        try {
            assert (currentUI.connectionId == 0);
            assert (this.serverConnections.isEmpty());
            this.serverConnections.add(currentUI);
        }
        finally {
            this.unlock();
        }
        currentUI.startDispatcher();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initSnapshotLogging(File loggingFile) {
        StreamClient conn;
        this.lock();
        try {
            int connectionId = this.serverConnections.size();
            FileOutputStream out = new FileOutputStream(loggingFile);
            System.err.println("Writing snapshot log to " + loggingFile);
            ActivityLogger.logMessage("Writing snapshot log to " + loggingFile);
            conn = new StreamClient(connectionId, null, new BufferedOutputStream(out));
            this.serverConnections.add(conn);
            ++this.passiveConnections;
        }
        catch (IOException e) {
            System.err.println("Failed to create snapshot log file:" + e.getMessage());
            return;
        }
        finally {
            this.unlock();
        }
        conn.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initPipe() {
        StreamClient conn;
        PrintStream stdout = System.out;
        MessagesStream.getMessagesStream();
        this.lock();
        try {
            int connectionId = this.serverConnections.size();
            conn = new StreamClient(connectionId, System.in, stdout);
            this.serverConnections.add(conn);
        }
        finally {
            this.unlock();
        }
        conn.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectionClosed() {
        block5: {
            this.lock();
            try {
                ++this.passiveConnections;
                if (this.passiveConnections != this.serverConnections.size()) break block5;
                try {
                    ActivityLogger.finished();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.exit(0);
            }
            finally {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addJob(EJob ejob, boolean onMySnapshot) {
        this.lock();
        try {
            if (onMySnapshot) {
                this.waitingJobs.add(0, ejob);
            } else {
                this.waitingJobs.add(ejob);
            }
            this.setEJobState(ejob, EJob.State.WAITING, onMySnapshot ? "waiting now" : "waiting");
            this.invokeEThread();
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void removeJob(Job j) {
        EJob ejob = j.ejob;
        this.lock();
        try {
            switch (j.ejob.state) {
                case WAITING: {
                    this.setEJobState(ejob, EJob.State.SERVER_DONE, null);
                }
                case SERVER_DONE: {
                    this.setEJobState(ejob, EJob.State.CLIENT_DONE, null);
                    return;
                }
            }
            return;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setProgress(EJob ejob, String progress) {
        this.lock();
        try {
            if (ejob.state == EJob.State.RUNNING) {
                this.setEJobState(ejob, EJob.State.RUNNING, progress);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator<Job> getAllJobs() {
        this.lock();
        try {
            Job job;
            ArrayList<Job> jobsList = new ArrayList<Job>();
            for (EJob ejob : this.startedJobs) {
                job = ejob.getJob();
                if (job == null) continue;
                jobsList.add(job);
            }
            for (EJob ejob : this.waitingJobs) {
                job = ejob.getJob();
                if (job == null) continue;
                jobsList.add(job);
            }
            Iterator<Job> iterator2 = jobsList.iterator();
            return iterator2;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Job.Inform> getAllJobInforms() {
        this.lock();
        try {
            Job job;
            ArrayList<Job.Inform> jobsList = new ArrayList<Job.Inform>();
            for (EJob ejob : this.startedJobs) {
                job = ejob.getJob();
                if (job != null) {
                    jobsList.add(job.getInform());
                    continue;
                }
                jobsList.add(ejob.getInform());
            }
            for (EJob ejob : this.waitingJobs) {
                job = ejob.getJob();
                if (job != null) {
                    jobsList.add(job.getInform());
                    continue;
                }
                jobsList.add(ejob.getInform());
            }
            ArrayList<Job.Inform> arrayList = jobsList;
            return arrayList;
        }
        finally {
            this.unlock();
        }
    }

    private void invokeEThread() {
        if (this.signalledEThread || this.startedJobs.size() >= this.maxNumThreads) {
            return;
        }
        if (!this.canDoIt()) {
            return;
        }
        if (this.startedJobs.size() < this.numThreads) {
            this.databaseChangesMutex.signal();
        } else {
            int n = this.numThreads++;
            new EThread(n);
        }
        this.signalledEThread = true;
    }

    private boolean canDoIt() {
        if (this.waitingJobs.isEmpty()) {
            return false;
        }
        EJob ejob = this.waitingJobs.get(0);
        return this.startedJobs.isEmpty() || !this.runningChangeJob && ejob.isExamine();
    }

    private void setEJobState(EJob ejob, EJob.State newState, String info) {
        Job.logger.trace("enter ServerJobManager.setEjobState {} {}", (Object)newState, (Object)ejob.jobName);
        EJob.State oldState = ejob.state;
        switch (newState) {
            case WAITING: {
                break;
            }
            case RUNNING: {
                if (oldState != EJob.State.RUNNING) break;
                assert (oldState == EJob.State.RUNNING);
                ejob.progress = info;
                if (!info.equals("aborting")) break;
                ejob.serverJob.scheduledToAbort = true;
                break;
            }
            case SERVER_DONE: {
                boolean removed;
                if (oldState == EJob.State.WAITING) {
                    removed = this.waitingJobs.remove(ejob);
                } else {
                    assert (oldState == EJob.State.RUNNING);
                    removed = this.startedJobs.remove(ejob);
                    if (this.startedJobs.isEmpty()) {
                        this.runningChangeJob = false;
                    }
                }
                assert (removed);
                ejob.state = newState;
                Client.fireServerEvent(new Client.EJobEvent(ejob.jobKey, ejob.jobName, ejob.getJob().getTool(), ejob.jobType, ejob.serializedJob, ejob.doItOk, ejob.serializedResult, ejob.newSnapshot, ejob.state));
                break;
            }
            case CLIENT_DONE: {
                assert (oldState == EJob.State.SERVER_DONE);
                break;
            }
        }
        ejob.state = newState;
        List<Job.Inform> jobs = this.getAllJobInforms();
        Client.fireServerEvent(new Client.JobQueueEvent(jobs.toArray(new Job.Inform[jobs.size()])));
        Job.logger.trace("exiting setJobState");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runLoop(Job initialJob) {
        initialJob.startJob();
        if (this.serverSocket == null) {
            return;
        }
        try {
            while (true) {
                StreamClient conn;
                Socket socket = this.serverSocket.accept();
                int connectionId = this.serverConnections.size();
                this.lock();
                try {
                    conn = new StreamClient(connectionId, socket.getInputStream(), socket.getOutputStream());
                    this.serverConnections.add(conn);
                }
                finally {
                    this.unlock();
                }
                System.out.println("Accepted connection " + connectionId);
                conn.start();
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
            return;
        }
    }

    EJob selectEJob() {
        this.lock();
        try {
            while (true) {
                this.signalledEThread = false;
                if (this.canDoIt()) {
                    EJob ejob = this.waitingJobs.remove(0);
                    this.startedJobs.add(ejob);
                    if (ejob.isExamine()) {
                        assert (!this.runningChangeJob);
                        this.invokeEThread();
                    } else {
                        assert (this.startedJobs.size() == 1);
                        assert (!this.runningChangeJob);
                        this.runningChangeJob = true;
                    }
                    this.setEJobState(ejob, EJob.State.RUNNING, "running");
                    EJob eJob = ejob;
                    return eJob;
                }
                if (Main.isBatch() && this.startedJobs.isEmpty()) {
                    ActivityLogger.finished();
                    System.exit(0);
                }
                Job.logger.trace("ServerJobManager.selectEJob pause");
                this.databaseChangesMutex.awaitUninterruptibly();
                Job.logger.trace("ServerJobManager.selectEJob resume");
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishEJob(EJob finishedEJob) {
        this.lock();
        try {
            this.setEJobState(finishedEJob, EJob.State.SERVER_DONE, "done");
        }
        finally {
            this.unlock();
        }
    }

    public static int getDefaultNumberOfThreads() {
        return defaultNumThreads;
    }

    public static int getMaxNumberOfThreads() {
        return maxNumberOfThreads;
    }

    static class UserInterfaceRedirect
    implements UserInterface {
        private final Job.Key jobKey;
        private final Client client;
        private final EDatabase database;
        private final EditingPreferences editingPreferences;
        TechId curTechId;
        LibId curLibId;
        CellId curCellId;
        private String progressNote;
        private int progressValue = -1;

        UserInterfaceRedirect(Job.Key jobKey, EditingPreferences ep) {
            this.jobKey = jobKey;
            this.client = Job.serverJobManager.serverConnections.get(jobKey.clientId);
            this.database = jobKey.doItOnServer ? EDatabase.serverDatabase() : EDatabase.clientDatabase();
            this.editingPreferences = ep;
        }

        UserInterfaceRedirect(Job.Key jobKey, AbstractUserInterface client, EditingPreferences ep) {
            this.jobKey = jobKey;
            this.client = client;
            assert (!jobKey.doItOnServer);
            this.database = EDatabase.clientDatabase();
            this.editingPreferences = ep;
        }

        UserInterfaceRedirect(EDatabase database, EditingPreferences ep) {
            this.jobKey = null;
            this.client = null;
            this.database = database;
            this.editingPreferences = ep;
        }

        void setCurrents(Job job) {
            assert (this.jobKey == job.getKey());
            this.curTechId = job.curTechId;
            this.curLibId = job.curLibId;
            this.curCellId = job.curCellId;
        }

        private static void printStackTrace(String methodName) {
            if (!Job.getDebug()) {
                return;
            }
            System.out.println("UserInterface." + methodName + " was called from DatabaseChangesThread");
            ActivityLogger.logException(new IllegalStateException());
        }

        @Override
        public void startProgressDialog(String msg, String filePath) {
            this.progressValue = -1;
            Client.fireServerEvent(new Client.StartProgressDialogEvent(msg, filePath));
        }

        @Override
        public void stopProgressDialog() {
            this.progressValue = -1;
            Client.fireServerEvent(new Client.StopProgressDialogEvent());
        }

        @Override
        public void setProgressValue(int pct) {
            if (pct == this.progressValue) {
                return;
            }
            this.progressValue = pct;
            Client.fireServerEvent(new Client.ProgressValueEvent(pct));
        }

        @Override
        public void setProgressNote(String message) {
            this.progressNote = message;
            this.progressValue = -1;
            Client.fireServerEvent(new Client.ProgressNoteEvent(message));
        }

        @Override
        public String getProgressNote() {
            return this.progressNote;
        }

        @Override
        public Job.Key getJobKey() {
            return this.jobKey;
        }

        @Override
        public EDatabase getDatabase() {
            return this.database;
        }

        @Override
        public EditingPreferences lowLevelGetEditingPreferences() {
            return this.editingPreferences;
        }

        @Override
        public Technology getCurrentTechnology() {
            Technology tech = null;
            if (this.curTechId != null) {
                tech = this.database.getTech(this.curTechId);
            }
            if (tech == null) {
                tech = this.database.getTechPool().findTechnology(User.getDefaultTechnology());
            }
            if (tech == null) {
                tech = this.database.getTechPool().findTechnology("mocmos");
            }
            return tech;
        }

        @Override
        public Library getCurrentLibrary() {
            return this.curLibId != null ? this.database.getLib(this.curLibId) : null;
        }

        @Override
        public EditWindow_ getCurrentEditWindow_() {
            UserInterfaceRedirect.printStackTrace("getCurrentEditWindow");
            return null;
        }

        @Override
        public EditWindow_ needCurrentEditWindow_() {
            UserInterfaceRedirect.printStackTrace("needCurrentEditWindow");
            return null;
        }

        @Override
        public Cell getCurrentCell() {
            return this.curCellId != null ? this.database.getCell(this.curCellId) : null;
        }

        @Override
        public Cell needCurrentCell() {
            Cell cell = this.getCurrentCell();
            if (cell != null) {
                return cell;
            }
            throw new IllegalStateException("Can't get current Cell in database thread");
        }

        @Override
        public void repaintAllWindows() {
            UserInterfaceRedirect.printStackTrace("repaintAllWindows");
        }

        @Override
        public void adjustReferencePoint(Cell cell, double cX, double cY) {
        }

        @Override
        public int getDefaultTextSize() {
            return 14;
        }

        @Override
        public EditWindow_ displayCell(Cell cell) {
            throw new IllegalStateException();
        }

        @Override
        public void termLogging(ErrorLogger logger, boolean explain, boolean terminate2) {
            Client.fireServerEvent(new Client.TermLoggingEvent(logger, explain, terminate2));
        }

        public void updateNetworkErrors(Cell cell, List<ErrorLogger.MessageLog> errors) {
            throw new IllegalStateException();
        }

        public void updateIncrementalDRCErrors(Cell cell, List<ErrorLogger.MessageLog> errors) {
            throw new IllegalStateException();
        }

        @Override
        public String reportLog(ErrorLogger.MessageLog log2, boolean showhigh, boolean separateWindow, int position) {
            UserInterfaceRedirect.printStackTrace("reportLog");
            return log2.getMessageString();
        }

        @Override
        public void showErrorMessage(String message, String title) {
            Client.fireServerEvent(new Client.ShowMessageEvent(this.client, message, title, true));
        }

        @Override
        public void showInformationMessage(String message, String title) {
            Client.fireServerEvent(new Client.ShowMessageEvent(this.client, message, title, false));
        }

        @Override
        public void printMessage(String message, boolean newLine) {
            if (newLine) {
                message = message + "\n";
            }
            Client.fireServerEvent(new Client.PrintEvent(this.client, message));
        }

        @Override
        public void saveMessages(String filePath) {
            Client.fireServerEvent(new Client.SavePrintEvent(this.client, filePath));
        }

        @Override
        public void beep() {
            Client.fireServerEvent(new Client.BeepEvent());
        }

        @Override
        public boolean confirmMessage(Object message) {
            UserInterfaceRedirect.printStackTrace("confirmMessage");
            return true;
        }

        @Override
        public int askForChoice(String message, String title, String[] choices, String defaultChoice) {
            throw new IllegalStateException(message);
        }

        @Override
        public String askForInput(Object message, String title, String def) {
            throw new IllegalStateException();
        }

        public int saveHighlights() {
            return -1;
        }

        public void restoreHighlights(int highlightsId) {
        }

        public void showUndoRedoStatus(boolean newUndoEnabled, boolean newRedoEnabled) {
        }
    }
}

