#ifndef MATH_H
#define MATH_H	/* make sure only used once */

#ifdef __cplusplus
extern "C" {
#endif

#include <values.h>

/* On some systems, HUGE ought to be MAXFLOAT or IEEE infinity */

#ifndef HUGE
#define HUGE    MAXDOUBLE
#endif

#ifndef M_E
#define M_E         2.7182818284590452354
#endif

#ifndef M_LOG2E
#define M_LOG2E     1.4426950408889634074
#endif

#ifndef M_LOG10E
#define M_LOG10E    0.43429448190325182765
#endif

#ifndef M_LN2
#define M_LN2       0.69314718055994530942
#endif

#ifndef M_LN10
#define M_LN10      2.30258509299404568402
#endif

#ifndef M_PI
#define M_PI        3.14159265358979323846
#endif

#ifndef M_PI_2
#define M_PI_2      1.57079632679489661923
#endif

#ifndef M_1_PI
#define M_1_PI      0.31830988618379067154
#endif

#ifndef M_PI_4
#define M_PI_4      0.78539816339744830962
#endif

#ifndef M_2_PI
#define M_2_PI      0.63661977236758134308
#endif

#ifndef M_2_SQRTPI
#define M_2_SQRTPI  1.12837916709551257390
#endif

#ifndef M_SQRT2
#define M_SQRT2     1.41421356237309504880
#endif

#ifndef M_SQRT1_2
#define M_SQRT1_2   0.70710678118654752440
#endif

#ifndef PI                      // as in stroustrup
#define PI  M_PI
#endif

#ifndef PI2
#define PI2  M_PI_2
#endif

/* these typedefs were taken from libg++ */
double  acos(double);
double  acosh(double);
double  asin(double);
double  asinh(double);
double  atan(double);
double  atan2(double, double);
double  atanh(double);
double  cbrt(double);
double  ceil(double);
double  copysign(double,double);
double  cos(double);
double  cosh(double);
double  drem(double,double);
double  erf(double);
double  erfc(double);
double  exp(double);
double  expm1(double);
double  fabs(double);
double  finite(double);
double  floor(double);
double  fmod(double,double);
double  frexp(double, int*);
double  gamma(double);
double  hypot(double,double);
double  infnan(int);
#if !defined(sequent) && !defined(DGUX) /* see below */
int     isinf(double);
int     isnan(double);
#endif
double  j0(double);
double  j1(double);
double  jn(int, double);
double  ldexp(double, int);
double  lgamma(double);
double  log(double);
double  log10(double);
double  log1p(double);
double  logb(double);
double  modf(double, double*);
double  pow(double, double);
double  rint(double);
double  scalb(double, int);
double  sin(double);
double  sinh(double);
double  sqrt(double);
double  tan(double);
double  tanh(double);
double  y0(double);
double  y1(double);
double  yn(int, double);

double aint(double);
double anint(double);
int irint(double);
int nint(double);

#ifdef __cplusplus
}
#endif
#endif
