/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.util;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Pipe;
import java.util.LinkedList;
import org.gnunet.util.Program;
import org.gnunet.util.RelativeTime;
import org.gnunet.util.Resolver;
import org.gnunet.util.Scheduler;
import org.gnunet.util.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Service
extends Program {
    private static final Logger logger = LoggerFactory.getLogger(Service.class);
    private Server s;
    private String serviceName;
    private RelativeTime idleTimeout;
    private boolean requireFound;
    private Pipe.SourceChannel sigpipeChannel;

    public Service(String serviceName, RelativeTime idleTimeout, boolean requireFound) {
        this.serviceName = serviceName;
        this.idleTimeout = idleTimeout;
        this.requireFound = requireFound;
    }

    public final Server getServer() {
        return this.s;
    }

    public void stop() {
        this.s.stopListening();
    }

    @Override
    public void runHook() {
        InetAddress addr;
        String ip4AddrList = (String)this.getConfiguration().getValueString(this.serviceName, "ACCEPT_FROM").orNull();
        String ip6AddrList = (String)this.getConfiguration().getValueString(this.serviceName, "ACCEPT_FROM6").orNull();
        int port = ((Long)this.getConfiguration().getValueNumber(this.serviceName, "PORT").get()).intValue();
        LinkedList<SocketAddress> addrs = new LinkedList<SocketAddress>();
        if (ip4AddrList != null) {
            for (String ip4Addr : ip4AddrList.split("[;]")) {
                addr = Resolver.getInetAddressFromString(ip4Addr);
                addrs.add(new InetSocketAddress(addr, port));
            }
        }
        if (ip6AddrList != null) {
            for (String ip6Addr : ip6AddrList.split("[;]")) {
                addr = Resolver.getInetAddressFromString(ip6Addr);
                addrs.add(new InetSocketAddress(addr, port));
            }
        }
        this.s = new Server(addrs, this.idleTimeout, this.requireFound);
        String pipeName = System.getenv("GNUNET_OS_CONTROL_PIPE");
        if (pipeName != null && !pipeName.isEmpty()) {
            Scheduler.FilePipe p = Scheduler.openFilePipe(new File(pipeName));
            Scheduler.TaskConfiguration t = new Scheduler.TaskConfiguration(RelativeTime.FOREVER, new SigpipeTask());
            t.addSelectEvent(p.getSource(), 1);
            t.setLifeness(false);
            t.schedule();
            this.sigpipeChannel = p.getSource();
        }
        this.run();
    }

    private class SigpipeTask
    implements Scheduler.Task {
        private SigpipeTask() {
        }

        @Override
        public void run(Scheduler.RunContext ctx) {
            byte sig;
            int n;
            ByteBuffer b = ByteBuffer.allocate(1);
            try {
                n = Service.this.sigpipeChannel.read(b);
            }
            catch (IOException e) {
                logger.error("error reading signal pipe", (Throwable)e);
                return;
            }
            b.flip();
            boolean stopped = false;
            if (n == 1 && (sig = b.get()) == 15) {
                logger.info("service shutting down");
                Service.this.getServer().stopListening();
                stopped = true;
            }
            if (!stopped) {
                Scheduler.TaskConfiguration t = new Scheduler.TaskConfiguration(RelativeTime.FOREVER, this);
                t.schedule();
            } else {
                try {
                    Service.this.sigpipeChannel.close();
                }
                catch (IOException e) {
                    logger.error("could not close sigpipe channel, quitting");
                }
                System.exit(2);
            }
        }
    }
}

