.TH GROG @MAN1EXT@ "@MDATE@" "Groff Version @VERSION@"
.
.\" --------------------------------------------------------------------
.\" Legalize
.\" --------------------------------------------------------------------
.
.ig
grog.1 - man page for grog (section 1)

Source file position:  <groff_source_top>/src/roff/grog/grog.man
Installed position:    $prefix/share/man/man1/grog.1

Last Update: 5 Jan 2009
..
.de co
Copyright (C) 1989-2000, 2001, 2002, 2003, 2006, 2007, 2009
Free Software Foundation, Inc.
.
Written by James Clark.
Maintained by
.MT wl@gnu.org 
Werner Lemberg
.ME .
Rewritten and put under GPL by Bernd Warken.
.
.P
This file is part of
.IR grog ,
which is part of
.IR groff ,
a free software project.
.
You can redistribute it and/or modify it under the terms of the
.nh
.B "GNU General Public License"
.hy
(\f[CR]GPL\f[]) as published by the
.nh
.BR "Free Software Foundation" ,
.hy
either version\~2, or (at your option) any later version.
.
.P
You should have received a copy of the \f[CR]GNU General Public
License\f[] along with
.IR groff ,
see the files \%\f[CB]COPYING\f[] and \%\f[CB]LICENSE\f[] in the top
directory of the
.I groff
source package.
.
Or read the
.I man\~page
.BR gpl (1).
You can also write to the
.nh
.B "Free Software Foundation, 51 Franklin St - Fifth Floor, Boston,"
.BR "MA 02110-1301, USA" .
.hy
..
.
.
.\" --------------------------------------------------------------------
.\" Local macros
.de FN
.I \\$1
..
.
.
.\" --------------------------------------------------------------------
.SH NAME
.
grog \- guess options for groff command
.
.
.\" --------------------------------------------------------------------
.SH SYNOPSIS
.
.SY grog
.OP \-C
.RI [ \%groff\-option\~ .\|.\|.\&]
.OP \-\-
.RI [ \%filespec\~ .\|.\|.]
.
.SY grog
.B \-h
|
.B \-\-help
.
.SY grog
.B \-v
|
.B \-\-version
.YS
.
.
.\" --------------------------------------------------------------------
.SH DESCRIPTION
.
.B grog
reads the input (file names or standard input) and guesses which of
the
.BR groff  (@MAN1EXT@)
options are needed to perform the input with the
.B groff
program.
.
The corresponding
.B groff
command is output.
.
.
.\" --------------------------------------------------------------------
.SH OPTIONS
.
The only
.B grog
options recognized are
.B \-C
(which is also passed on) to enable compatibility mode;
.B \-v
and
.B \-\-version
print information on the version number; and
.B \-h
and
.B \-\-help
print usage information.
.
.BR \-v ,
.BR \-\-version ,
.BR \-h ,
and
.B \-\-help
stop the program directly without printing a
.B groff
command to standard output.
.
.
.P
All other specified short options (words starting with one minus
character
.BR \- )
are interpreted as
.B groff
options or option clusters with or without argument.
.
No space is allowed between options and their argument.
.
Except from the
.BI \-m arg
options, all options will be passed on, i.e. they are included
unchanged in the command for the output without effecting the work of
.BR grog .
.
.
.P
A
.I filespec
argument can either be the name of an existing file or a single minus
.B \-
to mean standard input.
.
If no
.I filespec
is specified standard input is read automatically.
.
.
.\" --------------------------------------------------------------------
.SH DETAILS
.
.B grog
reads all
.I filespec
parameters as a whole.
.
It tries to guess which of the following
.B groff
options are required for running the input under
.BR groff :
.BR \-e ,
.BR \-man ,
.BR \-me ,
.BR \-mm ,
.BR \-mom ,
.BR \-ms ,
.BR \-mdoc,
.BR \-mdoc-old,
.BR \-p ,
.BR \-R ,
.BR \-g ,
.BR \-G ,
.BR \-s ,
and
.BR \-t .
The guessed
.B groff
command including those options and the found
.I filespec
parameters is put on the standard output.
.
.
.P
It is possible to specify arbitrary
.B groff
options on the command line.
.
These are passed on the output without change, except for the
.BI \-m arg
options.
.
.
.P
The
.B groff
program has trouble when the wrong
.BI \-m arg
option or several of these options are specified.
.
In these cases,
.B grog
will print an error message and exit with an error code.
.
It is better to specify no
.BI \-m arg
option.
.
Because such an option is only accepted and passed when
.B grog
does not find any of these options or the same option is found.
.
.
.P
If several different
.BI \-m arg
options are found by
.B grog
an error message is produced and the program is terminated with an
error code.
.
But the output is written with the wrong options nevertheless.
.
.
.P
Remember that it is not necessary to determine a macro package.
.
A
.I roff
file can also be written in the
.I groff
language without any macro package.
.
.B grog
will produce an output without an
.BI \-m arg
option.
.
.
.P
As
.B groff
also works with pure text files without any
.I roff
requests,
.B grog
cannot be used to identify a file to be a
.I roff
file.
.
.
.P
The
.BR groffer  (@MAN1EXT@)
program heavily depends on a working
.BR grog .
.
.
.P
The
.B grog
source contains two files written in different programming languages:
.
.ft CB
grog.pl
.ft R
is the
.I Perl
version, while
.ft CB
grog.sh
.ft R
is a shell script using
BR awk (1).
During the run of
.BR make (1),
it is determined whether the system contains a suitable version of
.BR perl (1).
If so,
.ft CB
grog.pl
.ft R
is transformed into
.BR grog ;
otherwise
.ft CB
grog.sh
.ft R
is used instead.
.
.
.\" --------------------------------------------------------------------
.SH EXAMPLES
.
.IP \(bu
Calling
.
.RS
.IP
.EX
grog meintro.me
.EE
.RE
.
.IP
results in
.
.RS
.IP
.EX
groff \-me meintro.me
.EE
.RE
.
.IP
So
.B grog
recognized that the file
.FN meintro.me
is written with the
.B \-me
macro package.
.RE
.
.
.IP \(bu
On the other hand,
.
.RS
.IP
.EX
grog pic.ms
.EE
.RE
.
.IP
outputs
.
.RS
.IP
.EX
groff \-pte \-ms pic.ms
.EE
.RE
.
.IP
Besides determining the macro package
.BR \-ms ,
.B grog
recognized that the file
.FN pic.ms
additionally needs
.BR \-pte ,
the combination of
.B \-p
for
.IR pic ,
.B \-t
for
.IR tbl ,
and
.B \-e
for
.IR eqn .
.RE
.
.
.IP \(bu
If both files are combined by the command
.
.RS
.IP
.EX
grog meintro.me pic.ms
.EE
.RE
.
.IP
an error message is sent to standard error because
.B groff
cannot work with two different macro packages:
.
.RS
.IP
.ft CR
grog: error: there are several macro packages: -me -ms
.ft
.RE
.
.IP
Additionally the corresponding output with the wrong options is printed
to standard output:
.
.RS
.IP
.EX
groff -pte -me -ms meintro.me pic.ms
.EE
.RE
.
.IP
But the program is terminated with an error code.
.
.
.IP \(bu
The call of
.
.RS
.IP
.EX
grog \-ksS \-Tdvi grnexmpl.g
.EE
.RE
.
.IP
contains several
.B groff
options that are just passed on the output without any interface to
.BR grog .
These are the option cluster
.B \-ksS
consisting of
.BR \-k ,
.BR \-s ,
and
.BR \-S ;
and the option
.B \-T
with argument
.BR dvi .
The output is
.
.RS
.IP
.EX
groff \-ksS \-Tdvi grnexmpl.g
.EE
.RE
.
.IP
so no additional option was added by
.BR grog .
As no option
.BI \-m arg
was found by
.B grog
this file does not use a macro package.
.
.
.IP \(bu
.B grog
can also handle files using the
.I chem
language.
.
The example
.
.RS
.IP
.EX
grog chAh_brackets.chem
.EE
.RE
.
.IP
outputs
.
.RS
.IP
.EX
chem chAh_brackets.chem | groff \-pe
.EE
.RE
.
.IP
So
.B chem
is run first and
.B groff
is appended.
.
The option
.B \-p
for
.B pic
is implied automatically by
.BR chem .
Additionally, the file uses
.I eqn
with
.BR \-e .
.
.
.\" --------------------------------------------------------------------
.SH "SEE ALSO"
.
.BR groff (@MAN1EXT@),
.BR @g@troff (@MAN1EXT@),
.BR @g@tbl (@MAN1EXT@),
.BR @g@pic (@MAN1EXT@),
.BR @g@eqn (@MAN1EXT@),
.BR @g@refer (@MAN1EXT@),
.BR @g@grn (@MAN1EXT@),
.BR grap (1),
.BR @g@soelim (@MAN1EXT@),
.BR groff_me (@MAN7EXT@),
.BR groff_ms (@MAN7EXT@),
.BR groff_mm (@MAN7EXT@),
.BR groff_mom (@MAN7EXT@),
.BR groff_man (@MAN7EXT@),
.BR groffer (@MAN1EXT@)
.
.
.\" --------------------------------------------------------------------
.SH "COPYING"
.
.co
.
.
.\" --------------------------------------------------------------------
.\" Emacs settings
.\" --------------------------------------------------------------------
.
.\" Local Variables:
.\" mode: nroff
.\" End:
