
(defun d-create-whole ()
  (progn
    (setq stage 6)
    (find-file (format "~/C/wagners-ring-cycle-old%d/order.html" stage))
    (setq ptr nil)
    (goto-char (point-min))
    (while (re-search-forward "\"\\(http://[^ \"]*\\)\"" nil t)
      (setq ptr (cons (buffer-substring-no-properties (match-beginning 1) (match-end 1))
                      ptr)))
    (setq list ptr)
    (setq list (nreverse list))
    (setq ptr list)
    (setq count 0)
    (find-file (format "~/C/wagners-ring-cycle-old%d/download.bat" stage))
    (goto-char (point-min))
    (read-only-mode -1)
    (erase-buffer)
    (insert "#!/bin/bash\n")
    (while ptr
      (if (not (string-match "[?]" (car ptr)))
          (insert "wget --timeout=600 --continue \"" (car ptr) "\" &\n"))
      (setq ptr (cdr ptr))
      (incf count)
      )
    (save-buffer)
    (kill-buffer)
    (save-buffer)
    (kill-buffer)
    )
  )

(defun d-split-files ()
  (let (count line)
    (progn
      (setq stage 6)
      (find-file (format "~/C/wagners-ring-cycle-old%d/download.bat" stage))
      (read-only-mode -1)
      (goto-char (point-min))
      (assert (not (looking-at "^#!/bin/bash$")))
      (setq count 1)
      ;;(setq f (buffer-file-name (current-buffer)))
      (setq f (format "~/C/wagners-ring-cycle-old%d/download-ring-cycle-part-%d.bat" stage count))
      (while (not (eobp))
        (when (= (mod count 5) 0)
          (save-excursion
            (find-file f)
            (save-buffer)
            (kill-buffer)
            (find-file (format "~/C/wagners-ring-cycle-old%d/download-ring-cycle-part-%d.bat" stage count))
            (read-only-mode -1)
            (erase-buffer)
            (goto-char (point-max))
            (setq f (buffer-file-name (current-buffer)))
            (insert "#!/bin/bash\n")))
        (setq line (d-current-line-as-string))
        (when (not (string-match "^#" line))
          (save-excursion
            (find-file f)
            (goto-char (point-max))
            (insert line "\n")
            (incf count)
            (message "count=%s" count)))
        (forward-line 1)
        (beginning-of-line)
        )
      (find-file f)
      (save-buffer)
      (kill-buffer)
      (save-buffer)
      (kill-buffer)
      )
    ))

;; (d-rename-munge-to-counter)
(defun d-rename-munge-to-counter ()
  (let (ptr list count)
    (progn
      (setq stage 1)
      (find-file (format "~/C/wagners-ring-cycle-old%d/download.bat" stage))
      (setq ptr nil)
      (goto-char (point-min))
      (assert (looking-at "^#"))
      (while (re-search-forward "\"http://[-a-zA-Z0-9/.]*/\\([^ \"/]*\\)\"" nil t)
        (setq ptr (cons (buffer-substring-no-properties (match-beginning 1) (match-end 1))
                        ptr))
        (assert (not (string-match "\\?" (car ptr)))))
      (setq list ptr)
      (setq list (nreverse list))
      (setq ptr list)
      (setq count 0)
      (while ptr
        (if (file-exists-p (format "~/C/wagners-ring-cycle-old%d/%s"  stage (car ptr)))
            (copy-file (format "~/C/wagners-ring-cycle-old%d/%s"      stage (car ptr))
                       (format "~/C/wagners-ring-cycle-new%d/%d.flac" stage count)
                       'OK-IF-ALREADY-EXISTS
                       'KEEP-TIME))
        (message "(car ptr)=%s count=%s" (car ptr) count)
        (setq ptr (cdr ptr))
        (incf count)
        ))
    )
  )

;; (d-download-file-size "~/.emacs")
;; (d-download-file-size "~/adsd")
(defun d-file-size (file)
  (if (file-exists-p file)
      (nth 7 (file-attributes file))
    0))

;; (d-merge-file-lists)
(defun d-merge-file-lists ()
  (let (ptr list count file1 file2 file3 file-merged len1 len2 len3 dir1 dir2 dir3 dir-merged)
    (progn
      (if os-type--mswindows-p
          (setq c-drive "c:/")
        (setq c-drive "~/C/"))
      (progn
        (setq count 0)
        (setq ptr nil)
        (while (< count 500)
          (setq ptr (cons (format "%03d.flac" count)
                          ptr))
          (incf count))
        (setq list (nreverse ptr)))
      (setq ptr list)
      (progn
        (setq file-list (directory-files c-drive nil "wagners-ring-cycle-new[0-9]+"))
        (setq dir-merged (concat c-drive "wagners-ring-cycle-merged/"))
        (make-directory dir-merged 'PARENTS))
      (while ptr
        (progn
          ;; (setq x (car file-list))
          (setq files (mapcar (lambda (x) (concat c-drive x "/" (car ptr))) file-list))
          (setq file-sizes (mapcar (lambda (x) (d-file-size x)) files))
          (setq max (apply 'max file-sizes))
          (setq file-merged (concat dir-merged (car ptr)))
          (setq ptr2 files)
          ;;(if (string-match "10" (car ptr2)) (debug "matched"))
          (while ptr2
            (when (and (file-exists-p      (car ptr2))
                       (= max (d-file-size (car ptr2))))
              ;;(debug "Night crawler")
              (message "Copying file %s -> %s" (car ptr2) file-merged)
              (copy-file (car ptr2) file-merged 'OK-IF-ALREADY-EXISTS 'KEEP-TIME))
            (setq ptr2 (cdr ptr2)))
          )
        (setq ptr (cdr ptr))
        (message "%s" (car ptr))
        ))
    ))

;;; (setq i 0)
;;; (setq str "apple\nbanana")
;;; (d-cull-newlines str)
(defun d-cull-newlines (str)
  (setq len (length str))
  (setq i   0)
  (while (< i len)
    (if (= (aref str i) ?\n)
        (aset str i ? ))
    (incf i))
  str)

(defun d-compose-list ()
  (progn
    (if (get-buffer "*track-list*")
        (kill-buffer "*track-list*"))
    (set-buffer (generate-new-buffer "*track-list*"))
    (read-only-mode -1)
    (find-file "~/C/wagners-ring-cycle-old5/order.html")
    (goto-char (point-min))
    (setq count 1)
    (while (re-search-forward "<td>Wagner:" nil t)
      (setq p1 (point))
      (re-search-forward "</td>")
      (forward-char -5)
      (setq p2 (point))
      (setq str (buffer-substring-no-properties p1 p2))
      (setq str (d-cull-newlines str))
      (save-excursion
        (set-buffer "*track-list*")
        (insert (format "Track %d: %s\n" count str)
                )
        (incf count)
      )))
  )

(provide 'wagner-download)
;;; download-files.el ends here

