
;;; name-checkpoints.el

;; Copyright (C) 2014-2015 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: name-checkpoints.el
;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords:
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; Known Bugs:

;; None so far!

;;; Code:

(defun name-checkpoints ()
  (interactive)
  (let ((name  (cfm--get-defun))
        (count 0))
    (goto-char (point-min))
    ;;(debug "fence")
    (while (re-search-forward "(checkpoint [^()]*)" nil t)
      (incf count)
      (setq chk (buffer-substring-no-properties (match-beginning 0) (match-end 0)))

      (cond
       ((string-match "\\((checkpoint\\) \"\\([^()\"]\\)\")" chk)

        (setq s1 (substring chk (match-beginning 1) (match-end 1)))
        (setq s2 (concat name ":" (format "%s" count)))
        (setq s3 (concat s1 " \"" s2 "\")"))
        )
       ((string-match "\\((checkpoint\\) \\([^()\"]\\))" chk)

        (setq s1 (substring chk (match-beginning 1) (match-end 1)))
        (setq s2 (concat name ":" (format "%s" count)))
        (setq s3 (concat s1 " \"" s2 "\")"))
        )
       (t
        (error "Smeg")))
      (checkpoint ":0")
      (delete-region (point-at-bol) (point-at-eol))
      (checkpoint ":0")
      (insert s3))
    (indent-region (point-min) (point-max) nil)
    (checkpoint ":0")
    ))

;;; name-checkpoints.el ends here
