/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.expr.KawaScriptEngine;
import gnu.expr.Language;
import gnu.kawa.util.WeakIdentityHashMap;
import gnu.mapping.Environment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import kawa.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScriptEngineFactory
implements ScriptEngineFactory {
    Language language;
    private List<String> extensions;
    protected List<String> names;
    private static List<String> noMimeTypes;
    WeakIdentityHashMap<Bindings, Environment> contextMap = new WeakIdentityHashMap();

    void setEnvironment(Bindings bindings, Environment env) {
        this.contextMap.put(bindings, env);
    }

    Environment getEnvironment(ScriptContext ctx) {
        return this.getEnvironment(ctx.getBindings(100));
    }

    Environment getEnvironment(Bindings bindings) {
        Environment env = (Environment)this.contextMap.get(bindings);
        if (env == null) {
            throw new UnsupportedOperationException("Bindings must be created using createBindings");
        }
        return env;
    }

    protected AbstractScriptEngineFactory(Language language) {
        this.language = language;
    }

    @Override
    public String getEngineName() {
        return "Kawa-" + this.language.getName();
    }

    @Override
    public String getEngineVersion() {
        return Version.getVersion();
    }

    @Override
    public String getLanguageVersion() {
        return Version.getVersion();
    }

    @Override
    public String getLanguageName() {
        return this.language.getName();
    }

    @Override
    public List<String> getExtensions() {
        if (this.extensions == null) {
            ArrayList<String> exts = new ArrayList<String>(1);
            String[][] langs = Language.getLanguages();
            for (int i = 0; i < langs.length; ++i) {
                String[] lang = langs[i];
                if (lang == null) continue;
                int n = lang.length - 1;
                String langClass = lang[n];
                if (!this.language.getName().equals(langClass)) continue;
                for (int j = 1; j < n; ++j) {
                    String ext = lang[j];
                    if (ext == null || ext.charAt(0) != '.') continue;
                    exts.add(ext.substring(1));
                }
            }
            this.extensions = Collections.unmodifiableList(exts);
        }
        return this.extensions;
    }

    @Override
    public List<String> getMimeTypes() {
        if (noMimeTypes == null) {
            noMimeTypes = Collections.unmodifiableList(new ArrayList(0));
        }
        return noMimeTypes;
    }

    @Override
    public List<String> getNames() {
        if (this.names == null) {
            ArrayList<String> n = new ArrayList<String>(3);
            this.getNames(n);
            this.names = Collections.unmodifiableList(n);
        }
        return this.names;
    }

    protected void getNames(List<String> names) {
        names.add(this.language.getName());
    }

    @Override
    public String getMethodCallSyntax(String obj, String m, String ... args) {
        throw new UnsupportedOperationException(this.getClass().getName() + ".getMethodCalSyntax not supported");
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        throw new UnsupportedOperationException(this.getClass().getName() + ".getOutputStatement not supported");
    }

    @Override
    public String getProgram(String ... statements) {
        throw new UnsupportedOperationException(this.getClass().getName() + ".getProgram not supported");
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return new KawaScriptEngine(this);
    }

    @Override
    public String getParameter(String key) {
        if (key.equals("javax.script.engine")) {
            return this.getEngineName();
        }
        if (key.equals("javax.script.engine_version")) {
            return this.getEngineVersion();
        }
        if (key.equals("javax.script.name")) {
            return this.getEngineName();
        }
        if (key.equals("javax.script.language")) {
            return this.getLanguageName();
        }
        if (key.equals("javax.script.language_version")) {
            return this.getLanguageVersion();
        }
        if (key.equals("THREADING")) {
            return "MULTITHREADED";
        }
        return null;
    }
}

