/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.AbstractSequence;
import gnu.lists.AttributePredicate;
import gnu.lists.Consumable;
import gnu.lists.Consumer;
import gnu.lists.Convert;
import gnu.lists.ElementPredicate;
import gnu.lists.GroupPredicate;
import gnu.lists.NodePredicate;
import gnu.lists.PositionConsumer;
import gnu.lists.SeqPosition;
import gnu.lists.Sequence;
import gnu.lists.TreePosition;
import java.io.PrintWriter;

public class TreeList
extends AbstractSequence
implements Consumer,
PositionConsumer,
Consumable {
    public Object[] objects;
    public int oindex;
    public char[] data;
    public int gapStart;
    public int gapEnd;
    public int attrStart;
    public int docStart;
    static final int MAX_CHAR_SHORT = 40959;
    static final int MIN_INT_SHORT = -4096;
    static final int MAX_INT_SHORT = 8191;
    static final int INT_SHORT_ZERO = 49152;
    static final int OBJECT_REF_SHORT = 57344;
    static final int OBJECT_REF_SHORT_INDEX_MAX = 4095;
    static final char OBJECT_REF_FOLLOWS = '\uf10d';
    static final char POSITION_REF_FOLLOWS = '\uf10e';
    protected static final char POSITION_PAIR_FOLLOWS = '\uf10f';
    static final int BYTE_PREFIX = 61440;
    static final char BOOL_FALSE = '\uf100';
    static final char BOOL_TRUE = '\uf101';
    public static final int INT_FOLLOWS = 61698;
    static final int LONG_FOLLOWS = 61699;
    static final int FLOAT_FOLLOWS = 61700;
    static final int DOUBLE_FOLLOWS = 61701;
    static final int CHAR_FOLLOWS = 61702;
    static final int CHAR_PAIR_FOLLOWS = 61703;
    static final int BEGIN_ATTRIBUTE_LONG = 61705;
    static final int END_ATTRIBUTE = 61706;
    static final int BEGIN_DOCUMENT = 61712;
    static final int END_DOCUMENT = 61713;
    static final int BASE_URI = 61714;
    static final int BEGIN_GROUP_SHORT = 40960;
    static final int BEGIN_GROUP_SHORT_INDEX_MAX = 4095;
    static final int END_GROUP_SHORT = 61707;
    static final int BEGIN_GROUP_LONG = 61704;
    static final int END_GROUP_LONG = 61708;
    int currentParent = 0;

    public TreeList() {
        this.resizeObjects();
        this.gapEnd = 200;
        this.data = new char[this.gapEnd];
    }

    public TreeList(TreeList treeList, int n, int n2) {
        this();
        treeList.consumeIRange(n, n2, this);
    }

    public TreeList(TreeList treeList) {
        this(treeList, 0, treeList.data.length);
    }

    public void clear() {
        this.gapStart = 0;
        this.gapEnd = this.data.length;
        this.attrStart = 0;
        if (this.gapEnd > 1500) {
            this.gapEnd = 200;
            this.data = new char[this.gapEnd];
        }
        this.objects = null;
        this.resizeObjects();
    }

    public void ensureSpace(int n) {
        int n2 = this.gapEnd - this.gapStart;
        if (n > n2) {
            int n3;
            int n4 = this.data.length;
            int n5 = 2 * n4;
            int n6 = n4 - n2 + n;
            if (n5 < n6) {
                n5 = n6;
            }
            char[] cArray = new char[n5];
            if (this.gapStart > 0) {
                System.arraycopy(this.data, 0, cArray, 0, this.gapStart);
            }
            if ((n3 = n4 - this.gapEnd) > 0) {
                System.arraycopy(this.data, this.gapEnd, cArray, n5 - n3, n3);
            }
            this.gapEnd = n5 - n3;
            this.data = cArray;
        }
    }

    public final void resizeObjects() {
        Object[] objectArray;
        if (this.objects == null) {
            boolean bl = false;
            int n = 100;
            objectArray = new Object[n];
        } else {
            int n = this.objects.length;
            int n2 = 2 * n;
            objectArray = new Object[n2];
            System.arraycopy(this.objects, 0, objectArray, 0, n);
        }
        this.objects = objectArray;
    }

    public int find(Object object2) {
        if (this.oindex == this.objects.length) {
            this.resizeObjects();
        }
        this.objects[this.oindex] = object2;
        return this.oindex++;
    }

    public int find(Object object2, Object object3) {
        int n = this.oindex;
        int n2 = n + 2;
        if (n2 > this.objects.length) {
            this.resizeObjects();
        }
        this.objects[n] = object2;
        this.objects[n + 1] = object3;
        this.oindex = n2;
        return n;
    }

    protected final int getIntN(int n) {
        return this.data[n] << 16 | this.data[n + 1] & 0xFFFF;
    }

    protected final long getLongN(int n) {
        char[] cArray = this.data;
        return ((long)cArray[n] & 0xFFFFL) << 48 | ((long)cArray[n + 1] & 0xFFFFL) << 32 | ((long)cArray[n + 2] & 0xFFFFL) << 16 | (long)cArray[n + 3] & 0xFFFFL;
    }

    public final void setIntN(int n, int n2) {
        this.data[n] = (char)(n2 >> 16);
        this.data[n + 1] = (char)n2;
    }

    public boolean consume(SeqPosition seqPosition) {
        this.ensureSpace(3);
        int n = this.find(seqPosition.copy());
        this.data[this.gapStart++] = 61710;
        this.setIntN(this.gapStart, n);
        this.gapStart += 2;
        return true;
    }

    public boolean writePosition(AbstractSequence abstractSequence, int n) {
        this.ensureSpace(5);
        this.data[this.gapStart] = 61711;
        int n2 = this.find(abstractSequence);
        this.setIntN(this.gapStart + 1, n2);
        this.setIntN(this.gapStart + 3, n);
        this.gapStart += 5;
        return true;
    }

    public void writeObject(Object object2) {
        if (object2 instanceof SeqPosition) {
            SeqPosition seqPosition = (SeqPosition)object2;
            this.writePosition(seqPosition.sequence, seqPosition.ipos);
            return;
        }
        this.ensureSpace(3);
        int n = this.find(object2);
        if (n < 4096) {
            this.data[this.gapStart++] = (char)(0xE000 | n);
        } else {
            this.data[this.gapStart++] = 61709;
            this.setIntN(this.gapStart, n);
            this.gapStart += 2;
        }
    }

    public void writeBaseUri(Object object2) {
        this.ensureSpace(3);
        int n = this.find(object2);
        this.data[this.gapStart++] = 61714;
        this.setIntN(this.gapStart, n);
        this.gapStart += 2;
    }

    public void beginGroup(String string, Object object2) {
        this.beginGroup(this.find(string, object2));
    }

    public void beginDocument() {
        this.ensureSpace(4);
        --this.gapEnd;
        this.currentParent = this.gapStart;
        this.data[this.gapStart++] = 61712;
        if (this.docStart != 0) {
            throw new Error("nested document");
        }
        this.docStart = this.gapStart;
        this.setIntN(this.gapStart, this.gapEnd - this.data.length);
        this.gapStart += 2;
        this.data[this.gapEnd] = 61713;
    }

    public void endDocument() {
        if (this.data[this.gapEnd] != '\uf111' || this.docStart <= 0) {
            throw new Error("unexpected endDocument");
        }
        ++this.gapEnd;
        this.setIntN(this.docStart, this.gapStart - this.docStart + 1);
        this.docStart = 0;
        this.data[this.gapStart++] = 61713;
        this.currentParent = 0;
    }

    public void beginGroup(int n) {
        this.ensureSpace(10);
        this.gapEnd -= 7;
        this.data[this.gapStart++] = 61704;
        this.setIntN(this.gapStart, this.gapEnd - this.data.length);
        this.gapStart += 2;
        this.data[this.gapEnd] = 61708;
        this.setIntN(this.gapEnd + 1, n);
        this.setIntN(this.gapEnd + 3, this.gapStart - 3);
        this.setIntN(this.gapEnd + 5, this.currentParent);
        this.currentParent = this.gapStart - 3;
    }

    public void endGroup(String string) {
        if (this.data[this.gapEnd] != '\uf10c') {
            throw new Error("unexpected endGroup " + string);
        }
        int n = this.getIntN(this.gapEnd + 1);
        int n2 = this.getIntN(this.gapEnd + 3);
        int n3 = this.getIntN(this.gapEnd + 5);
        this.gapEnd += 7;
        int n4 = this.gapStart - n2;
        int n5 = n2 - n3;
        if (n < 4095 && n4 < 65536 && n5 < 65536) {
            this.data[n2] = (char)(0xA000 | n);
            this.data[n2 + 1] = (char)n4;
            this.data[n2 + 2] = (char)n5;
            this.data[this.gapStart] = 61707;
            this.data[this.gapStart + 1] = (char)n4;
            this.gapStart += 2;
        } else {
            this.data[n2] = 61704;
            this.setIntN(n2 + 1, n4);
            this.data[this.gapStart] = 61708;
            this.setIntN(this.gapStart + 1, n);
            this.setIntN(this.gapStart + 3, -n4);
            if (n3 >= this.gapStart || n2 <= this.gapStart) {
                n3 -= this.gapStart;
            }
            this.setIntN(this.gapStart + 5, n3);
            this.gapStart += 7;
        }
        this.currentParent = n3;
    }

    public void beginAttribute(String string, Object object2) {
        this.beginAttribute(this.find(string, object2));
    }

    public void beginAttribute(int n) {
        this.ensureSpace(6);
        --this.gapEnd;
        this.data[this.gapStart++] = 61705;
        if (this.attrStart != 0) {
            throw new Error("nested attribute");
        }
        this.attrStart = this.gapStart;
        this.setIntN(this.gapStart, n);
        this.setIntN(this.gapStart + 2, this.gapEnd - this.data.length);
        this.gapStart += 4;
        this.data[this.gapEnd] = 61706;
    }

    public void endAttribute() {
        if (this.data[this.gapEnd] != '\uf10a' || this.attrStart <= 0) {
            throw new Error("unexpected endAttribute");
        }
        ++this.gapEnd;
        this.setIntN(this.attrStart + 2, this.gapStart - this.attrStart + 1);
        this.attrStart = 0;
        this.data[this.gapStart++] = 61706;
    }

    public void writeChar(int n) {
        this.ensureSpace(3);
        if (n <= 40959) {
            this.data[this.gapStart++] = (char)n;
        } else if (n < 65536) {
            this.data[this.gapStart++] = 61702;
            this.data[this.gapStart++] = (char)n;
        } else {
            this.data[this.gapStart++] = 61703;
        }
    }

    public void writeBoolean(boolean bl) {
        this.ensureSpace(1);
        this.data[this.gapStart++] = bl ? 61697 : 61696;
    }

    public void writeByte(int n) {
        this.ensureSpace(1);
        this.data[this.gapStart++] = (char)(61440 + (n & 0xFF));
    }

    public void writeInt(int n) {
        this.ensureSpace(3);
        if (n >= -4096 && n <= 8191) {
            this.data[this.gapStart++] = (char)(49152 + n);
        } else {
            this.data[this.gapStart++] = 61698;
            this.setIntN(this.gapStart, n);
            this.gapStart += 2;
        }
    }

    public void writeLong(long l) {
        this.ensureSpace(5);
        this.data[this.gapStart++] = 61699;
        this.data[this.gapStart++] = (char)(l >>> 48);
        this.data[this.gapStart++] = (char)(l >>> 32);
        this.data[this.gapStart++] = (char)(l >>> 16);
        this.data[this.gapStart++] = (char)l;
    }

    public void writeFloat(float f) {
        this.ensureSpace(3);
        int n = Float.floatToIntBits(f);
        this.data[this.gapStart++] = 61700;
        this.data[this.gapStart++] = (char)(n >>> 16);
        this.data[this.gapStart++] = (char)n;
    }

    public void writeDouble(double d) {
        this.ensureSpace(5);
        long l = Double.doubleToLongBits(d);
        this.data[this.gapStart++] = 61701;
        this.data[this.gapStart++] = (char)(l >>> 48);
        this.data[this.gapStart++] = (char)(l >>> 32);
        this.data[this.gapStart++] = (char)(l >>> 16);
        this.data[this.gapStart++] = (char)l;
    }

    public boolean ignoring() {
        return false;
    }

    public void writeChars(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.writeChar(string.charAt(i));
        }
    }

    public void write(char[] cArray, int n, int n2) {
        this.ensureSpace(n2);
        while (n2 > 0) {
            char c = cArray[n++];
            --n2;
            if (c <= '\u9fff') {
                this.data[this.gapStart++] = c;
                continue;
            }
            this.writeChar(c);
            this.ensureSpace(n2);
        }
    }

    public boolean isEmpty() {
        int n = this.gapStart == 0 ? this.gapEnd : 0;
        return n == this.data.length;
    }

    public int size() {
        int n = 0;
        int n2 = 0;
        while ((n2 = this.nextPos(n2)) != 0) {
            ++n;
        }
        return n;
    }

    public int createPos(int n, boolean bl) {
        return this.createRelativePos(0, n, bl);
    }

    public final int posToDataIndex(int n) {
        if (n == -1) {
            return this.data.length;
        }
        int n2 = n >>> 1;
        if ((n & 1) != 0) {
            --n2;
        }
        if (n2 >= this.gapStart) {
            n2 += this.gapEnd - this.gapStart;
        }
        if ((n & 1) != 0) {
            if ((n2 = this.nextDataIndex(n2)) < 0) {
                return this.data.length;
            }
            if (n2 == this.gapStart) {
                n2 += this.gapEnd - this.gapStart;
            }
        }
        return n2;
    }

    public int firstChildPos(int n) {
        int n2 = this.gotoChildrenStart(this.posToDataIndex(n));
        if (n2 < 0) {
            return 0;
        }
        return n2 << 1;
    }

    public final int gotoChildrenStart(int n) {
        if (n == this.data.length) {
            return -1;
        }
        char c = this.data[n];
        if (c >= '\ua000' && c <= '\uafff' || c == '\uf108' || c == '\uf110') {
            n += 3;
        } else {
            return -1;
        }
        while (true) {
            if (n >= this.gapStart) {
                n += this.gapEnd - this.gapStart;
            }
            if ((c = this.data[n]) == '\uf109') {
                int n2;
                n = n2 + ((n2 = this.getIntN(n + 3)) < 0 ? this.data.length : n);
                continue;
            }
            if (c == '\uf10a') {
                ++n;
                continue;
            }
            if (c != '\uf112') break;
            n += 3;
        }
        return n;
    }

    public int parentPos(int n) {
        int n2 = this.posToDataIndex(n);
        if (n2 == this.data.length) {
            return -1;
        }
        char c = this.data[n2];
        if (c == '\uf110') {
            return -1;
        }
        if (c >= '\ua000' && c <= '\uafff') {
            char c2 = this.data[n2 + 2];
            return c2 == '\u0000' ? -1 : n2 - c2 << 1;
        }
        if (c == '\uf108') {
            int n3;
            int n4;
            if ((n4 = this.getIntN((n3 += (n3 = this.getIntN(n2 + 1)) < 0 ? this.data.length : n2) + 5)) == 0) {
                return -1;
            }
            if (n4 < 0) {
                n4 += n3;
            }
            return n4 << 1;
        }
        block6: while (true) {
            if (n2 == this.gapStart) {
                n2 = this.gapEnd;
            }
            if (n2 == this.data.length) {
                return -1;
            }
            c = this.data[n2];
            switch (c) {
                case '\uf10b': {
                    return n2 - this.getIntN(n2 + 1) << 1;
                }
                case '\uf10c': {
                    int n5 = this.getIntN(n2 + 3);
                    if (n5 < 0) {
                        n5 += n2;
                    }
                    return n5;
                }
                case '\uf10a': {
                    ++n2;
                    continue block6;
                }
                case '\uf111': {
                    return -1;
                }
            }
            if ((n2 = this.nextDataIndex(n2)) < 0) break;
        }
        return -1;
    }

    public boolean gotoAttributesStart(TreePosition treePosition) {
        int n = this.gotoAttributesStart(treePosition.ipos >> 1);
        if (n < 0) {
            return false;
        }
        treePosition.push(this, n << 1);
        return true;
    }

    public int firstAttributePos(int n) {
        int n2 = this.gotoAttributesStart(this.posToDataIndex(n));
        return n2 < 0 ? 0 : n2 << 1;
    }

    public int gotoAttributesStart(int n) {
        if (n >= this.gapStart) {
            n += this.gapEnd - this.gapStart;
        }
        if (n == this.data.length) {
            return -1;
        }
        char c = this.data[n];
        if (c >= '\ua000' && c <= '\uafff' || c == '\uf108') {
            return n + 3;
        }
        return -1;
    }

    public Object get(int n) {
        int n2 = 0;
        while (--n >= 0) {
            if ((n2 = this.nextPos(n2)) != 0) continue;
            throw new IndexOutOfBoundsException();
        }
        return this.getPosNext(n2);
    }

    public boolean consumeNext(int n, Consumer consumer) {
        if (!this.hasNext(n)) {
            return false;
        }
        int n2 = this.posToDataIndex(n);
        int n3 = this.nextNodeIndex(n2, Integer.MAX_VALUE);
        if (n3 == n2) {
            n3 = this.nextDataIndex(n2);
        }
        if (n3 >= 0) {
            this.consumeIRange(n2, n3, consumer);
        }
        return true;
    }

    public void consumePosRange(int n, int n2, Consumer consumer) {
        this.consumeIRange(this.posToDataIndex(n), this.posToDataIndex(n2), consumer);
    }

    public int consumeIRange(int n, int n2, Consumer consumer) {
        int n3;
        block31: {
            char c;
            int n4;
            n3 = n;
            int n5 = n4 = n <= this.gapStart && n2 > this.gapStart ? this.gapStart : n2;
            block20: while (true) {
                int n6;
                int n7;
                if (n3 >= n4) {
                    if (n3 != this.gapStart || n2 <= this.gapEnd) break block31;
                    n3 = this.gapEnd;
                    n4 = n2;
                }
                if ((c = this.data[n3++]) <= '\u9fff') {
                    int n8 = n3 - 1;
                    n7 = n4;
                    while (n3 < n7) {
                        if ((c = this.data[n3++]) <= '\u9fff') continue;
                        --n3;
                        break;
                    }
                    consumer.write(this.data, n8, n3 - n8);
                    continue;
                }
                if (c >= '\ue000' && c <= '\uefff') {
                    consumer.writeObject(this.objects[c - 57344]);
                    continue;
                }
                if (c >= '\ua000' && c <= '\uafff') {
                    n6 = c - 40960;
                    consumer.beginGroup(this.objects[n6].toString(), this.objects[n6 + 1]);
                    n3 += 2;
                    continue;
                }
                if (c >= '\ub000' && c <= '\udfff') {
                    consumer.writeInt(c - 49152);
                    continue;
                }
                switch (c) {
                    case '\uf110': {
                        consumer.beginDocument();
                        n3 += 2;
                        continue block20;
                    }
                    case '\uf111': {
                        consumer.endDocument();
                        continue block20;
                    }
                    case '\uf112': {
                        if (consumer instanceof TreeList) {
                            ((TreeList)consumer).writeBaseUri(this.objects[this.getIntN(n3)]);
                        }
                        n3 += 2;
                        continue block20;
                    }
                    case '\uf100': 
                    case '\uf101': {
                        consumer.writeBoolean(c != '\uf100');
                        continue block20;
                    }
                    case '\uf106': {
                        consumer.write(this.data, n3, '\u0001' + c - 61702);
                        ++n3;
                        continue block20;
                    }
                    case '\uf107': {
                        consumer.write(this.data, n3, '\u0001' + c - 61702);
                        n3 += 2;
                        continue block20;
                    }
                    case '\uf10f': {
                        AbstractSequence abstractSequence = (AbstractSequence)this.objects[this.getIntN(n3)];
                        n7 = this.getIntN(n3 + 2);
                        if (consumer instanceof PositionConsumer) {
                            ((PositionConsumer)((Object)consumer)).writePosition(abstractSequence, n7);
                        } else {
                            consumer.writeObject(SeqPosition.make(abstractSequence, n7));
                        }
                        n3 += 4;
                        continue block20;
                    }
                    case '\uf10e': {
                        if (consumer instanceof PositionConsumer) {
                            ((PositionConsumer)((Object)consumer)).consume((SeqPosition)this.objects[this.getIntN(n3)]);
                            n3 += 2;
                            continue block20;
                        }
                    }
                    case '\uf10d': {
                        consumer.writeObject(this.objects[this.getIntN(n3)]);
                        n3 += 2;
                        continue block20;
                    }
                    case '\uf10b': {
                        n6 = this.data[n3++];
                        n6 = this.data[n3 - 2 - n6] - 40960;
                        consumer.endGroup(this.objects[n6].toString());
                        continue block20;
                    }
                    case '\uf108': {
                        n6 = this.getIntN(n3);
                        n6 += n6 >= 0 ? n3 - 1 : this.data.length;
                        n3 += 2;
                        n6 = this.getIntN(n6 + 1);
                        consumer.beginGroup(this.objects[n6].toString(), this.objects[n6 + 1]);
                        continue block20;
                    }
                    case '\uf10c': {
                        n6 = this.getIntN(n3);
                        consumer.endGroup(this.objects[n6].toString());
                        n3 += 6;
                        continue block20;
                    }
                    case '\uf109': {
                        n6 = this.getIntN(n3);
                        consumer.beginAttribute(this.objects[n6].toString(), this.objects[n6 + 1]);
                        n3 += 4;
                        continue block20;
                    }
                    case '\uf10a': {
                        consumer.endAttribute();
                        continue block20;
                    }
                    case '\uf102': {
                        consumer.writeInt(this.getIntN(n3));
                        n3 += 2;
                        continue block20;
                    }
                    case '\uf104': {
                        consumer.writeFloat(Float.intBitsToFloat(this.getIntN(n3)));
                        n3 += 2;
                        continue block20;
                    }
                    case '\uf103': {
                        consumer.writeLong(this.getLongN(n3));
                        n3 += 4;
                        continue block20;
                    }
                    case '\uf105': {
                        consumer.writeDouble(Double.longBitsToDouble(this.getLongN(n3)));
                        n3 += 4;
                        continue block20;
                    }
                }
                break;
            }
            this.dump();
            throw new Error("unknown code:" + c);
        }
        return n3;
    }

    public void toString(String string, StringBuffer stringBuffer) {
        int n = 0;
        int n2 = this.gapStart;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        block17: while (n < n2 || n == this.gapStart && (n = this.gapEnd) != (n2 = this.data.length)) {
            int n3;
            int n4;
            char c;
            if ((c = this.data[n++]) <= '\u9fff') {
                int n5 = n - 1;
                n4 = n2;
                while (n < n4) {
                    if ((c = this.data[n++]) <= '\u9fff') continue;
                    --n;
                    break;
                }
                if (bl2) {
                    stringBuffer.append('>');
                    bl2 = false;
                }
                stringBuffer.append(this.data, n5, n - n5);
                bl = false;
                continue;
            }
            if (c >= '\ue000' && c <= '\uefff') {
                if (bl2) {
                    stringBuffer.append('>');
                    bl2 = false;
                }
                if (bl) {
                    stringBuffer.append(string);
                } else {
                    bl = true;
                }
                stringBuffer.append(this.objects[c - 57344]);
                continue;
            }
            if (c >= '\ua000' && c <= '\uafff') {
                if (bl2) {
                    stringBuffer.append('>');
                    bl2 = false;
                }
                n3 = c - 40960;
                if (bl) {
                    stringBuffer.append(string);
                }
                stringBuffer.append('<');
                stringBuffer.append(this.objects[n3].toString());
                n += 2;
                bl = false;
                bl2 = true;
                continue;
            }
            if (c >= '\ub000' && c <= '\udfff') {
                if (bl2) {
                    stringBuffer.append('>');
                    bl2 = false;
                }
                if (bl) {
                    stringBuffer.append(string);
                } else {
                    bl = true;
                }
                stringBuffer.append(c - 49152);
                continue;
            }
            switch (c) {
                case '\uf110': 
                case '\uf112': {
                    n += 2;
                    continue block17;
                }
                case '\uf111': {
                    continue block17;
                }
                case '\uf100': 
                case '\uf101': {
                    if (bl2) {
                        stringBuffer.append('>');
                        bl2 = false;
                    }
                    if (bl) {
                        stringBuffer.append(string);
                    } else {
                        bl = true;
                    }
                    stringBuffer.append(c != '\uf100');
                    continue block17;
                }
                case '\uf106': {
                    if (bl2) {
                        stringBuffer.append('>');
                        bl2 = false;
                    }
                    stringBuffer.append(this.data, n, '\u0001' + c - 61702);
                    bl = false;
                    ++n;
                    continue block17;
                }
                case '\uf107': {
                    if (bl2) {
                        stringBuffer.append('>');
                        bl2 = false;
                    }
                    stringBuffer.append(this.data, n, '\u0001' + c - 61702);
                    bl = false;
                    n += 2;
                    continue block17;
                }
                case '\uf10f': {
                    if (bl2) {
                        stringBuffer.append('>');
                        bl2 = false;
                    }
                    AbstractSequence abstractSequence = (AbstractSequence)this.objects[this.getIntN(n)];
                    n4 = this.getIntN(n + 2);
                    stringBuffer.append(SeqPosition.make(abstractSequence, n4));
                    n += 4;
                    continue block17;
                }
                case '\uf10d': 
                case '\uf10e': {
                    if (bl2) {
                        stringBuffer.append('>');
                        bl2 = false;
                    }
                    if (bl) {
                        stringBuffer.append(string);
                    } else {
                        bl = true;
                    }
                    stringBuffer.append(this.objects[this.getIntN(n)]);
                    n += 2;
                    continue block17;
                }
                case '\uf108': {
                    n3 = this.getIntN(n);
                    n3 += n3 >= 0 ? n - 1 : this.data.length;
                    n += 2;
                    n3 = this.getIntN(n3 + 1);
                    if (bl2) {
                        stringBuffer.append('>');
                    } else if (bl) {
                        stringBuffer.append(string);
                    }
                    stringBuffer.append('<');
                    stringBuffer.append(this.objects[n3]);
                    bl = false;
                    bl2 = true;
                    continue block17;
                }
                case '\uf10b': 
                case '\uf10c': {
                    if (c == '\uf10b') {
                        n3 = this.data[n++];
                        n3 = this.data[n - 2 - n3] - 40960;
                    } else {
                        n3 = this.getIntN(n);
                        n += 6;
                    }
                    if (bl2) {
                        stringBuffer.append("/>");
                    } else {
                        stringBuffer.append("</");
                        stringBuffer.append(this.objects[n3]);
                        stringBuffer.append('>');
                    }
                    bl2 = false;
                    bl = true;
                    continue block17;
                }
                case '\uf109': {
                    n3 = this.getIntN(n);
                    stringBuffer.append(' ');
                    stringBuffer.append(this.objects[n3]);
                    stringBuffer.append("=\"");
                    bl3 = true;
                    bl2 = false;
                    n += 4;
                    continue block17;
                }
                case '\uf10a': {
                    stringBuffer.append('\"');
                    bl3 = false;
                    bl2 = true;
                    bl = false;
                    continue block17;
                }
                case '\uf102': {
                    if (bl2) {
                        stringBuffer.append('>');
                        bl2 = false;
                    }
                    if (bl) {
                        stringBuffer.append(string);
                    } else {
                        bl = true;
                    }
                    stringBuffer.append(this.getIntN(n));
                    n += 2;
                    continue block17;
                }
                case '\uf104': {
                    if (bl2) {
                        stringBuffer.append('>');
                        bl2 = false;
                    }
                    if (bl) {
                        stringBuffer.append(string);
                    } else {
                        bl = true;
                    }
                    stringBuffer.append(Float.intBitsToFloat(this.getIntN(n)));
                    n += 2;
                    continue block17;
                }
                case '\uf103': {
                    if (bl2) {
                        stringBuffer.append('>');
                        bl2 = false;
                    }
                    if (bl) {
                        stringBuffer.append(string);
                    } else {
                        bl = true;
                    }
                    stringBuffer.append(this.getLongN(n));
                    n += 4;
                    continue block17;
                }
                case '\uf105': {
                    if (bl2) {
                        stringBuffer.append('>');
                        bl2 = false;
                    }
                    if (bl) {
                        stringBuffer.append(string);
                    } else {
                        bl = true;
                    }
                    stringBuffer.append(Double.longBitsToDouble(this.getLongN(n)));
                    n += 4;
                    continue block17;
                }
            }
            this.dump();
            throw new Error("unknown code:" + c);
        }
    }

    public boolean hasNext(int n) {
        int n2 = this.posToDataIndex(n);
        if (n2 == this.data.length) {
            return false;
        }
        char c = this.data[n2];
        return c != '\uf10a' && c != '\uf10b' && c != '\uf10c' && c != '\uf111';
    }

    public int getNextKind(int n) {
        int n2 = this.posToDataIndex(n);
        if (n2 == this.data.length) {
            return 0;
        }
        char c = this.data[n2];
        if (c <= '\u9fff') {
            return 29;
        }
        if (c >= '\ue000' && c <= '\uefff') {
            return 32;
        }
        if (c >= '\ua000' && c <= '\uafff') {
            return 33;
        }
        if ((c & 0xFF00) == 61440) {
            return 28;
        }
        if (c >= '\ub000' && c <= '\udfff') {
            return 22;
        }
        switch (c) {
            case '\uf100': 
            case '\uf101': {
                return 27;
            }
            case '\uf102': {
                return 22;
            }
            case '\uf103': {
                return 24;
            }
            case '\uf104': {
                return 25;
            }
            case '\uf105': {
                return 26;
            }
            case '\uf106': 
            case '\uf107': {
                return 29;
            }
            case '\uf110': {
                return 34;
            }
            case '\uf108': {
                return 33;
            }
            case '\uf10a': 
            case '\uf10b': 
            case '\uf10c': 
            case '\uf111': {
                return 0;
            }
            case '\uf109': {
                return 35;
            }
        }
        return 32;
    }

    protected int getNextTypeIndex(int n) {
        int n2 = this.posToDataIndex(n);
        if (n2 == this.data.length) {
            return 0;
        }
        char c = this.data[n2];
        if (c >= '\ua000' && c <= '\uafff') {
            return c - 40960;
        }
        if (c == '\uf108') {
            int n3;
            return this.getIntN((n3 += (n3 = this.getIntN(n2 + 1)) < 0 ? this.data.length : n2) + 1);
        }
        if (c == '\uf109') {
            return this.getIntN(n2 + 1);
        }
        return -1;
    }

    public String getNextTypeName(int n) {
        int n2 = this.getNextTypeIndex(n);
        return n2 < 0 ? null : (String)this.objects[n2];
    }

    public Object getNextTypeObject(int n) {
        int n2 = this.getNextTypeIndex(n);
        return n2 < 0 ? null : this.objects[n2 + 1];
    }

    public Object getPosPrevious(int n) {
        if ((n & 1) != 0 && n != -1) {
            return this.getPosNext(n - 3);
        }
        return super.getPosPrevious(n);
    }

    private Object copyToList(int n, int n2) {
        return new TreeList(this, n, n2);
    }

    public int getPosNextInt(int n) {
        int n2 = this.posToDataIndex(n);
        if (n2 < this.data.length) {
            char c = this.data[n2];
            if (c >= '\ub000' && c <= '\udfff') {
                return c - 49152;
            }
            if (c == '\uf102') {
                return this.getIntN(n2 + 1);
            }
        }
        return ((Number)this.getPosNext(n)).intValue();
    }

    public Object getPosNext(int n) {
        int n2 = this.posToDataIndex(n);
        if (n2 == this.data.length) {
            return Sequence.eofValue;
        }
        char c = this.data[n2];
        if (c <= '\u9fff') {
            return Convert.toObject(c);
        }
        if (c >= '\ue000' && c <= '\uefff') {
            return this.objects[c - 57344];
        }
        if (c >= '\ua000' && c <= '\uafff') {
            return this.copyToList(n2, n2 + this.data[n2 + 1] + 2);
        }
        if (c >= '\ub000' && c <= '\udfff') {
            return Convert.toObject(c - 49152);
        }
        switch (c) {
            case '\uf110': {
                int n3 = this.getIntN(n2 + 1);
                n3 += n3 < 0 ? this.data.length : n2;
                return this.copyToList(n2, ++n3);
            }
            case '\uf100': 
            case '\uf101': {
                return Convert.toObject(c != '\uf100');
            }
            case '\uf102': {
                return Convert.toObject(this.getIntN(n2 + 1));
            }
            case '\uf103': {
                return Convert.toObject(this.getLongN(n2 + 1));
            }
            case '\uf104': {
                return Convert.toObject(Float.intBitsToFloat(this.getIntN(n2 + 1)));
            }
            case '\uf105': {
                return Convert.toObject(Double.longBitsToDouble(this.getLongN(n2 + 1)));
            }
            case '\uf106': {
                return Convert.toObject(this.data[n2 + 1]);
            }
            case '\uf109': {
                int n4 = this.getIntN(n2 + 3);
                return this.copyToList(n2, (n4 += n4 < 0 ? this.data.length : n2) + 1);
            }
            case '\uf108': {
                int n5 = this.getIntN(n2 + 1);
                return this.copyToList(n2, (n5 += n5 < 0 ? this.data.length : n2) + 7);
            }
            case '\uf10a': 
            case '\uf10b': 
            case '\uf10c': 
            case '\uf111': {
                return Sequence.eofValue;
            }
            case '\uf10d': 
            case '\uf10e': {
                return this.objects[this.getIntN(n2 + 1)];
            }
            case '\uf10f': {
                AbstractSequence abstractSequence = (AbstractSequence)this.objects[this.getIntN(n2 + 1)];
                n = this.getIntN(n2 + 3);
                return SeqPosition.make(abstractSequence, n);
            }
        }
        throw this.unsupported("getPosNext, code=" + Integer.toHexString(c));
    }

    public int stringValue(int n, StringBuffer stringBuffer) {
        int n2 = this.nextNodeIndex(n, Integer.MAX_VALUE);
        if (n2 > n) {
            while (n < n2 && n >= 0) {
                n = this.stringValue(false, n, stringBuffer);
            }
            return n;
        }
        return this.stringValue(false, n, stringBuffer);
    }

    public int stringValue(boolean bl, int n, StringBuffer stringBuffer) {
        Object object2 = null;
        int n2 = 0;
        if (n >= this.gapStart) {
            n += this.gapEnd - this.gapStart;
        }
        if (n == this.data.length) {
            return -1;
        }
        char c = this.data[n];
        ++n;
        if (c <= '\u9fff') {
            stringBuffer.append(c);
            return n;
        }
        if (c >= '\ue000' && c <= '\uefff') {
            object2 = this.objects[c - 57344];
        } else if (c >= '\ua000' && c <= '\uafff') {
            n2 = n + 2;
            n = this.data[n] + n + 1;
        } else {
            if ((c & 0xFF00) == 61440) {
                stringBuffer.append(c & 0xFF);
                return n;
            }
            if (c >= '\ub000' && c <= '\udfff') {
                stringBuffer.append(c - 49152);
                return n;
            }
            switch (c) {
                case '\uf112': {
                    return n + 2;
                }
                case '\uf100': 
                case '\uf101': {
                    stringBuffer.append(c != '\uf100');
                    return n;
                }
                case '\uf102': {
                    stringBuffer.append(this.getIntN(n));
                    return n + 2;
                }
                case '\uf103': {
                    stringBuffer.append(this.getLongN(n));
                    return n + 4;
                }
                case '\uf104': {
                    stringBuffer.append(Float.intBitsToFloat(this.getIntN(n)));
                    return n + 2;
                }
                case '\uf105': {
                    stringBuffer.append(Double.longBitsToDouble(this.getLongN(n)));
                    return n + 4;
                }
                case '\uf106': {
                    stringBuffer.append(this.data[n]);
                    return n + 1;
                }
                case '\uf110': {
                    n2 = n + 2;
                    int n3 = this.getIntN(n);
                    n = n3 + (n3 < 0 ? this.data.length + 1 : n);
                    break;
                }
                case '\uf108': {
                    n2 = n + 2;
                    int n3 = this.getIntN(n);
                    n = (n3 += n3 < 0 ? this.data.length : n - 1) + 7;
                    break;
                }
                case '\uf10a': 
                case '\uf10b': 
                case '\uf10c': 
                case '\uf111': {
                    return -1;
                }
                case '\uf109': {
                    int n4;
                    if (!bl) {
                        n2 = n + 4;
                    }
                    n = n4 + ((n4 = this.getIntN(n + 2)) < 0 ? this.data.length + 1 : n);
                    break;
                }
                case '\uf10f': {
                    AbstractSequence abstractSequence = (AbstractSequence)this.objects[this.getIntN(n)];
                    int n5 = this.getIntN(n + 2);
                    ((TreeList)abstractSequence).stringValue(bl, n5 >> 1, stringBuffer);
                    n += 4;
                    break;
                }
                default: {
                    throw new Error("unimplemented: " + Integer.toHexString(c) + " at:" + n);
                }
            }
        }
        if (object2 != null) {
            stringBuffer.append(object2);
        }
        if (n2 > 0) {
            while ((n2 = this.stringValue(true, n2, stringBuffer)) >= 0) {
            }
        }
        return n;
    }

    public int createRelativePos(int n, int n2, boolean bl) {
        if (bl) {
            if (n2 == 0) {
                if ((n & 1) != 0) {
                    return n;
                }
                if (n == 0) {
                    return 1;
                }
            }
            --n2;
        }
        if (n2 < 0) {
            throw this.unsupported("backwards createRelativePos");
        }
        int n3 = this.posToDataIndex(n);
        while (--n2 >= 0) {
            if ((n3 = this.nextDataIndex(n3)) >= 0) continue;
            throw new IndexOutOfBoundsException();
        }
        if (n3 >= this.gapEnd) {
            n3 -= this.gapEnd - this.gapStart;
        }
        return bl ? n3 + 1 << 1 | 1 : n3 << 1;
    }

    public final int nextNodeIndex(int n, int n2) {
        if ((n2 | Integer.MIN_VALUE) == -1) {
            n2 = this.data.length;
        }
        block5: while (true) {
            if (n == this.gapStart) {
                n = this.gapEnd;
            }
            if (n >= n2) {
                return n;
            }
            char c = this.data[n];
            if (c <= '\u9fff' || c >= '\ue000' && c <= '\uefff' || c >= '\ub000' && c <= '\udfff' || (c & 0xFF00) == 61440) {
                ++n;
                continue;
            }
            if (c >= '\ua000' && c <= '\uafff') {
                return n;
            }
            switch (c) {
                case '\uf112': {
                    n += 3;
                    continue block5;
                }
                case '\uf108': 
                case '\uf109': 
                case '\uf110': {
                    return n;
                }
                case '\uf10a': 
                case '\uf10b': 
                case '\uf10c': 
                case '\uf111': {
                    return n;
                }
            }
            n = this.nextDataIndex(n);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int nextMatching(int n, ElementPredicate elementPredicate, int n2, boolean bl) {
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        int n3 = this.posToDataIndex(n);
        int n4 = this.posToDataIndex(n2);
        int n5 = n3;
        if (elementPredicate instanceof NodePredicate) {
            n5 = this.nextNodeIndex(n5, n4);
        }
        boolean bl6 = false;
        if (elementPredicate instanceof GroupPredicate) {
            bl5 = true;
            bl4 = true;
            bl3 = false;
            bl2 = false;
        } else if (elementPredicate instanceof AttributePredicate) {
            bl5 = true;
            bl4 = false;
            bl3 = false;
            bl2 = false;
        } else {
            bl2 = !(elementPredicate instanceof NodePredicate);
            bl5 = true;
            bl4 = true;
            bl3 = true;
        }
        while (true) {
            int n6;
            block36: {
                char c;
                block35: {
                    if (n5 == this.gapStart) {
                        n5 = this.gapEnd;
                    }
                    if (n5 >= n4) {
                        return 0;
                    }
                    c = this.data[n5];
                    if (c > '\u9fff' && (c < '\ue000' || c > '\uefff') && (c < '\ub000' || c > '\udfff')) break block35;
                    if (bl3 && elementPredicate.isInstancePos(this, n5 << 1)) {
                        if (n5 < this.gapEnd) return n5 << 1;
                        n5 -= this.gapEnd - this.gapStart;
                        return n5 << 1;
                    }
                    n6 = n5 + 1;
                    break block36;
                }
                switch (c) {
                    case '\uf112': {
                        n6 = n5 + 3;
                        break block36;
                    }
                    case '\uf110': {
                        n6 = n5 + 3;
                        if (bl5) {
                            break;
                        }
                        break block36;
                    }
                    case '\uf102': 
                    case '\uf107': 
                    case '\uf10d': 
                    case '\uf10e': {
                        n6 = n5 + 3;
                        if (bl3) {
                            break;
                        }
                        break block36;
                    }
                    case '\uf106': {
                        n6 = n5 + 2;
                        break block36;
                    }
                    case '\uf10b': {
                        if (!bl) {
                            return 0;
                        }
                        n6 = n5 + 2;
                        break block36;
                    }
                    case '\uf10f': {
                        n6 = n5 + 5;
                        if (bl3) {
                            break;
                        }
                        break block36;
                    }
                    case '\uf10c': {
                        if (!bl) {
                            return 0;
                        }
                        n6 = n5 + 7;
                        break block36;
                    }
                    case '\uf10a': 
                    case '\uf111': {
                        if (!bl) {
                            return 0;
                        }
                        n6 = n5 + 1;
                        break block36;
                    }
                    case '\uf109': {
                        int n7;
                        n6 = bl5 ? n7 + 1 + ((n7 = this.getIntN(n5 + 3)) < 0 ? this.data.length : n5) : n5 + 5;
                        if (bl6) {
                            break;
                        }
                        break block36;
                    }
                    case '\uf100': 
                    case '\uf101': {
                        n6 = n5 + 1;
                        if (bl3) {
                            break;
                        }
                        break block36;
                    }
                    case '\uf103': 
                    case '\uf105': {
                        n6 = n5 + 5;
                        if (bl3) {
                            break;
                        }
                        break block36;
                    }
                    case '\uf108': {
                        int n7;
                        n6 = bl ? n5 + 3 : n7 + ((n7 = this.getIntN(n5 + 1)) < 0 ? this.data.length : n5) + 7;
                        if (bl4) {
                            break;
                        }
                        break block36;
                    }
                    default: {
                        if (c < '\ua000' || c > '\uafff') throw new Error("unknown code:" + c);
                        n6 = bl ? n5 + 3 : n5 + this.data[n5 + 1] + 2;
                        if (bl4) {
                            break;
                        }
                        break block36;
                    }
                }
                if (n5 > n3 && elementPredicate.isInstancePos(this, n5 << 1)) {
                    if (n5 < this.gapEnd) return n5 << 1;
                    n5 -= this.gapEnd - this.gapStart;
                    return n5 << 1;
                }
            }
            n5 = n6;
        }
    }

    public int nextPos(int n) {
        int n2;
        int n3 = n2 = this.posToDataIndex(n);
        if (n2 == this.data.length) {
            return 0;
        }
        if (n2 >= this.gapEnd) {
            n2 -= this.gapEnd - this.gapStart;
        }
        return (n2 << 1) + 3;
    }

    public final int nextDataIndex(int n) {
        char c;
        if (n == this.gapStart) {
            n = this.gapEnd;
        }
        if (n == this.data.length) {
            return -1;
        }
        if ((c = this.data[n++]) <= '\u9fff' || c >= '\ue000' && c <= '\uefff' || c >= '\ub000' && c <= '\udfff') {
            return n;
        }
        if (c >= '\ua000' && c <= '\uafff') {
            return this.data[n] + n + 1;
        }
        switch (c) {
            case '\uf110': {
                int n2 = this.getIntN(n);
                return (n2 += n2 < 0 ? this.data.length : n - 1) + 1;
            }
            case '\uf100': 
            case '\uf101': {
                return n;
            }
            case '\uf106': {
                return n + 1;
            }
            case '\uf102': 
            case '\uf107': 
            case '\uf10d': 
            case '\uf10e': {
                return n + 2;
            }
            case '\uf10f': {
                return n + 4;
            }
            case '\uf10a': 
            case '\uf10b': 
            case '\uf10c': 
            case '\uf111': {
                return -1;
            }
            case '\uf108': {
                int n3 = this.getIntN(n);
                return (n3 += n3 < 0 ? this.data.length : n - 1) + 7;
            }
            case '\uf109': {
                int n4 = this.getIntN(n + 2);
                return (n4 += n4 < 0 ? this.data.length : n - 1) + 1;
            }
            case '\uf103': 
            case '\uf105': {
                return n + 4;
            }
        }
        throw new Error("unknown code:" + Integer.toHexString(c));
    }

    public Object baseUriOfPos(int n) {
        do {
            int n2;
            if ((n2 = this.posToDataIndex(n)) == this.data.length) {
                return null;
            }
            char c = this.data[n2];
            if ((c < '\ua000' || c > '\uafff') && c != '\uf108' && c != '\uf110') continue;
            int n3 = n2 + 3;
            if (n3 == this.gapStart) {
                n3 = this.gapEnd;
            }
            if (n3 >= this.data.length || this.data[n3] != '\uf112') continue;
            return this.objects[this.getIntN(n3 + 1)];
        } while ((n = this.parentPos(n)) != -1);
        return null;
    }

    public int compare(int n, int n2) {
        int n3;
        int n4 = this.posToDataIndex(n);
        return n4 < (n3 = this.posToDataIndex(n2)) ? -1 : (n4 > n3 ? 1 : 0);
    }

    protected int getIndexDifference(int n, int n2) {
        int n3;
        int n4 = this.posToDataIndex(n2);
        int n5 = this.posToDataIndex(n);
        boolean bl = false;
        if (n4 > n5) {
            bl = true;
            n3 = n5;
            n5 = n4;
            n4 = n3;
        }
        n3 = 0;
        while (n4 < n5) {
            n4 = this.nextDataIndex(n4);
            ++n3;
        }
        return bl ? -n3 : n3;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public void consume(Consumer consumer) {
        this.consumeIRange(0, this.data.length, consumer);
    }

    public void dump() {
        PrintWriter printWriter = new PrintWriter(System.out);
        this.dump(printWriter);
        printWriter.flush();
    }

    public void dump(PrintWriter printWriter) {
        printWriter.println(this.getClass().getName() + " @" + System.identityHashCode(this) + " gapStart:" + this.gapStart + " gapEnd:" + this.gapEnd + " length:" + this.data.length);
        int n = 0;
        for (int i = 0; i < this.data.length; ++i) {
            if (i >= this.gapStart && i < this.gapEnd) continue;
            int n2 = this.data[i];
            printWriter.print("" + i + ": 0x" + Integer.toHexString(n2) + '=' + (short)n2);
            if (--n < 0) {
                int n3;
                Object object2;
                if (n2 <= 40959) {
                    if (n2 >= 32 && n2 < 127) {
                        printWriter.print("='" + (char)n2 + "'");
                    } else if (n2 == 10) {
                        printWriter.print("='\\n'");
                    } else {
                        printWriter.print("='\\u" + Integer.toHexString(n2) + "'");
                    }
                } else if (n2 >= 57344 && n2 <= 61439) {
                    object2 = this.objects[n2 -= 57344];
                    printWriter.print("=Object#" + n2 + '=' + object2 + ':' + object2.getClass().getName() + '@' + System.identityHashCode(object2));
                } else if (n2 >= 40960 && n2 <= 45055) {
                    n3 = this.data[i + 1] + i;
                    printWriter.print("=BEGIN_GROUP_SHORT end:" + n3 + " index#" + (n2 -= 40960) + "=<" + this.objects[n2] + "::" + this.objects[n2 + 1] + '>');
                    n = 2;
                } else if (n2 >= 45056 && n2 <= 57343) {
                    printWriter.print("= INT_SHORT:" + (n2 - 49152));
                } else {
                    switch (n2) {
                        case 61698: {
                            n3 = this.getIntN(i + 1);
                            printWriter.print("=INT_FOLLOWS value:" + n3);
                            n = 2;
                            break;
                        }
                        case 61699: {
                            long l = this.getLongN(i + 1);
                            printWriter.print("=LONG_FOLLOWS value:" + l);
                            n = 4;
                            break;
                        }
                        case 61700: {
                            n3 = this.getIntN(i + 1);
                            printWriter.print("=FLOAT_FOLLOWS value:" + Float.intBitsToFloat(n3));
                            n = 2;
                            break;
                        }
                        case 61701: {
                            long l = this.getLongN(i + 1);
                            printWriter.print("=DOUBLE_FOLLOWS value:" + Double.longBitsToDouble(l));
                            n = 4;
                            break;
                        }
                        case 61712: {
                            n3 = this.getIntN(i + 1);
                            int n4 = n3 < 0 ? this.data.length : i;
                            printWriter.print("=BEGIN_DOCUMENT end:");
                            printWriter.print(n3 += n4);
                            n = 2;
                            break;
                        }
                        case 61714: {
                            printWriter.print("=BASE_URI: ");
                            n3 = this.getIntN(i + 1);
                            printWriter.print(this.objects[n3]);
                            n = 2;
                            break;
                        }
                        case 61713: {
                            printWriter.print("=END_DOCUMENT");
                            break;
                        }
                        case 61696: {
                            printWriter.print("= false");
                            break;
                        }
                        case 61697: {
                            printWriter.print("= true");
                            break;
                        }
                        case 61702: {
                            printWriter.print("=CHAR_FOLLOWS");
                            n = 1;
                            break;
                        }
                        case 61703: {
                            printWriter.print("=CHAR_PAIR_FOLLOWS");
                            n = 2;
                            break;
                        }
                        case 61709: 
                        case 61710: {
                            n = 2;
                            break;
                        }
                        case 61707: {
                            printWriter.print("=END_GROUP_SHORT begin:");
                            n3 = i - this.data[i + 1];
                            printWriter.print(n3);
                            n3 = this.data[n3] - 40960;
                            printWriter.print(" -> #");
                            printWriter.print(n3);
                            printWriter.print("=<");
                            printWriter.print(this.objects[n3]);
                            printWriter.print('>');
                            n = 1;
                            break;
                        }
                        case 61704: {
                            n3 = this.getIntN(i + 1);
                            int n5 = n3 < 0 ? this.data.length : i;
                            printWriter.print("=BEGIN_GROUP_LONG end:");
                            printWriter.print(n3 += n5);
                            n3 = this.getIntN(n3 + 1);
                            printWriter.print(" -> #" + n3 + "=<" + this.objects[n3] + "::" + this.objects[n3 + 1] + '>');
                            n = 2;
                            break;
                        }
                        case 61708: {
                            n3 = this.getIntN(i + 1);
                            printWriter.print("=END_GROUP_LONG name:" + n3 + "=<" + this.objects[n3] + '>');
                            n3 = this.getIntN(i + 3);
                            n3 = n3 < 0 ? i + n3 : n3;
                            printWriter.print(" begin:" + n3);
                            n3 = this.getIntN(i + 5);
                            n3 = n3 < 0 ? i + n3 : n3;
                            printWriter.print(" parent:" + n3);
                            n = 6;
                            break;
                        }
                        case 61705: {
                            n3 = this.getIntN(i + 1);
                            printWriter.print("=BEGIN_ATTRIBUTE name:" + n3 + "=" + this.objects[n3] + "::" + this.objects[n3 + 1]);
                            n3 = this.getIntN(i + 3);
                            printWriter.print(" end:" + (n3 += n3 < 0 ? this.data.length : i));
                            n = 4;
                            break;
                        }
                        case 61706: {
                            printWriter.print("=END_ATTRIBUTE");
                            break;
                        }
                        case 61711: {
                            printWriter.print("=POSITION_PAIR_FOLLOWS seq:");
                            n3 = this.getIntN(i + 1);
                            printWriter.print(n3);
                            printWriter.print("=@");
                            object2 = this.objects[n3];
                            if (object2 == null) {
                                printWriter.print("null");
                            } else {
                                printWriter.print(System.identityHashCode(object2));
                            }
                            printWriter.print(" ipos:");
                            printWriter.print(this.getIntN(i + 3));
                            n = 4;
                        }
                    }
                }
            }
            printWriter.println();
        }
    }
}

