/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.ConstantConstraint;
import gnu.mapping.Future;
import gnu.mapping.NameMap;
import gnu.mapping.Symbol;
import gnu.mapping.SymbolEnumeration;
import gnu.mapping.TrivialConstraint;
import gnu.mapping.UnboundConstraint;
import gnu.mapping.UnboundSymbol;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.Hashtable;

public class Environment
extends NameMap
implements Externalizable {
    Symbol[] table;
    int log2Size = 4;
    private int mask;
    int num_bindings;
    static Environment global;
    Environment previous;
    boolean locked;
    protected TrivialConstraint trivialConstraint = new TrivialConstraint(this);
    protected UnboundConstraint unboundConstraint = new UnboundConstraint(this);
    protected ConstantConstraint constantConstraint;
    static final Hashtable envTable;
    static final Environment EmptyNamespace;

    public final boolean isLocked() {
        return this.locked;
    }

    public final void setLocked(boolean bl) {
        this.locked = bl;
    }

    public Environment getPrevious() {
        return this.previous;
    }

    public void setPrevious(Environment environment) {
        this.previous = environment;
    }

    public static Environment getInstance(String string) {
        Environment environment;
        if (string == null) {
            string = "";
        }
        if ((environment = (Environment)envTable.get(string)) != null) {
            return environment;
        }
        environment = new Environment();
        environment.setName(string);
        envTable.put(string, environment);
        return environment;
    }

    public static Environment user() {
        return Environment.current();
    }

    public static Object lookup_global(String string) throws UnboundSymbol {
        Symbol symbol = Environment.user().lookup(string);
        if (symbol == null) {
            throw new UnboundSymbol(string);
        }
        return symbol.get();
    }

    public static void define_global(String string, Object object2) {
        Environment.user().defineValue(string, object2);
    }

    public static void defineFunction(String string, Object object2) {
        Environment.defineFunction(Environment.user(), string, object2);
    }

    public static void defineFunction(Environment environment, String string, Object object2) {
        Symbol symbol = environment.getSymbol(string);
        symbol.constraint.setFunctionValue(symbol, object2);
    }

    public static void put_global(String string, Object object2) {
        Environment.user().put(string, object2);
    }

    public static Environment current() {
        return Environment.getCurrent();
    }

    public static Environment getCurrent() {
        Thread thread2 = Thread.currentThread();
        if (thread2 instanceof Future) {
            return ((Future)thread2).environment;
        }
        return global;
    }

    public static void setCurrent(Environment environment) {
        Thread thread2 = Thread.currentThread();
        if (thread2 instanceof Future) {
            ((Future)thread2).environment = environment;
        } else {
            global = environment;
        }
    }

    public Environment() {
        this(64);
    }

    public Environment(String string) {
        this();
        this.setName(string);
    }

    public Environment(int n) {
        while (n > 1 << this.log2Size) {
            ++this.log2Size;
        }
        n = 1 << this.log2Size;
        this.table = new Symbol[n];
        this.mask = n - 1;
    }

    public Environment(Environment environment) {
        this();
        this.previous = environment;
    }

    public Symbol getSymbol(String string) {
        Symbol symbol = this.lookup(string);
        if (symbol != null) {
            return symbol;
        }
        symbol = this.addSymbol(string, null);
        symbol.constraint = this.unboundConstraint;
        return symbol;
    }

    public static Symbol getCurrentSymbol(String string) {
        return Environment.getCurrent().getSymbol(string);
    }

    public Symbol lookup(String string) {
        return this.lookup(string, System.identityHashCode(string));
    }

    private Symbol lookup(String string, int n) {
        Environment environment = this;
        while (environment != null) {
            int n2 = Symbol.hashSearch(environment.table, environment.log2Size, environment.mask, string, n);
            Symbol symbol = environment.table[n2];
            if (symbol != null && symbol != Symbol.hashDELETED) {
                return symbol;
            }
            environment = environment.previous;
        }
        return null;
    }

    public Symbol defineValue(String string, Object object2) {
        Symbol symbol = this.getSymbol(string);
        symbol.constraint = this.trivialConstraint;
        symbol.value = object2;
        return symbol;
    }

    public Symbol define(String string, Object object2) {
        return this.defineValue(string, object2);
    }

    public void addSymbol(Symbol symbol) {
        if (3 * this.num_bindings >= 2 * this.table.length) {
            this.rehash();
        }
        if (Symbol.hashSet(this.table, this.log2Size, symbol) == null) {
            ++this.num_bindings;
        }
    }

    public Symbol addSymbol(String string, Object object2) {
        Symbol symbol = new Symbol(string);
        symbol.constraint = this.trivialConstraint;
        symbol.value = object2;
        this.addSymbol(symbol);
        return symbol;
    }

    void rehash() {
        int n = 2 * this.table.length;
        Symbol[] symbolArray = new Symbol[n];
        Symbol.hashInsertAll(symbolArray, this.log2Size + 1, this.table, this.log2Size);
        this.table = symbolArray;
        ++this.log2Size;
        this.mask = this.mask << 1 | 1;
    }

    public Object remove(String string) {
        Environment environment = this;
        while (environment != null) {
            if (this.locked) {
                throw new IllegalStateException("attempt to remove variable: " + string + " locked environment");
            }
            Symbol[] symbolArray = environment.table;
            Symbol symbol = Symbol.hashDelete(environment.table, environment.log2Size, string);
            if (symbol != null) {
                return symbol;
            }
            environment = environment.previous;
        }
        return null;
    }

    public Object remove(Object object2) {
        return this.remove((String)object2);
    }

    public void remove(Symbol symbol) {
        String string = symbol.getName();
        if (this.locked) {
            throw new IllegalStateException("attempt to remove variable: " + string + " locked environment");
        }
        Symbol.hashDelete(this.table, this.log2Size, string);
    }

    public final boolean isBound(String string) {
        return this.get(string, Symbol.UNBOUND) != Symbol.UNBOUND;
    }

    public Object get(String string, Object object2) {
        Symbol symbol = this.lookup(string);
        if (symbol == null) {
            return object2;
        }
        return symbol.get(object2);
    }

    public Object getFunction(String string) {
        return this.getChecked(string);
    }

    public Object put(String string, Object object2) {
        Symbol symbol = this.lookup(string);
        if (symbol == null) {
            this.define(string, object2);
            return null;
        }
        if (!symbol.isBound()) {
            symbol.set(object2);
            return null;
        }
        Object object3 = symbol.get();
        symbol.set(object2);
        return object3;
    }

    public Object put(Object object2, Object object3) {
        return this.put((String)object2, object3);
    }

    public void putFunction(String string, Object object2) {
        this.put(string, object2);
    }

    public SymbolEnumeration enumerateSymbols() {
        return new SymbolEnumeration(this.table, 1 << this.log2Size);
    }

    public SymbolEnumeration enumerateAllSymbols() {
        return new SymbolEnumeration(this);
    }

    public String toString() {
        String string = this.getName();
        if (string == null) {
            string = super.toString();
        }
        return "#<environment " + string + '>';
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getName());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.setName((String)objectInput.readObject());
    }

    public Object readResolve() throws ObjectStreamException {
        String string = this.getName();
        Environment environment = (Environment)envTable.get(string);
        if (environment != null) {
            return environment;
        }
        envTable.put(string, this);
        return this;
    }

    static {
        envTable = new Hashtable(50);
        EmptyNamespace = Environment.getInstance("");
    }
}

