/*
 * Decompiled with CFR 0.152.
 */
package gnu.math;

import gnu.math.Complex;
import gnu.math.DComplex;
import gnu.math.DFloNum;
import gnu.math.IntNum;
import gnu.math.Numeric;
import gnu.math.RatNum;
import java.math.BigDecimal;

public abstract class RealNum
extends Complex
implements Comparable {
    public final RealNum re() {
        return this;
    }

    public final RealNum im() {
        return IntNum.zero();
    }

    public abstract boolean isNegative();

    public abstract int sign();

    public RealNum max(RealNum realNum) {
        RealNum realNum2;
        boolean bl = this.isExact() && realNum.isExact();
        RealNum realNum3 = realNum2 = this.grt(realNum) ? this : realNum;
        if (!bl && realNum2.isExact()) {
            realNum2 = new DFloNum(realNum2.doubleValue());
        }
        return realNum2;
    }

    public RealNum min(RealNum realNum) {
        RealNum realNum2;
        boolean bl = this.isExact() && realNum.isExact();
        RealNum realNum3 = realNum2 = this.grt(realNum) ? realNum : this;
        if (!bl && realNum2.isExact()) {
            realNum2 = new DFloNum(realNum2.doubleValue());
        }
        return realNum2;
    }

    public static RealNum add(RealNum realNum, RealNum realNum2, int n) {
        return (RealNum)realNum.add(realNum2, n);
    }

    public static RealNum times(RealNum realNum, RealNum realNum2) {
        return (RealNum)realNum.mul(realNum2);
    }

    public static RealNum divide(RealNum realNum, RealNum realNum2) {
        return (RealNum)realNum.div(realNum2);
    }

    public abstract Numeric add(Object var1, int var2);

    public abstract Numeric mul(Object var1);

    public abstract Numeric div(Object var1);

    public Numeric abs() {
        return this.isNegative() ? this.neg() : this;
    }

    public final RealNum rneg() {
        return (RealNum)this.neg();
    }

    public boolean isZero() {
        return this.sign() == 0;
    }

    public RatNum toExact() {
        return DFloNum.toExact(this.doubleValue());
    }

    public static double toInt(double d, int n) {
        switch (n) {
            case 1: {
                return Math.floor(d);
            }
            case 2: {
                return Math.ceil(d);
            }
            case 3: {
                return d < 0.0 ? Math.ceil(d) : Math.floor(d);
            }
            case 4: {
                return Math.rint(d);
            }
        }
        return d;
    }

    public RealNum toInt(int n) {
        return new DFloNum(RealNum.toInt(this.doubleValue(), n));
    }

    public IntNum toExactInt(int n) {
        return RealNum.toExactInt(this.doubleValue(), n);
    }

    public static IntNum toExactInt(double d, int n) {
        return RealNum.toExactInt(RealNum.toInt(d, n));
    }

    public static IntNum toExactInt(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new ArithmeticException("cannot convert " + d + " to exact integer");
        }
        long l = Double.doubleToLongBits(d);
        boolean bl = l < 0L;
        int n = (int)(l >> 52) & 0x7FF;
        l &= 0xFFFFFFFFFFFFFL;
        l = n == 0 ? (l <<= 1) : (l |= 0x10000000000000L);
        if (n <= 1075) {
            int n2 = 1075 - n;
            if (n2 > 53) {
                return IntNum.zero();
            }
            return IntNum.make(bl ? -l : (l >>= n2));
        }
        return IntNum.shift(IntNum.make(bl ? -l : l), n - 1075);
    }

    public Complex exp() {
        return new DFloNum(Math.exp(this.doubleValue()));
    }

    public Complex log() {
        double d = this.doubleValue();
        if (d < 0.0) {
            return DComplex.log(d, 0.0);
        }
        return new DFloNum(Math.log(d));
    }

    public final Complex sin() {
        return new DFloNum(Math.sin(this.doubleValue()));
    }

    public final Complex sqrt() {
        double d = this.doubleValue();
        if (d >= 0.0) {
            return new DFloNum(Math.sqrt(d));
        }
        return DComplex.sqrt(d, 0.0);
    }

    public static IntNum toScaledInt(double d, int n) {
        return RealNum.toScaledInt(DFloNum.toExact(d), n);
    }

    public static IntNum toScaledInt(RatNum ratNum, int n) {
        if (n != 0) {
            IntNum intNum = IntNum.power(IntNum.ten(), n < 0 ? -n : n);
            IntNum intNum2 = ratNum.numerator();
            IntNum intNum3 = ratNum.denominator();
            if (n >= 0) {
                intNum2 = IntNum.times(intNum2, intNum);
            } else {
                intNum3 = IntNum.times(intNum3, intNum);
            }
            ratNum = RatNum.make(intNum2, intNum3);
        }
        return ratNum.toExactInt(4);
    }

    public IntNum toScaledInt(int n) {
        return RealNum.toScaledInt(this.toExact(), n);
    }

    public int compareTo(Object object2) {
        return this.compare(object2);
    }

    public BigDecimal asBigDecimal() {
        return new BigDecimal(this.doubleValue());
    }

    public static String toStringScientific(float f) {
        return RealNum.toStringScientific(Float.toString(f));
    }

    public static String toStringScientific(double d) {
        return RealNum.toStringScientific(Double.toString(d));
    }

    public static String toStringScientific(String string) {
        int n = string.indexOf(69);
        if (n >= 0) {
            return string;
        }
        int n2 = string.length();
        char c = string.charAt(n2 - 1);
        if (c == 'y' || c == 'N') {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n2 + 10);
        int n3 = RealNum.toStringScientific(string, stringBuffer);
        stringBuffer.append('E');
        stringBuffer.append(n3);
        return stringBuffer.toString();
    }

    public static int toStringScientific(String string, StringBuffer stringBuffer) {
        char c;
        int n;
        int n2;
        int n3;
        block11: {
            boolean bl;
            boolean bl2 = bl = string.charAt(0) == '-';
            if (bl) {
                stringBuffer.append('-');
            }
            n3 = bl ? 1 : 0;
            int n4 = string.length();
            if (string.charAt(n3) == '0') {
                char c2;
                n2 = n3;
                do {
                    if (n3 != n4) continue;
                    stringBuffer.append("0");
                    n = 0;
                    break block11;
                } while ((c2 = string.charAt(n3++)) < '0' || c2 > '9' || c2 == '0' && n3 != n4);
                stringBuffer.append(c2);
                stringBuffer.append('.');
                int n5 = n = c2 == '0' ? 0 : n2 - n3 + 2;
                if (n3 == n4) {
                    stringBuffer.append('0');
                } else {
                    while (n3 < n4) {
                        stringBuffer.append(string.charAt(n3++));
                    }
                }
            } else {
                n2 = n4 - (bl ? 2 : 1);
                int n6 = string.indexOf(46);
                n = n2 - n4 + n6;
                stringBuffer.append(string.charAt(n3++));
                stringBuffer.append('.');
                while (n3 < n4) {
                    char c3;
                    if ((c3 = string.charAt(n3++)) == '.') continue;
                    stringBuffer.append(c3);
                }
            }
        }
        n3 = stringBuffer.length();
        n2 = -1;
        while ((c = stringBuffer.charAt(--n3)) == '0') {
            n2 = n3;
        }
        if (c == '.') {
            n2 = n3 + 2;
        }
        if (n2 >= 0) {
            stringBuffer.setLength(n2);
        }
        return n;
    }

    public static String toStringDecimal(String string) {
        boolean bl;
        int n = string.indexOf(69);
        if (n < 0) {
            return string;
        }
        int n2 = string.length();
        char c = string.charAt(n2 - 1);
        if (c == 'y' || c == 'N') {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n2 + 10);
        boolean bl2 = bl = string.charAt(0) == '-';
        if (string.charAt(n + 1) != '-') {
            throw new Error("not implemented: toStringDecimal given non-negative exponent: " + string);
        }
        int n3 = n + 2;
        int n4 = 0;
        while (n3 < n2) {
            n4 = 10 * n4 + (string.charAt(n3++) - 48);
        }
        if (bl) {
            stringBuffer.append('-');
        }
        stringBuffer.append("0.");
        while (--n4 > 0) {
            stringBuffer.append('0');
        }
        n3 = 0;
        while ((c = string.charAt(n3++)) != 'E') {
            if (!(c != '-' & c != '.') || c == '0' && n3 >= n) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

