/*
 * Decompiled with CFR 0.152.
 */
package gnu.text;

import gnu.lists.Consumer;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;

public class EnglishIntegerFormat
extends NumberFormat {
    private static EnglishIntegerFormat cardinalEnglish;
    private static EnglishIntegerFormat ordinalEnglish;
    public boolean ordinal;
    public static final String[] ones;
    public static final String[] onesth;
    public static final String[] tens;
    public static final String[] tensth;
    public static final String[] power1000s;

    public EnglishIntegerFormat(boolean bl) {
        this.ordinal = bl;
    }

    public static EnglishIntegerFormat getInstance(boolean bl) {
        if (bl) {
            if (ordinalEnglish == null) {
                ordinalEnglish = new EnglishIntegerFormat(true);
            }
            return ordinalEnglish;
        }
        if (cardinalEnglish == null) {
            cardinalEnglish = new EnglishIntegerFormat(false);
        }
        return cardinalEnglish;
    }

    void format999(StringBuffer stringBuffer, int n, boolean bl) {
        int n2;
        if (n >= 100) {
            n2 = n / 100;
            n %= 100;
            if (n2 > 1) {
                stringBuffer.append(ones[n2]);
                stringBuffer.append(' ');
            }
            stringBuffer.append("hundred");
            if (n > 0) {
                stringBuffer.append(' ');
            } else if (bl) {
                stringBuffer.append("th");
            }
        }
        if (n >= 20) {
            n2 = n / 10;
            stringBuffer.append((bl && (n %= 10) == 0 ? tensth : tens)[n2]);
            if (n > 0) {
                stringBuffer.append('-');
            }
        }
        if (n > 0) {
            stringBuffer.append((bl ? onesth : ones)[n]);
        }
    }

    void format(StringBuffer stringBuffer, long l, int n, boolean bl) {
        if (l >= 1000L) {
            this.format(stringBuffer, l / 1000L, n + 1, false);
            if ((l %= 1000L) > 0L) {
                stringBuffer.append(", ");
            } else if (bl) {
                stringBuffer.append("th");
            }
        }
        if (l > 0L) {
            this.format999(stringBuffer, (int)l, bl && n == 0);
            if (n >= power1000s.length) {
                stringBuffer.append(" times ten to the ");
                this.format(stringBuffer, n * 3, 0, true);
                stringBuffer.append(" power");
            } else if (n > 0) {
                stringBuffer.append(power1000s[n]);
            }
        }
    }

    public void writeInt(int n, Consumer consumer) {
        this.writeLong(n, consumer);
    }

    public void writeLong(long l, Consumer consumer) {
        StringBuffer stringBuffer = new StringBuffer();
        this.format(l, stringBuffer, (FieldPosition)null);
        consumer.write(stringBuffer, 0, stringBuffer.length());
    }

    public void writeObject(Object object2, Consumer consumer) {
        this.writeLong(((Number)object2).longValue(), consumer);
    }

    public void writeBoolean(boolean bl, Consumer consumer) {
        this.writeLong(bl ? 1L : 0L, consumer);
    }

    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (l == 0L) {
            stringBuffer.append(this.ordinal ? "zeroth" : "zero");
        } else {
            if (l < 0L) {
                stringBuffer.append("minus ");
                l = -l;
            }
            this.format(stringBuffer, l, 0, this.ordinal);
        }
        if (fieldPosition != null) {
            // empty if block
        }
        return stringBuffer;
    }

    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        long l = (long)d;
        if ((double)l == d) {
            return this.format(l, stringBuffer, fieldPosition);
        }
        stringBuffer.append(Double.toString(d));
        return stringBuffer;
    }

    public Number parse(String string, ParsePosition parsePosition) {
        throw new Error("EnglishIntegerFormat.parseObject - not implemented");
    }

    static {
        ones = new String[]{null, "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen"};
        onesth = new String[]{null, "first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eighth", "ninth", "tenth", "eleventh", "twelveth", "thirteenth", "fourteenth", "fifteenth", "sixteenth", "seventeenth", "eighteenth", "nineteenth"};
        tens = new String[]{null, null, "twenty", "thirty", "forty", "fifty", "sixty", "seventy", "eighty", "ninety"};
        tensth = new String[]{null, null, "twentieth", "thirtieth", "fortieth", "fiftieth", "sixtieth", "seventieth", "eightieth", "ninetieth"};
        power1000s = new String[]{null, " thousand", " million", " billion", " trillion", " quadrillion", " quintillion", " sextillion", " septillion", " octillion", " nonillion", " decillion", " undecillion", " duodecillion", " tredecillion", " quattuordecillion", " quindecillion", " sexdecillion", " septendecillion", " octodecillion", " novemdecillion", " vigintillion"};
    }
}

