/*
 * Decompiled with CFR 0.152.
 */
package kawa.lang;

import gnu.expr.Language;
import gnu.expr.ModuleBody;
import gnu.expr.ModuleContext;
import gnu.kawa.reflect.ClassMemberLocation;
import gnu.mapping.Environment;
import gnu.mapping.EnvironmentKey;
import gnu.mapping.HasSetter;
import gnu.mapping.Procedure;
import gnu.mapping.Symbol;
import gnu.mapping.UnboundLocationException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;

public class AutoloadProcedure
extends Procedure
implements Externalizable {
    String className;
    Language language;
    Procedure loaded;
    static final Class classModuleBody = ModuleBody.class;

    public AutoloadProcedure() {
    }

    public AutoloadProcedure(String string, String string2) {
        super(string);
        this.className = string2;
    }

    public AutoloadProcedure(String string, String string2, Language language) {
        super(string);
        this.className = string2;
        this.language = language;
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("#<procedure ");
        String string = this.getName();
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print('>');
    }

    private void throw_error(String string) {
        this.loaded = null;
        String string2 = this.getName();
        throw new RuntimeException(string + this.className + " while autoloading " + (string2 == null ? "" : string2.toString()));
    }

    void load() {
        Object object2 = this.getSymbol();
        Language language = this.language;
        if (language == null) {
            language = Language.getDefaultLanguage();
        }
        Environment environment = language.getLangEnvironment();
        Symbol symbol = object2 instanceof Symbol ? (Symbol)object2 : environment.getSymbol(object2.toString());
        try {
            Class<?> clazz = Class.forName(this.className);
            if (classModuleBody.isAssignableFrom(clazz)) {
                Object object3;
                ModuleContext moduleContext = ModuleContext.getContext();
                Object object4 = moduleContext.searchInstance(clazz);
                if (object4 == null) {
                    try {
                        object4 = clazz.getDeclaredField("$instance").get(null);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        object4 = clazz.newInstance();
                    }
                    ClassMemberLocation.defineAll(object4, language, environment);
                    if (object4 instanceof ModuleBody) {
                        ((ModuleBody)object4).run();
                    }
                }
                if ((object3 = environment.getFunction(symbol, null)) == null || !(object3 instanceof Procedure)) {
                    this.throw_error("invalid ModuleBody class - does not define " + object2);
                }
                this.loaded = (Procedure)object3;
            } else {
                this.loaded = (Procedure)clazz.newInstance();
                if (this.loaded == this) {
                    this.throw_error("circularity detected");
                }
                if (object2 != null) {
                    try {
                        Object object5 = language.hasSeparateFunctionNamespace() ? EnvironmentKey.FUNCTION : null;
                        environment.put(symbol, object5, this.loaded);
                    }
                    catch (UnboundLocationException unboundLocationException) {
                        // empty catch block
                    }
                }
            }
            if (object2 != null && this.loaded.getSymbol() == null) {
                this.loaded.setSymbol(object2);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.throw_error("failed to find class ");
        }
        catch (InstantiationException instantiationException) {
            this.throw_error("failed to instantiate class ");
        }
        catch (IllegalAccessException illegalAccessException) {
            this.throw_error("illegal access in class ");
        }
    }

    public Procedure getLoaded() {
        if (this.loaded == null) {
            this.load();
        }
        return this.loaded;
    }

    public int numArgs() {
        return this.getLoaded().numArgs();
    }

    public Object apply0() throws Throwable {
        return this.getLoaded().apply0();
    }

    public Object apply1(Object object2) throws Throwable {
        return this.getLoaded().apply1(object2);
    }

    public Object apply2(Object object2, Object object3) throws Throwable {
        return this.getLoaded().apply2(object2, object3);
    }

    public Object apply3(Object object2, Object object3, Object object4) throws Throwable {
        return this.getLoaded().apply3(object2, object3, object4);
    }

    public Object apply4(Object object2, Object object3, Object object4, Object object5) throws Throwable {
        return this.getLoaded().apply4(object2, object3, object4, object5);
    }

    public Object applyN(Object[] objectArray) throws Throwable {
        if (this.loaded == null) {
            this.load();
        }
        if (this.loaded instanceof AutoloadProcedure) {
            throw new InternalError("circularity in autoload of " + this.getName());
        }
        return this.loaded.applyN(objectArray);
    }

    public Procedure getSetter() {
        if (this.loaded == null) {
            this.load();
        }
        if (this.loaded instanceof HasSetter) {
            return this.loaded.getSetter();
        }
        return super.getSetter();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getName());
        objectOutput.writeObject(this.className);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.setName((String)objectInput.readObject());
        this.className = (String)objectInput.readObject();
    }

    public Object getProperty(Object object2, Object object3) {
        Object object4 = super.getProperty(object2, null);
        if (object4 != null) {
            return object4;
        }
        return this.getLoaded().getProperty(object2, object3);
    }
}

