/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.vectorgraphics2d.pdf;

import de.erichseifert.vectorgraphics2d.GraphicsState;
import de.erichseifert.vectorgraphics2d.SizedDocument;
import de.erichseifert.vectorgraphics2d.intermediate.CommandSequence;
import de.erichseifert.vectorgraphics2d.intermediate.commands.AffineTransformCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.Command;
import de.erichseifert.vectorgraphics2d.intermediate.commands.CreateCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.DisposeCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.DrawImageCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.DrawShapeCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.DrawStringCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.FillShapeCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.Group;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetBackgroundCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetClipCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetColorCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetFontCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetHintCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetPaintCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetStrokeCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetTransformCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.StateCommand;
import de.erichseifert.vectorgraphics2d.pdf.PDFObject;
import de.erichseifert.vectorgraphics2d.pdf.Payload;
import de.erichseifert.vectorgraphics2d.pdf.Resources;
import de.erichseifert.vectorgraphics2d.pdf.SizePayload;
import de.erichseifert.vectorgraphics2d.util.DataUtils;
import de.erichseifert.vectorgraphics2d.util.FlateEncodeStream;
import de.erichseifert.vectorgraphics2d.util.FormattingWriter;
import de.erichseifert.vectorgraphics2d.util.GraphicsUtils;
import de.erichseifert.vectorgraphics2d.util.ImageDataStream;
import de.erichseifert.vectorgraphics2d.util.PageSize;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;

class PDFDocument
extends SizedDocument {
    private static final String EOL = "\n";
    private static final String CHARSET = "ISO-8859-1";
    private static final String HEADER = "%PDF-1.4";
    private static final String FOOTER = "%%EOF";
    private static final double MM_IN_UNITS = 2.834645669291339;
    private static final Map<Integer, Integer> STROKE_ENDCAPS = DataUtils.map(new Integer[]{0, 1, 2}, new Integer[]{0, 1, 2});
    private static final Map<Integer, Integer> STROKE_LINEJOIN = DataUtils.map(new Integer[]{0, 1, 2}, new Integer[]{0, 1, 2});
    private final List<PDFObject> objects;
    private int objectIdCounter;
    private final Map<PDFObject, Long> crossReferences;
    private PDFObject contents;
    private Resources resources;
    private final Map<Integer, PDFObject> images;
    private final Stack<GraphicsState> states = new Stack();
    private boolean transformed;

    public PDFDocument(CommandSequence commands, PageSize pageSize, boolean compressed) {
        super(pageSize, compressed);
        this.states.push(new GraphicsState());
        this.objects = new LinkedList<PDFObject>();
        this.objectIdCounter = 1;
        this.crossReferences = new HashMap<PDFObject, Long>();
        this.images = new HashMap<Integer, PDFObject>();
        this.initPage();
        for (Command command : commands) {
            this.handle(command);
        }
        this.close();
    }

    private GraphicsState getCurrentState() {
        return this.states.peek();
    }

    private void initPage() {
        PDFObject catalog = this.addCatalog();
        LinkedList<PDFObject> pagesKids = new LinkedList<PDFObject>();
        PDFObject pages = this.addPageTree(catalog, pagesKids);
        double x = this.getPageSize().getX() * 2.834645669291339;
        double y = this.getPageSize().getY() * 2.834645669291339;
        double width = this.getPageSize().getWidth() * 2.834645669291339;
        double height = this.getPageSize().getHeight() * 2.834645669291339;
        Map<String, Object> dict = DataUtils.map(new String[]{"Type", "Parent", "MediaBox"}, new Object[]{"Page", pages, new double[]{x, y, width, height}});
        PDFObject page = this.addDictionary(dict);
        pagesKids.add(page);
        Payload contentsPayload = new Payload();
        this.contents = this.addObject(null, contentsPayload);
        page.dict.put("Contents", this.contents);
        if (this.isCompressed()) {
            contentsPayload.addFilter(FlateEncodeStream.class);
            this.contents.dict.put("Filter", new Object[]{"FlateDecode"});
        }
        try {
            contentsPayload.write(DataUtils.join("", new Object[]{"q", EOL, PDFDocument.getOutput(this.getCurrentState().getColor()), EOL, 2.834645669291339, " 0 0 ", -2.834645669291339, " 0 ", height, " cm", EOL}).getBytes(CHARSET));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        SizePayload contentLengthPayload = new SizePayload(this.contents, CHARSET);
        PDFObject contentLength = this.addInteger(contentLengthPayload);
        this.contents.dict.put("Length", contentLength);
        this.resources = new Resources(this.objectIdCounter++, 0);
        this.objects.add(this.resources);
        page.dict.put("Resources", this.resources);
        Font font = this.getCurrentState().getFont();
        String fontResourceId = this.resources.getId(font);
        float fontSize = font.getSize2D();
        StringBuilder out = new StringBuilder();
        out.append("/").append(fontResourceId).append(" ").append(fontSize).append(" Tf").append(EOL);
        try {
            contentsPayload.write(out.toString().getBytes(CHARSET));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private PDFObject addObject(Map<String, Object> dict, Payload payload) {
        int id = this.objectIdCounter++;
        boolean version = false;
        PDFObject object = new PDFObject(id, 0, dict, payload, true);
        this.objects.add(object);
        return object;
    }

    private PDFObject addInteger(Payload payload) {
        int id = this.objectIdCounter++;
        boolean version = false;
        PDFObject object = new PDFObject(id, 0, null, payload, false);
        this.objects.add(object);
        return object;
    }

    private PDFObject addCatalog() {
        Map<String, Object> dict = DataUtils.map(new String[]{"Type"}, new Object[]{"Catalog"});
        return this.addDictionary(dict);
    }

    private PDFObject addPageTree(PDFObject catalog, List<PDFObject> pages) {
        Map<String, Object> dict = DataUtils.map(new String[]{"Type", "Kids", "Count"}, new Object[]{"Pages", pages, 1});
        PDFObject pageTree = this.addDictionary(dict);
        catalog.dict.put("Pages", pageTree);
        return pageTree;
    }

    private PDFObject addDictionary(Map<String, Object> dict) {
        int id = this.objectIdCounter++;
        boolean version = false;
        PDFObject object = new PDFObject(id, 0, dict, null, false);
        this.objects.add(object);
        return object;
    }

    private PDFObject addObject(Image image) {
        BufferedImage bufferedImage = GraphicsUtils.toBufferedImage(image);
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        int bitsPerSample = DataUtils.max(bufferedImage.getSampleModel().getSampleSize());
        int bands = bufferedImage.getSampleModel().getNumBands();
        String colorSpaceName = bands == 1 ? "DeviceGray" : "DeviceRGB";
        Payload imagePayload = new Payload();
        String[] imageFilters = new String[]{};
        if (this.isCompressed()) {
            imagePayload.addFilter(FlateEncodeStream.class);
            imageFilters = new String[]{"FlateDecode"};
        }
        ImageDataStream imageDataStream = new ImageDataStream(bufferedImage, ImageDataStream.Interleaving.WITHOUT_ALPHA);
        try {
            DataUtils.transfer(imageDataStream, imagePayload, 1024);
            imagePayload.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        int length = imagePayload.getBytes().length;
        Map<String, Object> imageDict = DataUtils.map(new String[]{"Type", "Subtype", "Width", "Height", "ColorSpace", "BitsPerComponent", "Length", "Filter"}, new Object[]{"XObject", "Image", width, height, colorSpaceName, bitsPerSample, length, imageFilters});
        PDFObject imageObject = this.addObject(imageDict, imagePayload);
        boolean hasAlpha = bufferedImage.getColorModel().hasAlpha();
        if (hasAlpha) {
            boolean isBitmask;
            BufferedImage mask = GraphicsUtils.getAlphaImage(bufferedImage);
            PDFObject maskObject = this.addObject(mask);
            boolean bl = isBitmask = mask.getSampleModel().getSampleSize(0) == 1;
            if (isBitmask) {
                maskObject.dict.put("ImageMask", true);
                maskObject.dict.remove("ColorSpace");
                imageObject.dict.put("Mask", maskObject);
            } else {
                imageObject.dict.put("SMask", maskObject);
            }
        }
        return imageObject;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        FormattingWriter o = new FormattingWriter(out, CHARSET, EOL);
        o.writeln(HEADER);
        for (PDFObject obj : this.objects) {
            this.crossReferences.put(obj, o.tell());
            o.writeln(PDFDocument.toString(obj));
            o.flush();
        }
        long xrefPos = o.tell();
        o.writeln("xref");
        o.write(0).write(" ").writeln(this.objects.size() + 1);
        o.format("%010d %05d f ", 0, 65535).writeln();
        for (PDFObject obj : this.objects) {
            o.format("%010d %05d n ", this.crossReferences.get(obj), 0).writeln();
        }
        o.flush();
        o.writeln("trailer");
        o.writeln(PDFDocument.serialize(DataUtils.map(new String[]{"Size", "Root"}, new Object[]{this.objects.size() + 1, this.objects.get(0)})));
        o.writeln("startxref");
        o.writeln(xrefPos);
        o.writeln(FOOTER);
        o.flush();
    }

    public static String toString(PDFObject obj) {
        StringBuilder out = new StringBuilder();
        out.append(obj.id).append(" ").append(obj.version).append(" obj").append(EOL);
        if (!obj.dict.isEmpty()) {
            out.append(PDFDocument.serialize(obj.dict)).append(EOL);
        }
        if (obj.payload != null) {
            String content;
            try {
                content = new String(obj.payload.getBytes(), CHARSET);
            }
            catch (UnsupportedEncodingException e) {
                content = "";
            }
            if (content.length() > 0) {
                if (obj.stream) {
                    out.append("stream").append(EOL);
                }
                out.append(content);
                if (obj.stream) {
                    out.append("endstream");
                }
                out.append(EOL);
            }
        }
        out.append("endobj");
        return out.toString();
    }

    private static String serialize(Object obj) {
        if (obj instanceof String) {
            return "/" + obj.toString();
        }
        if (obj instanceof float[]) {
            return PDFDocument.serialize(DataUtils.asList((float[])obj));
        }
        if (obj instanceof double[]) {
            return PDFDocument.serialize(DataUtils.asList((double[])obj));
        }
        if (obj instanceof Object[]) {
            return PDFDocument.serialize(Arrays.asList((Object[])obj));
        }
        if (obj instanceof List) {
            List list = (List)obj;
            StringBuilder out = new StringBuilder();
            out.append("[");
            int i = 0;
            for (Object elem : list) {
                if (i++ > 0) {
                    out.append(" ");
                }
                out.append(PDFDocument.serialize(elem));
            }
            out.append("]");
            return out.toString();
        }
        if (obj instanceof Map) {
            Map dict = (Map)obj;
            StringBuilder out = new StringBuilder();
            out.append("<<").append(EOL);
            for (Map.Entry entry : dict.entrySet()) {
                String key = entry.getKey().toString();
                out.append(PDFDocument.serialize(key)).append(" ");
                Object value = entry.getValue();
                out.append(PDFDocument.serialize(value)).append(EOL);
            }
            out.append(">>");
            return out.toString();
        }
        if (obj instanceof PDFObject) {
            PDFObject pdfObj = (PDFObject)obj;
            return String.valueOf(pdfObj.id) + " " + pdfObj.version + " R";
        }
        return DataUtils.format(obj);
    }

    public void handle(Command<?> command) {
        Command c;
        String s = "";
        if (command instanceof Group) {
            c = (Group)command;
            this.applyStateCommands((List)c.getValue());
            s = PDFDocument.getOutput(this.getCurrentState(), this.resources, !this.transformed);
            this.transformed = true;
        } else if (command instanceof DrawShapeCommand) {
            c = (DrawShapeCommand)command;
            s = PDFDocument.getOutput((Shape)c.getValue()) + " S";
        } else if (command instanceof FillShapeCommand) {
            c = (FillShapeCommand)command;
            s = PDFDocument.getOutput((Shape)c.getValue()) + " f";
        } else if (command instanceof DrawStringCommand) {
            c = (DrawStringCommand)command;
            s = PDFDocument.getOutput((String)c.getValue(), ((DrawStringCommand)c).getX(), ((DrawStringCommand)c).getY());
        } else if (command instanceof DrawImageCommand) {
            c = (DrawImageCommand)command;
            Image image = (Image)c.getValue();
            PDFObject imageObject = this.images.get(image.hashCode());
            if (imageObject == null) {
                imageObject = this.addObject(image);
                this.images.put(image.hashCode(), imageObject);
            }
            s = PDFDocument.getOutput(imageObject, ((DrawImageCommand)c).getX(), ((DrawImageCommand)c).getY(), ((DrawImageCommand)c).getWidth(), ((DrawImageCommand)c).getHeight(), this.resources);
        }
        try {
            Payload contentsPayload = this.contents.payload;
            contentsPayload.write(s.getBytes(CHARSET));
            contentsPayload.write(EOL.getBytes(CHARSET));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void applyStateCommands(List<Command<?>> commands) {
        for (Command<?> command : commands) {
            StateCommand c;
            if (command instanceof SetHintCommand) {
                c = (SetHintCommand)command;
                this.getCurrentState().getHints().put(((SetHintCommand)c).getKey(), c.getValue());
                continue;
            }
            if (command instanceof SetBackgroundCommand) {
                c = (SetBackgroundCommand)command;
                this.getCurrentState().setBackground((Color)c.getValue());
                continue;
            }
            if (command instanceof SetColorCommand) {
                c = (SetColorCommand)command;
                this.getCurrentState().setColor((Color)c.getValue());
                continue;
            }
            if (command instanceof SetPaintCommand) {
                c = (SetPaintCommand)command;
                this.getCurrentState().setPaint((Paint)c.getValue());
                continue;
            }
            if (command instanceof SetStrokeCommand) {
                c = (SetStrokeCommand)command;
                this.getCurrentState().setStroke((Stroke)c.getValue());
                continue;
            }
            if (command instanceof SetFontCommand) {
                c = (SetFontCommand)command;
                this.getCurrentState().setFont((Font)c.getValue());
                continue;
            }
            if (command instanceof SetTransformCommand) {
                throw new UnsupportedOperationException("The PDF format has no means of setting the transformation matrix.");
            }
            if (command instanceof AffineTransformCommand) {
                c = (AffineTransformCommand)command;
                AffineTransform stateTransform = this.getCurrentState().getTransform();
                AffineTransform transformToBeApplied = (AffineTransform)c.getValue();
                stateTransform.concatenate(transformToBeApplied);
                this.getCurrentState().setTransform(stateTransform);
                continue;
            }
            if (command instanceof SetClipCommand) {
                c = (SetClipCommand)command;
                this.getCurrentState().setClip((Shape)c.getValue());
                continue;
            }
            if (command instanceof CreateCommand) {
                try {
                    this.states.push((GraphicsState)this.getCurrentState().clone());
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (!(command instanceof DisposeCommand)) continue;
            this.states.pop();
        }
    }

    private static String getOutput(Color color) {
        if (color.getColorSpace().getType() == 9) {
            float[] cmyk = color.getComponents(null);
            String c = PDFDocument.serialize(Float.valueOf(cmyk[0]));
            String m = PDFDocument.serialize(Float.valueOf(cmyk[1]));
            String y = PDFDocument.serialize(Float.valueOf(cmyk[2]));
            String k = PDFDocument.serialize(Float.valueOf(cmyk[3]));
            return c + " " + m + " " + y + " " + k + " k " + c + " " + m + " " + y + " " + k + " K";
        }
        String r = PDFDocument.serialize((double)color.getRed() / 255.0);
        String g = PDFDocument.serialize((double)color.getGreen() / 255.0);
        String b = PDFDocument.serialize((double)color.getBlue() / 255.0);
        return r + " " + g + " " + b + " rg " + r + " " + g + " " + b + " RG";
    }

    private static String getOutput(Shape s) {
        StringBuilder out = new StringBuilder();
        PathIterator segments = s.getPathIterator(null);
        double[] coordsCur = new double[6];
        double[] pointPrev = new double[2];
        int i = 0;
        while (!segments.isDone()) {
            if (i > 0) {
                out.append(" ");
            }
            int segmentType = segments.currentSegment(coordsCur);
            switch (segmentType) {
                case 0: {
                    out.append(PDFDocument.serialize(coordsCur[0])).append(" ").append(PDFDocument.serialize(coordsCur[1])).append(" m");
                    pointPrev[0] = coordsCur[0];
                    pointPrev[1] = coordsCur[1];
                    break;
                }
                case 1: {
                    out.append(PDFDocument.serialize(coordsCur[0])).append(" ").append(PDFDocument.serialize(coordsCur[1])).append(" l");
                    pointPrev[0] = coordsCur[0];
                    pointPrev[1] = coordsCur[1];
                    break;
                }
                case 3: {
                    out.append(PDFDocument.serialize(coordsCur[0])).append(" ").append(PDFDocument.serialize(coordsCur[1])).append(" ").append(PDFDocument.serialize(coordsCur[2])).append(" ").append(PDFDocument.serialize(coordsCur[3])).append(" ").append(PDFDocument.serialize(coordsCur[4])).append(" ").append(PDFDocument.serialize(coordsCur[5])).append(" c");
                    pointPrev[0] = coordsCur[4];
                    pointPrev[1] = coordsCur[5];
                    break;
                }
                case 2: {
                    double x1 = pointPrev[0] + 0.6666666666666666 * (coordsCur[0] - pointPrev[0]);
                    double y1 = pointPrev[1] + 0.6666666666666666 * (coordsCur[1] - pointPrev[1]);
                    double x2 = coordsCur[0] + 0.3333333333333333 * (coordsCur[2] - coordsCur[0]);
                    double y2 = coordsCur[1] + 0.3333333333333333 * (coordsCur[3] - coordsCur[1]);
                    double x3 = coordsCur[2];
                    double y3 = coordsCur[3];
                    out.append(PDFDocument.serialize(x1)).append(" ").append(PDFDocument.serialize(y1)).append(" ").append(PDFDocument.serialize(x2)).append(" ").append(PDFDocument.serialize(y2)).append(" ").append(PDFDocument.serialize(x3)).append(" ").append(PDFDocument.serialize(y3)).append(" c");
                    pointPrev[0] = x3;
                    pointPrev[1] = y3;
                    break;
                }
                case 4: {
                    out.append("h");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown path operation.");
                }
            }
            ++i;
            segments.next();
        }
        return out.toString();
    }

    private static String getOutput(GraphicsState state, Resources resources, boolean first) {
        StringBuilder out = new StringBuilder();
        if (!first) {
            out.append("Q").append(EOL);
        }
        out.append("q").append(EOL);
        if (!state.getColor().equals(GraphicsState.DEFAULT_COLOR)) {
            if (state.getColor().getAlpha() != GraphicsState.DEFAULT_COLOR.getAlpha()) {
                double a = (double)state.getColor().getAlpha() / 255.0;
                String resourceId = resources.getId(a);
                out.append("/").append(resourceId).append(" gs").append(EOL);
            }
            out.append(PDFDocument.getOutput(state.getColor())).append(EOL);
        }
        if (!state.getTransform().equals(GraphicsState.DEFAULT_TRANSFORM)) {
            out.append(PDFDocument.getOutput(state.getTransform())).append(" cm").append(EOL);
        }
        if (!state.getStroke().equals(GraphicsState.DEFAULT_STROKE)) {
            out.append(PDFDocument.getOutput(state.getStroke())).append(EOL);
        }
        if (state.getClip() != GraphicsState.DEFAULT_CLIP) {
            out.append(PDFDocument.getOutput(state.getClip())).append(" W n").append(EOL);
        }
        if (!state.getFont().equals(GraphicsState.DEFAULT_FONT)) {
            Font font = state.getFont();
            String fontResourceId = resources.getId(font);
            float fontSize = font.getSize2D();
            out.append("/").append(fontResourceId).append(" ").append(fontSize).append(" Tf").append(EOL);
        }
        return DataUtils.stripTrailing(out.toString(), EOL);
    }

    private static String getOutput(Stroke s) {
        StringBuilder out = new StringBuilder();
        if (s instanceof BasicStroke) {
            BasicStroke strokeDefault = (BasicStroke)GraphicsState.DEFAULT_STROKE;
            BasicStroke strokeNew = (BasicStroke)s;
            if (strokeNew.getLineWidth() != strokeDefault.getLineWidth()) {
                out.append(PDFDocument.serialize(Float.valueOf(strokeNew.getLineWidth()))).append(" w").append(EOL);
            }
            if (strokeNew.getLineJoin() == 0 && strokeNew.getMiterLimit() != strokeDefault.getMiterLimit()) {
                out.append(PDFDocument.serialize(Float.valueOf(strokeNew.getMiterLimit()))).append(" M").append(EOL);
            }
            if (strokeNew.getLineJoin() != strokeDefault.getLineJoin()) {
                out.append(PDFDocument.serialize(STROKE_LINEJOIN.get(strokeNew.getLineJoin()))).append(" j").append(EOL);
            }
            if (strokeNew.getEndCap() != strokeDefault.getEndCap()) {
                out.append(PDFDocument.serialize(STROKE_ENDCAPS.get(strokeNew.getEndCap()))).append(" J").append(EOL);
            }
            if (strokeNew.getDashArray() != strokeDefault.getDashArray()) {
                if (strokeNew.getDashArray() != null) {
                    out.append(PDFDocument.serialize(strokeNew.getDashArray())).append(" ").append(PDFDocument.serialize(Float.valueOf(strokeNew.getDashPhase()))).append(" d").append(EOL);
                } else {
                    out.append(EOL).append("[] 0 d").append(EOL);
                }
            }
        }
        return out.toString();
    }

    private static String getOutput(AffineTransform transform) {
        double[] matrix = new double[6];
        transform.getMatrix(matrix);
        return DataUtils.join(" ", matrix);
    }

    private static String getOutput(String str, double x, double y) {
        return "q 1 0 0 -1 " + x + " " + y + " cm BT " + PDFDocument.getOutput(str) + " Tj ET Q";
    }

    private static StringBuilder getOutput(String str) {
        StringBuilder out = new StringBuilder();
        str = str.replaceAll("\\\\", "\\\\\\\\").replaceAll("\t", "\\\\t").replaceAll("\b", "\\\\b").replaceAll("\f", "\\\\f").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)").replaceAll("[\r\n]", "");
        out.append("(").append(str).append(")");
        return out;
    }

    private static String getOutput(PDFObject image, double x, double y, double width, double height, Resources resources) {
        String resourceId = resources.getId(image);
        return "q " + width + " 0 0 " + height + " " + x + " " + y + " cm 1 0 0 -1 0 1 cm /" + resourceId + " Do Q";
    }

    public void close() {
        try {
            String footer = "Q\n";
            if (this.transformed) {
                footer = footer + "Q\n";
            }
            Payload contentsPayload = this.contents.payload;
            contentsPayload.write(footer.getBytes(CHARSET));
            contentsPayload.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

