#!/bin/sh

# Liquid War 6 is a unique multiplayer wargame.
# Copyright (C)  2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015  Christian Mauduit <ufoot@ufoot.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# 
# Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
# Contact author        : ufoot@ufoot.org

echo "# Automatically generated by $0, do not edit." > Makefile.doxygen
echo >> Makefile.doxygen

echo "\$(srcdir)/liquidwar6-doxygen.texi: "`ls ../src/lib/*.h.in | sed "s/\.\./\$\(top_srcdir\)/g" | sort` >> Makefile.doxygen
echo "\tif test -w \$@ || test ! -f \$@ ; then echo doxygen liquidwar6 && echo > \$@; for l in `echo doxygen/xml/structlw6__* doxygen/xml/unionlw6__* | sort` ; do if test -f \"\$\$l\"; then xsltproc \$(srcdir)/doxygen/texinfo-struct.xsl \"\$\$l\" | grep -v \"<?xml\" | sed \"s/::@\\([0-9][0-9]*\\)/::\\\\1/g\" >> \$@; fi; done; fi" >> Makefile.doxygen 
echo >> Makefile.doxygen
#rm -f liquidwar6-doxygen.texi ; touch liquidwar6-doxygen.texi

for i in bot cfg cli cns cnx dat dsp dyn gen gfx glb gui hlp img ker ldr map mat msg net nod p2p pil scm sim snd srv sys tsk vox ; do
    echo "\$(srcdir)/$i-doxygen.texi: "`ls ../src/lib/$i/*.h | sed "s/\.\./\$\(top_srcdir\)/g" | grep -v gnulib-stdalign.h | grep -v ldr-png.h | grep -v sys/sys-build.h` >> Makefile.doxygen
    echo "\tif test -w \$@ || test ! -f \$@ ; then echo doxygen $i && echo > \$@; for l in `echo doxygen/xml/structlw6${i}__* doxygen/xml/unionlw6${i}__* | sort` ; do if test -f \"\$\$l\"; then xsltproc \$(srcdir)/doxygen/texinfo-struct.xsl \"\$\$l\" | grep -v \"<?xml\" | sed \"s/::@\\([0-9][0-9]*\\)/::\\\\1/g\" >> \$@; fi; done; fi" >> Makefile.doxygen
    echo >> Makefile.doxygen
    #rm -f $i-doxygen.texi ; touch $i-doxygen.texi
done

for i in bot/mod-brute bot/mod-follow bot/mod-idiot bot/mod-random gfx/mod-gl1 gfx/mod-gles2 gfx/mod-soft gfx/shared-sdl gfx/mod-caca snd/mod-csound snd/mod-ogg cli/mod-tcp cli/mod-udp cli/mod-http srv/mod-tcpd srv/mod-udpd srv/mod-httpd ; do
    j=`echo $i | cut -d "/" -f 2`
    k=`echo $j | sed "s/\-/__/g"`
    echo "\$(srcdir)/$j-doxygen.texi: "`find ../src/lib/$i -name "*.h" | sed "s/\.\./\$\(top_srcdir\)/g" | sort` >> Makefile.doxygen
    echo "\tif test -w \$@ || test ! -f \$@ ; then echo doxygen $j $k && echo > \$@; for l in `echo doxygen/xml/struct${k}__* doxygen/xml/union${k}__* | sort` ; do if test -f \"\$\$l\"; then xsltproc \$(srcdir)/doxygen/texinfo-struct.xsl \"\$\$l\" | grep -v \"<?xml\" | sed \"s/::@\\([0-9][0-9]*\\)/::\\\\1/g\" >> \$@; fi; done; fi" >> Makefile.doxygen
    echo >> Makefile.doxygen
    #rm -f $j-doxygen.texi ; touch $j-doxygen.texi
done

