/*  globalblob.c -- All the main routine globals in a struct */
/*
   Copyright (C) 2006 Jim Lowe
   All Rights Reserved.
  
   COPYING TERMS AND CONDITIONS:
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "globalblob.h"
#include "pax_commands.h"

GB *
gb_create(void) {
	GB * gb;
	gb = malloc (sizeof(GB));
	gb_init(gb);
	return gb;
}

void
gb_delete(GB * gb) {
	return;
}

void
gb_init(GB * G) {
	int i;
	G->g_stdout_testfd = -1; 
	G->g_fail_loudly = -1;
	G->g_verbose_threshold = SWC_VERBOSE_4;  /* default for most utiltiies */
	G->g_verboseG = 1; 
	G->g_signal_flag = 0; 
	G->g_t_efd = -1;
	G->g_s_efd = -1;
	G->g_logger_pid = 0;
	G->g_swevent_fd = -1;
	G->g_vstderr = (FILE*)NULL;

	/* G->g_pid_array[SWC_PID_ARRAY_LEN + SWC_PID_ARRAY_LEN]; */
	for (i=0; i<SWC_PID_ARRAY_LEN + SWC_PID_ARRAY_LEN; i++) {
		G->g_pid_array[i] = 0;
	}
	/* G->g_status_array[SWC_PID_ARRAY_LEN]; */
	for (i=0; i<SWC_PID_ARRAY_LEN; i++) {
		G->g_status_array[i] = 0;
	}
	/* G->g_targetfd_array[SWC_TARGET_FD_ARRAY_LEN]; */
	for (i=0; i<SWC_TARGET_FD_ARRAY_LEN; i++) {
		G->g_targetfd_array[i] = -1;
	}

	/* G->g_selectfd_array[SWC_TARGET_FD_ARRAY_LEN]; */
	for (i=0; i<SWC_TARGET_FD_ARRAY_LEN; i++) {
		G->g_selectfd_array[i] = -1;
	}

	G->g_io_req.tv_sec = 0;
	G->g_io_req.tv_nsec = 0;

	G->g_target_kmd = (SHCMD*)NULL;
	G->g_source_kmd = (SHCMD*)NULL;
	G->g_killcmd = (SHCMD*)NULL;
	G->g_pid_array_len = 0;
	G->g_nullfd = open("/dev/null", O_RDWR, 0);
	if (G->g_nullfd < 0) { 
		swlib_doif_writef(G->g_verboseG, G->g_fail_loudly,
			&G->g_logspec, swc_get_stderr_fd(G), "Can't open /dev/null\n");
		exit(1);
	}

	G->g_stderr_fd = -1;
	G->g_target_fdar = (int*)(NULL);
	G->g_source_fdar = (int*)(NULL);
	G->g_fork_pty = SWFORK_PTY;
	G->g_fork_pty2 = SWFORK_PTY2;
	G->g_fork_pty_none = SWFORK_NO_PTY;
	sigemptyset(&(G->g_fork_defaultmask));
	sigemptyset(&(G->g_fork_blockmask));
	sigemptyset(&(G->g_currentmask));
	G->g_do_progressmeter = 0;
	/* G->g_logspec = {-1, 0, -1 }; */
	G->g_logspec.logfdM = -1;
	G->g_logspec.loglevelM = 0;
	G->g_logspec.fail_loudlyM = -1;
	G->g_loglevel = 0;
	G->g_meter_fd = STDOUT_FILENO;
	G->g_xformat = NULL;        
	G->g_swi_event_fd = -1;    
	G->g_swutil = NULL;       
	G->g_pax_read_commands = g_pax_read_commands;
	G->g_pax_write_commands = g_pax_write_commands;
	G->g_source_script_name = (char*)NULL;
	G->g_target_script_name = (char*)NULL;
	G->g_is_seekable = 0;
	G->g_do_debug_events = 0;
}
