/*
   This file is part of TALER
   Copyright (C) 2023 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_update_pending_webhook.h
 * @brief implementation of the update_pending_webhook function for Postgres
 * @author Iván Ávalos
 */
#ifndef PG_UPDATE_PENDING_WEBHOOK_H
#define PG_UPDATE_PENDING_WEBHOOK_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "taler_merchantdb_plugin.h"

/**
 * Update the pending webhook. It is use if the webhook can't be send.
 *
 * @param cls closure
 * @param webhook_pending_serial pending_webhook that need to be update
 * @param next_attempt when to try the webhook next
 * @return database result code
 */
enum GNUNET_DB_QueryStatus
TMH_PG_update_pending_webhook (void *cls,
                               uint64_t webhook_pending_serial,
                               struct GNUNET_TIME_Absolute next_attempt);

#endif
