/*

  audio.cc

  audio subroutines for xlogmaster.cc
  Copyright (C) 1998 Georg C. F. Greve
  This is a GNU program
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
  
  
  Contact: 
           mailto:xlogmaster-bugs@gnu.org
           http://www.gnu.org/software/xlogmaster/
  Secondary sources:
           http://porter.desy.de/~greve/xlogmaster/
           http://www.fusebox.hanse.de/xlogmaster/
	 
*/

/*{{{  Header  */

#include "../config.h"
#include "sysinc.H"
#include "../import/import.h"
#include "logclass.H"
#include "audio.H"
#include "extern.H"

/*}}}*/

/*{{{  play()  */
void play(gint which){
  if ( sound == FALSE ) return;

  /* determine what to play: */
  gchar* audiofile = NULL;
  switch ( which ){
  case ALERT:
    audiofile = alert_sound;
    break;
  case NOTICE:
    audiofile = notice_sound;
    break;
  case UNICONIFY:
    audiofile = uniconify_sound;
    break;
  }
  if ( audiofile == NULL ) return;
  
  pid_t pid = fork();
  if ( pid != 0 ){
    if ( errno == EAGAIN || errno == ENOMEM ){
      fork_error();
      return;
    }

    reference_child(-1); /* we don't care about the end of this one as
			    long as it does get terminated... */
    return;
  }

  /*
    +++ NOW WE ARE A CHILD PROCESS +++
  */

  char* buffer = new char[AUDIO_BSIZE];
  int fd = open(audiofile, O_RDONLY);
  int out = open(sound_device, O_WRONLY );
  
  if ( fd == -1 || out == -1 ){
    close(fd);
    close(out);
    delete buffer;
    _exit(0);
  }
 
  long got = read( fd, buffer, AUDIO_BSIZE);

  while ( got > 0 ){
    write(out, buffer, got);
    got = read( fd, buffer, AUDIO_BSIZE);
  }

  close(fd);
  close(out);

  delete buffer;
  _exit(0);
}
/*}}}*/
