#ifndef MENU_H
#define MENU_H

/* 
   menu.h
   include file for xlogmaster menus
*/

/*{{{  Variables  */
// PopUp menu:
/* these are the widget that are being used in the
   pop-up menu */
static GtkWidget* menu;
static GtkWidget* load_config;
static GtkWidget* save_config;
static GtkWidget* customize_entry;
static GtkWidget* quit_menu;
static GtkWidget* about;
static GtkWidget* separator1;
static GtkWidget* separator2;
static GtkWidget* separator3;

// Fileselector
static GtkWidget *filew;

// Form:
static GtkWidget* form;
static GtkWidget* big_box;
static GtkWidget* buttonbox;
static GtkWidget *notebook;
static GtkTooltips* tooltips;
static GtkWidget* apply_button;
static GtkWidget* cancel_button;
static GtkWidget* add_button;
static GtkWidget* move_up_button;
static GtkWidget* move_down_button;
static GtkWidget* delete_button;
static GtkWidget* spacer;


// defines for the object data keys:
#define LG_FILENAME "xlogmaster::filename"
#define LG_BUTTON "xlogmaster::buttontext"
#define LG_HELP "xlogmaster::helptext"
#define LG_INTERVAL "xlogmaster::interval"
#define LG_MODE "xlogmaster::mode::tail"
#define LG_FILTER "xlogmaster::filter"

/* where all the filter things are attached...*/
#define MENU_BOX "xlogmaster::menu::box"
/* filter tags */
#define FILTER_DELETE "xlogmaster::filter::delete"
#define FILTER_STRING "xlogmaster::filter::string"
#define FILTER_STRING_EXECUTE "xlogmaster::filter::string::execute"
#define FILTER_STRING_LABEL "xlogmaster::filter::string::label"
#define FILTER_LABEL "xlogmaster::filter::label"
#define FILTER_LIST "xlogmaster::filter::list"
#define FILTER_LIST_LAST_ACTIVE "xlogmaster::filter::list::lastactive"
#define FILTER_LIST_ITEM_DATA "xlogmaster::filter::list::itemdata"
#define FILTER_BUTTON_MODE "xlogmaster::filter::button::mode"
#define FILTER_MODE_RAISE "xlogmaster::filter::mode::raise"
#define FILTER_MODE_LOWER "xlogmaster::filter::mode::lower"
#define FILTER_MODE_HIDE "xlogmaster::filter::mode::hide"
#define FILTER_MODE_ALERT "xlogmaster::filter::mode::alert"
#define FILTER_MODE_NOTICE "xlogmaster::filter::mode::notice"
#define FILTER_MODE_UNICONIFY "xlogmaster::filter::mode::uniconify"
#define FILTER_MODE_EXECUTE "xlogmaster::filter::mode::execute"
#define FILTER_MODE_INVERT "xlogmaster::filter::mode::invert"
#define FILTER_MODE_CASE_SENSITIVE "xlogmaster::filter::mode::case_sensitive"

static Filter** filter_tmp;

/* Flag to be used when the selection routine is updating the
   selection fields - this is needed to prevent an endless loop when
   repositioning an object in the list
*/
static int updating;

/* Flag to tell us whether the customization is already running */
static int customizing;

/*}}}*/

/*{{{  Subroutines  */
void fire_up_menu(GtkWidget*);
static gint popup_handler(GtkWidget*, GdkEventButton*, GtkWidget*);
void destroy (GtkWidget *, gpointer *);
void hide_show_buttons_proc();
void load_conf_proc(GtkWidget*, gpointer*);
static void do_load();
void file_ok_sel (GtkWidget *, GtkFileSelection *);
void file_cancel_sel (GtkWidget *, GtkFileSelection *);
void save_conf_proc(GtkWidget*, gpointer*);
void file_save_ok (GtkWidget*, GtkFileSelection*);
void customize_entry_proc(GtkWidget*, gpointer*);
void about_proc(GtkWidget*, gpointer*);

void create_form();

void insert_page(char*, char*, char*, int, int, Filter**, gint);
void create_textbox(GtkWidget *, char *, char *, char*, GtkObject*, gchar*);

void form_popdown (GtkWidget *, gpointer *);
void form_apply(GtkWidget *, gpointer *);
void form_cancel(GtkWidget *, gpointer *);
void retrieve_data(char**, char**, char**, int*, int*, Filter***, int);

void form_add(GtkWidget *, gpointer *);
void form_move_up(GtkWidget *, gpointer *);
void form_move_down(GtkWidget *, gpointer *);
void form_delete(GtkWidget *, gpointer *);

void select_file(GtkWidget*, gpointer*);
void file_pc_cancel_sel (GtkWidget *w, GtkFileSelection *fs);
void file_pc_ok_sel (GtkWidget *w, GtkFileSelection *fs);
void accept_it(GtkWidget*, gpointer*);

/*
  Just the Filter menu stuff below here:
 */
GtkWidget* create_filtermenu(GtkWidget*, Filter**);
void mode_change(GtkWidget *, gpointer *);
void filter_item_select(GtkList*, GtkWidget *);
void filter_add(GtkWidget *, gpointer *);
void filter_delete(GtkWidget *, gpointer *);
void position_child(GtkWidget*, GtkWidget*);
void destroy_filter_entry(GtkWidget *, gpointer *);
void purge_filter_fields(GtkList*, gint);
void update_filter_fields(Filter*, GtkWidget*);
void filter_set_sensitive(GtkWidget*, gint);
char* get_list_label(Filter*);
char* merge_label(char* , char* );
/*}}}*/

#endif /* MENU_H */
