/* ,file-id archive://[lord]/450/rx/spencer.h/1998-05-18
 */
#ifndef RXMATCHREGEXPH
#define RXMATCHREGEXPH
/*	Copyright (C) 1997 Tom Lord
 * 
 * This program is provided to you under the terms of the Liberty Software
 * License.  You are NOT permitted to redistribute, modify, or use it
 * except in very specific ways described by that license.
 *
 * This software comes with NO WARRANTY.
 * 
 * You should have received a copy of the Liberty Software License
 * along with this software; see the file =LICENSE.  If not, write to
 * the Tom Lord, 1810 Francisco St. #2, Berkeley CA, 94703, USA.  
 */



/* Given a regexp 
 *
 * Construct a stream-of-solutions to a regexp matching
 * problem.
 *
 * Given a string and a regexp, we can define a "regexp
 * matching problem" which is:
 *
 *	Does the string match the pattern, and if so,
 *	what are the positions of the parenthesized 
 * 	subexpressions of the pattern, and what is the
 *	state label of the final DFA superstate?
 *
 * There may be more than one way to assign positions to
 * the subexpressions: the functions declared in "regexp-match.h"
 * construct a stream-of-solutions, ordered by the "leftmost
 * longest" rule.
 *
 */



struct rx_solutions;

/* struct rx_registers
 *
 * The structure used to return the position of an overall match,
 * or a parenthesized sub-expression.
 */
struct rx_registers
{
  int rm_so; 		/* Byte offset from string's start to substring's start.  */
  int rm_eo;  		/* Byte offset from string's start to substring's end.  */
  int final_tag;	/* In register 0 of an array of registers, this field
			 * is set to the state label of the last superstate encountered
			 * during a match.
			 */
};

typedef int (*rx_vmfn) (void * closure,
			unsigned const char ** burst,
			int * len,
			int * offset,
			int start, int end, int need);

typedef int (*rx_contextfn) (void * closure,
			     struct rx_exp_node * node,
			     int start, int end,
			     struct rx_registers * regs);




struct rx_context_rules
{
  unsigned int newline_anchor:1;/* If true, an anchor at a newline matches.*/
  unsigned int not_bol:1;	/* If set, the anchors ('^' and '$') don't */
  unsigned int not_eol:1;	/*     match at the ends of the string.  */
  unsigned int case_indep:1;
};



struct rx_str_closure
{
  struct rx_context_rules rules;
  const unsigned char * str;
  int len;
};



/* automatically generated __STDC__ prototypes */
extern struct rx_solutions * rx_make_solutions (struct rx_registers * regs,
						int cset_size,
						struct rx_exp_node * expression,
						struct rx_exp_node ** subexps,
						int start,
						int end,
						rx_vmfn vmfn,
						rx_contextfn contextfn,
						void * closure);
extern int rx_next_solution (struct rx_solutions * solns);
extern int rx_solutions_final_tag (struct rx_solutions * solns);
extern void * rx_solutions_closure (struct rx_solutions * solns);
extern void rx_free_solutions (struct rx_solutions * solns);
extern int rx_str_vmfn (void * closure,
			unsigned const char ** burstp,
			int * lenp,
			int * offsetp,
			int start,
			int end,
			int need);
extern int rx_str_contextfn (void * closure,
			     struct rx_exp_node * node,
			     int start, int end,
			     struct rx_registers * regs);
extern struct rx_solutions * rx_basic_make_solutions (struct rx_registers * regs,
						      struct rx_exp_node * expression,
						      struct rx_exp_node ** subexps,
						      int start,
						      int end,
						      struct rx_context_rules * rules,
						      const unsigned char * str);
extern void rx_basic_free_solutions (struct rx_solutions * solns);
#endif  /* RXMATCHREGEXPH */
